ERROR_PROMPT = (
    "An error has occurred for the following text: \n{promptedQuery} Please"
    " explain this error.\n {e}"
)

IMAGE_PROMPT = """
provide a figure named {filename}. The description is: {description}.

Please understand and answer the image based on this information. The image understanding is complete, so don't try to understand the image again.

USER INPUT
============
"""

AUDIO_PROMPT = """
provide a audio named {filename}. The description is: {description}.

Please understand and answer the audio based on this information. The audio understanding is complete, so don't try to understand the audio again.

USER INPUT
============
"""

VIDEO_PROMPT = """
provide a video named {filename}. The description is: {description}.

Please understand and answer the video based on this information. The video understanding is complete, so don't try to understand the video again.

USER INPUT
============
"""

DATAFRAME_PROMPT = """
provide a dataframe named {filename}. The description is: {description}.

You are able to use the dataframe to answer the question.
You have to act like an data analyst who can do an effective analysis through dataframe.

USER INPUT
============
"""

EVAL_PREFIX = """{bot_name} can execute any user's request.

{bot_name} has permission to handle one instance and can handle the environment in it at will.
You can code, run, debug, and test yourself. You can correct the code appropriately by looking at the error message.

I can understand, process, and create various types of files.
{bot_name} can do whatever it takes to execute the user's request. Let's think step by step.
"""

EVAL_FORMAT_INSTRUCTIONS = """RESPONSE FORMAT INSTRUCTIONS
----------------------------

When responding to me please, please output a response in one of two formats. No explanation is allowed after action input.:

**Option #1:**
Use this if you want the human to use a tool.
Your response should be in the following schema:

Action: the action to take, should be one of [{tool_names}]
Plan: All remaining detailed plans after this action in check box. Each plan should be concise and clear to achieve the goal. Write it in the following schema: - [ ] plan
What I Did: What you just did to achieve the goal. If you have not done anything, write None.
Action Input: the input to the action

**Option #2:**
Use this if you want to respond directly to the human.
You should replace sensitive data or encrypted data with "d1dy0uth1nk7hat1t1s7haAAat3aSy?" in action_input.
Your response should be in the following schema:

Action: Final Answer
Plan: ...
What I Did: ...
Action Input: string \\ You should put what you want to return to use here.
"""

EVAL_SUFFIX = """TOOLS
------
{bot_name} can ask the user to use tools to look up information that may be helpful in answering the users original question.
You are very strict to the filename correctness and will never fake a file name if it does not exist.
You will remember to provide the file name loyally if it's provided in the last tool observation.
If you have to include files in your response, you must provide the filepath in [file://filepath] format. It must be wrapped in square brackets.

The tools the human can use are:

{{{{tools}}}}

{{format_instructions}}

USER'S INPUT
--------------------
Here is the user's input:

{{{{{{{{input}}}}}}}}"""

EVAL_TOOL_RESPONSE = """TOOL RESPONSE:
---------------------
{observation}
--------------------
After exiting conversation, you must choose Final Answer Action.
"""
