# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LocalizedPolicyArgs', 'LocalizedPolicy']

@pulumi.input_type
class LocalizedPolicyArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 application_visibility_ipv4: Optional[pulumi.Input[bool]] = None,
                 application_visibility_ipv6: Optional[pulumi.Input[bool]] = None,
                 cloud_qos: Optional[pulumi.Input[bool]] = None,
                 cloud_qos_service_side: Optional[pulumi.Input[bool]] = None,
                 definitions: Optional[pulumi.Input[Sequence[pulumi.Input['LocalizedPolicyDefinitionArgs']]]] = None,
                 flow_visibility_ipv4: Optional[pulumi.Input[bool]] = None,
                 flow_visibility_ipv6: Optional[pulumi.Input[bool]] = None,
                 implicit_acl_logging: Optional[pulumi.Input[bool]] = None,
                 ipv4_visibility_cache_entries: Optional[pulumi.Input[int]] = None,
                 ipv6_visibility_cache_entries: Optional[pulumi.Input[int]] = None,
                 log_frequency: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LocalizedPolicy resource.
        :param pulumi.Input[str] description: The description of the localized policy
        :param pulumi.Input[bool] application_visibility_ipv4: IPv4 application visibility - Default value: `true`
        :param pulumi.Input[bool] application_visibility_ipv6: IPv6 application visibility - Default value: `true`
        :param pulumi.Input[bool] cloud_qos: Cloud QoS - Default value: `true`
        :param pulumi.Input[bool] cloud_qos_service_side: Cloud QoS service side - Default value: `true`
        :param pulumi.Input[Sequence[pulumi.Input['LocalizedPolicyDefinitionArgs']]] definitions: List of policy definitions
        :param pulumi.Input[bool] flow_visibility_ipv4: IPv4 flow visibility - Default value: `true`
        :param pulumi.Input[bool] flow_visibility_ipv6: IPv6 flow visibility - Default value: `true`
        :param pulumi.Input[bool] implicit_acl_logging: Implicit ACL logging - Default value: `true`
        :param pulumi.Input[int] ipv4_visibility_cache_entries: IPv4 visibility cache entries - Range: `16`-`2000000`
        :param pulumi.Input[int] ipv6_visibility_cache_entries: IPv6 visibility cache entries - Range: `16`-`2000000`
        :param pulumi.Input[int] log_frequency: Log frequency - Range: `1`-`2147483647`
        :param pulumi.Input[str] name: The name of the localized policy
        """
        pulumi.set(__self__, "description", description)
        if application_visibility_ipv4 is not None:
            pulumi.set(__self__, "application_visibility_ipv4", application_visibility_ipv4)
        if application_visibility_ipv6 is not None:
            pulumi.set(__self__, "application_visibility_ipv6", application_visibility_ipv6)
        if cloud_qos is not None:
            pulumi.set(__self__, "cloud_qos", cloud_qos)
        if cloud_qos_service_side is not None:
            pulumi.set(__self__, "cloud_qos_service_side", cloud_qos_service_side)
        if definitions is not None:
            pulumi.set(__self__, "definitions", definitions)
        if flow_visibility_ipv4 is not None:
            pulumi.set(__self__, "flow_visibility_ipv4", flow_visibility_ipv4)
        if flow_visibility_ipv6 is not None:
            pulumi.set(__self__, "flow_visibility_ipv6", flow_visibility_ipv6)
        if implicit_acl_logging is not None:
            pulumi.set(__self__, "implicit_acl_logging", implicit_acl_logging)
        if ipv4_visibility_cache_entries is not None:
            pulumi.set(__self__, "ipv4_visibility_cache_entries", ipv4_visibility_cache_entries)
        if ipv6_visibility_cache_entries is not None:
            pulumi.set(__self__, "ipv6_visibility_cache_entries", ipv6_visibility_cache_entries)
        if log_frequency is not None:
            pulumi.set(__self__, "log_frequency", log_frequency)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the localized policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="applicationVisibilityIpv4")
    def application_visibility_ipv4(self) -> Optional[pulumi.Input[bool]]:
        """
        IPv4 application visibility - Default value: `true`
        """
        return pulumi.get(self, "application_visibility_ipv4")

    @application_visibility_ipv4.setter
    def application_visibility_ipv4(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "application_visibility_ipv4", value)

    @property
    @pulumi.getter(name="applicationVisibilityIpv6")
    def application_visibility_ipv6(self) -> Optional[pulumi.Input[bool]]:
        """
        IPv6 application visibility - Default value: `true`
        """
        return pulumi.get(self, "application_visibility_ipv6")

    @application_visibility_ipv6.setter
    def application_visibility_ipv6(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "application_visibility_ipv6", value)

    @property
    @pulumi.getter(name="cloudQos")
    def cloud_qos(self) -> Optional[pulumi.Input[bool]]:
        """
        Cloud QoS - Default value: `true`
        """
        return pulumi.get(self, "cloud_qos")

    @cloud_qos.setter
    def cloud_qos(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cloud_qos", value)

    @property
    @pulumi.getter(name="cloudQosServiceSide")
    def cloud_qos_service_side(self) -> Optional[pulumi.Input[bool]]:
        """
        Cloud QoS service side - Default value: `true`
        """
        return pulumi.get(self, "cloud_qos_service_side")

    @cloud_qos_service_side.setter
    def cloud_qos_service_side(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cloud_qos_service_side", value)

    @property
    @pulumi.getter
    def definitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LocalizedPolicyDefinitionArgs']]]]:
        """
        List of policy definitions
        """
        return pulumi.get(self, "definitions")

    @definitions.setter
    def definitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LocalizedPolicyDefinitionArgs']]]]):
        pulumi.set(self, "definitions", value)

    @property
    @pulumi.getter(name="flowVisibilityIpv4")
    def flow_visibility_ipv4(self) -> Optional[pulumi.Input[bool]]:
        """
        IPv4 flow visibility - Default value: `true`
        """
        return pulumi.get(self, "flow_visibility_ipv4")

    @flow_visibility_ipv4.setter
    def flow_visibility_ipv4(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "flow_visibility_ipv4", value)

    @property
    @pulumi.getter(name="flowVisibilityIpv6")
    def flow_visibility_ipv6(self) -> Optional[pulumi.Input[bool]]:
        """
        IPv6 flow visibility - Default value: `true`
        """
        return pulumi.get(self, "flow_visibility_ipv6")

    @flow_visibility_ipv6.setter
    def flow_visibility_ipv6(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "flow_visibility_ipv6", value)

    @property
    @pulumi.getter(name="implicitAclLogging")
    def implicit_acl_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        Implicit ACL logging - Default value: `true`
        """
        return pulumi.get(self, "implicit_acl_logging")

    @implicit_acl_logging.setter
    def implicit_acl_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "implicit_acl_logging", value)

    @property
    @pulumi.getter(name="ipv4VisibilityCacheEntries")
    def ipv4_visibility_cache_entries(self) -> Optional[pulumi.Input[int]]:
        """
        IPv4 visibility cache entries - Range: `16`-`2000000`
        """
        return pulumi.get(self, "ipv4_visibility_cache_entries")

    @ipv4_visibility_cache_entries.setter
    def ipv4_visibility_cache_entries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_visibility_cache_entries", value)

    @property
    @pulumi.getter(name="ipv6VisibilityCacheEntries")
    def ipv6_visibility_cache_entries(self) -> Optional[pulumi.Input[int]]:
        """
        IPv6 visibility cache entries - Range: `16`-`2000000`
        """
        return pulumi.get(self, "ipv6_visibility_cache_entries")

    @ipv6_visibility_cache_entries.setter
    def ipv6_visibility_cache_entries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_visibility_cache_entries", value)

    @property
    @pulumi.getter(name="logFrequency")
    def log_frequency(self) -> Optional[pulumi.Input[int]]:
        """
        Log frequency - Range: `1`-`2147483647`
        """
        return pulumi.get(self, "log_frequency")

    @log_frequency.setter
    def log_frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "log_frequency", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the localized policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _LocalizedPolicyState:
    def __init__(__self__, *,
                 application_visibility_ipv4: Optional[pulumi.Input[bool]] = None,
                 application_visibility_ipv6: Optional[pulumi.Input[bool]] = None,
                 cloud_qos: Optional[pulumi.Input[bool]] = None,
                 cloud_qos_service_side: Optional[pulumi.Input[bool]] = None,
                 definitions: Optional[pulumi.Input[Sequence[pulumi.Input['LocalizedPolicyDefinitionArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flow_visibility_ipv4: Optional[pulumi.Input[bool]] = None,
                 flow_visibility_ipv6: Optional[pulumi.Input[bool]] = None,
                 implicit_acl_logging: Optional[pulumi.Input[bool]] = None,
                 ipv4_visibility_cache_entries: Optional[pulumi.Input[int]] = None,
                 ipv6_visibility_cache_entries: Optional[pulumi.Input[int]] = None,
                 log_frequency: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering LocalizedPolicy resources.
        :param pulumi.Input[bool] application_visibility_ipv4: IPv4 application visibility - Default value: `true`
        :param pulumi.Input[bool] application_visibility_ipv6: IPv6 application visibility - Default value: `true`
        :param pulumi.Input[bool] cloud_qos: Cloud QoS - Default value: `true`
        :param pulumi.Input[bool] cloud_qos_service_side: Cloud QoS service side - Default value: `true`
        :param pulumi.Input[Sequence[pulumi.Input['LocalizedPolicyDefinitionArgs']]] definitions: List of policy definitions
        :param pulumi.Input[str] description: The description of the localized policy
        :param pulumi.Input[bool] flow_visibility_ipv4: IPv4 flow visibility - Default value: `true`
        :param pulumi.Input[bool] flow_visibility_ipv6: IPv6 flow visibility - Default value: `true`
        :param pulumi.Input[bool] implicit_acl_logging: Implicit ACL logging - Default value: `true`
        :param pulumi.Input[int] ipv4_visibility_cache_entries: IPv4 visibility cache entries - Range: `16`-`2000000`
        :param pulumi.Input[int] ipv6_visibility_cache_entries: IPv6 visibility cache entries - Range: `16`-`2000000`
        :param pulumi.Input[int] log_frequency: Log frequency - Range: `1`-`2147483647`
        :param pulumi.Input[str] name: The name of the localized policy
        :param pulumi.Input[int] version: The version of the object
        """
        if application_visibility_ipv4 is not None:
            pulumi.set(__self__, "application_visibility_ipv4", application_visibility_ipv4)
        if application_visibility_ipv6 is not None:
            pulumi.set(__self__, "application_visibility_ipv6", application_visibility_ipv6)
        if cloud_qos is not None:
            pulumi.set(__self__, "cloud_qos", cloud_qos)
        if cloud_qos_service_side is not None:
            pulumi.set(__self__, "cloud_qos_service_side", cloud_qos_service_side)
        if definitions is not None:
            pulumi.set(__self__, "definitions", definitions)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flow_visibility_ipv4 is not None:
            pulumi.set(__self__, "flow_visibility_ipv4", flow_visibility_ipv4)
        if flow_visibility_ipv6 is not None:
            pulumi.set(__self__, "flow_visibility_ipv6", flow_visibility_ipv6)
        if implicit_acl_logging is not None:
            pulumi.set(__self__, "implicit_acl_logging", implicit_acl_logging)
        if ipv4_visibility_cache_entries is not None:
            pulumi.set(__self__, "ipv4_visibility_cache_entries", ipv4_visibility_cache_entries)
        if ipv6_visibility_cache_entries is not None:
            pulumi.set(__self__, "ipv6_visibility_cache_entries", ipv6_visibility_cache_entries)
        if log_frequency is not None:
            pulumi.set(__self__, "log_frequency", log_frequency)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="applicationVisibilityIpv4")
    def application_visibility_ipv4(self) -> Optional[pulumi.Input[bool]]:
        """
        IPv4 application visibility - Default value: `true`
        """
        return pulumi.get(self, "application_visibility_ipv4")

    @application_visibility_ipv4.setter
    def application_visibility_ipv4(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "application_visibility_ipv4", value)

    @property
    @pulumi.getter(name="applicationVisibilityIpv6")
    def application_visibility_ipv6(self) -> Optional[pulumi.Input[bool]]:
        """
        IPv6 application visibility - Default value: `true`
        """
        return pulumi.get(self, "application_visibility_ipv6")

    @application_visibility_ipv6.setter
    def application_visibility_ipv6(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "application_visibility_ipv6", value)

    @property
    @pulumi.getter(name="cloudQos")
    def cloud_qos(self) -> Optional[pulumi.Input[bool]]:
        """
        Cloud QoS - Default value: `true`
        """
        return pulumi.get(self, "cloud_qos")

    @cloud_qos.setter
    def cloud_qos(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cloud_qos", value)

    @property
    @pulumi.getter(name="cloudQosServiceSide")
    def cloud_qos_service_side(self) -> Optional[pulumi.Input[bool]]:
        """
        Cloud QoS service side - Default value: `true`
        """
        return pulumi.get(self, "cloud_qos_service_side")

    @cloud_qos_service_side.setter
    def cloud_qos_service_side(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "cloud_qos_service_side", value)

    @property
    @pulumi.getter
    def definitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LocalizedPolicyDefinitionArgs']]]]:
        """
        List of policy definitions
        """
        return pulumi.get(self, "definitions")

    @definitions.setter
    def definitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LocalizedPolicyDefinitionArgs']]]]):
        pulumi.set(self, "definitions", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the localized policy
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="flowVisibilityIpv4")
    def flow_visibility_ipv4(self) -> Optional[pulumi.Input[bool]]:
        """
        IPv4 flow visibility - Default value: `true`
        """
        return pulumi.get(self, "flow_visibility_ipv4")

    @flow_visibility_ipv4.setter
    def flow_visibility_ipv4(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "flow_visibility_ipv4", value)

    @property
    @pulumi.getter(name="flowVisibilityIpv6")
    def flow_visibility_ipv6(self) -> Optional[pulumi.Input[bool]]:
        """
        IPv6 flow visibility - Default value: `true`
        """
        return pulumi.get(self, "flow_visibility_ipv6")

    @flow_visibility_ipv6.setter
    def flow_visibility_ipv6(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "flow_visibility_ipv6", value)

    @property
    @pulumi.getter(name="implicitAclLogging")
    def implicit_acl_logging(self) -> Optional[pulumi.Input[bool]]:
        """
        Implicit ACL logging - Default value: `true`
        """
        return pulumi.get(self, "implicit_acl_logging")

    @implicit_acl_logging.setter
    def implicit_acl_logging(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "implicit_acl_logging", value)

    @property
    @pulumi.getter(name="ipv4VisibilityCacheEntries")
    def ipv4_visibility_cache_entries(self) -> Optional[pulumi.Input[int]]:
        """
        IPv4 visibility cache entries - Range: `16`-`2000000`
        """
        return pulumi.get(self, "ipv4_visibility_cache_entries")

    @ipv4_visibility_cache_entries.setter
    def ipv4_visibility_cache_entries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv4_visibility_cache_entries", value)

    @property
    @pulumi.getter(name="ipv6VisibilityCacheEntries")
    def ipv6_visibility_cache_entries(self) -> Optional[pulumi.Input[int]]:
        """
        IPv6 visibility cache entries - Range: `16`-`2000000`
        """
        return pulumi.get(self, "ipv6_visibility_cache_entries")

    @ipv6_visibility_cache_entries.setter
    def ipv6_visibility_cache_entries(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "ipv6_visibility_cache_entries", value)

    @property
    @pulumi.getter(name="logFrequency")
    def log_frequency(self) -> Optional[pulumi.Input[int]]:
        """
        Log frequency - Range: `1`-`2147483647`
        """
        return pulumi.get(self, "log_frequency")

    @log_frequency.setter
    def log_frequency(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "log_frequency", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the localized policy
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class LocalizedPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_visibility_ipv4: Optional[pulumi.Input[bool]] = None,
                 application_visibility_ipv6: Optional[pulumi.Input[bool]] = None,
                 cloud_qos: Optional[pulumi.Input[bool]] = None,
                 cloud_qos_service_side: Optional[pulumi.Input[bool]] = None,
                 definitions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LocalizedPolicyDefinitionArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flow_visibility_ipv4: Optional[pulumi.Input[bool]] = None,
                 flow_visibility_ipv6: Optional[pulumi.Input[bool]] = None,
                 implicit_acl_logging: Optional[pulumi.Input[bool]] = None,
                 ipv4_visibility_cache_entries: Optional[pulumi.Input[int]] = None,
                 ipv6_visibility_cache_entries: Optional[pulumi.Input[int]] = None,
                 log_frequency: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can manage a Localized Policy .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.LocalizedPolicy("example",
            name="Example",
            description="My description",
            flow_visibility_ipv4=True,
            flow_visibility_ipv6=True,
            application_visibility_ipv4=True,
            application_visibility_ipv6=True,
            cloud_qos=True,
            cloud_qos_service_side=True,
            implicit_acl_logging=True,
            log_frequency=1000,
            ipv4_visibility_cache_entries=1000,
            ipv6_visibility_cache_entries=1000,
            definitions=[sdwan.LocalizedPolicyDefinitionArgs(
                id="2081c2f4-3f9f-4fee-8078-dcc8904e368d",
                type="acl",
            )])
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/localizedPolicy:LocalizedPolicy example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] application_visibility_ipv4: IPv4 application visibility - Default value: `true`
        :param pulumi.Input[bool] application_visibility_ipv6: IPv6 application visibility - Default value: `true`
        :param pulumi.Input[bool] cloud_qos: Cloud QoS - Default value: `true`
        :param pulumi.Input[bool] cloud_qos_service_side: Cloud QoS service side - Default value: `true`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LocalizedPolicyDefinitionArgs']]]] definitions: List of policy definitions
        :param pulumi.Input[str] description: The description of the localized policy
        :param pulumi.Input[bool] flow_visibility_ipv4: IPv4 flow visibility - Default value: `true`
        :param pulumi.Input[bool] flow_visibility_ipv6: IPv6 flow visibility - Default value: `true`
        :param pulumi.Input[bool] implicit_acl_logging: Implicit ACL logging - Default value: `true`
        :param pulumi.Input[int] ipv4_visibility_cache_entries: IPv4 visibility cache entries - Range: `16`-`2000000`
        :param pulumi.Input[int] ipv6_visibility_cache_entries: IPv6 visibility cache entries - Range: `16`-`2000000`
        :param pulumi.Input[int] log_frequency: Log frequency - Range: `1`-`2147483647`
        :param pulumi.Input[str] name: The name of the localized policy
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LocalizedPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a Localized Policy .

        ## Example Usage

        ```python
        import pulumi
        import pulumi_sdwan as sdwan

        example = sdwan.LocalizedPolicy("example",
            name="Example",
            description="My description",
            flow_visibility_ipv4=True,
            flow_visibility_ipv6=True,
            application_visibility_ipv4=True,
            application_visibility_ipv6=True,
            cloud_qos=True,
            cloud_qos_service_side=True,
            implicit_acl_logging=True,
            log_frequency=1000,
            ipv4_visibility_cache_entries=1000,
            ipv6_visibility_cache_entries=1000,
            definitions=[sdwan.LocalizedPolicyDefinitionArgs(
                id="2081c2f4-3f9f-4fee-8078-dcc8904e368d",
                type="acl",
            )])
        ```

        ## Import

        ```sh
        $ pulumi import sdwan:index/localizedPolicy:LocalizedPolicy example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param LocalizedPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LocalizedPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_visibility_ipv4: Optional[pulumi.Input[bool]] = None,
                 application_visibility_ipv6: Optional[pulumi.Input[bool]] = None,
                 cloud_qos: Optional[pulumi.Input[bool]] = None,
                 cloud_qos_service_side: Optional[pulumi.Input[bool]] = None,
                 definitions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LocalizedPolicyDefinitionArgs']]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flow_visibility_ipv4: Optional[pulumi.Input[bool]] = None,
                 flow_visibility_ipv6: Optional[pulumi.Input[bool]] = None,
                 implicit_acl_logging: Optional[pulumi.Input[bool]] = None,
                 ipv4_visibility_cache_entries: Optional[pulumi.Input[int]] = None,
                 ipv6_visibility_cache_entries: Optional[pulumi.Input[int]] = None,
                 log_frequency: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LocalizedPolicyArgs.__new__(LocalizedPolicyArgs)

            __props__.__dict__["application_visibility_ipv4"] = application_visibility_ipv4
            __props__.__dict__["application_visibility_ipv6"] = application_visibility_ipv6
            __props__.__dict__["cloud_qos"] = cloud_qos
            __props__.__dict__["cloud_qos_service_side"] = cloud_qos_service_side
            __props__.__dict__["definitions"] = definitions
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["flow_visibility_ipv4"] = flow_visibility_ipv4
            __props__.__dict__["flow_visibility_ipv6"] = flow_visibility_ipv6
            __props__.__dict__["implicit_acl_logging"] = implicit_acl_logging
            __props__.__dict__["ipv4_visibility_cache_entries"] = ipv4_visibility_cache_entries
            __props__.__dict__["ipv6_visibility_cache_entries"] = ipv6_visibility_cache_entries
            __props__.__dict__["log_frequency"] = log_frequency
            __props__.__dict__["name"] = name
            __props__.__dict__["version"] = None
        super(LocalizedPolicy, __self__).__init__(
            'sdwan:index/localizedPolicy:LocalizedPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_visibility_ipv4: Optional[pulumi.Input[bool]] = None,
            application_visibility_ipv6: Optional[pulumi.Input[bool]] = None,
            cloud_qos: Optional[pulumi.Input[bool]] = None,
            cloud_qos_service_side: Optional[pulumi.Input[bool]] = None,
            definitions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LocalizedPolicyDefinitionArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            flow_visibility_ipv4: Optional[pulumi.Input[bool]] = None,
            flow_visibility_ipv6: Optional[pulumi.Input[bool]] = None,
            implicit_acl_logging: Optional[pulumi.Input[bool]] = None,
            ipv4_visibility_cache_entries: Optional[pulumi.Input[int]] = None,
            ipv6_visibility_cache_entries: Optional[pulumi.Input[int]] = None,
            log_frequency: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'LocalizedPolicy':
        """
        Get an existing LocalizedPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] application_visibility_ipv4: IPv4 application visibility - Default value: `true`
        :param pulumi.Input[bool] application_visibility_ipv6: IPv6 application visibility - Default value: `true`
        :param pulumi.Input[bool] cloud_qos: Cloud QoS - Default value: `true`
        :param pulumi.Input[bool] cloud_qos_service_side: Cloud QoS service side - Default value: `true`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['LocalizedPolicyDefinitionArgs']]]] definitions: List of policy definitions
        :param pulumi.Input[str] description: The description of the localized policy
        :param pulumi.Input[bool] flow_visibility_ipv4: IPv4 flow visibility - Default value: `true`
        :param pulumi.Input[bool] flow_visibility_ipv6: IPv6 flow visibility - Default value: `true`
        :param pulumi.Input[bool] implicit_acl_logging: Implicit ACL logging - Default value: `true`
        :param pulumi.Input[int] ipv4_visibility_cache_entries: IPv4 visibility cache entries - Range: `16`-`2000000`
        :param pulumi.Input[int] ipv6_visibility_cache_entries: IPv6 visibility cache entries - Range: `16`-`2000000`
        :param pulumi.Input[int] log_frequency: Log frequency - Range: `1`-`2147483647`
        :param pulumi.Input[str] name: The name of the localized policy
        :param pulumi.Input[int] version: The version of the object
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LocalizedPolicyState.__new__(_LocalizedPolicyState)

        __props__.__dict__["application_visibility_ipv4"] = application_visibility_ipv4
        __props__.__dict__["application_visibility_ipv6"] = application_visibility_ipv6
        __props__.__dict__["cloud_qos"] = cloud_qos
        __props__.__dict__["cloud_qos_service_side"] = cloud_qos_service_side
        __props__.__dict__["definitions"] = definitions
        __props__.__dict__["description"] = description
        __props__.__dict__["flow_visibility_ipv4"] = flow_visibility_ipv4
        __props__.__dict__["flow_visibility_ipv6"] = flow_visibility_ipv6
        __props__.__dict__["implicit_acl_logging"] = implicit_acl_logging
        __props__.__dict__["ipv4_visibility_cache_entries"] = ipv4_visibility_cache_entries
        __props__.__dict__["ipv6_visibility_cache_entries"] = ipv6_visibility_cache_entries
        __props__.__dict__["log_frequency"] = log_frequency
        __props__.__dict__["name"] = name
        __props__.__dict__["version"] = version
        return LocalizedPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applicationVisibilityIpv4")
    def application_visibility_ipv4(self) -> pulumi.Output[bool]:
        """
        IPv4 application visibility - Default value: `true`
        """
        return pulumi.get(self, "application_visibility_ipv4")

    @property
    @pulumi.getter(name="applicationVisibilityIpv6")
    def application_visibility_ipv6(self) -> pulumi.Output[bool]:
        """
        IPv6 application visibility - Default value: `true`
        """
        return pulumi.get(self, "application_visibility_ipv6")

    @property
    @pulumi.getter(name="cloudQos")
    def cloud_qos(self) -> pulumi.Output[bool]:
        """
        Cloud QoS - Default value: `true`
        """
        return pulumi.get(self, "cloud_qos")

    @property
    @pulumi.getter(name="cloudQosServiceSide")
    def cloud_qos_service_side(self) -> pulumi.Output[bool]:
        """
        Cloud QoS service side - Default value: `true`
        """
        return pulumi.get(self, "cloud_qos_service_side")

    @property
    @pulumi.getter
    def definitions(self) -> pulumi.Output[Optional[Sequence['outputs.LocalizedPolicyDefinition']]]:
        """
        List of policy definitions
        """
        return pulumi.get(self, "definitions")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the localized policy
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="flowVisibilityIpv4")
    def flow_visibility_ipv4(self) -> pulumi.Output[bool]:
        """
        IPv4 flow visibility - Default value: `true`
        """
        return pulumi.get(self, "flow_visibility_ipv4")

    @property
    @pulumi.getter(name="flowVisibilityIpv6")
    def flow_visibility_ipv6(self) -> pulumi.Output[bool]:
        """
        IPv6 flow visibility - Default value: `true`
        """
        return pulumi.get(self, "flow_visibility_ipv6")

    @property
    @pulumi.getter(name="implicitAclLogging")
    def implicit_acl_logging(self) -> pulumi.Output[bool]:
        """
        Implicit ACL logging - Default value: `true`
        """
        return pulumi.get(self, "implicit_acl_logging")

    @property
    @pulumi.getter(name="ipv4VisibilityCacheEntries")
    def ipv4_visibility_cache_entries(self) -> pulumi.Output[Optional[int]]:
        """
        IPv4 visibility cache entries - Range: `16`-`2000000`
        """
        return pulumi.get(self, "ipv4_visibility_cache_entries")

    @property
    @pulumi.getter(name="ipv6VisibilityCacheEntries")
    def ipv6_visibility_cache_entries(self) -> pulumi.Output[Optional[int]]:
        """
        IPv6 visibility cache entries - Range: `16`-`2000000`
        """
        return pulumi.get(self, "ipv6_visibility_cache_entries")

    @property
    @pulumi.getter(name="logFrequency")
    def log_frequency(self) -> pulumi.Output[Optional[int]]:
        """
        Log frequency - Range: `1`-`2147483647`
        """
        return pulumi.get(self, "log_frequency")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the localized policy
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

