# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TlsSslDecryptionPolicyDefinitionArgs', 'TlsSslDecryptionPolicyDefinition']

@pulumi.input_type
class TlsSslDecryptionPolicyDefinitionArgs:
    def __init__(__self__, *,
                 description: pulumi.Input[str],
                 certificate_lifetime_in_days: Optional[pulumi.Input[int]] = None,
                 certificate_revocation_status: Optional[pulumi.Input[str]] = None,
                 default_action: Optional[pulumi.Input[str]] = None,
                 ec_key_type: Optional[pulumi.Input[str]] = None,
                 expired_certificate: Optional[pulumi.Input[str]] = None,
                 failure_mode: Optional[pulumi.Input[str]] = None,
                 minimal_tls_version: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_rules: Optional[pulumi.Input[Sequence[pulumi.Input['TlsSslDecryptionPolicyDefinitionNetworkRuleArgs']]]] = None,
                 rsa_key_pair_modulus: Optional[pulumi.Input[str]] = None,
                 ssl_decryption_enabled: Optional[pulumi.Input[str]] = None,
                 unknown_revocation_status: Optional[pulumi.Input[str]] = None,
                 unsupported_cipher_suites: Optional[pulumi.Input[str]] = None,
                 unsupported_protocol_versions: Optional[pulumi.Input[str]] = None,
                 untrusted_certificate: Optional[pulumi.Input[str]] = None,
                 url_rules: Optional[pulumi.Input[Sequence[pulumi.Input['TlsSslDecryptionPolicyDefinitionUrlRuleArgs']]]] = None,
                 use_default_ca_cert_bundle: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a TlsSslDecryptionPolicyDefinition resource.
        :param pulumi.Input[str] description: The description of the policy definition.
        :param pulumi.Input[int] certificate_lifetime_in_days: Certificate Lifetime(in Days)
        :param pulumi.Input[str] certificate_revocation_status: Certificate revocation status - Choices: `ocsp`, `none`
        :param pulumi.Input[str] default_action: Default action (applies when `mode` set to `security`) - Choices: `noIntent`, `doNotDecrypt`, `decrypt`
        :param pulumi.Input[str] ec_key_type: EC Key Type - Choices: `P256`, `P384`, `P521`
        :param pulumi.Input[str] expired_certificate: Expired certificate action - Choices: `drop`, `decrypt`
        :param pulumi.Input[str] failure_mode: Failure mode - Choices: `open`, `close`
        :param pulumi.Input[str] minimal_tls_version: Minimal TLS Version - Choices: `TLSv1.0`, `TLSv1.1`, `TLSv1.2`
        :param pulumi.Input[str] mode: The policy mode - Choices: `security`, `unified`
        :param pulumi.Input[str] name: The name of the policy definition.
        :param pulumi.Input[Sequence[pulumi.Input['TlsSslDecryptionPolicyDefinitionNetworkRuleArgs']]] network_rules: List of network rules (applies when `mode` set to `security`)
        :param pulumi.Input[str] rsa_key_pair_modulus: RSA key pair modules - Choices: `1024`, `2048`, `4096`
        :param pulumi.Input[str] ssl_decryption_enabled: SSL decryption enabled
        :param pulumi.Input[str] unknown_revocation_status: Unknown revocation status action - Choices: `drop`, `decrypt`
        :param pulumi.Input[str] unsupported_cipher_suites: Unsupported cipher suites action - Choices: `drop`, `no-decrypt`
        :param pulumi.Input[str] unsupported_protocol_versions: Unsupported protocol versions action - Choices: `drop`, `no-decrypt`
        :param pulumi.Input[str] untrusted_certificate: Untrusted certificate action - Choices: `drop`, `decrypt`
        :param pulumi.Input[Sequence[pulumi.Input['TlsSslDecryptionPolicyDefinitionUrlRuleArgs']]] url_rules: List of url rules (applies when `mode` set to `security`)
        :param pulumi.Input[bool] use_default_ca_cert_bundle: Use default CA certificate bundle
        """
        pulumi.set(__self__, "description", description)
        if certificate_lifetime_in_days is not None:
            pulumi.set(__self__, "certificate_lifetime_in_days", certificate_lifetime_in_days)
        if certificate_revocation_status is not None:
            pulumi.set(__self__, "certificate_revocation_status", certificate_revocation_status)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if ec_key_type is not None:
            pulumi.set(__self__, "ec_key_type", ec_key_type)
        if expired_certificate is not None:
            pulumi.set(__self__, "expired_certificate", expired_certificate)
        if failure_mode is not None:
            pulumi.set(__self__, "failure_mode", failure_mode)
        if minimal_tls_version is not None:
            pulumi.set(__self__, "minimal_tls_version", minimal_tls_version)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_rules is not None:
            pulumi.set(__self__, "network_rules", network_rules)
        if rsa_key_pair_modulus is not None:
            pulumi.set(__self__, "rsa_key_pair_modulus", rsa_key_pair_modulus)
        if ssl_decryption_enabled is not None:
            pulumi.set(__self__, "ssl_decryption_enabled", ssl_decryption_enabled)
        if unknown_revocation_status is not None:
            pulumi.set(__self__, "unknown_revocation_status", unknown_revocation_status)
        if unsupported_cipher_suites is not None:
            pulumi.set(__self__, "unsupported_cipher_suites", unsupported_cipher_suites)
        if unsupported_protocol_versions is not None:
            pulumi.set(__self__, "unsupported_protocol_versions", unsupported_protocol_versions)
        if untrusted_certificate is not None:
            pulumi.set(__self__, "untrusted_certificate", untrusted_certificate)
        if url_rules is not None:
            pulumi.set(__self__, "url_rules", url_rules)
        if use_default_ca_cert_bundle is not None:
            pulumi.set(__self__, "use_default_ca_cert_bundle", use_default_ca_cert_bundle)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Input[str]:
        """
        The description of the policy definition.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: pulumi.Input[str]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="certificateLifetimeInDays")
    def certificate_lifetime_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Certificate Lifetime(in Days)
        """
        return pulumi.get(self, "certificate_lifetime_in_days")

    @certificate_lifetime_in_days.setter
    def certificate_lifetime_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "certificate_lifetime_in_days", value)

    @property
    @pulumi.getter(name="certificateRevocationStatus")
    def certificate_revocation_status(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate revocation status - Choices: `ocsp`, `none`
        """
        return pulumi.get(self, "certificate_revocation_status")

    @certificate_revocation_status.setter
    def certificate_revocation_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_revocation_status", value)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[str]]:
        """
        Default action (applies when `mode` set to `security`) - Choices: `noIntent`, `doNotDecrypt`, `decrypt`
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter(name="ecKeyType")
    def ec_key_type(self) -> Optional[pulumi.Input[str]]:
        """
        EC Key Type - Choices: `P256`, `P384`, `P521`
        """
        return pulumi.get(self, "ec_key_type")

    @ec_key_type.setter
    def ec_key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ec_key_type", value)

    @property
    @pulumi.getter(name="expiredCertificate")
    def expired_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Expired certificate action - Choices: `drop`, `decrypt`
        """
        return pulumi.get(self, "expired_certificate")

    @expired_certificate.setter
    def expired_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expired_certificate", value)

    @property
    @pulumi.getter(name="failureMode")
    def failure_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Failure mode - Choices: `open`, `close`
        """
        return pulumi.get(self, "failure_mode")

    @failure_mode.setter
    def failure_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failure_mode", value)

    @property
    @pulumi.getter(name="minimalTlsVersion")
    def minimal_tls_version(self) -> Optional[pulumi.Input[str]]:
        """
        Minimal TLS Version - Choices: `TLSv1.0`, `TLSv1.1`, `TLSv1.2`
        """
        return pulumi.get(self, "minimal_tls_version")

    @minimal_tls_version.setter
    def minimal_tls_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "minimal_tls_version", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        The policy mode - Choices: `security`, `unified`
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy definition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkRules")
    def network_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TlsSslDecryptionPolicyDefinitionNetworkRuleArgs']]]]:
        """
        List of network rules (applies when `mode` set to `security`)
        """
        return pulumi.get(self, "network_rules")

    @network_rules.setter
    def network_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TlsSslDecryptionPolicyDefinitionNetworkRuleArgs']]]]):
        pulumi.set(self, "network_rules", value)

    @property
    @pulumi.getter(name="rsaKeyPairModulus")
    def rsa_key_pair_modulus(self) -> Optional[pulumi.Input[str]]:
        """
        RSA key pair modules - Choices: `1024`, `2048`, `4096`
        """
        return pulumi.get(self, "rsa_key_pair_modulus")

    @rsa_key_pair_modulus.setter
    def rsa_key_pair_modulus(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rsa_key_pair_modulus", value)

    @property
    @pulumi.getter(name="sslDecryptionEnabled")
    def ssl_decryption_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        SSL decryption enabled
        """
        return pulumi.get(self, "ssl_decryption_enabled")

    @ssl_decryption_enabled.setter
    def ssl_decryption_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_decryption_enabled", value)

    @property
    @pulumi.getter(name="unknownRevocationStatus")
    def unknown_revocation_status(self) -> Optional[pulumi.Input[str]]:
        """
        Unknown revocation status action - Choices: `drop`, `decrypt`
        """
        return pulumi.get(self, "unknown_revocation_status")

    @unknown_revocation_status.setter
    def unknown_revocation_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unknown_revocation_status", value)

    @property
    @pulumi.getter(name="unsupportedCipherSuites")
    def unsupported_cipher_suites(self) -> Optional[pulumi.Input[str]]:
        """
        Unsupported cipher suites action - Choices: `drop`, `no-decrypt`
        """
        return pulumi.get(self, "unsupported_cipher_suites")

    @unsupported_cipher_suites.setter
    def unsupported_cipher_suites(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unsupported_cipher_suites", value)

    @property
    @pulumi.getter(name="unsupportedProtocolVersions")
    def unsupported_protocol_versions(self) -> Optional[pulumi.Input[str]]:
        """
        Unsupported protocol versions action - Choices: `drop`, `no-decrypt`
        """
        return pulumi.get(self, "unsupported_protocol_versions")

    @unsupported_protocol_versions.setter
    def unsupported_protocol_versions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unsupported_protocol_versions", value)

    @property
    @pulumi.getter(name="untrustedCertificate")
    def untrusted_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Untrusted certificate action - Choices: `drop`, `decrypt`
        """
        return pulumi.get(self, "untrusted_certificate")

    @untrusted_certificate.setter
    def untrusted_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "untrusted_certificate", value)

    @property
    @pulumi.getter(name="urlRules")
    def url_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TlsSslDecryptionPolicyDefinitionUrlRuleArgs']]]]:
        """
        List of url rules (applies when `mode` set to `security`)
        """
        return pulumi.get(self, "url_rules")

    @url_rules.setter
    def url_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TlsSslDecryptionPolicyDefinitionUrlRuleArgs']]]]):
        pulumi.set(self, "url_rules", value)

    @property
    @pulumi.getter(name="useDefaultCaCertBundle")
    def use_default_ca_cert_bundle(self) -> Optional[pulumi.Input[bool]]:
        """
        Use default CA certificate bundle
        """
        return pulumi.get(self, "use_default_ca_cert_bundle")

    @use_default_ca_cert_bundle.setter
    def use_default_ca_cert_bundle(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_default_ca_cert_bundle", value)


@pulumi.input_type
class _TlsSslDecryptionPolicyDefinitionState:
    def __init__(__self__, *,
                 certificate_lifetime_in_days: Optional[pulumi.Input[int]] = None,
                 certificate_revocation_status: Optional[pulumi.Input[str]] = None,
                 default_action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ec_key_type: Optional[pulumi.Input[str]] = None,
                 expired_certificate: Optional[pulumi.Input[str]] = None,
                 failure_mode: Optional[pulumi.Input[str]] = None,
                 minimal_tls_version: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_rules: Optional[pulumi.Input[Sequence[pulumi.Input['TlsSslDecryptionPolicyDefinitionNetworkRuleArgs']]]] = None,
                 rsa_key_pair_modulus: Optional[pulumi.Input[str]] = None,
                 ssl_decryption_enabled: Optional[pulumi.Input[str]] = None,
                 unknown_revocation_status: Optional[pulumi.Input[str]] = None,
                 unsupported_cipher_suites: Optional[pulumi.Input[str]] = None,
                 unsupported_protocol_versions: Optional[pulumi.Input[str]] = None,
                 untrusted_certificate: Optional[pulumi.Input[str]] = None,
                 url_rules: Optional[pulumi.Input[Sequence[pulumi.Input['TlsSslDecryptionPolicyDefinitionUrlRuleArgs']]]] = None,
                 use_default_ca_cert_bundle: Optional[pulumi.Input[bool]] = None,
                 version: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering TlsSslDecryptionPolicyDefinition resources.
        :param pulumi.Input[int] certificate_lifetime_in_days: Certificate Lifetime(in Days)
        :param pulumi.Input[str] certificate_revocation_status: Certificate revocation status - Choices: `ocsp`, `none`
        :param pulumi.Input[str] default_action: Default action (applies when `mode` set to `security`) - Choices: `noIntent`, `doNotDecrypt`, `decrypt`
        :param pulumi.Input[str] description: The description of the policy definition.
        :param pulumi.Input[str] ec_key_type: EC Key Type - Choices: `P256`, `P384`, `P521`
        :param pulumi.Input[str] expired_certificate: Expired certificate action - Choices: `drop`, `decrypt`
        :param pulumi.Input[str] failure_mode: Failure mode - Choices: `open`, `close`
        :param pulumi.Input[str] minimal_tls_version: Minimal TLS Version - Choices: `TLSv1.0`, `TLSv1.1`, `TLSv1.2`
        :param pulumi.Input[str] mode: The policy mode - Choices: `security`, `unified`
        :param pulumi.Input[str] name: The name of the policy definition.
        :param pulumi.Input[Sequence[pulumi.Input['TlsSslDecryptionPolicyDefinitionNetworkRuleArgs']]] network_rules: List of network rules (applies when `mode` set to `security`)
        :param pulumi.Input[str] rsa_key_pair_modulus: RSA key pair modules - Choices: `1024`, `2048`, `4096`
        :param pulumi.Input[str] ssl_decryption_enabled: SSL decryption enabled
        :param pulumi.Input[str] unknown_revocation_status: Unknown revocation status action - Choices: `drop`, `decrypt`
        :param pulumi.Input[str] unsupported_cipher_suites: Unsupported cipher suites action - Choices: `drop`, `no-decrypt`
        :param pulumi.Input[str] unsupported_protocol_versions: Unsupported protocol versions action - Choices: `drop`, `no-decrypt`
        :param pulumi.Input[str] untrusted_certificate: Untrusted certificate action - Choices: `drop`, `decrypt`
        :param pulumi.Input[Sequence[pulumi.Input['TlsSslDecryptionPolicyDefinitionUrlRuleArgs']]] url_rules: List of url rules (applies when `mode` set to `security`)
        :param pulumi.Input[bool] use_default_ca_cert_bundle: Use default CA certificate bundle
        :param pulumi.Input[int] version: The version of the object
        """
        if certificate_lifetime_in_days is not None:
            pulumi.set(__self__, "certificate_lifetime_in_days", certificate_lifetime_in_days)
        if certificate_revocation_status is not None:
            pulumi.set(__self__, "certificate_revocation_status", certificate_revocation_status)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ec_key_type is not None:
            pulumi.set(__self__, "ec_key_type", ec_key_type)
        if expired_certificate is not None:
            pulumi.set(__self__, "expired_certificate", expired_certificate)
        if failure_mode is not None:
            pulumi.set(__self__, "failure_mode", failure_mode)
        if minimal_tls_version is not None:
            pulumi.set(__self__, "minimal_tls_version", minimal_tls_version)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_rules is not None:
            pulumi.set(__self__, "network_rules", network_rules)
        if rsa_key_pair_modulus is not None:
            pulumi.set(__self__, "rsa_key_pair_modulus", rsa_key_pair_modulus)
        if ssl_decryption_enabled is not None:
            pulumi.set(__self__, "ssl_decryption_enabled", ssl_decryption_enabled)
        if unknown_revocation_status is not None:
            pulumi.set(__self__, "unknown_revocation_status", unknown_revocation_status)
        if unsupported_cipher_suites is not None:
            pulumi.set(__self__, "unsupported_cipher_suites", unsupported_cipher_suites)
        if unsupported_protocol_versions is not None:
            pulumi.set(__self__, "unsupported_protocol_versions", unsupported_protocol_versions)
        if untrusted_certificate is not None:
            pulumi.set(__self__, "untrusted_certificate", untrusted_certificate)
        if url_rules is not None:
            pulumi.set(__self__, "url_rules", url_rules)
        if use_default_ca_cert_bundle is not None:
            pulumi.set(__self__, "use_default_ca_cert_bundle", use_default_ca_cert_bundle)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="certificateLifetimeInDays")
    def certificate_lifetime_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        Certificate Lifetime(in Days)
        """
        return pulumi.get(self, "certificate_lifetime_in_days")

    @certificate_lifetime_in_days.setter
    def certificate_lifetime_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "certificate_lifetime_in_days", value)

    @property
    @pulumi.getter(name="certificateRevocationStatus")
    def certificate_revocation_status(self) -> Optional[pulumi.Input[str]]:
        """
        Certificate revocation status - Choices: `ocsp`, `none`
        """
        return pulumi.get(self, "certificate_revocation_status")

    @certificate_revocation_status.setter
    def certificate_revocation_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_revocation_status", value)

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[str]]:
        """
        Default action (applies when `mode` set to `security`) - Choices: `noIntent`, `doNotDecrypt`, `decrypt`
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_action", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the policy definition.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="ecKeyType")
    def ec_key_type(self) -> Optional[pulumi.Input[str]]:
        """
        EC Key Type - Choices: `P256`, `P384`, `P521`
        """
        return pulumi.get(self, "ec_key_type")

    @ec_key_type.setter
    def ec_key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ec_key_type", value)

    @property
    @pulumi.getter(name="expiredCertificate")
    def expired_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Expired certificate action - Choices: `drop`, `decrypt`
        """
        return pulumi.get(self, "expired_certificate")

    @expired_certificate.setter
    def expired_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expired_certificate", value)

    @property
    @pulumi.getter(name="failureMode")
    def failure_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Failure mode - Choices: `open`, `close`
        """
        return pulumi.get(self, "failure_mode")

    @failure_mode.setter
    def failure_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "failure_mode", value)

    @property
    @pulumi.getter(name="minimalTlsVersion")
    def minimal_tls_version(self) -> Optional[pulumi.Input[str]]:
        """
        Minimal TLS Version - Choices: `TLSv1.0`, `TLSv1.1`, `TLSv1.2`
        """
        return pulumi.get(self, "minimal_tls_version")

    @minimal_tls_version.setter
    def minimal_tls_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "minimal_tls_version", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        The policy mode - Choices: `security`, `unified`
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy definition.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkRules")
    def network_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TlsSslDecryptionPolicyDefinitionNetworkRuleArgs']]]]:
        """
        List of network rules (applies when `mode` set to `security`)
        """
        return pulumi.get(self, "network_rules")

    @network_rules.setter
    def network_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TlsSslDecryptionPolicyDefinitionNetworkRuleArgs']]]]):
        pulumi.set(self, "network_rules", value)

    @property
    @pulumi.getter(name="rsaKeyPairModulus")
    def rsa_key_pair_modulus(self) -> Optional[pulumi.Input[str]]:
        """
        RSA key pair modules - Choices: `1024`, `2048`, `4096`
        """
        return pulumi.get(self, "rsa_key_pair_modulus")

    @rsa_key_pair_modulus.setter
    def rsa_key_pair_modulus(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rsa_key_pair_modulus", value)

    @property
    @pulumi.getter(name="sslDecryptionEnabled")
    def ssl_decryption_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        SSL decryption enabled
        """
        return pulumi.get(self, "ssl_decryption_enabled")

    @ssl_decryption_enabled.setter
    def ssl_decryption_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_decryption_enabled", value)

    @property
    @pulumi.getter(name="unknownRevocationStatus")
    def unknown_revocation_status(self) -> Optional[pulumi.Input[str]]:
        """
        Unknown revocation status action - Choices: `drop`, `decrypt`
        """
        return pulumi.get(self, "unknown_revocation_status")

    @unknown_revocation_status.setter
    def unknown_revocation_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unknown_revocation_status", value)

    @property
    @pulumi.getter(name="unsupportedCipherSuites")
    def unsupported_cipher_suites(self) -> Optional[pulumi.Input[str]]:
        """
        Unsupported cipher suites action - Choices: `drop`, `no-decrypt`
        """
        return pulumi.get(self, "unsupported_cipher_suites")

    @unsupported_cipher_suites.setter
    def unsupported_cipher_suites(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unsupported_cipher_suites", value)

    @property
    @pulumi.getter(name="unsupportedProtocolVersions")
    def unsupported_protocol_versions(self) -> Optional[pulumi.Input[str]]:
        """
        Unsupported protocol versions action - Choices: `drop`, `no-decrypt`
        """
        return pulumi.get(self, "unsupported_protocol_versions")

    @unsupported_protocol_versions.setter
    def unsupported_protocol_versions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unsupported_protocol_versions", value)

    @property
    @pulumi.getter(name="untrustedCertificate")
    def untrusted_certificate(self) -> Optional[pulumi.Input[str]]:
        """
        Untrusted certificate action - Choices: `drop`, `decrypt`
        """
        return pulumi.get(self, "untrusted_certificate")

    @untrusted_certificate.setter
    def untrusted_certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "untrusted_certificate", value)

    @property
    @pulumi.getter(name="urlRules")
    def url_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TlsSslDecryptionPolicyDefinitionUrlRuleArgs']]]]:
        """
        List of url rules (applies when `mode` set to `security`)
        """
        return pulumi.get(self, "url_rules")

    @url_rules.setter
    def url_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TlsSslDecryptionPolicyDefinitionUrlRuleArgs']]]]):
        pulumi.set(self, "url_rules", value)

    @property
    @pulumi.getter(name="useDefaultCaCertBundle")
    def use_default_ca_cert_bundle(self) -> Optional[pulumi.Input[bool]]:
        """
        Use default CA certificate bundle
        """
        return pulumi.get(self, "use_default_ca_cert_bundle")

    @use_default_ca_cert_bundle.setter
    def use_default_ca_cert_bundle(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_default_ca_cert_bundle", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[int]]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "version", value)


class TlsSslDecryptionPolicyDefinition(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_lifetime_in_days: Optional[pulumi.Input[int]] = None,
                 certificate_revocation_status: Optional[pulumi.Input[str]] = None,
                 default_action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ec_key_type: Optional[pulumi.Input[str]] = None,
                 expired_certificate: Optional[pulumi.Input[str]] = None,
                 failure_mode: Optional[pulumi.Input[str]] = None,
                 minimal_tls_version: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TlsSslDecryptionPolicyDefinitionNetworkRuleArgs']]]]] = None,
                 rsa_key_pair_modulus: Optional[pulumi.Input[str]] = None,
                 ssl_decryption_enabled: Optional[pulumi.Input[str]] = None,
                 unknown_revocation_status: Optional[pulumi.Input[str]] = None,
                 unsupported_cipher_suites: Optional[pulumi.Input[str]] = None,
                 unsupported_protocol_versions: Optional[pulumi.Input[str]] = None,
                 untrusted_certificate: Optional[pulumi.Input[str]] = None,
                 url_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TlsSslDecryptionPolicyDefinitionUrlRuleArgs']]]]] = None,
                 use_default_ca_cert_bundle: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        This resource can manage a TLS SSL Decryption Policy Definition .

        ## Import

        ```sh
        $ pulumi import sdwan:index/tlsSslDecryptionPolicyDefinition:TlsSslDecryptionPolicyDefinition example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] certificate_lifetime_in_days: Certificate Lifetime(in Days)
        :param pulumi.Input[str] certificate_revocation_status: Certificate revocation status - Choices: `ocsp`, `none`
        :param pulumi.Input[str] default_action: Default action (applies when `mode` set to `security`) - Choices: `noIntent`, `doNotDecrypt`, `decrypt`
        :param pulumi.Input[str] description: The description of the policy definition.
        :param pulumi.Input[str] ec_key_type: EC Key Type - Choices: `P256`, `P384`, `P521`
        :param pulumi.Input[str] expired_certificate: Expired certificate action - Choices: `drop`, `decrypt`
        :param pulumi.Input[str] failure_mode: Failure mode - Choices: `open`, `close`
        :param pulumi.Input[str] minimal_tls_version: Minimal TLS Version - Choices: `TLSv1.0`, `TLSv1.1`, `TLSv1.2`
        :param pulumi.Input[str] mode: The policy mode - Choices: `security`, `unified`
        :param pulumi.Input[str] name: The name of the policy definition.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TlsSslDecryptionPolicyDefinitionNetworkRuleArgs']]]] network_rules: List of network rules (applies when `mode` set to `security`)
        :param pulumi.Input[str] rsa_key_pair_modulus: RSA key pair modules - Choices: `1024`, `2048`, `4096`
        :param pulumi.Input[str] ssl_decryption_enabled: SSL decryption enabled
        :param pulumi.Input[str] unknown_revocation_status: Unknown revocation status action - Choices: `drop`, `decrypt`
        :param pulumi.Input[str] unsupported_cipher_suites: Unsupported cipher suites action - Choices: `drop`, `no-decrypt`
        :param pulumi.Input[str] unsupported_protocol_versions: Unsupported protocol versions action - Choices: `drop`, `no-decrypt`
        :param pulumi.Input[str] untrusted_certificate: Untrusted certificate action - Choices: `drop`, `decrypt`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TlsSslDecryptionPolicyDefinitionUrlRuleArgs']]]] url_rules: List of url rules (applies when `mode` set to `security`)
        :param pulumi.Input[bool] use_default_ca_cert_bundle: Use default CA certificate bundle
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TlsSslDecryptionPolicyDefinitionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can manage a TLS SSL Decryption Policy Definition .

        ## Import

        ```sh
        $ pulumi import sdwan:index/tlsSslDecryptionPolicyDefinition:TlsSslDecryptionPolicyDefinition example "f6b2c44c-693c-4763-b010-895aa3d236bd"
        ```

        :param str resource_name: The name of the resource.
        :param TlsSslDecryptionPolicyDefinitionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TlsSslDecryptionPolicyDefinitionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_lifetime_in_days: Optional[pulumi.Input[int]] = None,
                 certificate_revocation_status: Optional[pulumi.Input[str]] = None,
                 default_action: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ec_key_type: Optional[pulumi.Input[str]] = None,
                 expired_certificate: Optional[pulumi.Input[str]] = None,
                 failure_mode: Optional[pulumi.Input[str]] = None,
                 minimal_tls_version: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TlsSslDecryptionPolicyDefinitionNetworkRuleArgs']]]]] = None,
                 rsa_key_pair_modulus: Optional[pulumi.Input[str]] = None,
                 ssl_decryption_enabled: Optional[pulumi.Input[str]] = None,
                 unknown_revocation_status: Optional[pulumi.Input[str]] = None,
                 unsupported_cipher_suites: Optional[pulumi.Input[str]] = None,
                 unsupported_protocol_versions: Optional[pulumi.Input[str]] = None,
                 untrusted_certificate: Optional[pulumi.Input[str]] = None,
                 url_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TlsSslDecryptionPolicyDefinitionUrlRuleArgs']]]]] = None,
                 use_default_ca_cert_bundle: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TlsSslDecryptionPolicyDefinitionArgs.__new__(TlsSslDecryptionPolicyDefinitionArgs)

            __props__.__dict__["certificate_lifetime_in_days"] = certificate_lifetime_in_days
            __props__.__dict__["certificate_revocation_status"] = certificate_revocation_status
            __props__.__dict__["default_action"] = default_action
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__.__dict__["description"] = description
            __props__.__dict__["ec_key_type"] = ec_key_type
            __props__.__dict__["expired_certificate"] = expired_certificate
            __props__.__dict__["failure_mode"] = failure_mode
            __props__.__dict__["minimal_tls_version"] = minimal_tls_version
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            __props__.__dict__["network_rules"] = network_rules
            __props__.__dict__["rsa_key_pair_modulus"] = rsa_key_pair_modulus
            __props__.__dict__["ssl_decryption_enabled"] = ssl_decryption_enabled
            __props__.__dict__["unknown_revocation_status"] = unknown_revocation_status
            __props__.__dict__["unsupported_cipher_suites"] = unsupported_cipher_suites
            __props__.__dict__["unsupported_protocol_versions"] = unsupported_protocol_versions
            __props__.__dict__["untrusted_certificate"] = untrusted_certificate
            __props__.__dict__["url_rules"] = url_rules
            __props__.__dict__["use_default_ca_cert_bundle"] = use_default_ca_cert_bundle
            __props__.__dict__["version"] = None
        super(TlsSslDecryptionPolicyDefinition, __self__).__init__(
            'sdwan:index/tlsSslDecryptionPolicyDefinition:TlsSslDecryptionPolicyDefinition',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_lifetime_in_days: Optional[pulumi.Input[int]] = None,
            certificate_revocation_status: Optional[pulumi.Input[str]] = None,
            default_action: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            ec_key_type: Optional[pulumi.Input[str]] = None,
            expired_certificate: Optional[pulumi.Input[str]] = None,
            failure_mode: Optional[pulumi.Input[str]] = None,
            minimal_tls_version: Optional[pulumi.Input[str]] = None,
            mode: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TlsSslDecryptionPolicyDefinitionNetworkRuleArgs']]]]] = None,
            rsa_key_pair_modulus: Optional[pulumi.Input[str]] = None,
            ssl_decryption_enabled: Optional[pulumi.Input[str]] = None,
            unknown_revocation_status: Optional[pulumi.Input[str]] = None,
            unsupported_cipher_suites: Optional[pulumi.Input[str]] = None,
            unsupported_protocol_versions: Optional[pulumi.Input[str]] = None,
            untrusted_certificate: Optional[pulumi.Input[str]] = None,
            url_rules: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TlsSslDecryptionPolicyDefinitionUrlRuleArgs']]]]] = None,
            use_default_ca_cert_bundle: Optional[pulumi.Input[bool]] = None,
            version: Optional[pulumi.Input[int]] = None) -> 'TlsSslDecryptionPolicyDefinition':
        """
        Get an existing TlsSslDecryptionPolicyDefinition resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] certificate_lifetime_in_days: Certificate Lifetime(in Days)
        :param pulumi.Input[str] certificate_revocation_status: Certificate revocation status - Choices: `ocsp`, `none`
        :param pulumi.Input[str] default_action: Default action (applies when `mode` set to `security`) - Choices: `noIntent`, `doNotDecrypt`, `decrypt`
        :param pulumi.Input[str] description: The description of the policy definition.
        :param pulumi.Input[str] ec_key_type: EC Key Type - Choices: `P256`, `P384`, `P521`
        :param pulumi.Input[str] expired_certificate: Expired certificate action - Choices: `drop`, `decrypt`
        :param pulumi.Input[str] failure_mode: Failure mode - Choices: `open`, `close`
        :param pulumi.Input[str] minimal_tls_version: Minimal TLS Version - Choices: `TLSv1.0`, `TLSv1.1`, `TLSv1.2`
        :param pulumi.Input[str] mode: The policy mode - Choices: `security`, `unified`
        :param pulumi.Input[str] name: The name of the policy definition.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TlsSslDecryptionPolicyDefinitionNetworkRuleArgs']]]] network_rules: List of network rules (applies when `mode` set to `security`)
        :param pulumi.Input[str] rsa_key_pair_modulus: RSA key pair modules - Choices: `1024`, `2048`, `4096`
        :param pulumi.Input[str] ssl_decryption_enabled: SSL decryption enabled
        :param pulumi.Input[str] unknown_revocation_status: Unknown revocation status action - Choices: `drop`, `decrypt`
        :param pulumi.Input[str] unsupported_cipher_suites: Unsupported cipher suites action - Choices: `drop`, `no-decrypt`
        :param pulumi.Input[str] unsupported_protocol_versions: Unsupported protocol versions action - Choices: `drop`, `no-decrypt`
        :param pulumi.Input[str] untrusted_certificate: Untrusted certificate action - Choices: `drop`, `decrypt`
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TlsSslDecryptionPolicyDefinitionUrlRuleArgs']]]] url_rules: List of url rules (applies when `mode` set to `security`)
        :param pulumi.Input[bool] use_default_ca_cert_bundle: Use default CA certificate bundle
        :param pulumi.Input[int] version: The version of the object
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TlsSslDecryptionPolicyDefinitionState.__new__(_TlsSslDecryptionPolicyDefinitionState)

        __props__.__dict__["certificate_lifetime_in_days"] = certificate_lifetime_in_days
        __props__.__dict__["certificate_revocation_status"] = certificate_revocation_status
        __props__.__dict__["default_action"] = default_action
        __props__.__dict__["description"] = description
        __props__.__dict__["ec_key_type"] = ec_key_type
        __props__.__dict__["expired_certificate"] = expired_certificate
        __props__.__dict__["failure_mode"] = failure_mode
        __props__.__dict__["minimal_tls_version"] = minimal_tls_version
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["network_rules"] = network_rules
        __props__.__dict__["rsa_key_pair_modulus"] = rsa_key_pair_modulus
        __props__.__dict__["ssl_decryption_enabled"] = ssl_decryption_enabled
        __props__.__dict__["unknown_revocation_status"] = unknown_revocation_status
        __props__.__dict__["unsupported_cipher_suites"] = unsupported_cipher_suites
        __props__.__dict__["unsupported_protocol_versions"] = unsupported_protocol_versions
        __props__.__dict__["untrusted_certificate"] = untrusted_certificate
        __props__.__dict__["url_rules"] = url_rules
        __props__.__dict__["use_default_ca_cert_bundle"] = use_default_ca_cert_bundle
        __props__.__dict__["version"] = version
        return TlsSslDecryptionPolicyDefinition(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateLifetimeInDays")
    def certificate_lifetime_in_days(self) -> pulumi.Output[Optional[int]]:
        """
        Certificate Lifetime(in Days)
        """
        return pulumi.get(self, "certificate_lifetime_in_days")

    @property
    @pulumi.getter(name="certificateRevocationStatus")
    def certificate_revocation_status(self) -> pulumi.Output[Optional[str]]:
        """
        Certificate revocation status - Choices: `ocsp`, `none`
        """
        return pulumi.get(self, "certificate_revocation_status")

    @property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Output[Optional[str]]:
        """
        Default action (applies when `mode` set to `security`) - Choices: `noIntent`, `doNotDecrypt`, `decrypt`
        """
        return pulumi.get(self, "default_action")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the policy definition.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="ecKeyType")
    def ec_key_type(self) -> pulumi.Output[Optional[str]]:
        """
        EC Key Type - Choices: `P256`, `P384`, `P521`
        """
        return pulumi.get(self, "ec_key_type")

    @property
    @pulumi.getter(name="expiredCertificate")
    def expired_certificate(self) -> pulumi.Output[Optional[str]]:
        """
        Expired certificate action - Choices: `drop`, `decrypt`
        """
        return pulumi.get(self, "expired_certificate")

    @property
    @pulumi.getter(name="failureMode")
    def failure_mode(self) -> pulumi.Output[Optional[str]]:
        """
        Failure mode - Choices: `open`, `close`
        """
        return pulumi.get(self, "failure_mode")

    @property
    @pulumi.getter(name="minimalTlsVersion")
    def minimal_tls_version(self) -> pulumi.Output[Optional[str]]:
        """
        Minimal TLS Version - Choices: `TLSv1.0`, `TLSv1.1`, `TLSv1.2`
        """
        return pulumi.get(self, "minimal_tls_version")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[Optional[str]]:
        """
        The policy mode - Choices: `security`, `unified`
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the policy definition.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkRules")
    def network_rules(self) -> pulumi.Output[Optional[Sequence['outputs.TlsSslDecryptionPolicyDefinitionNetworkRule']]]:
        """
        List of network rules (applies when `mode` set to `security`)
        """
        return pulumi.get(self, "network_rules")

    @property
    @pulumi.getter(name="rsaKeyPairModulus")
    def rsa_key_pair_modulus(self) -> pulumi.Output[Optional[str]]:
        """
        RSA key pair modules - Choices: `1024`, `2048`, `4096`
        """
        return pulumi.get(self, "rsa_key_pair_modulus")

    @property
    @pulumi.getter(name="sslDecryptionEnabled")
    def ssl_decryption_enabled(self) -> pulumi.Output[Optional[str]]:
        """
        SSL decryption enabled
        """
        return pulumi.get(self, "ssl_decryption_enabled")

    @property
    @pulumi.getter(name="unknownRevocationStatus")
    def unknown_revocation_status(self) -> pulumi.Output[Optional[str]]:
        """
        Unknown revocation status action - Choices: `drop`, `decrypt`
        """
        return pulumi.get(self, "unknown_revocation_status")

    @property
    @pulumi.getter(name="unsupportedCipherSuites")
    def unsupported_cipher_suites(self) -> pulumi.Output[Optional[str]]:
        """
        Unsupported cipher suites action - Choices: `drop`, `no-decrypt`
        """
        return pulumi.get(self, "unsupported_cipher_suites")

    @property
    @pulumi.getter(name="unsupportedProtocolVersions")
    def unsupported_protocol_versions(self) -> pulumi.Output[Optional[str]]:
        """
        Unsupported protocol versions action - Choices: `drop`, `no-decrypt`
        """
        return pulumi.get(self, "unsupported_protocol_versions")

    @property
    @pulumi.getter(name="untrustedCertificate")
    def untrusted_certificate(self) -> pulumi.Output[Optional[str]]:
        """
        Untrusted certificate action - Choices: `drop`, `decrypt`
        """
        return pulumi.get(self, "untrusted_certificate")

    @property
    @pulumi.getter(name="urlRules")
    def url_rules(self) -> pulumi.Output[Optional[Sequence['outputs.TlsSslDecryptionPolicyDefinitionUrlRule']]]:
        """
        List of url rules (applies when `mode` set to `security`)
        """
        return pulumi.get(self, "url_rules")

    @property
    @pulumi.getter(name="useDefaultCaCertBundle")
    def use_default_ca_cert_bundle(self) -> pulumi.Output[Optional[bool]]:
        """
        Use default CA certificate bundle
        """
        return pulumi.get(self, "use_default_ca_cert_bundle")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[int]:
        """
        The version of the object
        """
        return pulumi.get(self, "version")

