#!python
# distutils: define_macros=NPY_NO_DEPRECATED_API=NPY_1_7_API_VERSION
# cython: language_level=3
# cython: cpow=True
# cython: boundscheck=False
# cython: wraparound=False
# cython: initializedcheck=False
# cython: cdivision=True
from typing import Optional
import numpy
cimport numpy
from libc.math cimport exp, fabs, log, sin, cos, tan, tanh, asin, acos, atan, isnan, isinf
from libc.math cimport NAN as nan
from libc.math cimport INFINITY as inf
import cython
from cpython.mem cimport PyMem_Malloc
from cpython.mem cimport PyMem_Realloc
from cpython.mem cimport PyMem_Free
from hydpy.cythons.autogen cimport configutils
from hydpy.cythons.autogen cimport interfaceutils
from hydpy.cythons.autogen cimport interputils
from hydpy.cythons.autogen import pointerutils
from hydpy.cythons.autogen cimport pointerutils
from hydpy.cythons.autogen cimport quadutils
from hydpy.cythons.autogen cimport rootutils
from hydpy.cythons.autogen cimport smoothutils
from hydpy.cythons.autogen cimport masterinterface
ctypedef void (*CallbackType) (Model)  noexcept nogil
cdef class CallbackWrapper:
    cdef CallbackType callback
@cython.final
cdef class Parameters:
    cdef public ControlParameters control
    cdef public DerivedParameters derived
@cython.final
cdef class ControlParameters:
    cdef public numpy.int64_t nmbtrapezes
    cdef public numpy.int64_t nmbwidths
    cdef public numpy.int64_t nmbsectors
    cdef public double[:] heights
    cdef public double[:] flowwidths
    cdef public double[:] totalwidths
    cdef public numpy.int64_t[:] transitions
    cdef public double[:] bottomlevels
    cdef public double[:] bottomwidths
    cdef public double[:] sideslopes
    cdef public double[:] stricklercoefficients
    cdef public double bottomslope
    cdef public double channeldepth
    cdef public double crestheight
    cdef public double crestheighttolerance
    cdef public double bankfulldischarge
    cdef public double dischargeexponent
@cython.final
cdef class DerivedParameters:
    cdef public double[:] bottomdepths
    cdef public double[:] trapezeheights
    cdef public double[:] slopewidths
    cdef public double[:] trapezeareas
    cdef public double[:] perimeterderivatives
    cdef public double[:,:] sectorflowwidths
    cdef public double[:,:] sectortotalwidths
    cdef public double[:,:] sectorflowareas
    cdef public double[:,:] sectortotalareas
    cdef public double[:,:] sectorflowperimeters
    cdef public double[:,:] sectorflowperimeterderivatives
    cdef public double crestheightregularisation
@cython.final
cdef class Sequences:
    cdef public FactorSequences factors
    cdef public FluxSequences fluxes
    cdef public AideSequences aides
@cython.final
cdef class FactorSequences:
    cdef public double waterdepth
    cdef public numpy.int64_t _waterdepth_ndim
    cdef public numpy.int64_t _waterdepth_length
    cdef public bint _waterdepth_ramflag
    cdef public double[:] _waterdepth_array
    cdef public bint _waterdepth_diskflag_reading
    cdef public bint _waterdepth_diskflag_writing
    cdef public double[:] _waterdepth_ncarray
    cdef public bint _waterdepth_outputflag
    cdef double *_waterdepth_outputpointer
    cdef public double waterlevel
    cdef public numpy.int64_t _waterlevel_ndim
    cdef public numpy.int64_t _waterlevel_length
    cdef public bint _waterlevel_ramflag
    cdef public double[:] _waterlevel_array
    cdef public bint _waterlevel_diskflag_reading
    cdef public bint _waterlevel_diskflag_writing
    cdef public double[:] _waterlevel_ncarray
    cdef public bint _waterlevel_outputflag
    cdef double *_waterlevel_outputpointer
    cdef public double[:] wettedareas
    cdef public numpy.int64_t _wettedareas_ndim
    cdef public numpy.int64_t _wettedareas_length
    cdef public numpy.int64_t _wettedareas_length_0
    cdef public bint _wettedareas_ramflag
    cdef public double[:,:] _wettedareas_array
    cdef public bint _wettedareas_diskflag_reading
    cdef public bint _wettedareas_diskflag_writing
    cdef public double[:] _wettedareas_ncarray
    cdef public double wettedarea
    cdef public numpy.int64_t _wettedarea_ndim
    cdef public numpy.int64_t _wettedarea_length
    cdef public bint _wettedarea_ramflag
    cdef public double[:] _wettedarea_array
    cdef public bint _wettedarea_diskflag_reading
    cdef public bint _wettedarea_diskflag_writing
    cdef public double[:] _wettedarea_ncarray
    cdef public bint _wettedarea_outputflag
    cdef double *_wettedarea_outputpointer
    cdef public double[:] flowareas
    cdef public numpy.int64_t _flowareas_ndim
    cdef public numpy.int64_t _flowareas_length
    cdef public numpy.int64_t _flowareas_length_0
    cdef public bint _flowareas_ramflag
    cdef public double[:,:] _flowareas_array
    cdef public bint _flowareas_diskflag_reading
    cdef public bint _flowareas_diskflag_writing
    cdef public double[:] _flowareas_ncarray
    cdef public double flowarea
    cdef public numpy.int64_t _flowarea_ndim
    cdef public numpy.int64_t _flowarea_length
    cdef public bint _flowarea_ramflag
    cdef public double[:] _flowarea_array
    cdef public bint _flowarea_diskflag_reading
    cdef public bint _flowarea_diskflag_writing
    cdef public double[:] _flowarea_ncarray
    cdef public bint _flowarea_outputflag
    cdef double *_flowarea_outputpointer
    cdef public double[:] totalareas
    cdef public numpy.int64_t _totalareas_ndim
    cdef public numpy.int64_t _totalareas_length
    cdef public numpy.int64_t _totalareas_length_0
    cdef public bint _totalareas_ramflag
    cdef public double[:,:] _totalareas_array
    cdef public bint _totalareas_diskflag_reading
    cdef public bint _totalareas_diskflag_writing
    cdef public double[:] _totalareas_ncarray
    cdef public double totalarea
    cdef public numpy.int64_t _totalarea_ndim
    cdef public numpy.int64_t _totalarea_length
    cdef public bint _totalarea_ramflag
    cdef public double[:] _totalarea_array
    cdef public bint _totalarea_diskflag_reading
    cdef public bint _totalarea_diskflag_writing
    cdef public double[:] _totalarea_ncarray
    cdef public bint _totalarea_outputflag
    cdef double *_totalarea_outputpointer
    cdef public double[:] wettedperimeters
    cdef public numpy.int64_t _wettedperimeters_ndim
    cdef public numpy.int64_t _wettedperimeters_length
    cdef public numpy.int64_t _wettedperimeters_length_0
    cdef public bint _wettedperimeters_ramflag
    cdef public double[:,:] _wettedperimeters_array
    cdef public bint _wettedperimeters_diskflag_reading
    cdef public bint _wettedperimeters_diskflag_writing
    cdef public double[:] _wettedperimeters_ncarray
    cdef public double[:] flowperimeters
    cdef public numpy.int64_t _flowperimeters_ndim
    cdef public numpy.int64_t _flowperimeters_length
    cdef public numpy.int64_t _flowperimeters_length_0
    cdef public bint _flowperimeters_ramflag
    cdef public double[:,:] _flowperimeters_array
    cdef public bint _flowperimeters_diskflag_reading
    cdef public bint _flowperimeters_diskflag_writing
    cdef public double[:] _flowperimeters_ncarray
    cdef public double wettedperimeter
    cdef public numpy.int64_t _wettedperimeter_ndim
    cdef public numpy.int64_t _wettedperimeter_length
    cdef public bint _wettedperimeter_ramflag
    cdef public double[:] _wettedperimeter_array
    cdef public bint _wettedperimeter_diskflag_reading
    cdef public bint _wettedperimeter_diskflag_writing
    cdef public double[:] _wettedperimeter_ncarray
    cdef public bint _wettedperimeter_outputflag
    cdef double *_wettedperimeter_outputpointer
    cdef public double[:] wettedperimeterderivatives
    cdef public numpy.int64_t _wettedperimeterderivatives_ndim
    cdef public numpy.int64_t _wettedperimeterderivatives_length
    cdef public numpy.int64_t _wettedperimeterderivatives_length_0
    cdef public bint _wettedperimeterderivatives_ramflag
    cdef public double[:,:] _wettedperimeterderivatives_array
    cdef public bint _wettedperimeterderivatives_diskflag_reading
    cdef public bint _wettedperimeterderivatives_diskflag_writing
    cdef public double[:] _wettedperimeterderivatives_ncarray
    cdef public double[:] flowperimeterderivatives
    cdef public numpy.int64_t _flowperimeterderivatives_ndim
    cdef public numpy.int64_t _flowperimeterderivatives_length
    cdef public numpy.int64_t _flowperimeterderivatives_length_0
    cdef public bint _flowperimeterderivatives_ramflag
    cdef public double[:,:] _flowperimeterderivatives_array
    cdef public bint _flowperimeterderivatives_diskflag_reading
    cdef public bint _flowperimeterderivatives_diskflag_writing
    cdef public double[:] _flowperimeterderivatives_ncarray
    cdef public double[:] surfacewidths
    cdef public numpy.int64_t _surfacewidths_ndim
    cdef public numpy.int64_t _surfacewidths_length
    cdef public numpy.int64_t _surfacewidths_length_0
    cdef public bint _surfacewidths_ramflag
    cdef public double[:,:] _surfacewidths_array
    cdef public bint _surfacewidths_diskflag_reading
    cdef public bint _surfacewidths_diskflag_writing
    cdef public double[:] _surfacewidths_ncarray
    cdef public double surfacewidth
    cdef public numpy.int64_t _surfacewidth_ndim
    cdef public numpy.int64_t _surfacewidth_length
    cdef public bint _surfacewidth_ramflag
    cdef public double[:] _surfacewidth_array
    cdef public bint _surfacewidth_diskflag_reading
    cdef public bint _surfacewidth_diskflag_writing
    cdef public double[:] _surfacewidth_ncarray
    cdef public bint _surfacewidth_outputflag
    cdef double *_surfacewidth_outputpointer
    cdef public double[:] flowwidths
    cdef public numpy.int64_t _flowwidths_ndim
    cdef public numpy.int64_t _flowwidths_length
    cdef public numpy.int64_t _flowwidths_length_0
    cdef public bint _flowwidths_ramflag
    cdef public double[:,:] _flowwidths_array
    cdef public bint _flowwidths_diskflag_reading
    cdef public bint _flowwidths_diskflag_writing
    cdef public double[:] _flowwidths_ncarray
    cdef public double[:] totalwidths
    cdef public numpy.int64_t _totalwidths_ndim
    cdef public numpy.int64_t _totalwidths_length
    cdef public numpy.int64_t _totalwidths_length_0
    cdef public bint _totalwidths_ramflag
    cdef public double[:,:] _totalwidths_array
    cdef public bint _totalwidths_diskflag_reading
    cdef public bint _totalwidths_diskflag_writing
    cdef public double[:] _totalwidths_ncarray
    cdef public double totalwidth
    cdef public numpy.int64_t _totalwidth_ndim
    cdef public numpy.int64_t _totalwidth_length
    cdef public bint _totalwidth_ramflag
    cdef public double[:] _totalwidth_array
    cdef public bint _totalwidth_diskflag_reading
    cdef public bint _totalwidth_diskflag_writing
    cdef public double[:] _totalwidth_ncarray
    cdef public bint _totalwidth_outputflag
    cdef double *_totalwidth_outputpointer
    cdef public double[:] dischargederivatives
    cdef public numpy.int64_t _dischargederivatives_ndim
    cdef public numpy.int64_t _dischargederivatives_length
    cdef public numpy.int64_t _dischargederivatives_length_0
    cdef public bint _dischargederivatives_ramflag
    cdef public double[:,:] _dischargederivatives_array
    cdef public bint _dischargederivatives_diskflag_reading
    cdef public bint _dischargederivatives_diskflag_writing
    cdef public double[:] _dischargederivatives_ncarray
    cdef public double dischargederivative
    cdef public numpy.int64_t _dischargederivative_ndim
    cdef public numpy.int64_t _dischargederivative_length
    cdef public bint _dischargederivative_ramflag
    cdef public double[:] _dischargederivative_array
    cdef public bint _dischargederivative_diskflag_reading
    cdef public bint _dischargederivative_diskflag_writing
    cdef public double[:] _dischargederivative_ncarray
    cdef public bint _dischargederivative_outputflag
    cdef double *_dischargederivative_outputpointer
    cdef public double celerity
    cdef public numpy.int64_t _celerity_ndim
    cdef public numpy.int64_t _celerity_length
    cdef public bint _celerity_ramflag
    cdef public double[:] _celerity_array
    cdef public bint _celerity_diskflag_reading
    cdef public bint _celerity_diskflag_writing
    cdef public double[:] _celerity_ncarray
    cdef public bint _celerity_outputflag
    cdef double *_celerity_outputpointer
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil
    cpdef inline set_pointeroutput(self, str name, pointerutils.PDouble value)
    cpdef inline void update_outputs(self) noexcept nogil
@cython.final
cdef class FluxSequences:
    cdef public double[:] discharges
    cdef public numpy.int64_t _discharges_ndim
    cdef public numpy.int64_t _discharges_length
    cdef public numpy.int64_t _discharges_length_0
    cdef public bint _discharges_ramflag
    cdef public double[:,:] _discharges_array
    cdef public bint _discharges_diskflag_reading
    cdef public bint _discharges_diskflag_writing
    cdef public double[:] _discharges_ncarray
    cdef public double discharge
    cdef public numpy.int64_t _discharge_ndim
    cdef public numpy.int64_t _discharge_length
    cdef public bint _discharge_ramflag
    cdef public double[:] _discharge_array
    cdef public bint _discharge_diskflag_reading
    cdef public bint _discharge_diskflag_writing
    cdef public double[:] _discharge_ncarray
    cdef public bint _discharge_outputflag
    cdef double *_discharge_outputpointer
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil
    cpdef inline set_pointeroutput(self, str name, pointerutils.PDouble value)
    cpdef inline void update_outputs(self) noexcept nogil
@cython.final
cdef class AideSequences:
    cdef public double index
    cdef public numpy.int64_t _index_ndim
    cdef public numpy.int64_t _index_length
    cdef public double excess
    cdef public numpy.int64_t _excess_ndim
    cdef public numpy.int64_t _excess_length
    cdef public double weight
    cdef public numpy.int64_t _weight_ndim
    cdef public numpy.int64_t _weight_length
@cython.final
cdef class Model:
    cdef public numpy.int64_t idx_sim
    cdef public numpy.npy_bool threading
    cdef public Parameters parameters
    cdef public Sequences sequences
    cpdef inline void simulate(self, numpy.int64_t idx)  noexcept nogil
    cpdef void simulate_period(self, numpy.int64_t i0, numpy.int64_t i1)  noexcept nogil
    cpdef void reset_reuseflags(self) noexcept nogil
    cpdef void save_data(self, numpy.int64_t idx) noexcept nogil
    cpdef inline void run(self) noexcept nogil
    cpdef void update_inlets(self) noexcept nogil
    cpdef void update_outlets(self) noexcept nogil
    cpdef void update_observers(self) noexcept nogil
    cpdef void update_receivers(self, numpy.int64_t idx) noexcept nogil
    cpdef void update_senders(self, numpy.int64_t idx) noexcept nogil
    cpdef void update_outputs(self) noexcept nogil
    cpdef inline void calc_waterdepth_v1(self) noexcept nogil
    cpdef inline void calc_waterdepth_v2(self) noexcept nogil
    cpdef inline void calc_waterdepth_v3(self) noexcept nogil
    cpdef inline void calc_waterlevel_v1(self) noexcept nogil
    cpdef inline void calc_waterlevel_v2(self) noexcept nogil
    cpdef inline void calc_index_excess_weight_v1(self) noexcept nogil
    cpdef inline void calc_wettedareas_v1(self) noexcept nogil
    cpdef inline void calc_flowareas_v1(self) noexcept nogil
    cpdef inline void calc_totalareas_v1(self) noexcept nogil
    cpdef inline void calc_wettedarea_v1(self) noexcept nogil
    cpdef inline void calc_flowarea_v1(self) noexcept nogil
    cpdef inline void calc_totalarea_v1(self) noexcept nogil
    cpdef inline void calc_wettedperimeters_v1(self) noexcept nogil
    cpdef inline void calc_flowperimeters_v1(self) noexcept nogil
    cpdef inline void calc_wettedperimeter_v1(self) noexcept nogil
    cpdef inline void calc_wettedperimeterderivatives_v1(self) noexcept nogil
    cpdef inline void calc_flowperimeterderivatives_v1(self) noexcept nogil
    cpdef inline void calc_surfacewidths_v1(self) noexcept nogil
    cpdef inline void calc_surfacewidth_v1(self) noexcept nogil
    cpdef inline void calc_flowwidths_v1(self) noexcept nogil
    cpdef inline void calc_totalwidths_v1(self) noexcept nogil
    cpdef inline void calc_totalwidth_v1(self) noexcept nogil
    cpdef inline void calc_discharges_v1(self) noexcept nogil
    cpdef inline void calc_discharges_v2(self) noexcept nogil
    cpdef inline void calc_discharge_v2(self) noexcept nogil
    cpdef inline void calc_discharge_v3(self) noexcept nogil
    cpdef inline void calc_dischargederivatives_v1(self) noexcept nogil
    cpdef inline void calc_dischargederivatives_v2(self) noexcept nogil
    cpdef inline void calc_dischargederivative_v1(self) noexcept nogil
    cpdef inline void calc_dischargederivative_v2(self) noexcept nogil
    cpdef inline void calc_celerity_v1(self) noexcept nogil
    cpdef inline void calc_celerity_v2(self) noexcept nogil
    cpdef double calculate_discharge_v1(self, double waterdepth) noexcept nogil
    cpdef void set_waterdepth_v1(self, double waterdepth) noexcept nogil
    cpdef void set_waterlevel_v1(self, double waterlevel) noexcept nogil
    cpdef void set_wettedarea_v1(self, double wettedarea) noexcept nogil
    cpdef double get_waterdepth_v1(self) noexcept nogil
    cpdef double get_waterlevel_v1(self) noexcept nogil
    cpdef double get_wettedarea_v1(self) noexcept nogil
    cpdef double get_wettedarea_v2(self) noexcept nogil
    cpdef double get_wettedperimeter_v1(self) noexcept nogil
    cpdef double get_surfacewidth_v1(self) noexcept nogil
    cpdef double get_surfacewidth_v2(self) noexcept nogil
    cpdef double get_discharge_v1(self) noexcept nogil
    cpdef double get_celerity_v1(self) noexcept nogil
    cpdef inline void calc_index_excess_weight(self) noexcept nogil
    cpdef inline void calc_wettedareas(self) noexcept nogil
    cpdef inline void calc_flowareas(self) noexcept nogil
    cpdef inline void calc_totalareas(self) noexcept nogil
    cpdef inline void calc_wettedarea(self) noexcept nogil
    cpdef inline void calc_flowarea(self) noexcept nogil
    cpdef inline void calc_totalarea(self) noexcept nogil
    cpdef inline void calc_wettedperimeters(self) noexcept nogil
    cpdef inline void calc_flowperimeters(self) noexcept nogil
    cpdef inline void calc_wettedperimeter(self) noexcept nogil
    cpdef inline void calc_wettedperimeterderivatives(self) noexcept nogil
    cpdef inline void calc_flowperimeterderivatives(self) noexcept nogil
    cpdef inline void calc_surfacewidths(self) noexcept nogil
    cpdef inline void calc_surfacewidth(self) noexcept nogil
    cpdef inline void calc_flowwidths(self) noexcept nogil
    cpdef inline void calc_totalwidths(self) noexcept nogil
    cpdef inline void calc_totalwidth(self) noexcept nogil
    cpdef double calculate_discharge(self, double waterdepth) noexcept nogil
    cpdef void set_waterdepth(self, double waterdepth) noexcept nogil
    cpdef void set_waterlevel(self, double waterlevel) noexcept nogil
    cpdef void set_wettedarea(self, double wettedarea) noexcept nogil
    cpdef double get_waterdepth(self) noexcept nogil
    cpdef double get_waterlevel(self) noexcept nogil
    cpdef double get_wettedperimeter(self) noexcept nogil
    cpdef double get_discharge(self) noexcept nogil
    cpdef double get_celerity(self) noexcept nogil
    cpdef void use_waterdepth_v1(self, double waterdepth) noexcept nogil
    cpdef void use_waterdepth_v2(self, double waterdepth) noexcept nogil
    cpdef void use_waterdepth_v3(self, double waterdepth) noexcept nogil
    cpdef void use_waterlevel_v1(self, double waterlevel) noexcept nogil
    cpdef void use_waterlevel_v2(self, double waterlevel) noexcept nogil
    cpdef void use_waterlevel_v3(self, double waterlevel) noexcept nogil
    cpdef void use_wettedarea_v1(self, double wettedarea) noexcept nogil
    cpdef void use_wettedarea(self, double wettedarea) noexcept nogil
