#!python
# distutils: define_macros=NPY_NO_DEPRECATED_API=NPY_1_7_API_VERSION
# cython: language_level=3
# cython: cpow=True
# cython: boundscheck=False
# cython: wraparound=False
# cython: initializedcheck=False
# cython: cdivision=True
from typing import Optional
import numpy
cimport numpy
from libc.math cimport exp, fabs, log, sin, cos, tan, tanh, asin, acos, atan, isnan, isinf
from libc.math cimport NAN as nan
from libc.math cimport INFINITY as inf
import cython
from cpython.mem cimport PyMem_Malloc
from cpython.mem cimport PyMem_Realloc
from cpython.mem cimport PyMem_Free
from hydpy.cythons.autogen cimport configutils
from hydpy.cythons.autogen cimport interfaceutils
from hydpy.cythons.autogen cimport interputils
from hydpy.cythons.autogen import pointerutils
from hydpy.cythons.autogen cimport pointerutils
from hydpy.cythons.autogen cimport quadutils
from hydpy.cythons.autogen cimport rootutils
from hydpy.cythons.autogen cimport smoothutils
from hydpy.cythons.autogen cimport masterinterface
ctypedef void (*CallbackType) (Model)  noexcept nogil
cdef class CallbackWrapper:
    cdef CallbackType callback
@cython.final
cdef class Parameters:
    cdef public ControlParameters control
    cdef public DerivedParameters derived
@cython.final
cdef class ControlParameters:
    cdef public numpy.int64_t nmbwidths
    cdef public numpy.int64_t nmbsectors
    cdef public double[:] heights
    cdef public double[:] flowwidths
    cdef public double[:] totalwidths
    cdef public numpy.int64_t[:] transitions
    cdef public double[:] stricklercoefficients
    cdef public double bottomslope
@cython.final
cdef class DerivedParameters:
    cdef public double[:,:] sectorflowwidths
    cdef public double[:,:] sectortotalwidths
    cdef public double[:,:] sectorflowareas
    cdef public double[:,:] sectortotalareas
    cdef public double[:,:] sectorflowperimeters
    cdef public double[:,:] sectorflowperimeterderivatives
@cython.final
cdef class Sequences:
    cdef public FactorSequences factors
    cdef public FluxSequences fluxes
    cdef public AideSequences aides
@cython.final
cdef class FactorSequences:
    cdef public double waterdepth
    cdef public numpy.int64_t _waterdepth_ndim
    cdef public numpy.int64_t _waterdepth_length
    cdef public bint _waterdepth_ramflag
    cdef public double[:] _waterdepth_array
    cdef public bint _waterdepth_diskflag_reading
    cdef public bint _waterdepth_diskflag_writing
    cdef public double[:] _waterdepth_ncarray
    cdef public bint _waterdepth_outputflag
    cdef double *_waterdepth_outputpointer
    cdef public double waterlevel
    cdef public numpy.int64_t _waterlevel_ndim
    cdef public numpy.int64_t _waterlevel_length
    cdef public bint _waterlevel_ramflag
    cdef public double[:] _waterlevel_array
    cdef public bint _waterlevel_diskflag_reading
    cdef public bint _waterlevel_diskflag_writing
    cdef public double[:] _waterlevel_ncarray
    cdef public bint _waterlevel_outputflag
    cdef double *_waterlevel_outputpointer
    cdef public double[:] flowareas
    cdef public numpy.int64_t _flowareas_ndim
    cdef public numpy.int64_t _flowareas_length
    cdef public numpy.int64_t _flowareas_length_0
    cdef public bint _flowareas_ramflag
    cdef public double[:,:] _flowareas_array
    cdef public bint _flowareas_diskflag_reading
    cdef public bint _flowareas_diskflag_writing
    cdef public double[:] _flowareas_ncarray
    cdef public double flowarea
    cdef public numpy.int64_t _flowarea_ndim
    cdef public numpy.int64_t _flowarea_length
    cdef public bint _flowarea_ramflag
    cdef public double[:] _flowarea_array
    cdef public bint _flowarea_diskflag_reading
    cdef public bint _flowarea_diskflag_writing
    cdef public double[:] _flowarea_ncarray
    cdef public bint _flowarea_outputflag
    cdef double *_flowarea_outputpointer
    cdef public double[:] totalareas
    cdef public numpy.int64_t _totalareas_ndim
    cdef public numpy.int64_t _totalareas_length
    cdef public numpy.int64_t _totalareas_length_0
    cdef public bint _totalareas_ramflag
    cdef public double[:,:] _totalareas_array
    cdef public bint _totalareas_diskflag_reading
    cdef public bint _totalareas_diskflag_writing
    cdef public double[:] _totalareas_ncarray
    cdef public double totalarea
    cdef public numpy.int64_t _totalarea_ndim
    cdef public numpy.int64_t _totalarea_length
    cdef public bint _totalarea_ramflag
    cdef public double[:] _totalarea_array
    cdef public bint _totalarea_diskflag_reading
    cdef public bint _totalarea_diskflag_writing
    cdef public double[:] _totalarea_ncarray
    cdef public bint _totalarea_outputflag
    cdef double *_totalarea_outputpointer
    cdef public double[:] flowperimeters
    cdef public numpy.int64_t _flowperimeters_ndim
    cdef public numpy.int64_t _flowperimeters_length
    cdef public numpy.int64_t _flowperimeters_length_0
    cdef public bint _flowperimeters_ramflag
    cdef public double[:,:] _flowperimeters_array
    cdef public bint _flowperimeters_diskflag_reading
    cdef public bint _flowperimeters_diskflag_writing
    cdef public double[:] _flowperimeters_ncarray
    cdef public double[:] flowperimeterderivatives
    cdef public numpy.int64_t _flowperimeterderivatives_ndim
    cdef public numpy.int64_t _flowperimeterderivatives_length
    cdef public numpy.int64_t _flowperimeterderivatives_length_0
    cdef public bint _flowperimeterderivatives_ramflag
    cdef public double[:,:] _flowperimeterderivatives_array
    cdef public bint _flowperimeterderivatives_diskflag_reading
    cdef public bint _flowperimeterderivatives_diskflag_writing
    cdef public double[:] _flowperimeterderivatives_ncarray
    cdef public double[:] flowwidths
    cdef public numpy.int64_t _flowwidths_ndim
    cdef public numpy.int64_t _flowwidths_length
    cdef public numpy.int64_t _flowwidths_length_0
    cdef public bint _flowwidths_ramflag
    cdef public double[:,:] _flowwidths_array
    cdef public bint _flowwidths_diskflag_reading
    cdef public bint _flowwidths_diskflag_writing
    cdef public double[:] _flowwidths_ncarray
    cdef public double[:] totalwidths
    cdef public numpy.int64_t _totalwidths_ndim
    cdef public numpy.int64_t _totalwidths_length
    cdef public numpy.int64_t _totalwidths_length_0
    cdef public bint _totalwidths_ramflag
    cdef public double[:,:] _totalwidths_array
    cdef public bint _totalwidths_diskflag_reading
    cdef public bint _totalwidths_diskflag_writing
    cdef public double[:] _totalwidths_ncarray
    cdef public double totalwidth
    cdef public numpy.int64_t _totalwidth_ndim
    cdef public numpy.int64_t _totalwidth_length
    cdef public bint _totalwidth_ramflag
    cdef public double[:] _totalwidth_array
    cdef public bint _totalwidth_diskflag_reading
    cdef public bint _totalwidth_diskflag_writing
    cdef public double[:] _totalwidth_ncarray
    cdef public bint _totalwidth_outputflag
    cdef double *_totalwidth_outputpointer
    cdef public double[:] dischargederivatives
    cdef public numpy.int64_t _dischargederivatives_ndim
    cdef public numpy.int64_t _dischargederivatives_length
    cdef public numpy.int64_t _dischargederivatives_length_0
    cdef public bint _dischargederivatives_ramflag
    cdef public double[:,:] _dischargederivatives_array
    cdef public bint _dischargederivatives_diskflag_reading
    cdef public bint _dischargederivatives_diskflag_writing
    cdef public double[:] _dischargederivatives_ncarray
    cdef public double dischargederivative
    cdef public numpy.int64_t _dischargederivative_ndim
    cdef public numpy.int64_t _dischargederivative_length
    cdef public bint _dischargederivative_ramflag
    cdef public double[:] _dischargederivative_array
    cdef public bint _dischargederivative_diskflag_reading
    cdef public bint _dischargederivative_diskflag_writing
    cdef public double[:] _dischargederivative_ncarray
    cdef public bint _dischargederivative_outputflag
    cdef double *_dischargederivative_outputpointer
    cdef public double celerity
    cdef public numpy.int64_t _celerity_ndim
    cdef public numpy.int64_t _celerity_length
    cdef public bint _celerity_ramflag
    cdef public double[:] _celerity_array
    cdef public bint _celerity_diskflag_reading
    cdef public bint _celerity_diskflag_writing
    cdef public double[:] _celerity_ncarray
    cdef public bint _celerity_outputflag
    cdef double *_celerity_outputpointer
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil
    cpdef inline set_pointeroutput(self, str name, pointerutils.PDouble value)
    cpdef inline void update_outputs(self) noexcept nogil
@cython.final
cdef class FluxSequences:
    cdef public double[:] discharges
    cdef public numpy.int64_t _discharges_ndim
    cdef public numpy.int64_t _discharges_length
    cdef public numpy.int64_t _discharges_length_0
    cdef public bint _discharges_ramflag
    cdef public double[:,:] _discharges_array
    cdef public bint _discharges_diskflag_reading
    cdef public bint _discharges_diskflag_writing
    cdef public double[:] _discharges_ncarray
    cdef public double discharge
    cdef public numpy.int64_t _discharge_ndim
    cdef public numpy.int64_t _discharge_length
    cdef public bint _discharge_ramflag
    cdef public double[:] _discharge_array
    cdef public bint _discharge_diskflag_reading
    cdef public bint _discharge_diskflag_writing
    cdef public double[:] _discharge_ncarray
    cdef public bint _discharge_outputflag
    cdef double *_discharge_outputpointer
    cpdef inline void load_data(self, numpy.int64_t idx)  noexcept nogil
    cpdef inline void save_data(self, numpy.int64_t idx)  noexcept nogil
    cpdef inline set_pointeroutput(self, str name, pointerutils.PDouble value)
    cpdef inline void update_outputs(self) noexcept nogil
@cython.final
cdef class AideSequences:
    cdef public double index
    cdef public numpy.int64_t _index_ndim
    cdef public numpy.int64_t _index_length
    cdef public double excess
    cdef public numpy.int64_t _excess_ndim
    cdef public numpy.int64_t _excess_length
    cdef public double weight
    cdef public numpy.int64_t _weight_ndim
    cdef public numpy.int64_t _weight_length
@cython.final
cdef class Model(masterinterface.MasterInterface):
    cdef public numpy.npy_bool threading
    cdef public Parameters parameters
    cdef public Sequences sequences
    cpdef inline void simulate(self, numpy.int64_t idx)  noexcept nogil
    cpdef void simulate_period(self, numpy.int64_t i0, numpy.int64_t i1)  noexcept nogil
    cpdef void reset_reuseflags(self) noexcept nogil
    cpdef void save_data(self, numpy.int64_t idx) noexcept nogil
    cpdef inline void run(self) noexcept nogil
    cpdef void update_inlets(self) noexcept nogil
    cpdef void update_outlets(self) noexcept nogil
    cpdef void update_observers(self) noexcept nogil
    cpdef void update_receivers(self, numpy.int64_t idx) noexcept nogil
    cpdef void update_senders(self, numpy.int64_t idx) noexcept nogil
    cpdef void update_outputs(self) noexcept nogil
    cpdef inline void set_waterdepth_v1(self, double waterdepth) noexcept nogil
    cpdef inline void set_waterlevel_v1(self, double waterlevel) noexcept nogil
    cpdef inline void calc_waterdepth_v3(self) noexcept nogil
    cpdef inline void calc_waterlevel_v2(self) noexcept nogil
    cpdef inline void calc_index_excess_weight_v1(self) noexcept nogil
    cpdef inline void calc_flowwidths_v1(self) noexcept nogil
    cpdef inline void calc_totalwidths_v1(self) noexcept nogil
    cpdef inline void calc_totalwidth_v1(self) noexcept nogil
    cpdef inline void calc_flowareas_v1(self) noexcept nogil
    cpdef inline void calc_totalareas_v1(self) noexcept nogil
    cpdef inline void calc_flowperimeters_v1(self) noexcept nogil
    cpdef inline void calc_flowperimeterderivatives_v1(self) noexcept nogil
    cpdef inline void calc_flowarea_v1(self) noexcept nogil
    cpdef inline void calc_totalarea_v1(self) noexcept nogil
    cpdef inline void calc_discharges_v2(self) noexcept nogil
    cpdef inline void calc_discharge_v3(self) noexcept nogil
    cpdef inline void calc_dischargederivatives_v2(self) noexcept nogil
    cpdef inline void calc_dischargederivative_v2(self) noexcept nogil
    cpdef inline void calc_celerity_v2(self) noexcept nogil
    cpdef double get_wettedarea_v2(self) noexcept nogil
    cpdef double get_surfacewidth_v2(self) noexcept nogil
    cpdef double get_discharge_v1(self) noexcept nogil
    cpdef double get_celerity_v1(self) noexcept nogil
    cpdef inline void set_waterdepth(self, double waterdepth) noexcept nogil
    cpdef inline void set_waterlevel(self, double waterlevel) noexcept nogil
    cpdef inline void calc_waterdepth(self) noexcept nogil
    cpdef inline void calc_waterlevel(self) noexcept nogil
    cpdef inline void calc_index_excess_weight(self) noexcept nogil
    cpdef inline void calc_flowwidths(self) noexcept nogil
    cpdef inline void calc_totalwidths(self) noexcept nogil
    cpdef inline void calc_totalwidth(self) noexcept nogil
    cpdef inline void calc_flowareas(self) noexcept nogil
    cpdef inline void calc_totalareas(self) noexcept nogil
    cpdef inline void calc_flowperimeters(self) noexcept nogil
    cpdef inline void calc_flowperimeterderivatives(self) noexcept nogil
    cpdef inline void calc_flowarea(self) noexcept nogil
    cpdef inline void calc_totalarea(self) noexcept nogil
    cpdef inline void calc_discharges(self) noexcept nogil
    cpdef inline void calc_discharge(self) noexcept nogil
    cpdef inline void calc_dischargederivatives(self) noexcept nogil
    cpdef inline void calc_dischargederivative(self) noexcept nogil
    cpdef inline void calc_celerity(self) noexcept nogil
    cpdef double get_wettedarea(self) noexcept nogil
    cpdef double get_surfacewidth(self) noexcept nogil
    cpdef double get_discharge(self) noexcept nogil
    cpdef double get_celerity(self) noexcept nogil
    cpdef void use_waterdepth_v3(self, double waterdepth) noexcept nogil
    cpdef void use_waterlevel_v3(self, double waterlevel) noexcept nogil
    cpdef void use_waterdepth(self, double waterdepth) noexcept nogil
    cpdef void use_waterlevel(self, double waterlevel) noexcept nogil
