# pylint: disable=missing-docstring, unused-argument, used-before-assignment

from hydpy.core.typingtools import *

Input: TypeAlias = Union[float, Double, PDouble]

class DoubleBase:
    def __neg__(self) -> Double: ...
    def __pos__(self) -> Double: ...
    def __abs__(self) -> Double: ...
    def __invert__(self) -> Double: ...
    def __int__(self) -> int: ...
    def __float__(self) -> float: ...
    def __str__(self) -> str: ...
    def __repr__(self) -> str: ...
    def __lt__(self, other: Input) -> bool: ...
    def __le__(self, other: Input) -> bool: ...
    def __eq__(self, other: Any) -> bool: ...
    def __ne__(self, other: Any) -> bool: ...
    def __ge__(self, other: Input) -> bool: ...
    def __gt__(self, other: Input) -> bool: ...

class Double(DoubleBase):
    def __init__(self, value: float) -> None: ...
    def setvalue(self, value: Input) -> None: ...
    def __getitem__(self, key: int) -> float: ...
    def __setitem__(self, key: int, value: Input) -> None: ...
    def __add__(self, other: Input) -> float: ...
    def __sub__(self, other: Input) -> float: ...
    def __mul__(self, other: Input) -> float: ...
    def __floordiv__(self, other: Input) -> float: ...
    def __truediv__(self, other: Input) -> float: ...
    def __mod__(self, other: Input) -> float: ...
    def __pow__(self, other: Input) -> float: ...
    def __radd__(self, other: Input) -> float: ...
    def __rsub__(self, other: Input) -> float: ...
    def __rmul__(self, other: Input) -> float: ...
    def __rfloordiv__(self, other: Input) -> float: ...
    def __rtruediv__(self, other: Input) -> float: ...
    def __rmod__(self, other: Input) -> float: ...
    def __rpow__(self, other: Input) -> float: ...
    def __iadd__(self, other: Input) -> Double: ...
    def __isub__(self, other: Input) -> Double: ...
    def __imul__(self, other: Input) -> Double: ...
    def __idiv__(self, other: Input) -> Double: ...
    def __ifloordiv__(self, other: Input) -> Double: ...
    def __itruediv__(self, other: Input) -> Double: ...
    def __imod__(self, other: Input) -> Double: ...

class PDouble(DoubleBase):
    def __init__(self, value: Double) -> None: ...
    def setvalue(self, value: Input) -> None: ...
    def __getitem__(self, key: int) -> float: ...
    def __setitem__(self, key: int, value: Input) -> None: ...
    def __add__(self, other: Input) -> float: ...
    def __sub__(self, other: Input) -> float: ...
    def __mul__(self, other: Input) -> float: ...
    def __floordiv__(self, other: Input) -> float: ...
    def __truediv__(self, other: Input) -> float: ...
    def __mod__(self, other: Input) -> float: ...
    def __pow__(self, other: Input) -> float: ...
    def __radd__(self, other: Input) -> float: ...
    def __rsub__(self, other: Input) -> float: ...
    def __rmul__(self, other: Input) -> float: ...
    def __rfloordiv__(self, other: Input) -> float: ...
    def __rtruediv__(self, other: Input) -> float: ...
    def __rmod__(self, other: Input) -> float: ...
    def __rpow__(self, other: Input) -> float: ...
    def __iadd__(self, other: Input) -> PDouble: ...
    def __isub__(self, other: Input) -> PDouble: ...
    def __imul__(self, other: Input) -> PDouble: ...
    def __idiv__(self, other: Input) -> PDouble: ...
    def __ifloordiv__(self, other: Input) -> PDouble: ...
    def __itruediv__(self, other: Input) -> PDouble: ...
    def __imod__(self, other: Input) -> PDouble: ...

class PPDouble:
    def __init__(self) -> None: ...
    def set_pointer(self, value: Double, idx: int) -> None: ...
    def _prepare_indices(self, idxs: int | slice) -> list[int]: ...
    def __getitem__(self, key: int | slice) -> VectorFloat: ...
    def __setitem__(self, key: int | slice, value: VectorInputFloat) -> None: ...
    def _get_shape(self) -> tuple[int]: ...
    def _set_shape(self, length: int) -> None: ...
    shape = property(_get_shape, _set_shape)

def check0(length: int) -> None: ...
def check1(length: int, idx: int) -> None: ...
def check2(ready: VectorInputFloat, length: int) -> None: ...
