# coding: utf-8

# flake8: noqa

"""
    CDN API

    API used to create and manage your CDN distributions.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


__version__ = "1.0.0"

# Define package exports
__all__ = [
    "DefaultApi",
    "ApiResponse",
    "ApiClient",
    "HostConfiguration",
    "OpenApiException",
    "ApiTypeError",
    "ApiValueError",
    "ApiKeyError",
    "ApiAttributeError",
    "ApiException",
    "BucketBackend",
    "BucketBackendCreate",
    "BucketBackendPatch",
    "BucketCredentials",
    "Config",
    "ConfigBackend",
    "ConfigPatch",
    "ConfigPatchBackend",
    "CreateDistributionPayload",
    "CreateDistributionPayloadBackend",
    "CreateDistributionResponse",
    "CustomDomain",
    "DeleteCustomDomainResponse",
    "DeleteDistributionResponse",
    "Distribution",
    "DistributionLogsRecord",
    "DistributionStatisticsRecord",
    "DistributionStatisticsRecordEntry",
    "DistributionStatisticsRecordRegions",
    "DistributionWaf",
    "Domain",
    "DomainStatus",
    "ErrorDetails",
    "FindCachePathsResponse",
    "FindCachePathsResponseEntry",
    "GenericJsonResponse",
    "GetCacheInfoResponse",
    "GetCacheInfoResponseHistoryEntry",
    "GetCustomDomainCustomCertificate",
    "GetCustomDomainManagedCertificate",
    "GetCustomDomainResponse",
    "GetCustomDomainResponseCertificate",
    "GetDistributionResponse",
    "GetLogsResponse",
    "GetLogsSearchFiltersResponse",
    "GetLogsSearchFiltersResponseDatacenterBlock",
    "GetLogsSearchFiltersResponseDatacenterBlockItem",
    "GetStatisticsResponse",
    "HttpBackend",
    "HttpBackendCreate",
    "HttpBackendPatch",
    "ListDistributionsResponse",
    "ListWafCollectionsResponse",
    "LokiLogSink",
    "LokiLogSinkCreate",
    "LokiLogSinkCredentials",
    "LokiLogSinkPatch",
    "Optimizer",
    "OptimizerPatch",
    "PatchDistributionPayload",
    "PatchDistributionResponse",
    "PurgeCachePayload",
    "PutCustomDomainCustomCertificate",
    "PutCustomDomainManagedCertificate",
    "PutCustomDomainPayload",
    "PutCustomDomainPayloadCertificate",
    "PutCustomDomainResponse",
    "PutCustomDomainResponseCertificate",
    "Region",
    "StatusError",
    "WAFRuleAction",
    "WAFViolation",
    "WafConfig",
    "WafConfigPatch",
    "WafMode",
    "WafParanoiaLevel",
    "WafRule",
    "WafRuleCollection",
    "WafRuleGroup",
    "WafStatusRuleBlock",
    "WafStatusRuleBlockReason",
    "WafStatusRuleBlockReasonDirectlyDefined",
    "WafStatusRuleBlockReasonInheritedFromCollection",
    "WafStatusRuleBlockReasonInheritedFromGroup",
    "WafStatusRuleBlockReasonInvalidWafType",
    "WafStatusRuleBlockReasonNeverDefined",
    "WafType",
]

# import apis into sdk package
from stackit.cdn.api.default_api import DefaultApi as DefaultApi
from stackit.cdn.api_client import ApiClient as ApiClient

# import ApiClient
from stackit.cdn.api_response import ApiResponse as ApiResponse
from stackit.cdn.configuration import HostConfiguration as HostConfiguration
from stackit.cdn.exceptions import ApiAttributeError as ApiAttributeError
from stackit.cdn.exceptions import ApiException as ApiException
from stackit.cdn.exceptions import ApiKeyError as ApiKeyError
from stackit.cdn.exceptions import ApiTypeError as ApiTypeError
from stackit.cdn.exceptions import ApiValueError as ApiValueError
from stackit.cdn.exceptions import OpenApiException as OpenApiException

# import models into sdk package
from stackit.cdn.models.bucket_backend import BucketBackend as BucketBackend
from stackit.cdn.models.bucket_backend_create import (
    BucketBackendCreate as BucketBackendCreate,
)
from stackit.cdn.models.bucket_backend_patch import (
    BucketBackendPatch as BucketBackendPatch,
)
from stackit.cdn.models.bucket_credentials import BucketCredentials as BucketCredentials
from stackit.cdn.models.config import Config as Config
from stackit.cdn.models.config_backend import ConfigBackend as ConfigBackend
from stackit.cdn.models.config_patch import ConfigPatch as ConfigPatch
from stackit.cdn.models.config_patch_backend import (
    ConfigPatchBackend as ConfigPatchBackend,
)
from stackit.cdn.models.create_distribution_payload import (
    CreateDistributionPayload as CreateDistributionPayload,
)
from stackit.cdn.models.create_distribution_payload_backend import (
    CreateDistributionPayloadBackend as CreateDistributionPayloadBackend,
)
from stackit.cdn.models.create_distribution_response import (
    CreateDistributionResponse as CreateDistributionResponse,
)
from stackit.cdn.models.custom_domain import CustomDomain as CustomDomain
from stackit.cdn.models.delete_custom_domain_response import (
    DeleteCustomDomainResponse as DeleteCustomDomainResponse,
)
from stackit.cdn.models.delete_distribution_response import (
    DeleteDistributionResponse as DeleteDistributionResponse,
)
from stackit.cdn.models.distribution import Distribution as Distribution
from stackit.cdn.models.distribution_logs_record import (
    DistributionLogsRecord as DistributionLogsRecord,
)
from stackit.cdn.models.distribution_statistics_record import (
    DistributionStatisticsRecord as DistributionStatisticsRecord,
)
from stackit.cdn.models.distribution_statistics_record_entry import (
    DistributionStatisticsRecordEntry as DistributionStatisticsRecordEntry,
)
from stackit.cdn.models.distribution_statistics_record_regions import (
    DistributionStatisticsRecordRegions as DistributionStatisticsRecordRegions,
)
from stackit.cdn.models.distribution_waf import DistributionWaf as DistributionWaf
from stackit.cdn.models.domain import Domain as Domain
from stackit.cdn.models.domain_status import DomainStatus as DomainStatus
from stackit.cdn.models.error_details import ErrorDetails as ErrorDetails
from stackit.cdn.models.find_cache_paths_response import (
    FindCachePathsResponse as FindCachePathsResponse,
)
from stackit.cdn.models.find_cache_paths_response_entry import (
    FindCachePathsResponseEntry as FindCachePathsResponseEntry,
)
from stackit.cdn.models.generic_json_response import (
    GenericJsonResponse as GenericJsonResponse,
)
from stackit.cdn.models.get_cache_info_response import (
    GetCacheInfoResponse as GetCacheInfoResponse,
)
from stackit.cdn.models.get_cache_info_response_history_entry import (
    GetCacheInfoResponseHistoryEntry as GetCacheInfoResponseHistoryEntry,
)
from stackit.cdn.models.get_custom_domain_custom_certificate import (
    GetCustomDomainCustomCertificate as GetCustomDomainCustomCertificate,
)
from stackit.cdn.models.get_custom_domain_managed_certificate import (
    GetCustomDomainManagedCertificate as GetCustomDomainManagedCertificate,
)
from stackit.cdn.models.get_custom_domain_response import (
    GetCustomDomainResponse as GetCustomDomainResponse,
)
from stackit.cdn.models.get_custom_domain_response_certificate import (
    GetCustomDomainResponseCertificate as GetCustomDomainResponseCertificate,
)
from stackit.cdn.models.get_distribution_response import (
    GetDistributionResponse as GetDistributionResponse,
)
from stackit.cdn.models.get_logs_response import GetLogsResponse as GetLogsResponse
from stackit.cdn.models.get_logs_search_filters_response import (
    GetLogsSearchFiltersResponse as GetLogsSearchFiltersResponse,
)
from stackit.cdn.models.get_logs_search_filters_response_datacenter_block import (
    GetLogsSearchFiltersResponseDatacenterBlock as GetLogsSearchFiltersResponseDatacenterBlock,
)
from stackit.cdn.models.get_logs_search_filters_response_datacenter_block_item import (
    GetLogsSearchFiltersResponseDatacenterBlockItem as GetLogsSearchFiltersResponseDatacenterBlockItem,
)
from stackit.cdn.models.get_statistics_response import (
    GetStatisticsResponse as GetStatisticsResponse,
)
from stackit.cdn.models.http_backend import HttpBackend as HttpBackend
from stackit.cdn.models.http_backend_create import (
    HttpBackendCreate as HttpBackendCreate,
)
from stackit.cdn.models.http_backend_patch import HttpBackendPatch as HttpBackendPatch
from stackit.cdn.models.list_distributions_response import (
    ListDistributionsResponse as ListDistributionsResponse,
)
from stackit.cdn.models.list_waf_collections_response import (
    ListWafCollectionsResponse as ListWafCollectionsResponse,
)
from stackit.cdn.models.loki_log_sink import LokiLogSink as LokiLogSink
from stackit.cdn.models.loki_log_sink_create import (
    LokiLogSinkCreate as LokiLogSinkCreate,
)
from stackit.cdn.models.loki_log_sink_credentials import (
    LokiLogSinkCredentials as LokiLogSinkCredentials,
)
from stackit.cdn.models.loki_log_sink_patch import LokiLogSinkPatch as LokiLogSinkPatch
from stackit.cdn.models.optimizer import Optimizer as Optimizer
from stackit.cdn.models.optimizer_patch import OptimizerPatch as OptimizerPatch
from stackit.cdn.models.patch_distribution_payload import (
    PatchDistributionPayload as PatchDistributionPayload,
)
from stackit.cdn.models.patch_distribution_response import (
    PatchDistributionResponse as PatchDistributionResponse,
)
from stackit.cdn.models.purge_cache_payload import (
    PurgeCachePayload as PurgeCachePayload,
)
from stackit.cdn.models.put_custom_domain_custom_certificate import (
    PutCustomDomainCustomCertificate as PutCustomDomainCustomCertificate,
)
from stackit.cdn.models.put_custom_domain_managed_certificate import (
    PutCustomDomainManagedCertificate as PutCustomDomainManagedCertificate,
)
from stackit.cdn.models.put_custom_domain_payload import (
    PutCustomDomainPayload as PutCustomDomainPayload,
)
from stackit.cdn.models.put_custom_domain_payload_certificate import (
    PutCustomDomainPayloadCertificate as PutCustomDomainPayloadCertificate,
)
from stackit.cdn.models.put_custom_domain_response import (
    PutCustomDomainResponse as PutCustomDomainResponse,
)
from stackit.cdn.models.put_custom_domain_response_certificate import (
    PutCustomDomainResponseCertificate as PutCustomDomainResponseCertificate,
)
from stackit.cdn.models.region import Region as Region
from stackit.cdn.models.status_error import StatusError as StatusError
from stackit.cdn.models.waf_config import WafConfig as WafConfig
from stackit.cdn.models.waf_config_patch import WafConfigPatch as WafConfigPatch
from stackit.cdn.models.waf_mode import WafMode as WafMode
from stackit.cdn.models.waf_paranoia_level import WafParanoiaLevel as WafParanoiaLevel
from stackit.cdn.models.waf_rule import WafRule as WafRule
from stackit.cdn.models.waf_rule_action import WAFRuleAction as WAFRuleAction
from stackit.cdn.models.waf_rule_collection import (
    WafRuleCollection as WafRuleCollection,
)
from stackit.cdn.models.waf_rule_group import WafRuleGroup as WafRuleGroup
from stackit.cdn.models.waf_status_rule_block import (
    WafStatusRuleBlock as WafStatusRuleBlock,
)
from stackit.cdn.models.waf_status_rule_block_reason import (
    WafStatusRuleBlockReason as WafStatusRuleBlockReason,
)
from stackit.cdn.models.waf_status_rule_block_reason_directly_defined import (
    WafStatusRuleBlockReasonDirectlyDefined as WafStatusRuleBlockReasonDirectlyDefined,
)
from stackit.cdn.models.waf_status_rule_block_reason_inherited_from_collection import (
    WafStatusRuleBlockReasonInheritedFromCollection as WafStatusRuleBlockReasonInheritedFromCollection,
)
from stackit.cdn.models.waf_status_rule_block_reason_inherited_from_group import (
    WafStatusRuleBlockReasonInheritedFromGroup as WafStatusRuleBlockReasonInheritedFromGroup,
)
from stackit.cdn.models.waf_status_rule_block_reason_invalid_waf_type import (
    WafStatusRuleBlockReasonInvalidWafType as WafStatusRuleBlockReasonInvalidWafType,
)
from stackit.cdn.models.waf_status_rule_block_reason_never_defined import (
    WafStatusRuleBlockReasonNeverDefined as WafStatusRuleBlockReasonNeverDefined,
)
from stackit.cdn.models.waf_type import WafType as WafType
from stackit.cdn.models.waf_violation import WAFViolation as WAFViolation
