# coding: utf-8

"""
    CDN API

    API used to create and manage your CDN distributions.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
from typing import Any, Dict, Optional, Set, Union

from pydantic import (
    BaseModel,
    ConfigDict,
    ValidationError,
    field_validator,
)
from typing_extensions import Self

from stackit.cdn.models.bucket_backend import BucketBackend
from stackit.cdn.models.http_backend import HttpBackend


CONFIGBACKEND_ONE_OF_SCHEMAS = ["BucketBackend", "HttpBackend"]


class ConfigBackend(BaseModel):
    """
    ConfigBackend
    """

    # data type: HttpBackend
    oneof_schema_1_validator: Optional[HttpBackend] = None
    # data type: BucketBackend
    oneof_schema_2_validator: Optional[BucketBackend] = None
    actual_instance: Optional[Union[BucketBackend, HttpBackend]] = None
    one_of_schemas: Set[str] = {"BucketBackend", "HttpBackend"}

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )

    discriminator_value_class_map: Dict[str, str] = {}

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator("actual_instance")
    def actual_instance_must_validate_oneof(cls, v):
        instance = ConfigBackend.model_construct()
        error_messages = []
        match = 0
        # validate data type: HttpBackend
        if not isinstance(v, HttpBackend):
            error_messages.append(f"Error! Input type `{type(v)}` is not `HttpBackend`")
        else:
            match += 1
        # validate data type: BucketBackend
        if not isinstance(v, BucketBackend):
            error_messages.append(f"Error! Input type `{type(v)}` is not `BucketBackend`")
        else:
            match += 1
        if match == 0:
            # no match
            raise ValueError(
                "No match found when setting `actual_instance` in ConfigBackend with oneOf schemas: BucketBackend, HttpBackend. Details: "
                + ", ".join(error_messages)
            )
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into HttpBackend
        try:
            instance.actual_instance = HttpBackend.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into BucketBackend
        try:
            instance.actual_instance = BucketBackend.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when deserializing the JSON string into ConfigBackend with oneOf schemas: BucketBackend, HttpBackend. Details: "
                + ", ".join(error_messages)
            )
        elif match == 0:
            # no match
            raise ValueError(
                "No match found when deserializing the JSON string into ConfigBackend with oneOf schemas: BucketBackend, HttpBackend. Details: "
                + ", ".join(error_messages)
            )
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(self) -> Optional[Union[Dict[str, Any], BucketBackend, HttpBackend]]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())
