# coding: utf-8

"""
    CDN API

    API used to create and manage your CDN distributions.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing_extensions import Annotated, Self

from stackit.cdn.models.config_patch_backend import ConfigPatchBackend
from stackit.cdn.models.loki_log_sink_patch import LokiLogSinkPatch
from stackit.cdn.models.optimizer_patch import OptimizerPatch
from stackit.cdn.models.region import Region
from stackit.cdn.models.waf_config_patch import WafConfigPatch


class ConfigPatch(BaseModel):
    """
    ConfigPatch
    """  # noqa: E501

    backend: Optional[ConfigPatchBackend] = None
    blocked_countries: Optional[List[StrictStr]] = Field(
        default=None,
        description="Restricts access to your content based on country.  We use the ISO 3166-1 alpha-2 standard for country codes (e.g., DE, ES, GB).  This setting blocks users from the specified countries. ",
        alias="blockedCountries",
    )
    blocked_ips: Optional[List[StrictStr]] = Field(
        default=None,
        description="Restricts access to your content by specifying a list of blocked IPv4 addresses.  This feature enhances security and privacy by preventing these addresses from accessing your distribution. ",
        alias="blockedIps",
    )
    default_cache_duration: Optional[StrictStr] = Field(
        default=None,
        description="Sets the default cache duration for the distribution.  The default cache duration is applied when a 'Cache-Control' header is not presented in the origin's response. We use ISO8601 duration format for cache duration (e.g. P1DT2H30M) ",
        alias="defaultCacheDuration",
    )
    log_sink: Optional[LokiLogSinkPatch] = Field(default=None, alias="logSink")
    monthly_limit_bytes: Optional[Annotated[int, Field(strict=True, ge=0)]] = Field(
        default=None,
        description="Sets the monthly limit of bandwidth in bytes that the pullzone is allowed to use. ",
        alias="monthlyLimitBytes",
    )
    optimizer: Optional[OptimizerPatch] = None
    regions: Optional[Annotated[List[Region], Field(min_length=1)]] = None
    waf: Optional[WafConfigPatch] = None
    __properties: ClassVar[List[str]] = [
        "backend",
        "blockedCountries",
        "blockedIps",
        "defaultCacheDuration",
        "logSink",
        "monthlyLimitBytes",
        "optimizer",
        "regions",
        "waf",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ConfigPatch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of backend
        if self.backend:
            _dict["backend"] = self.backend.to_dict()
        # override the default output from pydantic by calling `to_dict()` of log_sink
        if self.log_sink:
            _dict["logSink"] = self.log_sink.to_dict()
        # override the default output from pydantic by calling `to_dict()` of optimizer
        if self.optimizer:
            _dict["optimizer"] = self.optimizer.to_dict()
        # override the default output from pydantic by calling `to_dict()` of waf
        if self.waf:
            _dict["waf"] = self.waf.to_dict()
        # set to None if default_cache_duration (nullable) is None
        # and model_fields_set contains the field
        if self.default_cache_duration is None and "default_cache_duration" in self.model_fields_set:
            _dict["defaultCacheDuration"] = None

        # set to None if log_sink (nullable) is None
        # and model_fields_set contains the field
        if self.log_sink is None and "log_sink" in self.model_fields_set:
            _dict["logSink"] = None

        # set to None if monthly_limit_bytes (nullable) is None
        # and model_fields_set contains the field
        if self.monthly_limit_bytes is None and "monthly_limit_bytes" in self.model_fields_set:
            _dict["monthlyLimitBytes"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ConfigPatch from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "backend": ConfigPatchBackend.from_dict(obj["backend"]) if obj.get("backend") is not None else None,
                "blockedCountries": obj.get("blockedCountries"),
                "blockedIps": obj.get("blockedIps"),
                "defaultCacheDuration": obj.get("defaultCacheDuration"),
                "logSink": LokiLogSinkPatch.from_dict(obj["logSink"]) if obj.get("logSink") is not None else None,
                "monthlyLimitBytes": obj.get("monthlyLimitBytes"),
                "optimizer": OptimizerPatch.from_dict(obj["optimizer"]) if obj.get("optimizer") is not None else None,
                "regions": obj.get("regions"),
                "waf": WafConfigPatch.from_dict(obj["waf"]) if obj.get("waf") is not None else None,
            }
        )
        return _obj
