# coding: utf-8

"""
    CDN API

    API used to create and manage your CDN distributions.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field
from typing_extensions import Annotated, Self

from stackit.cdn.models.domain_status import DomainStatus
from stackit.cdn.models.status_error import StatusError


class CustomDomain(BaseModel):
    """
    Definition of a custom domain
    """  # noqa: E501

    errors: Optional[Annotated[List[StatusError], Field(min_length=1)]] = Field(
        default=None, description="This object is present if the custom domain has errors."
    )
    name: Annotated[str, Field(strict=True, max_length=72)] = Field(
        description="The domain. Can be used as input for the GetCustomDomain endpoint"
    )
    status: DomainStatus
    __properties: ClassVar[List[str]] = ["errors", "name", "status"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CustomDomain from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in errors (list)
        _items = []
        if self.errors:
            for _item in self.errors:
                if _item:
                    _items.append(_item.to_dict())
            _dict["errors"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CustomDomain from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "errors": (
                    [StatusError.from_dict(_item) for _item in obj["errors"]] if obj.get("errors") is not None else None
                ),
                "name": obj.get("name"),
                "status": obj.get("status"),
            }
        )
        return _obj
