# coding: utf-8

"""
    CDN API

    API used to create and manage your CDN distributions.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field
from typing_extensions import Self

from stackit.cdn.models.waf_status_rule_block import WafStatusRuleBlock


class DistributionWaf(BaseModel):
    """
    For this property to be present two pre-conditions must be met:   - the WAF was enabled at least once - the query parameter ?withWafStatus is truthy  This property contains the waf Status. At this point in time, this contains all resolved rules. Rules are split into 3 groups:  - enabledRules - logOnlyRules  - disabledRules  **Do note that the global waf mode (Disabled, LogOnly, Enabled) is *NOT* reflected in this list!**
    """  # noqa: E501

    disabled_rules: List[WafStatusRuleBlock] = Field(alias="disabledRules")
    enabled_rules: List[WafStatusRuleBlock] = Field(alias="enabledRules")
    log_only_rules: List[WafStatusRuleBlock] = Field(alias="logOnlyRules")
    __properties: ClassVar[List[str]] = ["disabledRules", "enabledRules", "logOnlyRules"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DistributionWaf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in disabled_rules (list)
        _items = []
        if self.disabled_rules:
            for _item in self.disabled_rules:
                if _item:
                    _items.append(_item.to_dict())
            _dict["disabledRules"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in enabled_rules (list)
        _items = []
        if self.enabled_rules:
            for _item in self.enabled_rules:
                if _item:
                    _items.append(_item.to_dict())
            _dict["enabledRules"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in log_only_rules (list)
        _items = []
        if self.log_only_rules:
            for _item in self.log_only_rules:
                if _item:
                    _items.append(_item.to_dict())
            _dict["logOnlyRules"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DistributionWaf from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "disabledRules": (
                    [WafStatusRuleBlock.from_dict(_item) for _item in obj["disabledRules"]]
                    if obj.get("disabledRules") is not None
                    else None
                ),
                "enabledRules": (
                    [WafStatusRuleBlock.from_dict(_item) for _item in obj["enabledRules"]]
                    if obj.get("enabledRules") is not None
                    else None
                ),
                "logOnlyRules": (
                    [WafStatusRuleBlock.from_dict(_item) for _item in obj["logOnlyRules"]]
                    if obj.get("logOnlyRules") is not None
                    else None
                ),
            }
        )
        return _obj
