# coding: utf-8

"""
    CDN API

    API used to create and manage your CDN distributions.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing_extensions import Annotated, Self

from stackit.cdn.models.get_logs_search_filters_response_datacenter_block import (
    GetLogsSearchFiltersResponseDatacenterBlock,
)


class GetLogsSearchFiltersResponse(BaseModel):
    """
    GetLogsSearchFiltersResponse
    """  # noqa: E501

    cache: List[StrictStr]
    data_center: GetLogsSearchFiltersResponseDatacenterBlock = Field(alias="dataCenter")
    remote_country: List[Annotated[str, Field(min_length=2, strict=True, max_length=2)]] = Field(
        description="List of ISO-3166 Alpha2 Country Codes matching the input filter. Response is ordered in ascending order.   For more Info about the country codes, see https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2 ",
        alias="remoteCountry",
    )
    status: List[Annotated[int, Field(strict=True, ge=0)]] = Field(
        description="List of Status Codes matching the input filter. Response is ordered in ascending order."
    )
    __properties: ClassVar[List[str]] = ["cache", "dataCenter", "remoteCountry", "status"]

    @field_validator("cache")
    def cache_validate_enum(cls, value):
        """Validates the enum"""
        for i in value:
            if i not in set(["HIT", "MISS"]):
                raise ValueError("each list item must be one of ('HIT', 'MISS')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetLogsSearchFiltersResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of data_center
        if self.data_center:
            _dict["dataCenter"] = self.data_center.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetLogsSearchFiltersResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "cache": obj.get("cache"),
                "dataCenter": (
                    GetLogsSearchFiltersResponseDatacenterBlock.from_dict(obj["dataCenter"])
                    if obj.get("dataCenter") is not None
                    else None
                ),
                "remoteCountry": obj.get("remoteCountry"),
                "status": obj.get("status"),
            }
        )
        return _obj
