# coding: utf-8

"""
    CDN API

    API used to create and manage your CDN distributions.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field
from typing_extensions import Self

from stackit.cdn.models.get_logs_search_filters_response_datacenter_block_item import (
    GetLogsSearchFiltersResponseDatacenterBlockItem,
)


class GetLogsSearchFiltersResponseDatacenterBlock(BaseModel):
    """
    Object containing Datacenters to filter for. Each datacenter is grouped to the respective region.
    """  # noqa: E501

    af: List[GetLogsSearchFiltersResponseDatacenterBlockItem] = Field(alias="AF")
    asia: List[GetLogsSearchFiltersResponseDatacenterBlockItem] = Field(alias="ASIA")
    eu: List[GetLogsSearchFiltersResponseDatacenterBlockItem] = Field(alias="EU")
    na: List[GetLogsSearchFiltersResponseDatacenterBlockItem] = Field(alias="NA")
    sa: List[GetLogsSearchFiltersResponseDatacenterBlockItem] = Field(alias="SA")
    __properties: ClassVar[List[str]] = ["AF", "ASIA", "EU", "NA", "SA"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetLogsSearchFiltersResponseDatacenterBlock from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in af (list)
        _items = []
        if self.af:
            for _item in self.af:
                if _item:
                    _items.append(_item.to_dict())
            _dict["AF"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in asia (list)
        _items = []
        if self.asia:
            for _item in self.asia:
                if _item:
                    _items.append(_item.to_dict())
            _dict["ASIA"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in eu (list)
        _items = []
        if self.eu:
            for _item in self.eu:
                if _item:
                    _items.append(_item.to_dict())
            _dict["EU"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in na (list)
        _items = []
        if self.na:
            for _item in self.na:
                if _item:
                    _items.append(_item.to_dict())
            _dict["NA"] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in sa (list)
        _items = []
        if self.sa:
            for _item in self.sa:
                if _item:
                    _items.append(_item.to_dict())
            _dict["SA"] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetLogsSearchFiltersResponseDatacenterBlock from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "AF": (
                    [GetLogsSearchFiltersResponseDatacenterBlockItem.from_dict(_item) for _item in obj["AF"]]
                    if obj.get("AF") is not None
                    else None
                ),
                "ASIA": (
                    [GetLogsSearchFiltersResponseDatacenterBlockItem.from_dict(_item) for _item in obj["ASIA"]]
                    if obj.get("ASIA") is not None
                    else None
                ),
                "EU": (
                    [GetLogsSearchFiltersResponseDatacenterBlockItem.from_dict(_item) for _item in obj["EU"]]
                    if obj.get("EU") is not None
                    else None
                ),
                "NA": (
                    [GetLogsSearchFiltersResponseDatacenterBlockItem.from_dict(_item) for _item in obj["NA"]]
                    if obj.get("NA") is not None
                    else None
                ),
                "SA": (
                    [GetLogsSearchFiltersResponseDatacenterBlockItem.from_dict(_item) for _item in obj["SA"]]
                    if obj.get("SA") is not None
                    else None
                ),
            }
        )
        return _obj
