# coding: utf-8

"""
    CDN API

    API used to create and manage your CDN distributions.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing_extensions import Annotated, Self

from stackit.cdn.models.waf_mode import WafMode
from stackit.cdn.models.waf_paranoia_level import WafParanoiaLevel
from stackit.cdn.models.waf_type import WafType


class WafConfigPatch(BaseModel):
    """
    Modify the WAF Configuration  ## WAF Rules You can modify the set of enabled, disabled and log-only Rules by modifying these 9 properties: - enabledRuleIds - disabledRuleIds - logOnlyRuleIds - enabledRuleGroupIds - disabledRuleGroupIds - logOnlyRuleGroupIds - enabledRuleCollectionIds - disabledRuleCollectionIds - logOnlyRuleCollectionIds  Please inquire the `WafConfig` Description on how the effective configuration is determined.  For patching, if an ID is already used in one of the properties, it will be removed (and effectively moved) to the new property. If patching multiple properties with the same ID (e.g. writing `@builtin/crs/response` to `logOnlyRuleCollectionIds` and `enabledRuleCollectionIds`), the request will be rejected with a 400.
    """  # noqa: E501

    allowed_http_methods: Optional[Annotated[List[StrictStr], Field(min_length=1)]] = Field(
        default=None, alias="allowedHttpMethods"
    )
    allowed_http_versions: Optional[Annotated[List[StrictStr], Field(min_length=1)]] = Field(
        default=None, alias="allowedHttpVersions"
    )
    allowed_request_content_types: Optional[Annotated[List[StrictStr], Field(min_length=1)]] = Field(
        default=None, alias="allowedRequestContentTypes"
    )
    disabled_rule_collection_ids: Optional[List[StrictStr]] = Field(
        default=None, description="Ids of WAF Collections to mark as disabled ", alias="disabledRuleCollectionIds"
    )
    disabled_rule_group_ids: Optional[List[StrictStr]] = Field(
        default=None, description="Ids of WAF Rule Groups to mark as disabled ", alias="disabledRuleGroupIds"
    )
    disabled_rule_ids: Optional[List[StrictStr]] = Field(
        default=None,
        description="Ids of WAF Rules that are **explicitly** disabled for this distribution. ",
        alias="disabledRuleIds",
    )
    enabled_rule_collection_ids: Optional[List[StrictStr]] = Field(
        default=None, description="Ids of WAF Collections to mark as enabled ", alias="enabledRuleCollectionIds"
    )
    enabled_rule_group_ids: Optional[List[StrictStr]] = Field(
        default=None, description="Ids of WAF Rule Groups to mark as enabled ", alias="enabledRuleGroupIds"
    )
    enabled_rule_ids: Optional[List[StrictStr]] = Field(
        default=None,
        description="Ids of WAF Rules that are **explicitly** enabled for this distribution. ",
        alias="enabledRuleIds",
    )
    log_only_rule_collection_ids: Optional[List[StrictStr]] = Field(
        default=None, description="Ids of WAF Collections to mark as log Only. ", alias="logOnlyRuleCollectionIds"
    )
    log_only_rule_group_ids: Optional[List[StrictStr]] = Field(
        default=None, description="Ids of WAF Rule Groups to mark as log Only. ", alias="logOnlyRuleGroupIds"
    )
    log_only_rule_ids: Optional[List[StrictStr]] = Field(
        default=None,
        description="Ids of WAF Rules that are **explicitly** marked as Log Only for this distribution. ",
        alias="logOnlyRuleIds",
    )
    mode: Optional[WafMode] = None
    paranoia_level: Optional[WafParanoiaLevel] = Field(default=None, alias="paranoiaLevel")
    type: Optional[WafType] = None
    __properties: ClassVar[List[str]] = [
        "allowedHttpMethods",
        "allowedHttpVersions",
        "allowedRequestContentTypes",
        "disabledRuleCollectionIds",
        "disabledRuleGroupIds",
        "disabledRuleIds",
        "enabledRuleCollectionIds",
        "enabledRuleGroupIds",
        "enabledRuleIds",
        "logOnlyRuleCollectionIds",
        "logOnlyRuleGroupIds",
        "logOnlyRuleIds",
        "mode",
        "paranoiaLevel",
        "type",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WafConfigPatch from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WafConfigPatch from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "allowedHttpMethods": obj.get("allowedHttpMethods"),
                "allowedHttpVersions": obj.get("allowedHttpVersions"),
                "allowedRequestContentTypes": obj.get("allowedRequestContentTypes"),
                "disabledRuleCollectionIds": obj.get("disabledRuleCollectionIds"),
                "disabledRuleGroupIds": obj.get("disabledRuleGroupIds"),
                "disabledRuleIds": obj.get("disabledRuleIds"),
                "enabledRuleCollectionIds": obj.get("enabledRuleCollectionIds"),
                "enabledRuleGroupIds": obj.get("enabledRuleGroupIds"),
                "enabledRuleIds": obj.get("enabledRuleIds"),
                "logOnlyRuleCollectionIds": obj.get("logOnlyRuleCollectionIds"),
                "logOnlyRuleGroupIds": obj.get("logOnlyRuleGroupIds"),
                "logOnlyRuleIds": obj.get("logOnlyRuleIds"),
                "mode": obj.get("mode"),
                "paranoiaLevel": obj.get("paranoiaLevel"),
                "type": obj.get("type"),
            }
        )
        return _obj
