# coding: utf-8

"""
    CDN API

    API used to create and manage your CDN distributions.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
from typing import Any, Dict, Optional, Set, Union

from pydantic import (
    BaseModel,
    ConfigDict,
    ValidationError,
    field_validator,
)
from typing_extensions import Self

from stackit.cdn.models.waf_status_rule_block_reason_directly_defined import (
    WafStatusRuleBlockReasonDirectlyDefined,
)
from stackit.cdn.models.waf_status_rule_block_reason_inherited_from_collection import (
    WafStatusRuleBlockReasonInheritedFromCollection,
)
from stackit.cdn.models.waf_status_rule_block_reason_inherited_from_group import (
    WafStatusRuleBlockReasonInheritedFromGroup,
)
from stackit.cdn.models.waf_status_rule_block_reason_invalid_waf_type import (
    WafStatusRuleBlockReasonInvalidWafType,
)
from stackit.cdn.models.waf_status_rule_block_reason_never_defined import (
    WafStatusRuleBlockReasonNeverDefined,
)


WAFSTATUSRULEBLOCKREASON_ONE_OF_SCHEMAS = [
    "WafStatusRuleBlockReasonDirectlyDefined",
    "WafStatusRuleBlockReasonInheritedFromCollection",
    "WafStatusRuleBlockReasonInheritedFromGroup",
    "WafStatusRuleBlockReasonInvalidWafType",
    "WafStatusRuleBlockReasonNeverDefined",
]


class WafStatusRuleBlockReason(BaseModel):
    """
    Defines the Reason why a Rule is in the specified state (set to be enabled, disabled or logOnly).
    """

    # data type: WafStatusRuleBlockReasonNeverDefined
    oneof_schema_1_validator: Optional[WafStatusRuleBlockReasonNeverDefined] = None
    # data type: WafStatusRuleBlockReasonDirectlyDefined
    oneof_schema_2_validator: Optional[WafStatusRuleBlockReasonDirectlyDefined] = None
    # data type: WafStatusRuleBlockReasonInvalidWafType
    oneof_schema_3_validator: Optional[WafStatusRuleBlockReasonInvalidWafType] = None
    # data type: WafStatusRuleBlockReasonInheritedFromCollection
    oneof_schema_4_validator: Optional[WafStatusRuleBlockReasonInheritedFromCollection] = None
    # data type: WafStatusRuleBlockReasonInheritedFromGroup
    oneof_schema_5_validator: Optional[WafStatusRuleBlockReasonInheritedFromGroup] = None
    actual_instance: Optional[
        Union[
            WafStatusRuleBlockReasonDirectlyDefined,
            WafStatusRuleBlockReasonInheritedFromCollection,
            WafStatusRuleBlockReasonInheritedFromGroup,
            WafStatusRuleBlockReasonInvalidWafType,
            WafStatusRuleBlockReasonNeverDefined,
        ]
    ] = None
    one_of_schemas: Set[str] = {
        "WafStatusRuleBlockReasonDirectlyDefined",
        "WafStatusRuleBlockReasonInheritedFromCollection",
        "WafStatusRuleBlockReasonInheritedFromGroup",
        "WafStatusRuleBlockReasonInvalidWafType",
        "WafStatusRuleBlockReasonNeverDefined",
    }

    model_config = ConfigDict(
        validate_assignment=True,
        protected_namespaces=(),
    )

    discriminator_value_class_map: Dict[str, str] = {}

    def __init__(self, *args, **kwargs) -> None:
        if args:
            if len(args) > 1:
                raise ValueError("If a position argument is used, only 1 is allowed to set `actual_instance`")
            if kwargs:
                raise ValueError("If a position argument is used, keyword arguments cannot be used.")
            super().__init__(actual_instance=args[0])
        else:
            super().__init__(**kwargs)

    @field_validator("actual_instance")
    def actual_instance_must_validate_oneof(cls, v):
        instance = WafStatusRuleBlockReason.model_construct()
        error_messages = []
        match = 0
        # validate data type: WafStatusRuleBlockReasonNeverDefined
        if not isinstance(v, WafStatusRuleBlockReasonNeverDefined):
            error_messages.append(f"Error! Input type `{type(v)}` is not `WafStatusRuleBlockReasonNeverDefined`")
        else:
            match += 1
        # validate data type: WafStatusRuleBlockReasonDirectlyDefined
        if not isinstance(v, WafStatusRuleBlockReasonDirectlyDefined):
            error_messages.append(f"Error! Input type `{type(v)}` is not `WafStatusRuleBlockReasonDirectlyDefined`")
        else:
            match += 1
        # validate data type: WafStatusRuleBlockReasonInvalidWafType
        if not isinstance(v, WafStatusRuleBlockReasonInvalidWafType):
            error_messages.append(f"Error! Input type `{type(v)}` is not `WafStatusRuleBlockReasonInvalidWafType`")
        else:
            match += 1
        # validate data type: WafStatusRuleBlockReasonInheritedFromCollection
        if not isinstance(v, WafStatusRuleBlockReasonInheritedFromCollection):
            error_messages.append(
                f"Error! Input type `{type(v)}` is not `WafStatusRuleBlockReasonInheritedFromCollection`"
            )
        else:
            match += 1
        # validate data type: WafStatusRuleBlockReasonInheritedFromGroup
        if not isinstance(v, WafStatusRuleBlockReasonInheritedFromGroup):
            error_messages.append(f"Error! Input type `{type(v)}` is not `WafStatusRuleBlockReasonInheritedFromGroup`")
        else:
            match += 1
        if match == 0:
            # no match
            raise ValueError(
                "No match found when setting `actual_instance` in WafStatusRuleBlockReason with oneOf schemas: WafStatusRuleBlockReasonDirectlyDefined, WafStatusRuleBlockReasonInheritedFromCollection, WafStatusRuleBlockReasonInheritedFromGroup, WafStatusRuleBlockReasonInvalidWafType, WafStatusRuleBlockReasonNeverDefined. Details: "
                + ", ".join(error_messages)
            )
        else:
            return v

    @classmethod
    def from_dict(cls, obj: Union[str, Dict[str, Any]]) -> Self:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> Self:
        """Returns the object represented by the json string"""
        instance = cls.model_construct()
        error_messages = []
        match = 0

        # deserialize data into WafStatusRuleBlockReasonNeverDefined
        try:
            instance.actual_instance = WafStatusRuleBlockReasonNeverDefined.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into WafStatusRuleBlockReasonDirectlyDefined
        try:
            instance.actual_instance = WafStatusRuleBlockReasonDirectlyDefined.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into WafStatusRuleBlockReasonInvalidWafType
        try:
            instance.actual_instance = WafStatusRuleBlockReasonInvalidWafType.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into WafStatusRuleBlockReasonInheritedFromCollection
        try:
            instance.actual_instance = WafStatusRuleBlockReasonInheritedFromCollection.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))
        # deserialize data into WafStatusRuleBlockReasonInheritedFromGroup
        try:
            instance.actual_instance = WafStatusRuleBlockReasonInheritedFromGroup.from_json(json_str)
            match += 1
        except (ValidationError, ValueError) as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError(
                "Multiple matches found when deserializing the JSON string into WafStatusRuleBlockReason with oneOf schemas: WafStatusRuleBlockReasonDirectlyDefined, WafStatusRuleBlockReasonInheritedFromCollection, WafStatusRuleBlockReasonInheritedFromGroup, WafStatusRuleBlockReasonInvalidWafType, WafStatusRuleBlockReasonNeverDefined. Details: "
                + ", ".join(error_messages)
            )
        elif match == 0:
            # no match
            raise ValueError(
                "No match found when deserializing the JSON string into WafStatusRuleBlockReason with oneOf schemas: WafStatusRuleBlockReasonDirectlyDefined, WafStatusRuleBlockReasonInheritedFromCollection, WafStatusRuleBlockReasonInheritedFromGroup, WafStatusRuleBlockReasonInvalidWafType, WafStatusRuleBlockReasonNeverDefined. Details: "
                + ", ".join(error_messages)
            )
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is None:
            return "null"

        if hasattr(self.actual_instance, "to_json") and callable(self.actual_instance.to_json):
            return self.actual_instance.to_json()
        else:
            return json.dumps(self.actual_instance)

    def to_dict(
        self,
    ) -> Optional[
        Union[
            Dict[str, Any],
            WafStatusRuleBlockReasonDirectlyDefined,
            WafStatusRuleBlockReasonInheritedFromCollection,
            WafStatusRuleBlockReasonInheritedFromGroup,
            WafStatusRuleBlockReasonInvalidWafType,
            WafStatusRuleBlockReasonNeverDefined,
        ]
    ]:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is None:
            return None

        if hasattr(self.actual_instance, "to_dict") and callable(self.actual_instance.to_dict):
            return self.actual_instance.to_dict()
        else:
            # primitive type
            return self.actual_instance

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.model_dump())
