# coding: utf-8

"""
    CDN API

    API used to create and manage your CDN distributions.

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

from __future__ import annotations

import json
import pprint
from typing import Any, ClassVar, Dict, List, Optional, Set

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing_extensions import Self

from stackit.cdn.models.waf_rule_action import WAFRuleAction


class WAFViolation(BaseModel):
    """
    Information about a violated WAF rule in case the WAF is enabled and a rule was triggered (either in BLOCK or LOG_ONLY mode)
    """  # noqa: E501

    action: WAFRuleAction
    asn: StrictStr = Field(description="ASN for the request")
    message: StrictStr = Field(description="Rule specific message explaining the violation")
    method: StrictStr = Field(description="HTTP Method of the request that triggered the violation")
    request_headers: Dict[str, StrictStr] = Field(alias="requestHeaders")
    rule_id: StrictStr = Field(description="ID of the WAF rule that was triggered", alias="ruleId")
    __properties: ClassVar[List[str]] = ["action", "asn", "message", "method", "requestHeaders", "ruleId"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WAFViolation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WAFViolation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "action": obj.get("action"),
                "asn": obj.get("asn"),
                "message": obj.get("message"),
                "method": obj.get("method"),
                "requestHeaders": obj.get("requestHeaders"),
                "ruleId": obj.get("ruleId"),
            }
        )
        return _obj
