# coding: utf-8

"""
    API Endpoints

    Deliver monetary rewards and incentives to employees, customers, survey participants, and more through the Tremendous API. For organizational tasks, like managing your organization and its members within Tremendous, please see the Tremendous Organizational API.

    The version of the OpenAPI document: 2
    Contact: developers@tremendous.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from tremendous.models.list_campaigns200_response_campaigns_inner_email_style import ListCampaigns200ResponseCampaignsInnerEmailStyle
from tremendous.models.list_campaigns200_response_campaigns_inner_webpage_style import ListCampaigns200ResponseCampaignsInnerWebpageStyle
from typing import Optional, Set
from typing_extensions import Self

class CreateCampaignRequest(BaseModel):
    """
    With a campaign you can define the look & feel of how rewards are sent out. It also lets you set the available products (different gift cards, charity, etc.) recipients can choose from. 
    """ # noqa: E501
    name: StrictStr = Field(description="Name of the campaign")
    description: Optional[StrictStr] = Field(description="Description of the campaign")
    products: List[Annotated[str, Field(strict=True)]] = Field(description="List of IDs of products (different gift cards, charity, etc.) that are available in this campaign. ")
    webpage_style: Optional[ListCampaigns200ResponseCampaignsInnerWebpageStyle] = None
    email_style: Optional[ListCampaigns200ResponseCampaignsInnerEmailStyle] = None
    __properties: ClassVar[List[str]] = ["name", "description", "products", "webpage_style", "email_style"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateCampaignRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of webpage_style
        if self.webpage_style:
            _dict['webpage_style'] = self.webpage_style.to_dict()
        # override the default output from pydantic by calling `to_dict()` of email_style
        if self.email_style:
            _dict['email_style'] = self.email_style.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateCampaignRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "name": obj.get("name"),
            "description": obj.get("description"),
            "products": obj.get("products"),
            "webpage_style": ListCampaigns200ResponseCampaignsInnerWebpageStyle.from_dict(obj["webpage_style"]) if obj.get("webpage_style") is not None else None,
            "email_style": ListCampaigns200ResponseCampaignsInnerEmailStyle.from_dict(obj["email_style"]) if obj.get("email_style") is not None else None
        })
        return _obj


