# coding: utf-8

"""
    API Endpoints

    Deliver monetary rewards and incentives to employees, customers, survey participants, and more through the Tremendous API. For organizational tasks, like managing your organization and its members within Tremendous, please see the Tremendous Organizational API.

    The version of the OpenAPI document: 2
    Contact: developers@tremendous.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class CreateConnectedOrganizationMemberSession200ResponseConnectedOrganizationMemberSession(BaseModel):
    """
    CreateConnectedOrganizationMemberSession200ResponseConnectedOrganizationMemberSession
    """ # noqa: E501
    connected_organization_member_id: Annotated[str, Field(strict=True)] = Field(description="Tremendous' identifier for the connected organization member.")
    url: StrictStr = Field(description="The URL to start the \"Tremendous for Platforms\" flow.")
    return_url: StrictStr = Field(description="The URL used for links that redirect the user back to your site when they've completed their actions on Tremendous.")
    expires_at: datetime = Field(description="Timestamp of when the session will expire.")
    created_at: datetime = Field(description="Timestamp of when the session was created.")
    __properties: ClassVar[List[str]] = ["connected_organization_member_id", "url", "return_url", "expires_at", "created_at"]

    @field_validator('connected_organization_member_id')
    def connected_organization_member_id_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if not re.match(r"[A-Z0-9]{4,20}", value):
            raise ValueError(r"must validate the regular expression /[A-Z0-9]{4,20}/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateConnectedOrganizationMemberSession200ResponseConnectedOrganizationMemberSession from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateConnectedOrganizationMemberSession200ResponseConnectedOrganizationMemberSession from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "connected_organization_member_id": obj.get("connected_organization_member_id"),
            "url": obj.get("url"),
            "return_url": obj.get("return_url"),
            "expires_at": obj.get("expires_at"),
            "created_at": obj.get("created_at")
        })
        return _obj


