# compute cron value ; used by IN.JOB
# efv 01.12.2025 create
# ------------------------------------------
import sys
from cron_converter import Cron
from datetime import datetime


def next(cronexp: str, dtiso: str):
     """Compute next datetime from crontab expression, starting from dtiso else now().

     Args:
          cronexp (str): a crontab expression string like : */5 * * * *
          dtiso (str): a datetime iso format string like : 2025-12-01T09:00:23 
               if null use now()

     Raises:
          Exception: forward the exception to the caller 

     Returns:
          _type_: datetime.isoformat YYYY-MM-DDTHH:MM:SS 
     """
     try:
        if len(cronexp) == 0:
            raise Exception("cronexp is not provided.")
        if len(dtiso) == 0:
            reference = datetime.now()
        else:
            reference = datetime.fromisoformat(dtiso)
        cron_instance = Cron()  # Create a new instance
        cron_instance.from_string(cronexp) # load the cron expression
        schedule = cron_instance.schedule(reference) # load the datetime reference
        thenext = schedule.next() # compute the next runtime datetime 
        return thenext.isoformat() # return isoformat YYYY-MM-DDTHH:MM:SS 
     except:
        raise # raise the error to the parent caller

# ---------------------------------------------------------------------------------------

def validate(cronexp: str):
     try:
          if cronexp == '':
               raise Exception("cronexp is not provided.")
          cron_instance = Cron()  # Create a new instance
          cron_instance.from_string(cronexp)
          return cron_instance.to_string()
     except:
        raise

# ---------------------------------------------------------------------------------------

if __name__ == "__main__":
     """
     test and sample of cron validate(), cron next()
     python inpython\intools\in_cron.py '*/5 * * * *' '2025-12-01T09:00:23'
     python inpython\intools\in_cron.py '*/5 * * * *' 
     """
     cronexp = sys.argv[1]
     dtiso = ''
     if len(sys.argv) == 3:
          dtiso = sys.argv[2]
     res = validate(cronexp)
     print(res, type(res))
     res = next(cronexp, dtiso)
     print(res, type(res))

