import win32com.client
import zipfile
from PIL import Image
import os
import shutil
from pathlib import Path
import time

word = win32com.client.Dispatch("Word.Application")
wdFormatPDF = 17 

def make_docx(output_filename, source_dir):
    path_cmp = source_dir.split(os.sep)
    main_dir = path_cmp[len(path_cmp)-1] + '\\'
    relroot = os.path.abspath(os.path.join(source_dir, os.pardir))
    with zipfile.ZipFile(output_filename, "w", zipfile.ZIP_DEFLATED) as zip:
        for root, dirs, files in os.walk(source_dir):
            zip.write(root, os.path.relpath(root, relroot).replace(main_dir,''))
            for file in files:
                filename = os.path.join(root, file)
                if os.path.isfile(filename): 
                    arcname = os.path.join(os.path.relpath(root, relroot).replace(main_dir,''), file) 
                    arcname=arcname.replace(main_dir,'')
                    zip.write(filename, arcname)
    shutil.rmtree(source_dir + "/docProps")
    shutil.rmtree(source_dir + "/_rels")
    shutil.rmtree(source_dir + "/word")
    if os.path.exists(source_dir + "/customXml"): shutil.rmtree(source_dir + "/customXml")
    os.remove(source_dir + "\\[Content_Types].xml")

def convert_emf_png(input_filename,output_filename,dir_tmp):
    archive = zipfile.ZipFile(input_filename)
    file_rels = dir_tmp + "\\word\\_rels\\document.xml.rels"
    for file in archive.filelist:
        archive.extract(file,path = dir_tmp)
        if(file.filename == "word/_rels/document.xml.rels"):
            f = open(file_rels, 'r')
            docx_rels = f.read()
        if file.filename.startswith('word/media/') :
            root, extension = os.path.splitext(file.filename)
            if extension == ".emf" :
               path_pict = file.filename.split("/")
               pict_name = path_pict[len(path_pict)-1]
               pict_png = pict_name.replace(".emf",".png")
               docx_rels = docx_rels.replace(pict_name,pict_png)
               Image.open(dir_tmp + "\\" + file.filename).save(dir_tmp + "\\" + root + ".png")
               os.remove(dir_tmp + "\\" + file.filename)
    with open(file_rels, 'w') as f:
        f.write(docx_rels)  
    make_docx(output_filename,dir_tmp)         

def convert_docx_pdf(input_filename,output_filename):
    relroot = os.path.abspath(os.path.join(output_filename, os.pardir))
    dir_tmp = relroot + '\\tmp' + str(time.strftime('%Y%m%d%H%M%S'))
    if not os.path.exists(dir_tmp): os.mkdir(dir_tmp)
    dir_tmp_zip = dir_tmp + "\\zipdocx"
    if not os.path.exists(dir_tmp_zip): os.mkdir(dir_tmp_zip)
    convert_emf_png(input_filename,dir_tmp + "/doc_tmp.docx", dir_tmp_zip)
    os.rmdir(dir_tmp_zip)
    docx_filepath = Path(dir_tmp + "/doc_tmp.docx").resolve()
    pdf_filepath = Path(output_filename).resolve()
    doc = word.Documents.Open(str(docx_filepath))
    doc.SaveAs(str(pdf_filepath), FileFormat=wdFormatPDF)
    doc.Close(0)
    os.remove(dir_tmp + "/doc_tmp.docx")
    os.rmdir(dir_tmp)

def protect_docx(pFileName, pPassword):  
    doc = word.Documents.Open(pFileName, PasswordDocument=pPassword)
    doc.Protect(Type=2, NoReset=True, Password=pPassword)
    doc.Save()
    doc.Close()
    word.Quit()
