import geopy.distance
from geopy.geocoders import Nominatim

def distance(lat1, lon1, lat2, lon2, methode = "geodesic"):
    poin1 = (lat1,lon1)
    point2 = (lat2, lon2)
    try:
        if methode == "great_circle" :
            return geopy.distance.great_circle(poin1, point2).km 
        if methode == "geodesic" :
            return geopy.distance.geodesic(
            poin1, point2,ellipsoid='Intl 1924').km 
    except Exception as e:
        raise e

def geoloc(adr):
    geolocator = Nominatim(user_agent="openstreetmap.org")
    location = geolocator.geocode(adr)
    return str(location.latitude) + "|" + str(location.longitude)


if __name__ == "__main__":
    print("Hello from in_geo_calc")
    print(distance(52.2296756, 21.0122287, 52.406374, 16.9251681))
    print(geoloc("64, rue Grande 6760 Gomery Belgique"))
