import os
import logging as log
import datetime as dt
import configparser


def init_log(logName, msg="", initOK=False):
    if not (initOK):
        intoolsPath = os.path.abspath(__file__)
        intoolsDir = os.path.dirname(intoolsPath)
        iniFile = os.path.join(intoolsDir, "intools.ini")
        if os.path.exists(iniFile):
            config = configparser.ConfigParser()
            config.read(iniFile)
            if 'enabledLog' in config:
                enabledLog = config["enabledLog"]
                if logName in enabledLog:
                    if enabledLog.getboolean(logName):
                        initOK = True

    if not (initOK):
        return (False)

    logok = False
    logPath = ""
    for cle, valeur in os.environ.items():
        if cle == "UVDB":
            logok = True
            logPath = valeur.replace("UVDB", "logs")
            break

    if logok:
        logPath = os.path.join(logPath, "inpython")
        os.makedirs(logPath, exist_ok=True)

    if not (os.path.exists(logPath)):
        return (False)

    log_file = os.path.join(logPath, f"{dt.datetime.now().strftime('%Y%m%d')}-{logName}.log")

    log.basicConfig(
        filename=log_file,  # Nom du fichier log
        level=log.DEBUG,  # Niveau de log (DEBUG, INFO, WARNING, ERROR, CRITICAL)
        format='%(asctime)s - %(levelname)s - %(message)s',  # Format des messages de log
        datefmt='%Y-%m-%d %H:%M:%S'  # Format des dates
    )

    if os.path.exists(log_file):
        if os.path.getsize(log_file) == 0:
            info("InTools log file initialisation!")
        if len(msg):
            info(msg)

    return (True)


def debug(msg):
    log.debug(msg)


def error(msg):
    log.error(msg)


def info(msg):
    log.info(msg)


def marning(msg):
    log.warning(msg)


if __name__ == '__main__':
    print("main")

    # repertoire_courant = Path.cwd()

    # inlog.debug(f"Le répertoire courant est : {repertoire_courant}")
    # chemin_du_script = Path(__file__).resolve()
    # repertoire_du_script = chemin_du_script.parent
    # inlog.debug(f"Le répertoire du script est : {repertoire_du_script}")
