# outil de conversion de fichier xls ou xlsx en fichier CVS

import sys
import csv
import pandas as pd
import json
import os.path

def hello_world():
    print('Hello world fron xls_to_csv')

def parse_csv(csv_file,csv_dest="",nligne=1):
    # Ouvrir le fichier CSV en mode lecture
    with open(csv_file, newline='',encoding="utf8") as csvfile:
        # Créer un lecteur CSV
        lecteur_csv = csv.reader(csvfile, delimiter=';')
        donnees = list(lecteur_csv)
        num = 0
        # Parcourir chaque ligne du fichier CSV
        for lindex, ligne in enumerate(donnees):
            for cindex, cellule in enumerate(ligne):
                if len(cellule) > 0 :
                    donnees[lindex][cindex] = cellule.replace('\n','|') 
        for i in range(nligne-1): donnees.pop(0)
    if csv_dest!="" : 
        os.remove(csv_file)
        csv_file=csv_dest
        tp_write = 'a'
    else:
        tp_write = 'w'

    with open(csv_file, tp_write, newline='') as fichier_sortie:
        writer_csv = csv.writer(fichier_sortie, delimiter=';')
        # Écrire les données modifiées dans le nouveau fichier CSV
        writer_csv.writerows(donnees)

def isInteger(s):
    if s[0] == '-':
        s = s.split('-')[1]
    if s.isdigit():
        return(True)
    return(False)


def convert_to_csv_by_sheet(xls_file,csv_file,sheet_list,fusion=False,buffer=False,nligne=1):
    if buffer: fusion=True
    csv_result = []
    if fusion : 
        if os.path.isfile(csv_file):
            os.remove(csv_file)
        csv_result.append(csv_file)
    all_sheets = pd.read_excel(xls_file, sheet_name=None, keep_default_na=False)
    sheets = all_sheets.keys()
    sheet_names = []
    for sheet_name in sheets:
        sheet_names.append(sheet_name)
    
    if sheet_list == "*" :
        sheets_to_extract = sheet_names
    else :         
        sheets_to_extract = sheet_list.split("|")

    for sh in sheets_to_extract:
        try:
            if isInteger(sh):
                n = int(sh)
                if n < 0:
                    sh_index = len(sheets) + n
                else:
                    sh_index = n - 1
            else:
                sh_index = sheet_names.index(sh)
            sheet_name = sheet_names[sh_index]
            csv_sheet_file = csv_file.split('.')[0] + "_" + sheet_name + ".csv"
            if fusion==False : 
                csv_result.append(csv_sheet_file)
            
            df = pd.read_excel(xls_file, sheet_name=sheet_name, keep_default_na=False)
            df.to_csv(csv_sheet_file, index=False, sep=';')

            if fusion:
                parse_csv(csv_sheet_file,csv_result[0],nligne)
            else:
                parse_csv(csv_sheet_file,nligne=nligne)
        except:
            print("la feuille [",sh,"] n'est pas présente!")
    if buffer :
        for csvr in csv_result:
            file = open(csvr, "r")
            content = file.read()
            file.close()
            os.remove(csvr)
            return content.replace('\n','|')
    else:
        return(json.dumps(csv_result))


def convert_sheets_to_csv(xls_file,csv_file):
    all_sheets = pd.read_excel(xls_file, sheet_name=None, keep_default_na=False)
    sheets = all_sheets.keys()
    for sheet_name in sheets:
        csv_sheet_file = csv_file.split('.')[0] + "_" + sheet_name + ".csv"
        df = pd.read_excel(xls_file, sheet_name=sheet_name, keep_default_na=False)
        df.to_csv(csv_sheet_file, index=False, sep=';')
        parse_csv(csv_sheet_file)
    return


def convert_to_csv(xls_file,csv_file):
    df = pd.read_excel(xls_file, keep_default_na=False)
    df.to_csv(csv_file, index=False, sep=';')
    parse_csv(csv_file)
    return

if __name__ == '__main__':
    arguments = sys.argv

    if len(arguments) == 3:
        xl_filename = arguments[1].replace('\\','/')  # Premier argument
        csv_filename = arguments[2].replace('\\','/')  # Deuxième argument
        convert_to_csv(xl_filename, csv_filename)
    else:
        xl_filename = "C:/INTEGRIX/PARTAGE/Fichiers Fabriquants/Calcul Détail 23_1061 - CBL réf. Kiem 2050 de 04-07-24.xlsx"  # Premier argument
        csv_filename = "C:/INTEGRIX/PARTAGE/Fichiers Fabriquants/MON-CODE-PROJET.csv"  # Deuxième argument
        convert_to_csv(xl_filename, csv_filename)
        print("Arguments manquants")
