from docx import Document
from docx.shared import Inches
from docx.enum.text import WD_ALIGN_PARAGRAPH
from docx.oxml import OxmlElement
from docx.oxml.ns import qn
from docx.shared import Pt
from docx.shared import Cm
from docx.enum.style import WD_STYLE_TYPE
import csv

# Fonction pour ajouter des bordures à une cellule
def set_cell_border(cell, **kwargs):
    """
    cell: L'objet cellule du tableau auquel appliquer les bordures
    kwargs: Propriétés de la bordure (haut, bas, gauche, droite, intérieur_horizontal, intérieur_vertical)
    Exemple d'utilisation : set_cell_border(cell, top={"sz": 2, "val": "single", "color": "000000"})
    """
    tc = cell._element
    tcPr = tc.get_or_add_tcPr()

    for edge in ('top', 'bottom', 'start', 'end', 'insideH', 'insideV'):
        if edge in kwargs:
            edge_data = kwargs[edge]
            tag = 'w:{}'.format(edge)
            element = tcPr.find(qn(tag))
            if element is None:
                element = OxmlElement(tag)
                tcPr.append(element)
            for key in edge_data:
                element.set(qn('w:{}'.format(key)), str(edge_data[key]))


def build_projet(txt_filename,tpl_filename,doc_filename):
    doc_prj = Document(tpl_filename)
    font_styles = doc_prj.styles
    font_charstyle = font_styles.add_style('ppcstyle', WD_STYLE_TYPE.CHARACTER)
    font_object = font_charstyle.font
    font_object.size = Pt(9)

    font_charstylestot = font_styles.add_style('stotstyle', WD_STYLE_TYPE.CHARACTER)
    font_objectstot = font_charstylestot.font
    font_objectstot.size = Pt(10)

    font_charstylestit = font_styles.add_style('stitstyle', WD_STYLE_TYPE.CHARACTER)
    font_objectstit = font_charstylestit.font
    font_objectstit.size = Pt(11)

    data = []

    #txt_filename = 'C:\\X\\Servalux\\TEST_DETAIL.txt'
    with open(txt_filename, 'r', encoding="utf-8") as file:
        # Créer un lecteur CSV
        reader = csv.reader(file, delimiter=';')  # Spécifiez le délimiteur approprié si nécessaire
        for rowidx, row in enumerate(reader):
                if rowidx >= 9:
                    if len(row) > 0:
                        data.append(row)

        current_pos = ''
        ctotal = 0
        sctotal = 0
        prv_chapter_pos = 0
        prv_section_pos = 0
        n = 0
        chap = ""
        for posidx, pos in enumerate(data[0]):
            if pos == "CPC":
                if prv_chapter_pos > 0:
                    #add_chapter_total(prv_chapter_pos,doc_prj)
                    table = doc_prj.add_table(rows=1, cols=3)
                    row = table.rows[0]
                    row.cells[0].text = str(data[4][prv_chapter_pos])
                    row.cells[2].text = data[21][prv_chapter_pos]
                    prv_chapter_pos = 0
                text = str(data[4][posidx])
                #print(f'Chapître {text}')
                chap = text
                #paragraph = doc_prj.add_paragraph()
                #run = paragraph.add_run(f'{text}')
                #run.bold = True
                #run.underline = True 
                prv_chapter_pos = posidx
            if pos == "SPC":
                if prv_section_pos > 0:
                    table = doc_prj.add_table(rows=1, cols=2)
                    row = table.rows[0]
                    text = str(data[4][prv_section_pos])
                    row.cells[0].text = f'Sous-total {text}'
                    row.cells[0].width = Cm(140)
                    paragraphs = row.cells[0].paragraphs
                    paragraph = paragraphs[0]
                    run_obj = paragraph.runs
                    run = run_obj[0]
                    run.style = "stotstyle"

                    total = data[12][prv_section_pos]
                    if len(data[12][prv_section_pos]) > 0:
                        row.cells[1].text = data[12][prv_section_pos]
                    else:
                        row.cells[1].text = f'{sctotal:.2f}€'
                    cell = row.cells[1]
                    row.cells[1].width = Cm(30)
                    paragraph = cell.paragraphs[0]
                    run_obj = paragraph.runs
                    run = run_obj[0]
                    run.style = "stotstyle"

                    cell.paragraphs[0].alignment = WD_ALIGN_PARAGRAPH.RIGHT
                    set_cell_border(row.cells[0],
                                    top={"sz": 2, "val": "single", "color": "000000"},   # Bordure du haut
                                    bottom={"sz": 2, "val": "single", "color": "000000"}, # Bordure du bas
                                    start={"sz": 2, "val": "single", "color": "000000"})    # Bordure droite
                    set_cell_border(row.cells[1],
                                    top={"sz": 2, "val": "single", "color": "000000"},   # Bordure du haut
                                    bottom={"sz": 2, "val": "single", "color": "000000"}, # Bordure du bas
                                    end={"sz": 2, "val": "single", "color": "000000"})    # Bordure droite
                    prv_section_pos = 0
                    sctotal = 0
                    paragraph = doc_prj.add_paragraph()

                text = str(data[4][posidx])
                #print(f'Sous-Chapître {text}')
                paragraph = doc_prj.add_paragraph()
                # if n > 0 :
                #     paragraph.add_run('\n')
                run = paragraph.add_run(f'{chap} {text}')
                run.bold = True
                run.underline = True 
                run = paragraph.add_run('\n')
                n += 1

                paragraph = doc_prj.add_paragraph()
                run = paragraph.add_run(f'Positions incluses dans le montant global du devis :\n',style='stitstyle')
                run.bold = True
                run.underline = True 
                prv_section_pos = posidx
            if pos == "PPC":
                text = str(data[4][posidx]).replace("|"," ")
                #print(f'Position {text}')
                paragraph = doc_prj.add_paragraph()
                run = paragraph.add_run(f' {text}', style='ppcstyle')
                paragraph = doc_prj.add_paragraph()
                paragraph.alignment = WD_ALIGN_PARAGRAPH.RIGHT
                run = paragraph.add_run(f' {data[12][posidx]}€\n', style='ppcstyle')
                sctotal += float(data[12][posidx])
            if pos == "VPC":
                paragraph = doc_prj.add_paragraph()
                run = paragraph.add_run(f'Positions NON incluses dans le montant global du devis :\n',style='stitstyle')
                run.bold = True
                run.underline = True 
                paragraph = doc_prj.add_paragraph()
                text = str(data[4][posidx]).replace("|"," ")
                #print(f'Position {text}')
                run = paragraph.add_run(f'{text}', style='ppcstyle')
                paragraph = doc_prj.add_paragraph()
                paragraph.alignment = WD_ALIGN_PARAGRAPH.RIGHT
                run = paragraph.add_run(f' {data[12][posidx]}€\n', style='ppcstyle')
            if pos == "XPC":
                test=1
                #text = str(data[4][posidx])
                #print(f'Composant {text}')
                #run = paragraph.add_run(f'\t{text}\n')

        if prv_section_pos > 0:
            #add_chapter_total(prv_section_pos,doc_prj)
            table = doc_prj.add_table(rows=1, cols=2)
            row = table.rows[0]
            text = str(data[4][prv_section_pos])
            row.cells[0].text = f'Sous-total {text}'
            row.cells[0].width = Cm(140)
            paragraphs = row.cells[0].paragraphs
            paragraph = paragraphs[0]
            run_obj = paragraph.runs
            run = run_obj[0]
            run.style = "stotstyle"

            total = data[12][prv_section_pos]
            if len(data[12][prv_section_pos]) > 0:
                row.cells[1].text = data[12][prv_section_pos]
            else:
                row.cells[1].text = f'{sctotal:.2f}€'
            cell = row.cells[1]
            row.cells[1].width = Cm(30)
            paragraphs = row.cells[1].paragraphs
            paragraph = paragraphs[0]
            run_obj = paragraph.runs
            run = run_obj[0]
            run.style = "stotstyle"
            cell.paragraphs[0].alignment = WD_ALIGN_PARAGRAPH.RIGHT
            set_cell_border(row.cells[0],
                            top={"sz": 2, "val": "single", "color": "000000"},   # Bordure du haut
                            bottom={"sz": 2, "val": "single", "color": "000000"}, # Bordure du bas
                            start={"sz": 2, "val": "single", "color": "000000"})    # Bordure droite
            set_cell_border(row.cells[1],
                            top={"sz": 2, "val": "single", "color": "000000"},   # Bordure du haut
                            bottom={"sz": 2, "val": "single", "color": "000000"}, # Bordure du bas
                            end={"sz": 2, "val": "single", "color": "000000"})    # Bordure droite
            prv_section_pos = 0

    doc_prj.add_page_break()
    #doc_prj.save('C:\\X\\Servalux\\TEST_DETAIL.docx')
    doc_prj.save(doc_filename)