from pydantic import BaseModel
from typing import Dict, Any, Optional


class NodeEvent(BaseModel):
    """
    node_type 就是 NodeType的值，但是不能直接使用 NodeType 因為會circular import
    """

    node_id: str
    node_type: str
    node_title: str


class NodeRunStartedEvent(NodeEvent):
    pass


class NodeRunCompletedEvent(NodeEvent):
    outputs: Dict[str, Any]


class NodeRunStreamEvent(NodeEvent):
    chunk: str


class NodeRunFailedEvent(NodeEvent):
    error: str


class WorkflowRunStartedEvent(BaseModel):
    pass


class WorkflowRunCompletedEvent(BaseModel):
    outputs: Dict[str, Any]


class WorkflowRunFailedEvent(BaseModel):
    error: str
