/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp;

import at.ac.iiasa.ixmp.database.AutoRollback;
import at.ac.iiasa.ixmp.database.ConfigProvider;
import at.ac.iiasa.ixmp.database.DBUtils;
import at.ac.iiasa.ixmp.database.DbDAO;
import at.ac.iiasa.ixmp.dto.AccessRequestDTO;
import at.ac.iiasa.ixmp.dto.DocumentationKey;
import at.ac.iiasa.ixmp.dto.TimesliceDTO;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.IamVariable;
import at.ac.iiasa.ixmp.objects.Metadata;
import at.ac.iiasa.ixmp.objects.MsgScenario;
import at.ac.iiasa.ixmp.objects.Scenario;
import at.ac.iiasa.ixmp.objects.ScenarioDbStatus;
import at.ac.iiasa.ixmp.objects.TimeSeries;
import at.ac.iiasa.ixmp.rest.v2_1.dto.ModelDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.NodeDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.ScenarioDTO;
import at.ac.iiasa.ixmp.security.EntityType;
import at.ac.iiasa.ixmp.security.SecurityService;
import at.ac.iiasa.ixmp.utils.ApplicationConfig;
import at.ac.iiasa.ixmp.utils.AuthServerConfig;
import at.ac.iiasa.ixmp.utils.DatabaseConfig;
import java.io.Closeable;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Platform
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(Platform.class);
    private final DatabaseConfig dbConfig;
    private final boolean forceMigration;
    private ApplicationConfig applicationConfig = null;
    private AuthServerConfig serverConfig = null;
    protected DbDAO db = null;
    private final Map<Integer, IamVariable> idIamVariableMap = new HashMap<Integer, IamVariable>();
    private final Map<String, Map<String, IamVariable>> nameUnitVariableMap = new HashMap<String, Map<String, IamVariable>>();
    private final HashMap<Integer, String> idNodeMap = new HashMap();
    private final HashMap<String, Integer> nodeIdMap = new HashMap();
    private final HashMap<Integer, String> idUnitMap = new HashMap();
    private final HashMap<String, Integer> unitIdMap = new HashMap();
    SecurityService securityService;
    private Map<String, TimesliceDTO> nameTimesliceMap = null;
    private Map<Integer, TimesliceDTO> idTimesliceMap = null;

    public Platform(String api) throws IxException {
        this.dbConfig = ConfigProvider.getDatabaseConfig();
        this.forceMigration = DbDAO.getForceMigration(null);
        this.initPlatform(api);
    }

    public Platform(String api, Properties properties) throws IxException {
        this.initSecurityConfig(properties);
        this.dbConfig = ConfigProvider.getConfig("jdbc", properties, DatabaseConfig.class);
        this.forceMigration = Boolean.parseBoolean(properties.getProperty("force_migration", "false"));
        this.initPlatform(api);
    }

    public Platform(String api, String propsFile) throws IxException {
        this.initSecurityConfig(propsFile);
        this.dbConfig = ConfigProvider.getDatabaseConfig(propsFile);
        this.forceMigration = DbDAO.getForceMigration(propsFile);
        this.initPlatform(api);
    }

    private void initSecurityConfig(String propsFile) {
        try {
            this.applicationConfig = ConfigProvider.getConfig("application", propsFile, ApplicationConfig.class);
            this.serverConfig = ConfigProvider.getConfig("config.server", propsFile, AuthServerConfig.class);
        }
        catch (IxException e) {
            log.debug("Security configuration missing");
        }
    }

    private void initSecurityConfig(Properties properties) {
        try {
            this.applicationConfig = ConfigProvider.getConfig("application", properties, ApplicationConfig.class);
            this.serverConfig = ConfigProvider.getConfig("config.server", properties, AuthServerConfig.class);
        }
        catch (IxException e) {
            log.debug("Security configuration missing");
        }
    }

    @Deprecated
    public Platform(String api, String dbFile, String dbType) throws IxException {
        if (dbFile == null) {
            throw new IxException("Please specify a local database file!");
        }
        this.dbConfig = ConfigProvider.getDatabaseConfig(dbFile, dbType);
        this.forceMigration = DbDAO.getForceMigration(null);
        this.initPlatform(api);
    }

    protected void initPlatform(String api) throws IxException {
        log.debug(String.format("Config: url=%s, driver=%s, user=%s", this.dbConfig.url(), this.dbConfig.driver(), this.dbConfig.user()));
        this.db = DbDAO.create(api, this.dbConfig, this.forceMigration);
        log.info("Welcome to the IX modeling platform!");
        log.info(String.format(" connected to database '%s' (user: %s)...", this.dbConfig.url(), this.dbConfig.user()));
    }

    public void openDB() throws IxException {
        this.db.testConn();
        log.info(String.format("connected to database '%s'...", this.dbConfig.url()));
    }

    public void closeDB() throws IxException {
        if (this.db.closeConn()) {
            log.info(String.format("closed the connection to database '%s'", this.dbConfig.url()));
        }
    }

    public List<Map<String, Object>> getScenarioList(boolean defaultOnly, String model, String scenario) throws IxException {
        return this.db.getModelScenarioList(defaultOnly, model, scenario);
    }

    public void unlockRunid(int runId) throws IxException {
        this.db.setStatus(runId, ScenarioDbStatus.AVAILABLE_IN_DB);
    }

    public void removeRunid(int runId) throws IxException {
        this.db.unassignDefaultVersion(runId);
        this.db.setStatus(runId, ScenarioDbStatus.NONE);
    }

    public Scenario newScenario(String model, String scenario, String annotation) throws IxException {
        return this.newScenario(model, scenario, null, annotation);
    }

    public Scenario newScenario(String model, String scenario, String scheme, String annotation) throws IxException {
        if (scheme != null && scheme.equals("MESSAGE")) {
            return new MsgScenario(this, model, scenario, true, annotation);
        }
        return new Scenario(this, model, scenario, true, scheme, annotation);
    }

    public Scenario getScenario(String model, String scenario) throws IxException {
        int runid = this.db.getRunId(model, scenario);
        if (runid == -1) {
            throw new IxException("There exists no default Scenario '" + model + "|" + scenario + "' in the database!");
        }
        String scheme = this.db.getScheme(runid);
        if (scheme != null && scheme.equals("MESSAGE")) {
            return new MsgScenario(this, model, scenario);
        }
        return new Scenario(this, model, scenario);
    }

    public Scenario getScenario(String model, String scenario, int version) throws IxException {
        int runId = this.db.getRunId(model, scenario, version);
        String scheme = this.db.getScheme(runId);
        if (scheme != null && scheme.equals("MESSAGE")) {
            return new MsgScenario(this, model, scenario, version);
        }
        return new Scenario(this, model, scenario, version);
    }

    public TimeSeries newTimeSeries(String model, String scenario, String annotation) throws IxException {
        return new TimeSeries(this, model, scenario, true, annotation);
    }

    public TimeSeries getTimeSeries(String model, String scenario) throws IxException {
        return new TimeSeries(this, model, scenario);
    }

    public TimeSeries getTimeSeries(String model, String scenario, int version) throws IxException {
        return new TimeSeries(this, model, scenario, version);
    }

    public void exportTimeseriesData(List<Long> runIds, List<String> variables, String filename) throws IxException {
        this.exportTimeseriesData(runIds, variables, null, null, filename, false);
    }

    public void exportTimeseriesData(List<Long> runIds, List<String> variables, List<String> units, List<String> regions, String filename) throws IxException {
        this.db.exportTimeseriesData(runIds, variables, units, regions, filename, false);
    }

    public void exportTimeseriesData(List<Long> runIds, List<String> variables, List<String> units, List<String> regions, String filename, boolean exportAllIfRunsEmpty) throws IxException {
        this.db.exportTimeseriesData(runIds, variables, units, regions, filename, exportAllIfRunsEmpty);
    }

    public IamVariable getIamVariable(int id) throws IxException {
        IamVariable iamVar = this.idIamVariableMap.get(id);
        if (iamVar == null) {
            iamVar = this.db.getIamVariableFromDB(this, null, -1, id);
            if (iamVar == null) {
                throw new IxException("The IamVariable id '" + id + "' does not exist in the database!'");
            }
            this.putIamVariableToCache(iamVar);
        }
        return iamVar;
    }

    public IamVariable assignIamVariableId(String variable, String unit, String scheme) throws IxException {
        int variableId = this.loadIamVariable(variable, unit);
        if (variableId != -1) {
            return this.idIamVariableMap.get(variableId);
        }
        int unitId = this.getUnitId(unit, true, scheme);
        variableId = this.db.assignIamVariableInDB(variable, unitId, scheme);
        IamVariable iamVar = new IamVariable(this, variable, unitId, variableId);
        this.putIamVariableToCache(iamVar);
        return iamVar;
    }

    public IamVariable getIamVariable(String variable, String unit) throws IxException {
        int variableId = this.loadIamVariable(variable, unit);
        if (variableId == -1) {
            throw new IxException(String.format("The IamVariable '%s|%s' was not initialized in the database!", variable, unit));
        }
        return this.idIamVariableMap.get(variableId);
    }

    public List<Integer> getIamVariableIds(List<String> variables, List<String> units) throws IxException {
        if (DBUtils.isEmpty(variables) && DBUtils.isEmpty(units)) {
            throw new IxException("Please provide either variables or units");
        }
        LinkedList<Integer> unitIds = new LinkedList<Integer>();
        if (!DBUtils.isEmpty(units)) {
            for (String unit : units) {
                unitIds.add(this.getUnitId(unit));
            }
        }
        return this.db.getVariableUnitKeys(variables, unitIds);
    }

    public Map<Long, List<IamVariable>> getIamVariablesOfRuns(List<Long> runIds) throws IxException {
        HashMap<Long, List<IamVariable>> variables = new HashMap<Long, List<IamVariable>>();
        Map<Long, List<Integer>> variableIds = this.db.getIamVariableIdsOfRunIds(runIds);
        LinkedList<Integer> missingIds = new LinkedList<Integer>();
        for (Map.Entry<Long, List<Integer>> entry : variableIds.entrySet()) {
            for (Integer variableId : entry.getValue()) {
                if (this.idIamVariableMap.containsKey(variableId)) continue;
                missingIds.add(variableId);
            }
        }
        if (missingIds.size() > 0) {
            List<IamVariable> missingVariables = this.db.getIamVariables(this, missingIds);
            for (IamVariable variable : missingVariables) {
                this.putIamVariableToCache(variable);
            }
        }
        for (Map.Entry<Long, List<Integer>> entry : variableIds.entrySet()) {
            Long runId = entry.getKey();
            for (Integer variableId : entry.getValue()) {
                variables.computeIfAbsent(runId, varsOfRun -> new ArrayList()).add(this.idIamVariableMap.get(variableId));
            }
        }
        return variables;
    }

    private void putIamVariableToCache(IamVariable variable) throws IxException {
        this.idIamVariableMap.putIfAbsent(variable.getId(), variable);
        this.nameUnitVariableMap.computeIfAbsent(variable.getVariable(), k -> new HashMap()).putIfAbsent(variable.getUnit(), variable);
    }

    private int loadIamVariable(String variable, String unit) throws IxException {
        int unitId = this.getUnitId(unit);
        IamVariable iamVar = (IamVariable)this.nameUnitVariableMap.getOrDefault(variable, Collections.emptyMap()).get(unit);
        if (iamVar != null) {
            return iamVar.getId();
        }
        IamVariable loadedIamVariable = this.db.getIamVariableFromDB(this, variable, unitId, -1);
        if (loadedIamVariable != null) {
            this.putIamVariableToCache(loadedIamVariable);
            return loadedIamVariable.getId();
        }
        return -1;
    }

    public List<NodeDTO> listNodes(String hierarchy) throws IxException {
        List<NodeDTO> nodeList = this.db.getNodeFromDB(null, -1, hierarchy, true);
        for (NodeDTO node : nodeList) {
            this.idNodeMap.put(node.getId(), node.getName());
            this.nodeIdMap.put(node.getName(), node.getId());
        }
        return nodeList;
    }

    public String getNodeName(int nodeId) throws IxException {
        String nodeName;
        if (!this.idNodeMap.containsKey(nodeId)) {
            this.loadNodeFromDB(null, nodeId);
        }
        if ((nodeName = this.idNodeMap.get(nodeId)) == null) {
            throw new IxException(String.format("The node id '%d' does not exist in the database!'", nodeId));
        }
        return nodeName;
    }

    public int getNodeId(String nodeName) throws IxException {
        return this.getNodeId(nodeName, true);
    }

    public Integer getNodeId(String nodeName, boolean throwWhenMissing) throws IxException {
        Integer nodeId;
        if (!this.nodeIdMap.containsKey(nodeName)) {
            this.loadNodeFromDB(nodeName, -1);
        }
        if ((nodeId = this.nodeIdMap.get(nodeName)) == null && throwWhenMissing) {
            throw new IxException(String.format("The node '%s' does not exist in the database!'", nodeName));
        }
        return nodeId;
    }

    public List<Integer> getNodeIdList(List<String> nodeNames) throws IxException {
        if (nodeNames == null) {
            return null;
        }
        LinkedList<Integer> nodeIds = new LinkedList<Integer>();
        for (String node : nodeNames) {
            nodeIds.add(this.getNodeId(node));
        }
        return nodeIds;
    }

    public void addNode(String nodeName, String parent, String hierarhy) throws IxException {
        for (Map.Entry<Integer, String> entry : this.db.saveNode(nodeName, parent, hierarhy).entrySet()) {
            this.nodeIdMap.put(entry.getValue(), entry.getKey());
            this.idNodeMap.put(entry.getKey(), entry.getValue());
        }
    }

    public void addNodeSynonym(String nodeName, String synonym) throws IxException {
        for (Map.Entry<String, Integer> entry : this.db.saveNodeSynonym(nodeName, synonym).entrySet()) {
            this.nodeIdMap.put(entry.getKey(), entry.getValue());
        }
    }

    private void loadNodeFromDB(String node, int id) throws IxException {
        Map<Integer, String> newNode = this.db.getNodeFromDB(node, id, null, false).stream().collect(Collectors.toMap(NodeDTO::getId, NodeDTO::getName));
        for (Map.Entry<Integer, String> entry : newNode.entrySet()) {
            this.nodeIdMap.put(entry.getValue(), entry.getKey());
            this.idNodeMap.put(entry.getKey(), entry.getValue());
        }
        if (node != null) {
            Map<String, Integer> newNodeSynonym = this.db.getNodeSynonymsFromDB(node);
            for (Map.Entry<String, Integer> entry : newNodeSynonym.entrySet()) {
                this.nodeIdMap.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public String[] getUnitList() throws IxException {
        this.loadUnitFromDB(null, -1);
        return this.unitIdMap.keySet().toArray(new String[0]);
    }

    public String getUnit(int id) throws IxException {
        String retval = this.idUnitMap.get(id);
        if (retval == null) {
            this.loadUnitFromDB(null, id);
            retval = this.idUnitMap.get(id);
            if (retval == null) {
                throw new IxException(String.format("The unit id '%d' does not exist in the database!'", id));
            }
        }
        return retval;
    }

    public int getUnitId(String unit) throws IxException {
        return this.getUnitId(unit, false, null);
    }

    public int getUnitId(String unit, boolean addUnitToDb, String scheme) throws IxException {
        if (!this.unitIdMap.containsKey(unit)) {
            this.loadUnitFromDB(unit, -1);
        }
        if (this.unitIdMap.containsKey(unit)) {
            return this.unitIdMap.get(unit);
        }
        if (!addUnitToDb) {
            throw new IxException(String.format("The unit '%s' does not exist in the database!", unit));
        }
        return this.addUnitToDB(unit, scheme);
    }

    public int addUnitToDB(String unit, String scheme) throws IxException {
        int id = this.db.addUnitToDB(unit, scheme).intValue();
        this.loadUnitFromDB(null, id);
        return id;
    }

    private void loadUnitFromDB(String unit, int id) throws IxException {
        Map<Integer, String> newUnit = this.db.getUnitFromDB(unit, id);
        newUnit.forEach((key, value) -> {
            this.unitIdMap.put((String)value, (Integer)key);
            this.idUnitMap.put((Integer)key, (String)value);
        });
    }

    public void setLogLevel(String level) {
        org.apache.log4j.Logger.getLogger((String)Platform.class.getPackage().getName()).setLevel(Level.toLevel((String)level));
    }

    public String getLogLevel() {
        return org.apache.log4j.Logger.getLogger((String)Platform.class.getPackage().getName()).getEffectiveLevel().toString();
    }

    public String getDoc(DocumentationKey.DocumentationDomain type, String name) throws IxException {
        return this.db.getDocumentation(Collections.singletonMap(type, Collections.singletonList(name))).getOrDefault((Object)type, Collections.emptyMap()).getOrDefault(name, "no documentation");
    }

    public Map<String, String> getDoc(DocumentationKey.DocumentationDomain type) throws IxException {
        Map<DocumentationKey.DocumentationDomain, List<String>> filters = Collections.singletonMap(type, Collections.emptyList());
        return this.db.getDocumentation(filters).getOrDefault((Object)type, Collections.emptyMap());
    }

    public void setDoc(DocumentationKey.DocumentationDomain domain, String name, String description) throws IxException {
        this.db.setDocumentation(Collections.singletonMap(domain, Collections.singletonMap(name, description)));
    }

    public void setDoc(DocumentationKey.DocumentationDomain domain, Map<String, String> docs) throws IxException {
        this.db.setDocumentation(Collections.singletonMap(domain, docs));
    }

    private synchronized SecurityService getSecurityService() throws IxException {
        if (this.securityService == null) {
            this.securityService = this.applicationConfig != null && this.serverConfig != null ? new SecurityService(this.applicationConfig, this.serverConfig) : new SecurityService();
        }
        return this.securityService;
    }

    public boolean checkModelAccess(String username, String accessType, String model) throws IxException {
        return this.checkModelAccess(username, accessType, Collections.singletonList(model)).get(model);
    }

    public Map<String, Boolean> checkModelAccess(String username, String accessType, List<String> models) throws IxException {
        if (models.isEmpty()) {
            return Collections.emptyMap();
        }
        SecurityService securityService = this.getSecurityService();
        String applicationTag = securityService.getApplicationTag();
        List<AccessRequestDTO> requests = models.stream().map(model -> new AccessRequestDTO(username, applicationTag, EntityType.MODEL.name(), StringUtils.upperCase((String)accessType), (String)model)).collect(Collectors.toList());
        List<Boolean> accesses = securityService.checkMultiAccess(requests);
        return IntStream.range(0, models.size()).boxed().collect(Collectors.toMap(models::get, accesses::get));
    }

    @Override
    public void close() {
        try {
            this.closeDB();
        }
        catch (IxException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public int getTimesliceId(String time) throws IxException {
        this.fillTimeslices(false);
        if (!this.nameTimesliceMap.containsKey(time)) {
            throw new IxException(String.format("There is no time slice called %s found", time));
        }
        return this.nameTimesliceMap.get(time).getId();
    }

    public String getTimesliceName(int time) throws IxException {
        this.fillTimeslices(false);
        if (!this.idTimesliceMap.containsKey(time)) {
            throw new IxException(String.format("There is no time slice identified by %s found", time));
        }
        return this.idTimesliceMap.get(time).getName();
    }

    public Double getTimesliceDuration(String time) throws IxException {
        this.fillTimeslices(false);
        if (!this.nameTimesliceMap.containsKey(time)) {
            throw new IxException(String.format("There is no time slice called %s found", time));
        }
        return this.nameTimesliceMap.get(time).getDuration();
    }

    public void addTimeslice(String name, String category, Double duration) throws IxException {
        this.db.addTimeslice(name, category, duration);
        this.fillTimeslices(true);
    }

    public void removeTimeslice(String name) throws IxException {
        this.db.removeTimeslice(name);
        this.fillTimeslices(true);
    }

    public List<TimesliceDTO> getTimeslices() throws IxException {
        this.fillTimeslices(false);
        return new ArrayList<TimesliceDTO>(this.idTimesliceMap.values());
    }

    private synchronized void fillTimeslices(boolean force) throws IxException {
        if (force || this.idTimesliceMap == null || this.nameTimesliceMap == null) {
            List<TimesliceDTO> timeslices = this.db.getTimeslices();
            this.nameTimesliceMap = new HashMap<String, TimesliceDTO>(timeslices.size());
            this.idTimesliceMap = new HashMap<Integer, TimesliceDTO>(timeslices.size());
            for (TimesliceDTO slice : timeslices) {
                this.idTimesliceMap.put(slice.getId(), slice);
                this.nameTimesliceMap.put(slice.getName(), slice);
            }
        }
    }

    public void setMeta(String model, String scenario, Long version, Map<String, Serializable> metadata) throws IxException {
        try (Connection cn = this.db.getPooledConn();
             AutoRollback tm = new AutoRollback(cn);){
            Long scenarioId = scenario == null ? null : Long.valueOf(this.db.getScenarioId(cn, scenario));
            Long modelId = model == null ? null : Long.valueOf(this.db.getModelId(cn, model));
            List<Metadata.MetadataEntry<? extends Serializable>> entries = metadata.entrySet().stream().map(e -> new Metadata.MetadataEntry<Serializable>(null, (String)e.getKey(), Metadata.wrap((Serializable)e.getValue()), modelId, scenarioId, version)).collect(Collectors.toList());
            Metadata meta = new Metadata();
            meta.setScenarioId(scenarioId);
            meta.setModelId(modelId);
            meta.setVersion(version);
            meta.setEntries(entries);
            Metadata saved = this.db.saveMetadata(cn, meta);
            tm.commit();
            log.debug(String.format("Saved meta indicators: %s", saved));
        }
        catch (SQLException e2) {
            log.error("Cannot save meta", (Throwable)e2);
        }
    }

    public Map<String, Serializable> getMeta(String model, String scenario, Long version) throws IxException {
        return this.getMeta(model, scenario, version, false);
    }

    public Map<String, Serializable> getMeta(String model, String scenario, Long version, boolean strict) throws IxException {
        Map<String, Serializable> map;
        block8: {
            Connection cn = this.db.getPooledConn();
            try {
                Long modelId = model != null ? Long.valueOf(this.db.getModelId(cn, model)) : null;
                Long scenarioId = scenario != null ? Long.valueOf(this.db.getScenarioId(cn, scenario)) : null;
                Metadata metadata = this.db.getMetadata(cn, modelId, scenarioId, version);
                map = metadata.getEntries().stream().filter(e -> !strict || Objects.equals(modelId, e.getModelId()) && Objects.equals(scenarioId, e.getScenarioId()) && Objects.equals(version, e.getVersion())).collect(Collectors.toMap(Metadata.MetadataEntry::getName, Metadata.MetadataEntry::getValue));
                if (cn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null) {
                        try {
                            cn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e2) {
                    throw new IxException("Cannot get meta indicators", e2);
                }
            }
            cn.close();
        }
        return map;
    }

    public void removeMeta(String model, String scenario, Long version, List<String> categories) throws IxException {
        try (Connection cn = this.db.getPooledConn();
             AutoRollback tm = new AutoRollback(cn);){
            Metadata existing = this.db.getMetadata(cn, model, scenario, version);
            HashSet<String> categoriesSet = new HashSet<String>(categories);
            existing.setEntries(existing.getEntries().stream().filter(e -> categoriesSet.contains(e.getName())).collect(Collectors.toList()));
            this.db.removeMetadata(cn, existing);
            tm.commit();
        }
        catch (SQLException e2) {
            log.error("Cannot remove meta", (Throwable)e2);
        }
    }

    public void addModel(String name) throws IxException {
        try (Connection cn = this.db.getPooledConn();
             AutoRollback tm = new AutoRollback(cn);){
            this.db.assignSomeId(cn, name, "MODEL");
            tm.commit();
        }
        catch (SQLException e) {
            throw new IxException(String.format("Cannot register new model: %s", name), e);
        }
    }

    public List<String> listModels() throws IxException {
        return this.db.getModelList().stream().map(ModelDTO::getName).collect(Collectors.toList());
    }

    public void addScenario(String name) throws IxException {
        try (Connection cn = this.db.getPooledConn();
             AutoRollback tm = new AutoRollback(cn);){
            this.db.assignSomeId(cn, name, "SCENARIO");
            tm.commit();
        }
        catch (SQLException e) {
            throw new IxException(String.format("Cannot register new scenario: %s", name), e);
        }
    }

    public List<String> listScenarios() throws IxException {
        return this.db.getScenarioList().stream().map(ScenarioDTO::getName).collect(Collectors.toList());
    }

    public DbDAO getDb() {
        return this.db;
    }
}

