/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.database;

import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.utils.DatabaseConfig;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.cfg4j.provider.ConfigurationProvider;
import org.cfg4j.provider.ConfigurationProviderBuilder;
import org.cfg4j.source.ConfigurationSource;
import org.cfg4j.source.classpath.ClasspathConfigurationSource;
import org.cfg4j.source.compose.FallbackConfigurationSource;
import org.cfg4j.source.context.filesprovider.ConfigFilesProvider;
import org.cfg4j.source.files.FilesConfigurationSource;
import org.cfg4j.source.inmemory.InMemoryConfigurationSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(ConfigProvider.class);

    public static DatabaseConfig getDatabaseConfig(String dbFile, String dbType) throws IxException {
        try {
            if (!"HSQLDB".equals(dbType)) {
                String msg = String.format("unknown type '%s' when loading the DbConfig class!", dbType);
                log.error(msg);
                throw new IxException(msg);
            }
            String hsqldbDriver = "org.hsqldb.jdbcDriver";
            try {
                Class.forName(hsqldbDriver);
            }
            catch (ClassNotFoundException e) {
                String msg = "cannot find hsqldb driver!";
                log.error(msg, (Throwable)e);
                throw new IxException(msg);
            }
            Properties props = new Properties();
            props.setProperty("db.driver", hsqldbDriver);
            props.setProperty("db.url", String.format("jdbc:hsqldb:file:%s", dbFile));
            props.setProperty("db.user", "ixmp");
            props.setProperty("db.pwd", "ixmp");
            ConfigurationProvider provider = new ConfigurationProviderBuilder().withConfigurationSource((ConfigurationSource)new InMemoryConfigurationSource(props)).build();
            return (DatabaseConfig)provider.bind("db", DatabaseConfig.class);
        }
        catch (NoSuchElementException e) {
            throw ConfigProvider.loggedIxException(String.format("Config %s cannot be loaded: %s", DatabaseConfig.class.getSimpleName(), e.getMessage()), e);
        }
    }

    public static DatabaseConfig getDatabaseConfig() throws IxException {
        return ConfigProvider.getDatabaseConfig("ixmp.properties");
    }

    public static DatabaseConfig getDatabaseConfig(String fileName) throws IxException {
        ConfigurationProvider provider = ConfigProvider.getFileConfigProvider(fileName);
        try {
            return (DatabaseConfig)provider.bind("jdbc", DatabaseConfig.class);
        }
        catch (IllegalArgumentException | IllegalStateException | NoSuchElementException e) {
            throw ConfigProvider.loggedIxException(String.format("Config %s cannot be loaded: %s", fileName, e.getMessage()), e);
        }
    }

    public static <T> T getConfig(String prefix, Properties properties, Class<T> configClass) throws IxException {
        InMemoryConfigurationSource configurationSource = new InMemoryConfigurationSource(properties);
        ConfigurationProvider provider = new ConfigurationProviderBuilder().withConfigurationSource((ConfigurationSource)configurationSource).build();
        try {
            return (T)provider.bind(prefix, configClass);
        }
        catch (IllegalArgumentException | IllegalStateException | NoSuchElementException e) {
            throw ConfigProvider.loggedIxException(String.format("Config %s cannot be loaded: %s", configClass.getSimpleName(), e.getMessage()), e);
        }
    }

    public static <T> T getConfig(String prefix, String fileName, Class<T> configClass) throws IxException {
        ConfigurationProvider provider = ConfigProvider.getFileConfigProvider(fileName);
        try {
            return (T)provider.bind(prefix, configClass);
        }
        catch (IllegalArgumentException | IllegalStateException | NoSuchElementException e) {
            throw ConfigProvider.loggedIxException(String.format("Config %s cannot be loaded: %s", configClass.getSimpleName(), e.getMessage()), e);
        }
    }

    private static ConfigurationProvider getFileConfigProvider(String fileName) {
        ConfigFilesProvider configFilesProvider = () -> Collections.singletonList(Paths.get(fileName, new String[0]));
        ClasspathConfigurationSource classPathSource = new ClasspathConfigurationSource(configFilesProvider);
        FilesConfigurationSource filesSource = new FilesConfigurationSource(configFilesProvider);
        FallbackConfigurationSource fallbackConfigurationSource = new FallbackConfigurationSource(new ConfigurationSource[]{classPathSource, filesSource});
        return new ConfigurationProviderBuilder().withConfigurationSource((ConfigurationSource)fallbackConfigurationSource).build();
    }

    private static IxException loggedIxException(String message, Throwable throwable) {
        log.debug(message, throwable);
        return new IxException(message);
    }
}

