/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.database;

import at.ac.iiasa.ixmp.Platform;
import at.ac.iiasa.ixmp.database.AutoRollback;
import at.ac.iiasa.ixmp.database.DAO;
import at.ac.iiasa.ixmp.database.DBUtils;
import at.ac.iiasa.ixmp.database.HsqldbDAO;
import at.ac.iiasa.ixmp.database.OracleDAO;
import at.ac.iiasa.ixmp.database.PostgresDAO;
import at.ac.iiasa.ixmp.dto.DocumentationKey;
import at.ac.iiasa.ixmp.dto.FileContent;
import at.ac.iiasa.ixmp.dto.FileDTO;
import at.ac.iiasa.ixmp.dto.Model;
import at.ac.iiasa.ixmp.dto.Region;
import at.ac.iiasa.ixmp.dto.Scenario;
import at.ac.iiasa.ixmp.dto.TimeseriesEntryDTO;
import at.ac.iiasa.ixmp.dto.TimeseriesVariable;
import at.ac.iiasa.ixmp.dto.TimesliceDTO;
import at.ac.iiasa.ixmp.dto.Unit;
import at.ac.iiasa.ixmp.dto.Workspace;
import at.ac.iiasa.ixmp.dto.WorkspacePanel;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.exceptions.IxNotFoundException;
import at.ac.iiasa.ixmp.ixobjects.IXelement;
import at.ac.iiasa.ixmp.objects.ChangelogEntry;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.Equation;
import at.ac.iiasa.ixmp.objects.IamVariable;
import at.ac.iiasa.ixmp.objects.IndexSet;
import at.ac.iiasa.ixmp.objects.Item;
import at.ac.iiasa.ixmp.objects.Metadata;
import at.ac.iiasa.ixmp.objects.Parameter;
import at.ac.iiasa.ixmp.objects.ScenarioDbStatus;
import at.ac.iiasa.ixmp.objects.TimeSeries;
import at.ac.iiasa.ixmp.objects.Variable;
import at.ac.iiasa.ixmp.rest.v2_1.dto.AnnotationLogItem;
import at.ac.iiasa.ixmp.rest.v2_1.dto.ChangeLogItem;
import at.ac.iiasa.ixmp.rest.v2_1.dto.DatasetDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.DatasetDefinitionDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.DatasetType;
import at.ac.iiasa.ixmp.rest.v2_1.dto.DatasetsFilterDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.DocsItemDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.JobDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.LockInfoDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.MetadataTypeDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.MetadataTypeInfoDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.ModelDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.NodeDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.ParameterDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.RunDetailsDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.RunInfoDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.RunParameterDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.ScenarioDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.SourceFilter;
import at.ac.iiasa.ixmp.rest.v2_1.dto.TimeseriesDTO;
import at.ac.iiasa.ixmp.rest.v2_1.util.RunparamsSets;
import at.ac.iiasa.ixmp.utils.DatabaseConfig;
import at.ac.iiasa.ixmp.utils.Pagination;
import at.ac.iiasa.ixmp.utils.Partition;
import at.ac.iiasa.ixmp.utils.WorkspacePublishType;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.sql.DataSource;
import javax.validation.constraints.NotNull;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.cfg4j.provider.ConfigurationProvider;
import org.cfg4j.provider.ConfigurationProviderBuilder;
import org.cfg4j.source.ConfigurationSource;
import org.cfg4j.source.classpath.ClasspathConfigurationSource;
import org.cfg4j.source.compose.FallbackConfigurationSource;
import org.cfg4j.source.files.FilesConfigurationSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.FlywayException;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DbDAO
implements DAO {
    private static final Logger log = LoggerFactory.getLogger(DbDAO.class);
    private static final HashSet<String> TABLE_NAMES_WHITELIST = new HashSet<String>(Arrays.asList("APP_FILES", "MODEL", "SCENARIO", "IX_UNIT", "IAMC_NODES", "WORKSPACES"));
    private static final String[] ixParTables = new String[]{"IX_PAR_BLOBSTORE", "IX_PAR_DIM", "IX_PAR"};
    private static final String[] ixVarTables = new String[]{"IX_VAR_BLOBSTORE", "IX_VAR_DIM", "IX_VAR"};
    private static final String[] ixSetTables = new String[]{"IX_SET_BLOBSTORE", "IX_SET_DIM", "IX_SET", "IX_IDXSET"};
    private static final String[] ixStructure = new String[]{"IX_COMMENT", "IX_KEY"};
    private static final Set<String> ixItemTypes = new HashSet<String>(Arrays.asList("SET", "PAR", "VAR", "EQU"));
    private static final int MAX_BATCHES = 1000;
    public static final String ALL_SYMBOLS = "*";
    public static final int LARGE_FETCH_SIZE = 1000;
    public static final int BUFFER_SIZE = 0x100000;
    private String dbInterface;
    private DatabaseConfig config;
    private DataSource ds;
    private static final Set<String> AUTO_ID_TABLES = new HashSet<String>(Arrays.asList("annotation", "files", "iamc_key", "iamc_nodes", "iamc_ts", "job_queue", "metadata", "model", "run", "scenario", "unit", "workspaces", "iamc_timeslices"));
    private static final Set<String> DICT_TABLES = new HashSet<String>(Arrays.asList("model", "scenario"));
    private static final String encodingPrefix = "base64,";
    private static final String[] TS_CSV_COLS = new String[]{"MODEL", "SCENARIO", "VERSION", "VARIABLE", "UNIT", "REGION", "META", "SUBANNUAL", "YEAR", "VALUE"};

    private static String dbEngine(@NotNull DatabaseConfig config) {
        String dbUrl = config.url();
        int start = dbUrl.indexOf(":") + 1;
        int end = dbUrl.indexOf(":", start);
        return dbUrl.substring(start, end);
    }

    private synchronized void initDataSource() throws SQLException {
        if (this.ds == null || this.ds.unwrap(HikariDataSource.class).isClosed()) {
            HikariConfig hikariCfg = new HikariConfig();
            hikariCfg.setMaximumPoolSize(4);
            hikariCfg.setMinimumIdle(2);
            hikariCfg.setJdbcUrl(this.config.url());
            hikariCfg.setUsername(this.config.user());
            hikariCfg.setPassword(this.config.pwd());
            hikariCfg.setDriverClassName(this.config.driver());
            hikariCfg.setIdleTimeout(30000L);
            hikariCfg.setConnectionTimeout(30000L);
            hikariCfg.setMaxLifetime(750000L);
            this.ds = new HikariDataSource(hikariCfg);
        }
    }

    public static DbDAO create(String pInterface, DatabaseConfig config, Boolean forceMigration) throws IxException {
        DbDAO dao;
        String engine;
        switch (engine = DbDAO.dbEngine(config)) {
            case "oracle": {
                dao = new OracleDAO();
                break;
            }
            case "postgresql": {
                dao = new PostgresDAO();
                break;
            }
            case "hsqldb": {
                dao = new HsqldbDAO();
                break;
            }
            default: {
                throw new IxException("Unsupported DB engine: " + engine);
            }
        }
        dao.dbInterface = pInterface;
        dao.config = config;
        super.updateSchemaIfNecessary(forceMigration);
        dao.openConn();
        return dao;
    }

    public static DbDAO create(String pInterface, DatabaseConfig config) throws IxException {
        return DbDAO.create(pInterface, config, null);
    }

    public static boolean getForceMigration(String propFile) {
        try {
            String propFileName = propFile == null ? "ixmp.properties" : propFile;
            ClasspathConfigurationSource classpathConfigurationSource = new ClasspathConfigurationSource(() -> Collections.singletonList(Paths.get(propFileName, new String[0])));
            FilesConfigurationSource filesConfigurationSource = new FilesConfigurationSource(() -> Collections.singletonList(Paths.get(propFileName, new String[0])));
            ConfigurationProvider provider = new ConfigurationProviderBuilder().withConfigurationSource((ConfigurationSource)new FallbackConfigurationSource(new ConfigurationSource[]{classpathConfigurationSource, filesConfigurationSource})).build();
            return (Boolean)provider.getProperty("force_migration", Boolean.TYPE);
        }
        catch (IllegalArgumentException | IllegalStateException | NoSuchElementException e) {
            return false;
        }
    }

    private void updateSchemaIfNecessary(Boolean forceMigration) {
        block13: {
            String engine;
            if (forceMigration == null) {
                forceMigration = DbDAO.getForceMigration(null);
            }
            log.debug(String.format("Performing DB migration for %s (user=%s, force=%s)", this.config.url(), this.config.user(), forceMigration));
            boolean doSchemaMigration = false;
            boolean ignoreFutureMigrations = true;
            boolean baselineOnMigrate = false;
            Flyway flyway = new Flyway();
            flyway.setTable("schema_version");
            String[] locations = new String[1];
            switch (engine = DbDAO.dbEngine(this.config)) {
                case "postgresql": {
                    locations[0] = "classpath:db/migration/postgresql";
                    doSchemaMigration = true;
                    ignoreFutureMigrations = true;
                    break;
                }
                case "oracle": {
                    locations[0] = "classpath:db/migration/oracle";
                    baselineOnMigrate = true;
                    break;
                }
                case "hsqldb": {
                    locations[0] = "classpath:db/migration/hsql";
                    if (!this.config.url().contains("hsqldb:file:") && !this.config.url().contains("hsqldb:mem:")) break;
                    doSchemaMigration = true;
                    ignoreFutureMigrations = false;
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Unsupported DB engine: %s", engine));
                }
            }
            flyway.setLocations(locations);
            flyway.setDataSource(this.config.url(), this.config.user(), this.config.pwd(), new String[0]);
            flyway.setIgnoreFutureMigrations(ignoreFutureMigrations);
            try {
                flyway.validate();
            }
            catch (FlywayException fwe) {
                log.debug(String.format("%s|%s", engine, fwe.getMessage()));
                if (!doSchemaMigration && !forceMigration.booleanValue()) break block13;
                flyway.setBaselineOnMigrate(baselineOnMigrate);
                flyway.migrate();
            }
        }
    }

    public Connection getPooledConn() throws IxException, SQLException {
        if (this.ds == null) {
            throw this.loggedIxException("Data source is not initialized", null);
        }
        return this.ds.getConnection();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private int getSomeId(Connection conn, String name, String table) throws IxException {
        if (!TABLE_NAMES_WHITELIST.contains(DBUtils.upperCase(table))) {
            throw this.loggedIxException("Not allowed to get ID from '" + table + "'", null);
        }
        String sql = "SELECT id FROM " + table + " WHERE name = ?";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            int n;
            block16: {
                stmt.setString(1, name);
                ResultSet rs = stmt.executeQuery();
                try {
                    if (!rs.next()) {
                        throw this.loggedIxException(String.format("There was a problem getting '%s' in table '%s' from the database!", name, table), null);
                    }
                    n = rs.getInt("id");
                    if (rs == null) break block16;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return n;
        }
        catch (SQLException e) {
            throw this.loggedIxException(String.format("There was a problem getting '%s' in table '%s' from the database!", name, table), e);
        }
    }

    public int getModelId(Connection cn, String model) throws IxException {
        return this.getSomeId(cn, model, "MODEL");
    }

    public int getScenarioId(Connection cn, String scenario) throws IxException {
        return this.getSomeId(cn, scenario, "SCENARIO");
    }

    private Map<String, Object> getRunResultInfo(ResultSet rs) throws SQLException {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS").withZone(ZoneId.systemDefault());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("run_id", rs.getInt("run_id"));
        map.put("model_id", rs.getInt("model_id"));
        map.put("scen_id", rs.getInt("scen_id"));
        map.put("model", rs.getString("model"));
        map.put("scenario", rs.getString("scenario"));
        map.put("is_default", rs.getBoolean("is_default"));
        map.put("is_locked", rs.getBoolean("is_locked"));
        map.put("cre_user", rs.getString("cre_user"));
        Timestamp creDate = rs.getTimestamp("cre_date");
        map.put("cre_date", rs.wasNull() ? null : formatter.format(creDate.toInstant()));
        map.put("upd_user", rs.getString("upd_user"));
        Timestamp updDate = rs.getTimestamp("upd_date");
        map.put("upd_date", rs.wasNull() ? null : formatter.format(updDate.toInstant()));
        map.put("lock_user", rs.getString("lock_user"));
        Timestamp lockDate = rs.getTimestamp("lock_date");
        map.put("lock_date", rs.wasNull() ? null : formatter.format(lockDate.toInstant()));
        map.put("version", rs.getInt("version"));
        map.put("scheme", rs.getString("scheme"));
        map.put("annotation", rs.getString("annotation"));
        return map;
    }

    @Override
    public List<Map<String, Object>> getModelScenarioList(boolean getDefaultOnly, String model, String scenario) throws IxException {
        List<Map<String, Object>> list;
        block8: {
            Connection conn = this.getPooledConn();
            try {
                int modelId = model != null ? this.getSomeId(conn, model, "model") : -1;
                int scenarioId = scenario != null ? this.getSomeId(conn, scenario, "scenario") : -1;
                list = this.getModelScenarioList(conn, modelId, scenarioId, getDefaultOnly);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw this.loggedIxException("There was a problem getting the list of scenarios from the database!", e);
                }
            }
            conn.close();
        }
        return list;
    }

    private PreparedStatement prepareGetModelScenarioList(Connection conn, boolean getOnlyDefault, int modelId, int scenarioId) throws SQLException {
        String sql = "SELECT r.id run_id,        m.id model_id,        s.id scen_id,        m.name model,        s.name scenario,        CASE WHEN d.id >= 0 THEN 1 ELSE 0 END is_default,        CASE r.status WHEN 0 THEN 1 WHEN 1 THEN 0 END AS is_locked,        r.cre_user,        r.cre_date,        r.upd_user,        r.upd_date,        r.lock_user,        r.lock_date,        r.version,        r.scheme,        r.annotation FROM run r INNER JOIN model m ON m.id = r.model_id INNER JOIN scenario s ON s.id = r.scen_id ";
        sql = getOnlyDefault ? sql + "INNER JOIN run_default d ON d.model_id = m.id AND d.scen_id = s.id AND d.id = r.id " : sql + "LEFT OUTER JOIN run_default d ON d.model_id = m.id AND d.scen_id = s.id AND d.id = r.id ";
        if (modelId >= 0 && scenarioId >= 0) {
            sql = sql + "WHERE r.model_id = ? AND r.scen_id = ? ";
        } else if (modelId >= 0) {
            sql = sql + "WHERE r.model_id = ? ";
        } else if (scenarioId >= 0) {
            sql = sql + "WHERE d.scen_id = ? ";
        }
        sql = sql + "ORDER BY model ASC, scenario ASC, d.id ASC, version DESC ";
        PreparedStatement stmt = conn.prepareStatement(sql);
        if (modelId >= 0 && scenarioId >= 0) {
            stmt.setInt(1, modelId);
            stmt.setInt(2, scenarioId);
        } else if (modelId >= 0) {
            stmt.setInt(1, modelId);
        } else if (scenarioId >= 0) {
            stmt.setInt(1, scenarioId);
        }
        return stmt;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<Map<String, Object>> getModelScenarioList(Connection conn, int modelId, int scenarioId, boolean getOnlyDefault) throws IxException {
        try (PreparedStatement stmt = this.prepareGetModelScenarioList(conn, getOnlyDefault, modelId, scenarioId);){
            ArrayList<Map<String, Object>> arrayList;
            block15: {
                ResultSet results = stmt.executeQuery();
                try {
                    ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
                    while (results.next()) {
                        data.add(this.getRunResultInfo(results));
                    }
                    arrayList = data;
                    if (results == null) break block15;
                }
                catch (Throwable throwable) {
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                results.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem getting the list of scenarios from the database!", e);
        }
    }

    @Override
    public List<Map<String, Object>> getModelScenarioList(boolean getOnlyDefault, int modelId, int scenarioId) throws IxException {
        List<Map<String, Object>> list;
        block8: {
            Connection conn = this.getPooledConn();
            try {
                list = this.getModelScenarioList(conn, modelId, scenarioId, getOnlyDefault);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw this.loggedIxException("There was a problem getting the list of scenarios from the database!", e);
                }
            }
            conn.close();
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> getModelScenarioList(boolean getDefaultOnly) throws IxException {
        List<Map<String, Object>> list;
        block8: {
            Connection conn = this.getPooledConn();
            try {
                list = this.getModelScenarioList(conn, -1, -1, getDefaultOnly);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw this.loggedIxException("There was a problem getting the list of scenarios from the database!", e);
                }
            }
            conn.close();
        }
        return list;
    }

    private PreparedStatement prepareGetRunInfo(Connection conn, int runId) throws SQLException {
        String sql = "SELECT r.id AS run_id, m.id AS model_id,        s.id AS scen_id,        m.name AS model,        s.name AS scenario,        CASE WHEN d.id >= 0 THEN 1 ELSE 0 END AS is_default,        CASE r.status WHEN 0 THEN 1 WHEN 1 THEN 0 END AS is_locked,        r.cre_user,        r.cre_date,        r.upd_user,       r.upd_date,        r.lock_user,        r.lock_date,        r.version AS version,        r.scheme,        r.annotation FROM run r LEFT OUTER JOIN model m ON m.id = r.model_id LEFT OUTER JOIN scenario s ON  s.id = r.scen_id LEFT OUTER JOIN run_default d ON d.model_id = m.id AND d.scen_id = s.id AND d.id = r.id WHERE r.id = ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setInt(1, runId);
        return stmt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Object> getRunInfo(int runId) throws IxException {
        try (Connection conn = this.getPooledConn();
             PreparedStatement stmt = this.prepareGetRunInfo(conn, runId);
             ResultSet results = stmt.executeQuery();){
            if (!results.next()) throw new IxNotFoundException("Run info not found for given run ID " + runId);
            Map<String, Object> map = this.getRunResultInfo(results);
            return map;
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem getting the run info from the database!", e);
        }
    }

    @Override
    public int getRunId(String model, String scenario) throws IxException {
        return this.getRunId(model, scenario, true);
    }

    private PreparedStatement prepareGetDefaultRunId(Connection conn, Long modelId, Long scenarioId) throws SQLException {
        String sql = "SELECT id FROM run_default WHERE model_id = ? AND scen_id = ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setLong(1, modelId);
        stmt.setLong(2, scenarioId);
        return stmt;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Long getDefaultRunId(Connection cn, Long modelId, Long scenarioId) throws IxException {
        try (PreparedStatement stmt = this.prepareGetDefaultRunId(cn, modelId, scenarioId);){
            Long l;
            block14: {
                ResultSet rs = stmt.executeQuery();
                try {
                    Long l2 = l = rs.next() ? Long.valueOf(rs.getLong("id")) : null;
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return l;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot get runid from database", e);
        }
    }

    private PreparedStatement prepareGetMaxRunId(Connection conn, Long modelId, Long scenarioId) throws SQLException {
        String sql = "SELECT MAX(id) AS id FROM run WHERE model_id = ? AND scen_id = ? AND status >= 0";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setLong(1, modelId);
        stmt.setLong(2, scenarioId);
        return stmt;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Long getMaxRunId(Connection conn, Long modelId, Long scenarioId) throws IxException {
        try (PreparedStatement stmt = this.prepareGetMaxRunId(conn, modelId, scenarioId);){
            Long l;
            block14: {
                ResultSet rs = stmt.executeQuery();
                try {
                    Long l2 = l = rs.next() ? Long.valueOf(rs.getLong("id")) : null;
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return l;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot get runid from database", e);
        }
    }

    @Override
    public int getRunId(String model, String scenario, boolean getMaxAsDefault) throws IxException {
        int n;
        block8: {
            Connection cn = this.getPooledConn();
            try {
                Long runId = this.getRunId(cn, model, scenario, getMaxAsDefault);
                int n2 = n = runId != null ? runId.intValue() : -1;
                if (cn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null) {
                        try {
                            cn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IxException | SQLException e) {
                    throw this.loggedIxException("There was a problem getting the run id from the database!", e);
                }
            }
            cn.close();
        }
        return n;
    }

    @Override
    public Long getRunId(Connection cn, String model, String scenario, boolean getMaxAsDefault) throws IxException {
        Long scenarioId;
        Long modelId = this.getSomeId(cn, model, "MODEL");
        Long runId = this.getDefaultRunId(cn, modelId, scenarioId = Long.valueOf(this.getSomeId(cn, scenario, "SCENARIO")));
        if (runId == null && getMaxAsDefault) {
            runId = this.getMaxRunId(cn, modelId, scenarioId);
        }
        return runId;
    }

    private PreparedStatement prepareGetRunId(Connection conn, String model, String scenario, int version) throws SQLException {
        String qString = "SELECT r.id AS id FROM run r INNER JOIN model m ON m.id = r.model_id INNER JOIN scenario s ON s.id = r.scen_id WHERE m.name = ? AND s.name = ? AND r.version = ? AND r.status >= 0";
        PreparedStatement stmt = conn.prepareStatement(qString);
        stmt.setString(1, model);
        stmt.setString(2, scenario);
        stmt.setInt(3, version);
        return stmt;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getRunId(String model, String scenario, int version) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Map<String, Object> getModelScenarioName(int runId) throws IxException {
        Map<String, Object> map;
        block8: {
            Connection conn = this.getPooledConn();
            try {
                map = this.getModelScenarioName(conn, runId);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw this.loggedIxException("There was a problem looking for scenarios in the database!", e);
                }
            }
            conn.close();
        }
        return map;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> getModelScenarioName(Connection conn, int runId) throws IxException {
        String sql = "SELECT m.name AS model, \t\ts.name AS scenario, \t\tr.version AS version, \t\tr.annotation AS annotation FROM run r INNER JOIN model m ON m.id = r.model_id INNER JOIN scenario s ON s.id = r.scen_id WHERE r.id = ? AND status >= 0 ";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            HashMap<String, Object> hashMap;
            block15: {
                stmt.setInt(1, runId);
                ResultSet results = stmt.executeQuery();
                try {
                    if (!results.next()) {
                        throw this.loggedIxException("There exists no scenario with run id " + runId + " in the database!", null);
                    }
                    HashMap<String, Object> retval = new HashMap<String, Object>();
                    retval.put("model", results.getString("model"));
                    retval.put("scenario", results.getString("scenario"));
                    retval.put("version", results.getInt("version"));
                    retval.put("annotation", results.getString("annotation"));
                    hashMap = retval;
                    if (results == null) break block15;
                }
                catch (Throwable throwable) {
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                results.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem looking for scenarios in the database!", e);
        }
    }

    @Override
    public void unassignDefaultVersion(long runId) throws IxException {
        try (Connection cn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(cn);){
            this.unassignDefaultVersion(cn, runId);
            tm.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem unassigning the default version of a scenario in the database!", e);
        }
    }

    @Override
    public void unassignDefaultVersion(Connection cn, long runId) throws IxException {
        String sql = "DELETE FROM run_default WHERE id = ?";
        try (PreparedStatement stmt = cn.prepareStatement(sql);){
            stmt.setLong(1, runId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem unassigning the default version of a scenario in the database!", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ScenarioDbStatus getStatus(int runId) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public LockInfoDTO getLockInfo(int runId) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setStatus(int runId, ScenarioDbStatus status) throws IxException {
        String user = System.getProperty("user.name", "(unknown)");
        this.setStatus(user, runId, status);
    }

    @Override
    public void setStatus(String user, int runId, ScenarioDbStatus status) throws IxException {
        if (status == ScenarioDbStatus.NONE) {
            throw this.loggedIxException("Cannot set scenario status to NONE", null);
        }
        String sqlCheck = "SELECT status FROM run WHERE id = ?";
        String sqlUpdate = "UPDATE run SET status = ?, lock_user = ?, lock_date = ? WHERE id = ? AND status = ?";
        try (Connection conn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(conn);
             PreparedStatement stmtCheck = conn.prepareStatement(sqlCheck);
             PreparedStatement stmtUpdate = conn.prepareStatement(sqlUpdate);){
            stmtCheck.setLong(1, runId);
            ScenarioDbStatus currentStatus = ScenarioDbStatus.NONE;
            try (ResultSet rsSelect = stmtCheck.executeQuery();){
                if (rsSelect.next()) {
                    currentStatus = ScenarioDbStatus.fromState(rsSelect.getInt("status"));
                }
            }
            if (currentStatus == ScenarioDbStatus.NONE) {
                throw this.loggedIxException("No scenario found in DB to update status", null);
            }
            if (currentStatus == ScenarioDbStatus.LOCKED_IN_DB && status == ScenarioDbStatus.LOCKED_IN_DB) {
                throw this.loggedIxException("Cannot lock already locked scenario!", null);
            }
            stmtUpdate.setInt(1, status.getState());
            stmtUpdate.setInt(5, currentStatus.getState());
            if (status == ScenarioDbStatus.AVAILABLE_IN_DB) {
                stmtUpdate.setNull(2, 12);
                stmtUpdate.setNull(3, 91);
            } else if (status == ScenarioDbStatus.LOCKED_IN_DB) {
                stmtUpdate.setString(2, user);
                stmtUpdate.setDate(3, new Date(DateTime.now().getMillis()));
            } else {
                throw this.loggedIxException(String.format("Wrong status %s specified for run %d!", new Object[]{status, runId}), null);
            }
            stmtUpdate.setInt(4, runId);
            int updatedCnt = stmtUpdate.executeUpdate();
            if (updatedCnt != 1) {
                throw this.loggedIxException(String.format("Wrong status %s specified for run %d or run not found!", new Object[]{status, runId}), null);
            }
            tm.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException(String.format("There was a problem setting the status for run id '%d'!", runId), e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getScheme(int runId) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void cloneItemBlobInDB(Connection conn, int prevRunId, String type, String name, int runId) throws IxException {
        this.assertElementType(type);
        String sql = "UPDATE ix_" + type + "_blobstore SET (ele_blob, com_blob) = (   SELECT ele_blob, com_blob   FROM ix_" + type + "_blobstore   WHERE runid = ?   AND name = ?) WHERE runid = ? AND name = ?";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setInt(1, prevRunId);
            stmt.setString(2, name);
            stmt.setInt(3, runId);
            stmt.setString(4, name);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw this.loggedIxException(String.format("Error copying the blob for item '%s' to the database!", name), e);
        }
    }

    protected void assertElementType(String type) throws IxException {
        if (!ixItemTypes.contains(DBUtils.upperCase(type))) {
            throw this.loggedIxException(String.format("Unknown element type: %s", type), null);
        }
    }

    private void removeItemElementsFromDB(Connection conn, String name, String type, int runId) throws IxException {
        this.assertElementType(type);
        String sql = "DELETE FROM ix_" + type + "_blobstore WHERE runid = ? AND name = ?";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setInt(1, runId);
            stmt.setString(2, name);
            int delRc = stmt.executeUpdate();
            log.debug("removed " + type + " '" + name + "' from BLOB storage. rc=" + delRc);
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error while removing elements from DB", e);
        }
    }

    @Override
    public void removeItemFromDB(Connection conn, Set<String> removedItemList, String type, int runId) throws IxException {
        this.assertElementType(type);
        String dimString = "DELETE FROM ix_" + type + "_dim WHERE runid = ? AND name = ?";
        String itemString = "DELETE FROM ix_" + type + " WHERE runid = ? AND name = ?";
        try (PreparedStatement prepDimStmt = conn.prepareStatement(dimString);
             PreparedStatement prepItemStmt = conn.prepareStatement(itemString);){
            boolean batch = false;
            for (String aItem : removedItemList) {
                this.removeItemElementsFromDB(conn, aItem, type, runId);
                prepDimStmt.setInt(1, runId);
                prepDimStmt.setString(2, aItem);
                prepDimStmt.addBatch();
                prepItemStmt.setInt(1, runId);
                prepItemStmt.setString(2, aItem);
                prepItemStmt.addBatch();
                batch = true;
            }
            if (batch) {
                prepDimStmt.executeBatch();
                prepItemStmt.executeBatch();
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error removing an item from the database!", e);
        }
    }

    @Override
    public void writeAnnotation(int runId, String status, int annotationId, String script, String text) throws IxException {
        try (Connection conn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(conn);){
            this.writeAnnotation(conn, runId, status, annotationId, script, text);
            tm.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot write annotation", e);
        }
    }

    @Override
    public void writeAnnotation(Connection conn, long runId, String status, int annotationId, String script, String text) throws IxException {
        String sql = "INSERT INTO annotation_log (annotationid, status, runid, interface, script, cre_user, cre_date, text) VALUES (?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP, ?)";
        String user = System.getProperty("user.name", "(unknown)");
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setInt(1, annotationId);
            stmt.setString(2, status);
            stmt.setLong(3, runId);
            stmt.setString(4, this.getDbInterface());
            stmt.setString(5, script);
            stmt.setString(6, user);
            stmt.setString(7, text);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Could not write annotation!", e);
        }
    }

    @Override
    public int assignAnnotationId(Connection conn) throws IxException {
        return this.getNextId(conn, "ANNOTATION").intValue();
    }

    abstract PreparedStatement prepareGetNextId(Connection var1, String var2) throws SQLException;

    /*
     * Enabled aggressive exception aggregation
     */
    private Long getNextId(Connection conn, String tableName) throws IxException {
        if (!AUTO_ID_TABLES.contains(tableName = tableName.toLowerCase())) {
            throw new IxException("Cannot generate id for " + tableName);
        }
        try (PreparedStatement stmt = this.prepareGetNextId(conn, tableName);){
            Long l;
            block16: {
                ResultSet rs = stmt.executeQuery();
                try {
                    if (!rs.next()) {
                        throw new IxException("Cannot get next id for " + tableName);
                    }
                    l = rs.getLong(1);
                    if (rs == null) break block16;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return l;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot get next id for " + tableName, e);
        }
    }

    @Override
    @Deprecated
    public void cleanupById(int runId, int annotationId, String pCase, String name) throws IxException {
        String osUser = System.getProperty("user.name", "(unknown)");
        try (Connection conn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(conn);
             Statement stmt = conn.createStatement();){
            String status = null;
            LinkedList<String> tables = new LinkedList<String>();
            switch (pCase) {
                case "scenario": {
                    tables.addAll(Arrays.asList(ixParTables));
                    tables.addAll(Arrays.asList(ixVarTables));
                    tables.addAll(Arrays.asList(ixSetTables));
                    tables.addAll(Arrays.asList(ixStructure));
                    status = "deleted";
                    break;
                }
                case "Var": {
                    tables.addAll(Arrays.asList(ixVarTables));
                    status = "solution imported";
                    break;
                }
                case "refTS": {
                    status = "deleted";
                }
            }
            for (String table : tables) {
                String sql = "DELETE FROM " + table + " WHERE runid = " + runId;
                if (name != null) {
                    sql = sql + " AND name = '" + name + "'";
                }
                log.debug(sql);
                int rc = stmt.executeUpdate(sql);
                log.info(String.format("table %s: %d records deleted.", table, rc));
            }
            String sql = "UPDATE annotation_log SET status = '" + status + " (" + annotationId + ")',     upd_user = '" + osUser + "',     upd_date = CURRENT_TIMESTAMP WHERE runid = " + runId + " AND status = 'ok'";
            stmt.executeUpdate(sql);
            tm.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("The Scenario (runid " + runId + ") could not be deleted!'", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<AnnotationLogItem> getAnnotationLog(Long runId, Pagination pagination) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getAnnotationLogSize(Long runId) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String buildOrderLimitClause(String orderBy, Pagination pagination) {
        String sql = "ORDER BY " + orderBy;
        if (pagination != null) {
            sql = sql + " OFFSET " + pagination.getOffset() + " ROWS";
            if (pagination.getLimit() >= 0L) {
                sql = sql + " FETCH NEXT " + pagination.getLimit() + " ROWS ONLY";
            }
        }
        return sql;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<ChangeLogItem> getChangeLog(Long annotationId, Pagination pagination) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public long getChangeLogSize(Long annotationId) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<Long, List<Integer>> getIamVariableIdsOfRunIds(List<Long> runIds) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<IamVariable> getIamVariables(Platform mp, List<Integer> variableIds) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public IamVariable getIamVariableFromDB(Platform mp, String variable, int unitId, int variableId) throws IxException {
        String sql = "SELECT keyid, keystring, unitid FROM iamc_key ";
        if (variable != null && unitId >= 0) {
            sql = sql + " WHERE keystring = ? AND unitid = ?";
        } else if (variable != null) {
            sql = sql + " WHERE keystring = ?";
        } else if (variableId != -1) {
            sql = sql + " WHERE keyid = ?";
        }
        try (Connection conn = this.getPooledConn();){
            IamVariable iamVariable;
            block28: {
                ResultSet rs;
                PreparedStatement stmt;
                block26: {
                    IamVariable iamVariable2;
                    block27: {
                        stmt = conn.prepareStatement(sql);
                        try {
                            stmt.setFetchSize(1);
                            if (variable != null && unitId >= 0) {
                                stmt.setString(1, variable);
                                stmt.setInt(2, unitId);
                            } else if (variable != null) {
                                stmt.setString(1, variable);
                            } else if (variableId != -1) {
                                stmt.setInt(1, variableId);
                            }
                            rs = stmt.executeQuery();
                            if (rs.next()) break block26;
                            iamVariable2 = null;
                            if (stmt == null) break block27;
                        }
                        catch (Throwable throwable) {
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        stmt.close();
                    }
                    return iamVariable2;
                }
                iamVariable = new IamVariable(mp, rs.getString("keystring"), rs.getInt("unitid"), rs.getInt("keyid"));
                if (stmt == null) break block28;
                stmt.close();
            }
            return iamVariable;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error reading an IamVariable from the database!", e);
        }
    }

    IxException loggedIxException(String message, Throwable origin) {
        log.debug(message, origin);
        return new IxException(message, origin);
    }

    /*
     * Exception decompiling
     */
    @Override
    public int assignIamVariableInDB(String variable, int unitId, String scheme) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<NodeDTO> getNodeFromDB(String nodeName, int id, String hierarchy, boolean includeSynonyms) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<Long, List<String>> getNodesSynonyms(Connection conn, Collection<Long> nodeIds) throws SQLException {
        String sql = "SELECT node_synonym, node_id FROM iamc_nodes_synonym WHERE node_id IN (" + this.getPlaceholders(nodeIds) + ")";
        try (PreparedStatement synonymsStmt = conn.prepareStatement(sql);){
            HashMap<Long, List<String>> hashMap;
            block15: {
                int index = 0;
                for (Long nodeId : nodeIds) {
                    synonymsStmt.setLong(++index, nodeId);
                }
                ResultSet synonymsRs = synonymsStmt.executeQuery();
                try {
                    HashMap<Long, List<String>> result = new HashMap<Long, List<String>>();
                    while (synonymsRs.next()) {
                        Long synonymNodeId = synonymsRs.getLong("node_id");
                        String synonymName = synonymsRs.getString("node_synonym");
                        if (result.containsKey(synonymNodeId)) {
                            ((List)result.get(synonymNodeId)).add(synonymName);
                            continue;
                        }
                        result.put(synonymNodeId, new ArrayList<String>(Collections.singletonList(synonymName)));
                    }
                    hashMap = result;
                    if (synonymsRs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (synonymsRs != null) {
                        try {
                            synonymsRs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                synonymsRs.close();
            }
            return hashMap;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, Integer> getNodeSynonymsFromDB(String node) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Integer getNodeIdByName(Connection conn, String name) throws IxException {
        String sql = "SELECT id FROM iamc_nodes WHERE name = ?";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, name);
            ResultSet rs = stmt.executeQuery();
            if (rs.next()) {
                Integer n2 = rs.getInt(1);
                return n2;
            }
            Integer n = null;
            return n;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot find node with name " + name, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<Integer, String> saveNode(String nodeName, String parent, String hierarchy) throws IxException {
        try (Connection conn = this.getPooledConn();){
            Map<Integer, String> map;
            try (AutoRollback tm = new AutoRollback(conn);){
                Integer nodeId = this.getNodeIdByName(conn, nodeName);
                if (nodeId != null) {
                    this.updateNode(conn, nodeId, nodeName, parent, hierarchy);
                } else {
                    nodeId = this.createNode(conn, nodeName, parent, hierarchy);
                }
                tm.commit();
                map = Collections.singletonMap(nodeId, nodeName);
            }
            return map;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot save node", e);
        }
    }

    private Integer createNode(Connection conn, String nodeName, String parent, String hierarchy) throws IxException {
        Integer n;
        block8: {
            String insert = "INSERT INTO iamc_nodes (id, hierarchy, name, parent) VALUES (?, ?, ?, ?)";
            int nodeId = this.getNextId(conn, "iamc_nodes").intValue();
            PreparedStatement stmt = conn.prepareStatement(insert);
            try {
                stmt.setInt(1, nodeId);
                stmt.setString(2, hierarchy);
                stmt.setString(3, nodeName);
                stmt.setString(4, parent);
                stmt.executeUpdate();
                n = nodeId;
                if (stmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw this.loggedIxException(String.format("Cannot add node with name %s", nodeName), e);
                }
            }
            stmt.close();
        }
        return n;
    }

    private void updateNode(Connection conn, Integer nodeId, String nodeName, String parent, String hierarchy) throws IxException {
        String update = "UPDATE iamc_nodes SET hierarchy = ?, \t name = ?,     parent = ? WHERE id = ?";
        try (PreparedStatement stmt = conn.prepareStatement(update);){
            stmt.setString(1, hierarchy);
            stmt.setString(2, nodeName);
            stmt.setString(3, parent);
            stmt.setInt(4, nodeId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot add node with name " + nodeName, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Integer> saveNodeSynonym(String nodeName, String synonym) throws IxException {
        try (Connection cn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(cn);){
            Integer nodeId = this.getNodeIdByName(cn, nodeName);
            if (nodeId == null) throw new IxException("Cannot find node with name " + nodeName);
            String update = "UPDATE iamc_nodes_synonym SET node_id = ? WHERE node_synonym = ?";
            try (PreparedStatement updateStmt = cn.prepareStatement(update);){
                updateStmt.setInt(1, nodeId);
                updateStmt.setString(2, synonym);
                String insert = "INSERT INTO iamc_nodes_synonym(node_id, node_synonym) VALUES (?, ?)";
                if (updateStmt.executeUpdate() == 0) {
                    try (PreparedStatement insertStmt = cn.prepareStatement(insert);){
                        insertStmt.setInt(1, nodeId);
                        insertStmt.setString(2, synonym);
                        if (insertStmt.executeUpdate() != 1) {
                            throw new IxException("Cannot add node synonym with name " + nodeName);
                        }
                    }
                }
                tm.commit();
                Map<String, Integer> map = Collections.singletonMap(synonym, nodeId);
                return map;
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot add node synonym with name " + nodeName, e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Long addUnitToDB(String unit, String scheme) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PreparedStatement prepareGetUnitFromDB(Connection conn, String unit, int id) throws SQLException {
        PreparedStatement prepStmt;
        if (unit != null) {
            String sql = "SELECT id, name FROM ix_unit WHERE name = ?";
            prepStmt = conn.prepareStatement(sql);
            prepStmt.setString(1, this.cleanString(unit));
        } else if (id >= 0) {
            String sql = "SELECT id, name FROM ix_unit WHERE id = ?";
            prepStmt = conn.prepareStatement(sql);
            prepStmt.setInt(1, id);
        } else {
            String sql = "SELECT id, name FROM ix_unit ";
            prepStmt = conn.prepareStatement(sql);
        }
        return prepStmt;
    }

    @Override
    public Map<Integer, String> getUnitFromDB(String unit, int id) throws IxException {
        Map<Integer, String> map;
        block8: {
            Connection conn = this.getPooledConn();
            try {
                map = this.getUnitFromDB(conn, unit, id);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    String error = unit != null ? String.format("error getting the unit-id mapping for unit '%s' from the database!", unit) : (id >= 0 ? String.format("error getting the unit-id mapping for id '%d' from the database!", id) : "error loading all units from the database!");
                    throw this.loggedIxException(error, e);
                }
            }
            conn.close();
        }
        return map;
    }

    private Map<Integer, String> getUnitFromDB(Connection conn, String unit, int id) throws SQLException {
        try (PreparedStatement prepStmt = this.prepareGetUnitFromDB(conn, unit, id);){
            HashMap<Integer, String> hashMap;
            block13: {
                ResultSet rs = prepStmt.executeQuery();
                try {
                    HashMap<Integer, String> result = new HashMap<Integer, String>();
                    while (rs.next()) {
                        int unitId = rs.getInt(1);
                        String unitString = rs.getString(2);
                        result.put(unitId, unitString);
                    }
                    hashMap = result;
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashMap;
        }
    }

    private String cleanString(String text) {
        return text.replaceAll("'", "''");
    }

    private <T extends Number> String concatQString(List<T> list) {
        return list.stream().map(Object::toString).collect(Collectors.joining(","));
    }

    private <T extends Number> String buildInClause(String column, Collection<T> list, boolean emptyListOption) {
        if (list == null || list.isEmpty()) {
            return emptyListOption ? "1=1" : "1!=1";
        }
        Partition<T> parts = Partition.ofSize(list, 1000);
        return "(" + parts.stream().map(part -> column + " IN (" + this.concatQString((List)part) + ")").collect(Collectors.joining(" OR ")) + ")";
    }

    private PreparedStatement buildStringInStatement(Connection conn, String sql, String column, Collection<String> values, boolean emptyListOption) throws SQLException {
        if (values == null || values.isEmpty()) {
            return conn.prepareStatement(sql + (emptyListOption ? "1=1 " : "1!=1 "));
        }
        Partition<String> parts = Partition.ofSize(values, 1000);
        String conditionClause = " (" + parts.stream().map(part -> column + " IN (" + this.getPlaceholders((Collection)part) + ")").collect(Collectors.joining(" OR ")) + ")";
        PreparedStatement stmt = conn.prepareStatement(sql + conditionClause);
        int index = 0;
        for (String value : values) {
            stmt.setString(++index, value);
        }
        return stmt;
    }

    @Override
    public void cloneTimeseriesInDB(Connection conn, int prevRunId, boolean isMeta, Integer firstYear, int runId) throws IxException {
        boolean isSlice;
        String queryInfo = "SELECT tsid, node, key, meta, time FROM iamc_tsinfo WHERE runid = ? AND meta = ? ";
        String cloneInfo = "INSERT INTO iamc_tsinfo (runid, tsid, node, key, meta, time) SELECT ?, ?, node, key, meta, time FROM iamc_tsinfo WHERE tsid = ? ";
        String cloneData = "INSERT INTO iamc_tsdata (tsid, year, value) SELECT ?, year, value FROM iamc_tsdata WHERE tsid = ? ";
        boolean bl = isSlice = firstYear != null;
        if (isSlice) {
            cloneData = cloneData + "AND year < ? ";
        }
        try (PreparedStatement queryInfoStmt = conn.prepareStatement(queryInfo);
             PreparedStatement cloneInfoStmt = conn.prepareStatement(cloneInfo);
             PreparedStatement cloneDataStmt = conn.prepareStatement(cloneData);){
            boolean batchData = false;
            queryInfoStmt.setInt(1, prevRunId);
            queryInfoStmt.setInt(2, isMeta ? 1 : 0);
            try (ResultSet rs = queryInfoStmt.executeQuery();){
                while (rs.next()) {
                    int prevTsId = rs.getInt("tsid");
                    int newTsId = this.getNextId(conn, "IAMC_TS").intValue();
                    cloneInfoStmt.setInt(1, runId);
                    cloneInfoStmt.setInt(2, newTsId);
                    cloneInfoStmt.setInt(3, prevTsId);
                    cloneInfoStmt.addBatch();
                    cloneDataStmt.setInt(1, newTsId);
                    cloneDataStmt.setInt(2, prevTsId);
                    if (isSlice) {
                        cloneDataStmt.setInt(3, firstYear);
                    }
                    cloneDataStmt.addBatch();
                    batchData = true;
                }
                if (batchData) {
                    cloneInfoStmt.executeBatch();
                    cloneDataStmt.executeBatch();
                }
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error cloning timeseries data in the database!", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getVersion(Connection conn, int runId) throws IxException {
        String sql = "SELECT version FROM run WHERE id = ?";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            int n;
            block15: {
                stmt.setInt(1, runId);
                ResultSet results = stmt.executeQuery();
                try {
                    if (!results.next()) {
                        throw this.loggedIxException("There exists no Scenario with run id " + runId + " in the database!", null);
                    }
                    n = results.getInt(1);
                    if (results == null) break block15;
                }
                catch (Throwable throwable) {
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                results.close();
            }
            return n;
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem getting the version number from the database!", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getLastVersion(Connection conn, int scenarioId, int modelId) throws IxException {
        String sql = "SELECT max(version) FROM run WHERE model_id = ? AND scen_id = ?";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            int n;
            block15: {
                stmt.setInt(1, modelId);
                stmt.setInt(2, scenarioId);
                ResultSet results = stmt.executeQuery();
                try {
                    if (!results.next()) {
                        throw this.loggedIxException("There exists no scenario for this model/scenario id's in the database!", null);
                    }
                    n = results.getInt(1);
                    if (results == null) break block15;
                }
                catch (Throwable throwable) {
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                results.close();
            }
            return n;
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem getting the last version number from the database!", e);
        }
    }

    /*
     * Exception decompiling
     */
    public int assignSomeId(Connection conn, String name, String table) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int assignRunId(Connection conn, String model, String scenario, String scheme, String annotation, String user) throws IxException {
        int n;
        block13: {
            int modelId = this.assignSomeId(conn, model, "MODEL");
            int scenarioId = this.assignSomeId(conn, scenario, "SCENARIO");
            int nextVersion = this.getLastVersion(conn, scenarioId, modelId);
            ++nextVersion;
            int runId = this.getNextId(conn, "RUN").intValue();
            String sql = "INSERT INTO run(id, model_id, scen_id, version, scheme, annotation, cre_user, cre_date) VALUES (?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP)";
            PreparedStatement stmt = conn.prepareStatement(sql);
            try {
                stmt.setInt(1, runId);
                stmt.setInt(2, modelId);
                stmt.setInt(3, scenarioId);
                stmt.setInt(4, nextVersion);
                if (scheme != null) {
                    stmt.setString(5, scheme);
                } else {
                    stmt.setNull(5, 12);
                }
                if (annotation != null) {
                    stmt.setString(6, annotation);
                } else {
                    stmt.setNull(6, 12);
                }
                stmt.setString(7, user);
                if (stmt.executeUpdate() != 1) {
                    throw this.loggedIxException("There was a problem assigning a new run id in the database!", null);
                }
                n = runId;
                if (stmt == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw this.loggedIxException("There was a problem assigning a new run id in the database!", e);
                }
            }
            stmt.close();
        }
        return n;
    }

    @Override
    public void saveIdxSetToDB(Connection conn, Collection<IndexSet> collection, int runId) throws IxException {
        String selectString = "SELECT runid, name FROM ix_idxset WHERE runid = ? AND name = ?";
        String asteriskString = "INSERT INTO ix_idxset (runid, name, itemid) VALUES (?, ?, ?)";
        String insertString = "INSERT INTO ix_idxset (ele_blob, runid, name, itemid) VALUES (?, ?, ?, ?)";
        String updateString = "UPDATE ix_idxset SET ele_blob = ? WHERE runid = ? AND name = ?";
        try (PreparedStatement selectPrepStmt = conn.prepareStatement(selectString);){
            selectPrepStmt.setInt(1, runId);
            selectPrepStmt.setString(2, ALL_SYMBOLS);
            try (ResultSet rs = selectPrepStmt.executeQuery();){
                if (!rs.next()) {
                    PreparedStatement asteriskPrepStmt = conn.prepareStatement(asteriskString);
                    asteriskPrepStmt.setInt(1, runId);
                    asteriskPrepStmt.setString(2, ALL_SYMBOLS);
                    asteriskPrepStmt.setInt(3, -1);
                    asteriskPrepStmt.executeUpdate();
                    asteriskPrepStmt.close();
                }
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error saving the '*' index set!", e);
        }
        for (IndexSet aSet : collection) {
            String name = aSet.getName();
            try {
                boolean doUpdate = false;
                try (PreparedStatement selectPrepStmt = conn.prepareStatement(selectString);){
                    selectPrepStmt.setInt(1, runId);
                    selectPrepStmt.setString(2, name);
                    try (ResultSet aRs = selectPrepStmt.executeQuery();){
                        doUpdate = aRs.next();
                    }
                }
                int updateRc = -1;
                boolean doBlobNull = true;
                ByteArrayInputStream bais = null;
                int blobLength = 0;
                List<Element> aBlob = aSet.getEleBlobForDB();
                if (!aBlob.isEmpty()) {
                    doBlobNull = false;
                    byte[] itemAsBytes = this.writeInputStream(aBlob, name);
                    bais = new ByteArrayInputStream(itemAsBytes);
                    blobLength = itemAsBytes.length;
                }
                if (doUpdate) {
                    try (PreparedStatement updatePrepStmt = conn.prepareStatement(updateString);){
                        this.setBlob(updatePrepStmt, 1, doBlobNull, bais, blobLength);
                        updatePrepStmt.setInt(2, runId);
                        updatePrepStmt.setString(3, name);
                        updateRc = updatePrepStmt.executeUpdate();
                        log.debug(String.format("update set '%s' rc=%d size=%d", name, updateRc, blobLength));
                    }
                }
                if (updateRc == 1) continue;
                PreparedStatement insertPrepStmt = conn.prepareStatement(insertString);
                try {
                    this.setBlob(insertPrepStmt, 1, doBlobNull, bais, blobLength);
                    insertPrepStmt.setInt(2, runId);
                    insertPrepStmt.setString(3, name);
                    insertPrepStmt.setInt(4, aSet.getItemId());
                    int insertRc = insertPrepStmt.executeUpdate();
                    log.debug(String.format("insert set '%s' rc=%d size=%d", name, insertRc, blobLength));
                }
                finally {
                    if (insertPrepStmt == null) continue;
                    insertPrepStmt.close();
                }
            }
            catch (SQLException e) {
                throw this.loggedIxException("Error saving an item-blob to database!", e);
            }
        }
    }

    protected void setBlob(PreparedStatement updatePrepStmt, int columnIndex, boolean isNull, ByteArrayInputStream input, int size) throws SQLException {
        if (isNull) {
            updatePrepStmt.setNull(columnIndex, 2004);
        } else {
            updatePrepStmt.setBinaryStream(columnIndex, (InputStream)input, size);
        }
    }

    protected byte[] writeInputStream(Object obj, String name) throws IxException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(baos)));
            oos.writeObject(obj);
            oos.flush();
            oos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw this.loggedIxException("Error creating a byte-array from a blob for item '" + name + "'!", e);
        }
    }

    @Override
    public void getIndexSets(at.ac.iiasa.ixmp.objects.Scenario scen, int runId) throws IxException {
        String sql = "SELECT name, itemid, ele_blob FROM ix_idxset WHERE runid = ? AND itemid >= 0 ORDER BY itemid";
        try (Connection conn = this.getPooledConn();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setInt(1, runId);
            try (ResultSet rs = stmt.executeQuery();){
                while (rs.next()) {
                    String name = rs.getString(1);
                    int itemId = rs.getInt(2);
                    Blob blob = rs.getBlob(3);
                    List<Element> elements = null;
                    if (!rs.wasNull()) {
                        elements = this.readElementFromBlob(blob.getBinaryStream());
                        blob.free();
                    }
                    new IndexSet(scen.getMp(), scen, name, itemId, elements);
                }
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error getting index sets", e);
        }
    }

    @Override
    public void getItemList(at.ac.iiasa.ixmp.objects.Scenario scen, int runId, String type) throws IxException {
        this.assertElementType(type);
        this.initItems(scen, runId, type);
        this.setScenarioDims(scen, runId, type);
    }

    private void setScenarioDims(at.ac.iiasa.ixmp.objects.Scenario scen, int runId, String type) throws IxException {
        String sql = "SELECT name, idx, idx_set, idx_name FROM ix_" + type + "_dim WHERE runid = ? ORDER BY name ASC, idx ASC";
        try (Connection conn = this.getPooledConn();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setLong(1, runId);
            try (ResultSet rs = stmt.executeQuery();){
                Item currentItem = null;
                String currentName = null;
                while (rs.next()) {
                    String name = rs.getString("name");
                    if (currentItem == null || !currentName.equals(name)) {
                        currentName = name;
                        currentItem = scen.getItem(currentName);
                    }
                    int idx = rs.getInt("idx");
                    String idxSet = rs.getString("idx_set");
                    String idxName = rs.getString("idx_name");
                    currentItem.setIXitemDimsFromDB(idx, idxSet, idxName);
                }
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Failed to set scenario dims", e);
        }
    }

    private void initItems(at.ac.iiasa.ixmp.objects.Scenario scen, int runId, String type) throws IxException {
        this.assertElementType(type);
        String sql = "SELECT name, itemid, dim FROM ix_" + type + " WHERE runid = ? ORDER BY itemid ASC";
        try (Connection conn = this.getPooledConn();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setLong(1, runId);
            try (ResultSet rs = stmt.executeQuery();){
                Platform platform = scen.getMp();
                while (rs.next()) {
                    String name = rs.getString("name");
                    int itemId = rs.getInt("itemid");
                    int dim = rs.getInt("dim");
                    switch (type) {
                        case "SET": {
                            new at.ac.iiasa.ixmp.objects.Set(platform, scen, name, itemId, dim);
                            break;
                        }
                        case "PAR": {
                            new Parameter(platform, scen, name, itemId, dim);
                            break;
                        }
                        case "VAR": {
                            new Variable(platform, scen, name, itemId, dim);
                            break;
                        }
                        case "EQU": {
                            new Equation(platform, scen, name, itemId, dim);
                        }
                    }
                }
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Failed to initialize scenario items", e);
        }
    }

    private PreparedStatement prepareIsDefaultVersion(Connection conn, Long runId) throws SQLException {
        String sql = "SELECT id FROM run_default WHERE id = ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setLong(1, runId);
        return stmt;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isDefaultVersion(int runId) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setDefaultVersion(Connection conn, String model, String scenario, long runId) throws IxException {
        String delete = "DELETE FROM run_default WHERE model_id = ? AND scen_id = ?";
        String insert = "INSERT INTO run_default (model_id, scen_id, id) VALUES (?, ?, ?)";
        int modelId = this.getSomeId(conn, model, "MODEL");
        int scenarioId = this.getSomeId(conn, scenario, "SCENARIO");
        try {
            PreparedStatement stmt = conn.prepareStatement(delete);
            stmt.setInt(1, modelId);
            stmt.setInt(2, scenarioId);
            stmt.executeUpdate();
            stmt.close();
            stmt = conn.prepareStatement(insert);
            stmt.setInt(1, modelId);
            stmt.setInt(2, scenarioId);
            stmt.setLong(3, runId);
            stmt.executeUpdate();
            stmt.close();
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem setting the default version of a scenario in the database!", e);
        }
    }

    @Override
    public void saveSeqItemId(Connection conn, int seqItemId, int runId) throws IxException {
        String sql = "UPDATE run SET seq_item_id = ? WHERE id = ?";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setInt(1, seqItemId);
            stmt.setInt(2, runId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem saving the item sequence counter in the database!", e);
        }
    }

    private PreparedStatement prepareGetSeqItemId(Connection conn, Long runId) throws SQLException {
        String sql = "SELECT seq_item_id FROM run WHERE id = ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setLong(1, runId);
        return stmt;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getSeqItemId(int runId) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setUpdUserDate(Connection conn, int runId) throws IxException {
        String sql = "UPDATE run SET upd_user = ?, upd_date = CURRENT_TIMESTAMP WHERE id = ?";
        String user = System.getProperty("user.name", "(unknown)");
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, user);
            stmt.setInt(2, runId);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem setting the user/timestamp for the update in the database!", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Timestamp getLastUpdTimestamp(int runId) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setRunIdAnnotation(int runId, String annotation) throws IxException {
        String sql = "UPDATE run SET annotation = ? WHERE id = ?";
        try (Connection conn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(conn);
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setString(1, annotation);
            stmt.setInt(2, runId);
            stmt.executeUpdate();
            tm.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("There was a problem updating the annotation for run id '" + runId + "'!", e);
        }
    }

    @Override
    public void createSetInDB(Connection conn, Collection<at.ac.iiasa.ixmp.objects.Set> setList, int runId) throws IxException {
        this.createItemInDB(conn, new LinkedHashSet<Item>(setList), "SET", runId);
    }

    @Override
    public void createParInDB(Connection conn, Collection<Parameter> parList, int runId) throws IxException {
        this.createItemInDB(conn, new LinkedHashSet<Item>(parList), "PAR", runId);
    }

    @Override
    public void createVarInDB(Connection conn, Collection<Variable> varList, int runId) throws IxException {
        this.createItemInDB(conn, new LinkedHashSet<Item>(varList), "VAR", runId);
    }

    @Override
    public void createEquInDB(Connection conn, Collection<Equation> equList, int runId) throws IxException {
        this.createItemInDB(conn, new LinkedHashSet<Item>(equList), "EQU", runId);
    }

    @Override
    public void createItemInDB(Connection conn, Set<Item> itemList, String type, int runId) throws IxException {
        this.assertElementType(type);
        String name = null;
        String itemString = "INSERT INTO ix_" + type + " (runid, name, dim, itemid) VALUES (?, ?, ?, ?)";
        String dimString = "INSERT INTO ix_" + type + "_dim (runid, name, idx, idx_set, idx_name) VALUES (?, ?, ?, ?, ?)";
        String blobString = "INSERT INTO ix_" + type + "_blobstore (runid, name) VALUES (?, ?)";
        try (PreparedStatement prepDimStmt = conn.prepareStatement(dimString);
             PreparedStatement prepItemStmt = conn.prepareStatement(itemString);
             PreparedStatement prepBlobStmt = conn.prepareStatement(blobString);){
            boolean batch = false;
            boolean dimBatch = false;
            for (Item aItem : itemList) {
                name = aItem.getName();
                prepItemStmt.setInt(1, runId);
                prepItemStmt.setString(2, name);
                prepItemStmt.setInt(3, aItem.getDim());
                prepItemStmt.setInt(4, aItem.getItemId());
                prepItemStmt.addBatch();
                batch = true;
                List<String> idxSets = aItem.getIdxSets();
                List<String> idxNames = aItem.getIdxNames();
                for (int idx = 0; idx < aItem.getDim(); ++idx) {
                    prepDimStmt.setInt(1, runId);
                    prepDimStmt.setString(2, name);
                    prepDimStmt.setInt(3, idx);
                    prepDimStmt.setString(4, idxSets.get(idx));
                    prepDimStmt.setString(5, idxNames.get(idx));
                    prepDimStmt.addBatch();
                    dimBatch = true;
                }
                prepBlobStmt.setInt(1, runId);
                prepBlobStmt.setString(2, aItem.getName());
                prepBlobStmt.addBatch();
            }
            if (batch) {
                prepItemStmt.executeBatch();
            }
            if (dimBatch) {
                prepDimStmt.executeBatch();
            }
            if (batch) {
                prepBlobStmt.executeBatch();
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException(String.format("Error creating the %s '%s' in the database!", type, name), e);
        }
    }

    @Override
    public void saveItemElementsToDB(Connection conn, Item item, int runId) throws IxException {
        String name = item.getName();
        String type = item.getTypeForDB();
        List<Element> aBlob = item.getEleBlobForDB();
        this.saveBlobToDB(conn, name, type, "ele", aBlob, aBlob.size(), runId);
        item.hasUpdatedElement = false;
    }

    @Override
    public void saveItemCommentsToDB(Connection conn, Item item, int runId) throws IxException {
        String name = item.getName();
        String type = item.getTypeForDB();
        Map<Integer, List<Integer>> aMap = item.getCommentMapForDB();
        this.saveBlobToDB(conn, name, type, "com", aMap, aMap.size(), runId);
        item.hasUpdatedComment = false;
    }

    protected void saveBlobToDB(Connection conn, String name, String type, String col, Object obj, int size, int runId) throws IxException {
        this.assertElementType(type);
        String sql = "UPDATE ix_" + type + "_blobstore SET " + col + "_blob = ? WHERE runid = ? AND name = ? ";
        try (PreparedStatement updatePrepStmt = conn.prepareStatement(sql);){
            int blobLength = 0;
            if (obj == null || size == 0) {
                updatePrepStmt.setNull(1, 2004);
            } else {
                byte[] bytes = this.writeInputStream(obj, name);
                blobLength = bytes.length;
                updatePrepStmt.setBinaryStream(1, new ByteArrayInputStream(bytes));
            }
            updatePrepStmt.setInt(2, runId);
            updatePrepStmt.setString(3, name);
            int updateRc = updatePrepStmt.executeUpdate();
            log.debug(String.format("update %s %s rc=%d size=%d", type, name, updateRc, blobLength));
        }
        catch (SQLException e) {
            throw this.loggedIxException(String.format("Error saving the %s blob for item '%s' to the database!", type, name), e);
        }
    }

    @Override
    public boolean hasItemElementsInBlob(int runId, Item item) throws IxException {
        String name = item.getName();
        String type = item.getTypeForDB();
        return this.hasItemBlob(runId, name, type, "ele");
    }

    /*
     * Exception decompiling
     */
    private boolean hasItemBlob(int runId, String name, String type, String col) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void getItemElementsFromDB(int runId, Item item) throws IxException {
        log.debug("loading elements for " + item.getTypeName() + " from database...");
        List ele = this.getBlobFromDB(runId, item, "ele", DbDAO::objectToElements);
        if (ele != null) {
            item.setElementListFromDB(ele);
        }
    }

    @Override
    public Map<Integer, List<Integer>> getItemCommentsFromDB(int runId, Item item) throws IxException {
        log.debug("loading comments for " + item.getTypeName() + " from database...");
        return this.getBlobFromDB(runId, item, "com", obj -> (Map)obj);
    }

    /*
     * Exception decompiling
     */
    protected <T> T getBlobFromDB(int runId, Item item, String col, Converter<Object, T> converter) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 9 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void createKeysInDB(Connection conn, Map<Integer, String> idKeyMap, int runId) throws IxException {
        String sql = "INSERT INTO ix_key (runid, keyid, key) VALUES (?, ?, ?)";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            for (Map.Entry<Integer, String> entry : idKeyMap.entrySet()) {
                stmt.setInt(1, runId);
                stmt.setInt(2, entry.getKey());
                stmt.setString(3, entry.getValue());
                stmt.addBatch();
            }
            if (!idKeyMap.isEmpty()) {
                stmt.executeBatch();
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot create keys in DB!", e);
        }
    }

    private PreparedStatement prepareGetKeyIdList(Connection conn, Long runId) throws SQLException {
        String sql = "SELECT keyid, key FROM ix_key WHERE runid = ? ORDER BY keyid ASC";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setLong(1, runId);
        return stmt;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getKeyIdList(int runId, at.ac.iiasa.ixmp.objects.Scenario scen) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void saveCommentsInDB(Connection conn, Map<Integer, String> idCommentMap, int runId) throws IxException {
        if (idCommentMap.isEmpty()) {
            return;
        }
        String sql = "INSERT INTO ix_comment (runid, comid, comstring) VALUES (?, ?, ?)";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            for (Map.Entry<Integer, String> entry : idCommentMap.entrySet()) {
                stmt.setInt(1, runId);
                stmt.setInt(2, entry.getKey());
                stmt.setString(3, entry.getValue());
                stmt.addBatch();
            }
            if (!idCommentMap.isEmpty()) {
                stmt.executeBatch();
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot save comments in DB!", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getCommentIdList(int runId, at.ac.iiasa.ixmp.objects.Scenario scenario) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void updateTimeseriesInDB(Connection conn, Map<List<Integer>, Integer> tsInfo, Map<List<Integer>, Map<Integer, Double>> tsList, int runId) throws IxException {
        int NOT_SPECIFIED = -1;
        String insertInfo = "INSERT INTO iamc_tsinfo (tsid, runid, node, key, meta, time) VALUES (?, ?, ?, ?, ?, ?)";
        String insertData = "UPDATE iamc_tsdata SET value = ? WHERE tsid = ? AND year = ?";
        try (PreparedStatement infoStmt = conn.prepareStatement(insertInfo);
             PreparedStatement dataStmt = conn.prepareStatement(insertData);){
            int batchInfo = 0;
            int batchData = 0;
            for (Map.Entry<List<Integer>, Map<Integer, Double>> ts : tsList.entrySet()) {
                Integer tsId = tsInfo.get(ts.getKey());
                if (tsId == null) {
                    tsId = this.getNextId(conn, "IAMC_TS").intValue();
                    infoStmt.setInt(1, tsId);
                    infoStmt.setInt(2, runId);
                    infoStmt.setInt(3, ts.getKey().get(0));
                    infoStmt.setInt(4, ts.getKey().get(1));
                    infoStmt.setInt(5, ts.getKey().get(2));
                    if (ts.getKey().size() > 3) {
                        infoStmt.setInt(6, ts.getKey().get(3));
                    } else {
                        infoStmt.setInt(6, -1);
                    }
                    infoStmt.addBatch();
                    ++batchInfo;
                    tsInfo.put(ts.getKey(), tsId);
                }
                for (Map.Entry<Integer, Double> data : ts.getValue().entrySet()) {
                    dataStmt.setDouble(1, data.getValue());
                    dataStmt.setInt(2, tsId);
                    dataStmt.setInt(3, data.getKey());
                    dataStmt.addBatch();
                    ++batchData;
                }
                if (batchInfo < 1000 && batchData < 1000) continue;
                if (batchInfo > 0) {
                    infoStmt.executeBatch();
                    batchInfo = 0;
                }
                if (batchData <= 0) continue;
                dataStmt.executeBatch();
                batchData = 0;
            }
            if (batchInfo > 0) {
                infoStmt.executeBatch();
            }
            if (batchData > 0) {
                dataStmt.executeBatch();
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error writing the timeseries data to the IXMP database!", e);
        }
    }

    @Override
    public void removeTimeseriesInDB(Connection conn, Map<List<Integer>, Integer> tsInfo, Map<List<Integer>, List<Integer>> tsList, int runId) throws IxException {
        String deleteInfo = "DELETE FROM iamc_tsinfo ti WHERE tsid = ? AND runid = ? AND NOT EXISTS (SELECT 1 FROM iamc_tsdata td WHERE td.tsid = ti.tsid)";
        String deleteData = "DELETE FROM iamc_tsdata WHERE tsid = ? AND year = ?";
        try (PreparedStatement infoStmt = conn.prepareStatement(deleteInfo);
             PreparedStatement dataStmt = conn.prepareStatement(deleteData);){
            int batchInfo = 0;
            int batchData = 0;
            HashMap<Integer, List> batchedTs = new HashMap<Integer, List>();
            for (Map.Entry<List<Integer>, List<Integer>> ts : tsList.entrySet()) {
                List<Integer> key = ts.getKey();
                Integer tsId = tsInfo.get(key);
                if (tsId != null) {
                    for (Integer year : ts.getValue()) {
                        dataStmt.setLong(1, tsId.intValue());
                        dataStmt.setInt(2, year);
                        dataStmt.addBatch();
                        ++batchData;
                    }
                    infoStmt.setLong(1, tsId.intValue());
                    infoStmt.setLong(2, runId);
                    infoStmt.addBatch();
                    batchedTs.put(batchInfo, key);
                    ++batchInfo;
                }
                if (batchInfo < 1000 && batchData < 1000) continue;
                if (batchData > 0) {
                    dataStmt.executeBatch();
                    batchData = 0;
                }
                if (batchInfo <= 0) continue;
                int[] removedTs = infoStmt.executeBatch();
                batchedTs.forEach((index, tsKey) -> {
                    if (removedTs[index] > 0) {
                        tsInfo.remove(tsKey);
                    }
                });
                batchInfo = 0;
                batchedTs = new HashMap();
            }
            if (batchData > 0) {
                dataStmt.executeBatch();
            }
            if (batchInfo > 0) {
                int[] removedTs = infoStmt.executeBatch();
                batchedTs.forEach((index, tsKey) -> {
                    if (removedTs[index] > 0) {
                        tsInfo.remove(tsKey);
                    }
                });
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error writing the timeseries data to the IXMP database!", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<List<Integer>, Integer> getTsInfoFromDB(Connection conn, Integer runId) throws IxException {
        String sql = "SELECT node, key, meta, time, tsid FROM iamc_tsinfo WHERE runid = ?";
        try (PreparedStatement qStmt = conn.prepareStatement(sql);){
            HashMap<List<Integer>, Integer> hashMap;
            block15: {
                qStmt.setInt(1, runId);
                ResultSet aRs = qStmt.executeQuery();
                try {
                    HashMap<List<Integer>, Integer> tsInfo = new HashMap<List<Integer>, Integer>();
                    while (aRs.next()) {
                        List<Integer> vecNdId = TimeSeries.getVecNdId(aRs.getInt("node"), aRs.getInt("key"), aRs.getInt("meta"), aRs.getInt("time"));
                        int tsid = aRs.getInt("tsid");
                        tsInfo.put(vecNdId, tsid);
                    }
                    hashMap = tsInfo;
                    if (aRs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (aRs != null) {
                        try {
                            aRs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                aRs.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error loading existing timeseries-info entries from database!", e);
        }
    }

    @Override
    public List<Integer> getVariableUnitKeys(List<String> variableNames, List<Integer> unitIds) throws IxException {
        ArrayList<Integer> arrayList;
        block23: {
            String baseSql = "SELECT keyid FROM iamc_key WHERE " + this.buildInClause("unitid", unitIds, true);
            ArrayList<String> variableGroups = DBUtils.isEmpty(variableNames) ? Collections.singletonList(variableNames) : new ArrayList<String>(Partition.ofSize(variableNames, 1000));
            Connection conn = this.getPooledConn();
            try {
                ArrayList<Integer> result = new ArrayList<Integer>();
                for (List list : variableGroups) {
                    String sql = baseSql;
                    if (!DBUtils.isEmpty(list)) {
                        sql = sql + " AND keystring IN (" + this.getPlaceholders(list) + ")";
                    }
                    PreparedStatement stmt = conn.prepareStatement(sql);
                    try {
                        int index = 0;
                        if (!DBUtils.isEmpty(list)) {
                            for (String variableName : list) {
                                stmt.setString(++index, variableName);
                            }
                        }
                        ResultSet resultSet = stmt.executeQuery();
                        try {
                            while (resultSet.next()) {
                                result.add(resultSet.getInt("keyid"));
                            }
                        }
                        finally {
                            if (resultSet == null) continue;
                            resultSet.close();
                        }
                    }
                    finally {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                }
                arrayList = result;
                if (conn == null) break block23;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw this.loggedIxException("Error fetching keys of variable-units (table IAMC_KEY)", e);
                }
            }
            conn.close();
        }
        return arrayList;
    }

    @Override
    @Deprecated
    public void addToTimeseriesList(Map<List<Integer>, Map<Integer, Double>> tsMap, Integer runId, Integer keyId) throws IxException {
        String sql = "SELECT i.node, i.time, i.meta, d.year, d.value, i.key FROM iamc_tsinfo i INNER JOIN iamc_tsdata d ON i.tsid = d.tsid WHERE i.runid = ? ";
        if (keyId != null) {
            sql = sql + "AND i.key = ? ";
        }
        sql = sql + "ORDER BY node ASC, key ASC, time ASC, year ASC";
        try (Connection conn = this.getPooledConn();
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setInt(1, runId);
            if (keyId != null) {
                stmt.setInt(2, keyId);
            }
            try (ResultSet rs = stmt.executeQuery();){
                List<Integer> vecNdId = null;
                LinkedHashMap<Integer, Double> data = null;
                int prevNode = -1;
                int prevMeta = -1;
                int prevTime = -1;
                int prevKeyId = -1;
                while (rs.next()) {
                    int node = rs.getInt("node");
                    int time = rs.getInt("time");
                    int meta = rs.getInt("meta");
                    int year = rs.getInt("year");
                    keyId = rs.getInt("key");
                    double value = rs.getDouble("value");
                    if (node != prevNode || keyId != prevKeyId || meta != prevMeta || time != prevTime) {
                        if (data != null) {
                            tsMap.put(vecNdId, data);
                        }
                        vecNdId = TimeSeries.getVecNdId(node, keyId, meta, time);
                        data = new LinkedHashMap<Integer, Double>();
                        prevNode = node;
                        prevKeyId = keyId;
                        prevMeta = meta;
                        prevTime = time;
                    }
                    if (data == null) continue;
                    data.put(year, value);
                }
                if (data != null) {
                    tsMap.put(vecNdId, data);
                }
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error loading existing timeseries-data entries from database!", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<TimeseriesEntryDTO> getTimeseriesFromDB(List<Integer> runIdList, List<Integer> nodeList, List<Integer> keyList, List<Integer> timeList, List<Integer> yearList, Function<ResultSet, TimeseriesEntryDTO> converter) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void openConn() throws IxException {
        try {
            this.initDataSource();
            log.debug("URL (source):" + this.config.url() + "|" + this.config.user() + "|" + this.config.pwd());
        }
        catch (SQLException e) {
            throw this.loggedIxException("Could not open the database connection!", e);
        }
    }

    protected void shutdownIfNeeded() throws IxException {
    }

    protected DatabaseConfig getConfig() {
        return this.config;
    }

    public void testConn() throws IxException {
        try (Connection conn = this.getPooledConn();
             Statement stmt = conn.createStatement();){
            stmt.executeQuery(this.getTestSQL());
        }
        catch (SQLException e) {
            log.error(e.getMessage());
            this.openConn();
        }
    }

    protected abstract String getTestSQL();

    public boolean closeConn() throws IxException {
        if (this.ds != null) {
            try {
                HikariDataSource hikariDataSource = this.ds.unwrap(HikariDataSource.class);
                if (!hikariDataSource.isClosed()) {
                    this.shutdownIfNeeded();
                    hikariDataSource.close();
                    return true;
                }
                log.info("Database connection could not be closed or was already closed");
            }
            catch (SQLException e) {
                log.error("Cannot close data source", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public Metadata getMetadata(String model, String scenario, Long version) throws IxException {
        Metadata metadata;
        block8: {
            Connection conn = this.getPooledConn();
            try {
                metadata = this.getMetadata(conn, model, scenario, version);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw this.loggedIxException("Cannot retrieve meta indicators", e);
                }
            }
            conn.close();
        }
        return metadata;
    }

    public Metadata getMetadata(Connection cn, String model, String scenario, Long version) throws IxException {
        Long scenarioId = scenario == null ? null : Long.valueOf(this.getSomeId(cn, scenario, "SCENARIO"));
        Long modelId = model == null ? null : Long.valueOf(this.getSomeId(cn, model, "MODEL"));
        return this.getMetadata(cn, modelId, scenarioId, version);
    }

    private void updateMetaEntry(ResultSet rs, Map<Long, Metadata.MetadataEntry<?>> entriesMap) throws SQLException {
        Long id = rs.getLong("meta_id");
        String name = rs.getString("name");
        long idx = rs.getLong("idx");
        Long scenId = this.getNullableLong(rs, "scen_id");
        Long modelId = this.getNullableLong(rs, "model_id");
        Long version = this.getNullableLong(rs, "version");
        Metadata.MetadataEntry<Object> entry = null;
        if (idx == -1L) {
            String stringValue = rs.getString("string_value");
            if (!rs.wasNull()) {
                entry = new Metadata.MetadataEntry<String>(id, name, stringValue, modelId, scenId, version);
            } else {
                BigDecimal numericValue = rs.getBigDecimal("numeric_value");
                if (!rs.wasNull()) {
                    entry = new Metadata.MetadataEntry<BigDecimal>(id, name, numericValue.stripTrailingZeros(), modelId, scenId, version);
                } else {
                    Boolean booleanValue = rs.getBoolean("boolean_value");
                    if (!rs.wasNull()) {
                        entry = new Metadata.MetadataEntry<Boolean>(id, name, booleanValue, modelId, scenId, version);
                    } else {
                        log.warn("Could not read meta indicator");
                    }
                }
            }
        } else {
            entry = entriesMap.get(id);
            String stringValue = rs.getString("string_value");
            if (!rs.wasNull()) {
                if (entry == null) {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(stringValue);
                    entry = new Metadata.MetadataEntry(id, name, list, modelId, scenId, version);
                } else {
                    entry.getStringListValue().ifPresent(v -> v.add(stringValue));
                }
            } else {
                BigDecimal numericValue = rs.getBigDecimal("numeric_value");
                if (!rs.wasNull()) {
                    if (entry == null) {
                        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
                        list.add(numericValue.stripTrailingZeros());
                        entry = new Metadata.MetadataEntry(id, name, list, modelId, scenId, version);
                    } else {
                        entry.getNumericListValue().ifPresent(v -> v.add(numericValue.stripTrailingZeros()));
                    }
                } else {
                    Boolean booleanValue = rs.getBoolean("boolean_value");
                    if (!rs.wasNull()) {
                        if (entry == null) {
                            ArrayList<Boolean> list = new ArrayList<Boolean>();
                            list.add(booleanValue);
                            entry = new Metadata.MetadataEntry(id, name, list, modelId, scenId, version);
                        } else {
                            entry.getBooleanListValue().ifPresent(v -> v.add(booleanValue));
                        }
                    } else {
                        log.warn("Could not read meta indicator");
                    }
                }
            }
        }
        if (entry != null) {
            entriesMap.put(id, entry);
        }
    }

    private PreparedStatement prepareGetMetadata(Connection conn, Long scenarioId, Long modelId, Long version) throws SQLException, IxException {
        if (version != null && (modelId == null || scenarioId == null) || modelId == null && scenarioId == null) {
            throw new IxException("Incorrect combination of model, scenario and/or version used to select meta");
        }
        String sql = "SELECT m.id AS meta_id, m.name, \t    me.idx, me.string_value, me.numeric_value, me.boolean_value,       rm.scen_id, rm.model_id, rm.version FROM metadata m INNER JOIN metadata_entries me ON (me.meta_id = m.id) INNER JOIN run_meta rm ON m.id = rm.meta_id WHERE m.id IN (SELECT DISTINCT meta_id FROM run_meta WHERE (1=0 ";
        if (modelId != null) {
            sql = sql + "OR (model_id = ? AND scen_id IS NULL AND version IS NULL) ";
        }
        if (scenarioId != null) {
            sql = sql + "OR (model_id IS NULL AND scen_id = ? AND version IS NULL) ";
        }
        if (modelId != null && scenarioId != null) {
            sql = sql + "OR (model_id = ? AND scen_id = ? AND version IS NULL) ";
        }
        if (version != null) {
            sql = sql + "OR (model_id = ? AND scen_id = ? AND version = ?) ";
        }
        sql = sql + ")) ORDER BY m.id ASC, me.idx ASC ";
        PreparedStatement stmt = conn.prepareStatement(sql);
        int index = 0;
        if (modelId != null) {
            stmt.setLong(++index, modelId);
        }
        if (scenarioId != null) {
            stmt.setLong(++index, scenarioId);
        }
        if (modelId != null && scenarioId != null) {
            stmt.setLong(++index, modelId);
            stmt.setLong(++index, scenarioId);
        }
        if (version != null) {
            stmt.setLong(++index, modelId);
            stmt.setLong(++index, scenarioId);
            stmt.setLong(++index, version);
        }
        log.debug("SQL: " + sql);
        return stmt;
    }

    @Override
    public Metadata getMetadata(Long scenarioId, Long modelId, Long version) throws IxException {
        Metadata metadata;
        block8: {
            Connection conn = this.getPooledConn();
            try {
                metadata = this.getMetadata(conn, modelId, scenarioId, version);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw this.loggedIxException("Cannot retrieve meta indicators", e);
                }
            }
            conn.close();
        }
        return metadata;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Metadata getMetadata(Connection conn, Long modelId, Long scenarioId, Long version) throws IxException {
        try (PreparedStatement stmt = this.prepareGetMetadata(conn, scenarioId, modelId, version);){
            Metadata metadata;
            block15: {
                ResultSet rs = stmt.executeQuery();
                try {
                    HashMap entriesMap = new HashMap();
                    while (rs.next()) {
                        this.updateMetaEntry(rs, entriesMap);
                    }
                    Metadata result = new Metadata();
                    result.setEntries(new ArrayList<Metadata.MetadataEntry<? extends Serializable>>(entriesMap.values()));
                    result.setScenarioId(scenarioId);
                    result.setModelId(modelId);
                    result.setVersion(version);
                    metadata = result;
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return metadata;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot retrieve meta indicators", e);
        }
    }

    private PreparedStatement prepareGetMetadata(Connection conn, List<Long> runIds) throws SQLException {
        String sql = "SELECT r.id AS run_id, r.model_id, r.scen_id, r.version,        m.id AS meta_id, m.name, me.idx, me.string_value, me.numeric_value, me.boolean_value FROM run r INNER JOIN run_meta rm   ON (rm.model_id = r.model_id OR rm.model_id IS NULL)   AND (rm.scen_id = r.scen_id OR rm.scen_id IS NULL)   AND (rm.version = r.version OR rm.version IS NULL) INNER JOIN metadata m ON m.id = rm.meta_id INNER JOIN metadata_entries me ON (me.meta_id = m.id) WHERE r.id IN (" + this.getPlaceholders(runIds) + ") ORDER BY r.id ASC, m.id ASC, me.idx ASC";
        PreparedStatement stmt = conn.prepareStatement(sql);
        int index = 0;
        for (Long runId : runIds) {
            stmt.setLong(++index, runId);
        }
        log.debug("SQL: " + sql);
        return stmt;
    }

    @Override
    public List<Metadata> getMetadata(List<Long> runIds) throws IxException {
        ArrayList<Metadata> arrayList;
        block23: {
            if (runIds.isEmpty()) {
                return Collections.emptyList();
            }
            Connection conn = this.getPooledConn();
            try {
                Partition<Long> parts = Partition.ofSize(runIds, 1000);
                ArrayList<Metadata> result = new ArrayList<Metadata>();
                for (List list : parts) {
                    PreparedStatement stmt = this.prepareGetMetadata(conn, list);
                    try {
                        ResultSet rs = stmt.executeQuery();
                        try {
                            Long prevRunId = null;
                            Metadata metadata = null;
                            HashMap entriesMap = null;
                            while (rs.next()) {
                                Long runId = rs.getLong("run_id");
                                if (!Objects.equals(prevRunId, runId)) {
                                    if (metadata != null) {
                                        metadata.setEntries(new ArrayList<Metadata.MetadataEntry<? extends Serializable>>(entriesMap.values()));
                                        result.add(metadata);
                                    }
                                    metadata = new Metadata();
                                    metadata.setRunId(runId);
                                    metadata.setModelId(rs.getLong("model_id"));
                                    metadata.setScenarioId(rs.getLong("scen_id"));
                                    metadata.setVersion(rs.getLong("version"));
                                    entriesMap = new HashMap();
                                    prevRunId = runId;
                                }
                                this.updateMetaEntry(rs, entriesMap);
                            }
                            if (metadata == null) continue;
                            metadata.setEntries(new ArrayList<Metadata.MetadataEntry<? extends Serializable>>(entriesMap.values()));
                            result.add(metadata);
                        }
                        finally {
                            if (rs == null) continue;
                            rs.close();
                        }
                    }
                    finally {
                        if (stmt == null) continue;
                        stmt.close();
                    }
                }
                arrayList = result;
                if (conn == null) break block23;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    log.error("Error getting meta indicators for scenarios", (Throwable)e);
                    return Collections.emptyList();
                }
            }
            conn.close();
        }
        return arrayList;
    }

    private Metadata.MetadataEntry<?> saveMetadataEntry(Connection conn, Metadata.MetadataEntry<?> entry, Long modelId, Long scenarioId, Long version) throws SQLException, IxException {
        PreparedStatement stmt;
        block45: {
            if (entry.getId() != null) {
                stmt = conn.prepareStatement("UPDATE metadata SET name = ? WHERE id = ?");
                try {
                    stmt.setString(1, entry.getName());
                    stmt.setLong(2, entry.getId());
                    stmt.executeUpdate();
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                this.removeMetadataEntries(conn, entry.getId());
            } else {
                this.checkMetaAtAnotherLevel(conn, modelId, scenarioId, version, entry.getName());
                Long metaId = this.getExactMetaId(conn, modelId, scenarioId, version, entry.getName());
                if (metaId != null) {
                    this.removeMetadataEntries(conn, metaId);
                } else {
                    metaId = this.getNextId(conn, "metadata");
                    try (PreparedStatement stmt2 = conn.prepareStatement("INSERT INTO metadata (id, name) VALUES (?, ?)");){
                        stmt2.setLong(1, metaId);
                        stmt2.setString(2, entry.getName());
                        stmt2.executeUpdate();
                    }
                }
                entry.setId(metaId);
            }
            stmt = conn.prepareStatement("INSERT INTO metadata_entries (meta_id, idx, string_value, numeric_value, boolean_value) VALUES (?, ?, ?, ?, ?)");
            try {
                Object value = entry.getValue();
                if (value instanceof String) {
                    stmt.setLong(1, entry.getId());
                    stmt.setInt(2, -1);
                    stmt.setString(3, (String)value);
                    stmt.setNull(4, 3);
                    this.setBooleanParameter(stmt, 5, null);
                    stmt.executeUpdate();
                    break block45;
                }
                if (value instanceof BigDecimal) {
                    stmt.setLong(1, entry.getId());
                    stmt.setInt(2, -1);
                    stmt.setNull(3, 12);
                    stmt.setBigDecimal(4, (BigDecimal)value);
                    this.setBooleanParameter(stmt, 5, null);
                    stmt.executeUpdate();
                    break block45;
                }
                if (value instanceof Boolean) {
                    stmt.setLong(1, entry.getId());
                    stmt.setInt(2, -1);
                    stmt.setNull(3, 12);
                    stmt.setNull(4, 3);
                    this.setBooleanParameter(stmt, 5, (Boolean)value);
                    stmt.executeUpdate();
                    break block45;
                }
                if (value instanceof ArrayList) {
                    ArrayList list = (ArrayList)value;
                    int index = 0;
                    for (Object listValue : list) {
                        if (listValue instanceof String) {
                            stmt.setLong(1, entry.getId());
                            stmt.setInt(2, index++);
                            stmt.setString(3, (String)listValue);
                            stmt.setNull(4, 3);
                            this.setBooleanParameter(stmt, 5, null);
                            stmt.addBatch();
                            continue;
                        }
                        if (listValue instanceof BigDecimal) {
                            stmt.setLong(1, entry.getId());
                            stmt.setInt(2, index++);
                            stmt.setNull(3, 12);
                            stmt.setBigDecimal(4, (BigDecimal)listValue);
                            this.setBooleanParameter(stmt, 5, null);
                            stmt.addBatch();
                            continue;
                        }
                        if (listValue instanceof Boolean) {
                            stmt.setLong(1, entry.getId());
                            stmt.setInt(2, index++);
                            stmt.setNull(3, 12);
                            stmt.setNull(4, 3);
                            this.setBooleanParameter(stmt, 5, (Boolean)listValue);
                            stmt.addBatch();
                            continue;
                        }
                        throw new IxException(String.format("Saving meta indicator (%s) is not yet implemented for type: %s", entry.getName(), listValue.getClass().getSimpleName()));
                    }
                    stmt.executeBatch();
                    break block45;
                }
                throw new IxException(String.format("Saving meta indicators (%s) is not yet implemented for type: %s", entry.getName(), value.getClass().getSimpleName()));
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        }
        stmt = conn.prepareStatement("SELECT count(*) FROM run_meta WHERE meta_id = ? AND (scen_id = ? OR scen_id IS NULL AND ? IS NULL) AND (model_id = ? OR model_id IS NULL AND ? IS NULL) AND (version = ? OR version IS NULL AND ? IS NULL) ");
        try {
            DbDAO.setNullable(stmt, 1, entry.getId());
            DbDAO.setNullable(stmt, 2, scenarioId);
            DbDAO.setNullable(stmt, 3, scenarioId);
            DbDAO.setNullable(stmt, 4, modelId);
            DbDAO.setNullable(stmt, 5, modelId);
            DbDAO.setNullable(stmt, 6, version);
            DbDAO.setNullable(stmt, 7, version);
            ResultSet resultSet = stmt.executeQuery();
            resultSet.next();
            if (resultSet.getLong(1) == 0L) {
                try (PreparedStatement insertStmt = conn.prepareStatement("INSERT INTO run_meta (meta_id, scen_id, model_id, version) VALUES (?, ?, ?, ?)");){
                    DbDAO.setNullable(insertStmt, 1, entry.getId());
                    DbDAO.setNullable(insertStmt, 2, scenarioId);
                    DbDAO.setNullable(insertStmt, 3, modelId);
                    DbDAO.setNullable(insertStmt, 4, version);
                    insertStmt.executeUpdate();
                }
            }
            resultSet.close();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
        return entry;
    }

    private void checkMetaAtAnotherLevel(Connection cn, Long modelId, Long scenarioId, Long version, String name) throws SQLException, IxException {
        log.debug(String.format("Checking for meta category duplicates: modelId=%d scenarioId=%d version=%d", modelId, scenarioId, version));
        String sql = "SELECT m.id, rm.scen_id, rm.model_id, rm.version, mo.name AS model_name, s.name AS scenario_name FROM run_meta rm INNER JOIN metadata m ON m.id = rm.meta_id LEFT OUTER JOIN scenario s ON s.id = rm.scen_id LEFT OUTER JOIN model mo ON mo.id = rm.model_id WHERE m.name = ? ";
        if (modelId != null && scenarioId == null && version == null) {
            sql = sql + "AND NOT (rm.model_id IS NOT NULL AND rm.scen_id IS NULL AND rm.version IS NULL)";
        } else if (modelId == null && scenarioId != null && version == null) {
            sql = sql + "AND NOT (rm.model_id IS NULL AND rm.scen_id IS NOT NULL AND rm.version IS NULL)";
        } else if (modelId != null && scenarioId != null && version == null) {
            sql = sql + "AND NOT (rm.model_id IS NOT NULL AND rm.scen_id IS NOT NULL AND rm.version IS NULL)";
        } else if (modelId != null && scenarioId != null) {
            sql = sql + "AND NOT (rm.model_id IS NOT NULL AND rm.scen_id IS NOT NULL AND rm.version IS NOT NULL)";
        } else {
            throw new IxException("Invalid arguments: unsupported combination of model/scenario/version");
        }
        try (PreparedStatement stmt = cn.prepareStatement(sql);){
            stmt.setString(1, name);
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    String duplicateModel = rs.getString("model_name");
                    String duplicateScenario = rs.getString("scenario_name");
                    Long duplicateVersion = this.getNullableLong(rs, "version");
                    String error = "The meta category '%s' is already used at another level: model %s, scenario %s, version %s";
                    throw new IxException(String.format(error, name, duplicateModel, duplicateScenario, duplicateVersion));
                }
            }
        }
    }

    private Long getExactMetaId(Connection cn, Long modelId, Long scenarioId, Long version, String name) throws IxException, SQLException {
        String sql = "SELECT m.id, rm.scen_id, rm.model_id, rm.version FROM run_meta rm INNER JOIN metadata m ON m.id = rm.meta_id WHERE m.name = ? ";
        sql = modelId != null ? sql + "AND rm.model_id = ? " : sql + "AND rm.model_id IS NULL ";
        sql = scenarioId != null ? sql + "AND rm.scen_id = ? " : sql + "AND rm.scen_id IS NULL ";
        sql = version != null ? sql + "AND rm.version = ? " : sql + "AND rm.version IS NULL ";
        try (PreparedStatement stmt = cn.prepareStatement(sql);){
            Long l;
            block19: {
                ResultSet rs;
                block17: {
                    Long l2;
                    block18: {
                        int index = 0;
                        stmt.setString(++index, name);
                        if (modelId != null) {
                            stmt.setLong(++index, modelId);
                        }
                        if (scenarioId != null) {
                            stmt.setLong(++index, scenarioId);
                        }
                        if (version != null) {
                            stmt.setLong(++index, version);
                        }
                        rs = stmt.executeQuery();
                        try {
                            if (rs.next()) break block17;
                            l2 = null;
                            if (rs == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        rs.close();
                    }
                    return l2;
                }
                l = rs.getLong("id");
                if (rs == null) break block19;
                rs.close();
            }
            return l;
        }
    }

    private Long getNullableLong(ResultSet rs, String name) throws SQLException {
        long result = rs.getLong(name);
        return rs.wasNull() ? null : Long.valueOf(result);
    }

    private void removeMetadataEntries(Connection cn, Long metaId) throws SQLException {
        try (PreparedStatement stmt = cn.prepareStatement("DELETE FROM metadata_entries WHERE meta_id = ?");){
            stmt.setLong(1, metaId);
            stmt.executeUpdate();
        }
    }

    private void removeMetadataEntryWithRefs(Connection conn, Metadata.MetadataEntry<?> entry) throws SQLException, IxException {
        Long metaId = entry.getId();
        if (metaId == null) {
            throw new IxException("Error removing not saved meta indicators");
        }
        PreparedStatement stmt = conn.prepareStatement("DELETE FROM run_meta WHERE meta_id = ?");
        stmt.setLong(1, metaId);
        stmt.executeUpdate();
        this.removeMetadataEntries(conn, metaId);
        stmt = conn.prepareStatement("DELETE FROM metadata WHERE id = ?");
        stmt.setLong(1, metaId);
        stmt.executeUpdate();
    }

    protected void setBooleanParameter(PreparedStatement stmt, int parameterIndex, Boolean value) throws SQLException {
        if (value == null) {
            stmt.setNull(parameterIndex, 16);
        } else {
            stmt.setBoolean(parameterIndex, value);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Metadata saveMetadata(Metadata metadata) throws IxException {
        try (Connection conn = this.getPooledConn();){
            Metadata metadata2;
            try (AutoRollback tm = new AutoRollback(conn);){
                metadata = this.saveMetadata(conn, metadata);
                tm.commit();
                log.debug(String.format("Saved %d meta indicators for scenario %d model %d version %d", metadata.getEntries().size(), metadata.getScenarioId(), metadata.getModelId(), metadata.getVersion()));
                metadata2 = metadata;
            }
            return metadata2;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot save meta indicators", e);
        }
    }

    public Metadata saveMetadata(Connection cn, Metadata metadata) throws IxException, SQLException {
        ArrayList<Metadata.MetadataEntry<? extends Serializable>> updated = new ArrayList<Metadata.MetadataEntry<? extends Serializable>>(metadata.getEntries().size());
        for (Metadata.MetadataEntry<? extends Serializable> entry : metadata.getEntries()) {
            updated.add(this.saveMetadataEntry(cn, entry, metadata.getModelId(), metadata.getScenarioId(), metadata.getVersion()));
        }
        metadata.setEntries(updated);
        log.debug(String.format("Saved %d meta indicators for scenario %d model %d version %d", metadata.getEntries().size(), metadata.getScenarioId(), metadata.getModelId(), metadata.getVersion()));
        return metadata;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<MetadataTypeDTO> getMetadataTypes() throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected PreparedStatement prepareGetMetadataTypeInfo(Connection conn, String type) throws SQLException {
        String sql = "SELECT m.name,        ARRAY(SELECT DISTINCT string_value                FROM metadata m1 INNER JOIN metadata_entries me ON me.meta_id = m1.id         \t     WHERE m1.name = m.name                 AND me.string_value IS NOT NULL               ORDER BY string_value ASC) AS string_values,        ARRAY(SELECT DISTINCT numeric_value                FROM metadata m1 INNER JOIN metadata_entries me ON me.meta_id = m1.id         \t     WHERE m1.name = m.name                 AND me.numeric_value IS NOT NULL               ORDER BY numeric_value ASC) AS numeric_values,        ARRAY(SELECT DISTINCT boolean_value                FROM metadata m1 INNER JOIN metadata_entries me ON me.meta_id = m1.id         \t     WHERE m1.name = m.name                 AND me.boolean_value IS NOT NULL               ORDER BY boolean_value ASC) AS boolean_values,       (SELECT MIN(numeric_value)          FROM metadata m1 INNER JOIN metadata_entries me ON me.meta_id = m1.id         WHERE m1.name = m.name) min_value,       (SELECT MAX(numeric_value)          FROM metadata m1 INNER JOIN metadata_entries me ON me.meta_id = m1.id         WHERE m1.name = m.name) max_value FROM metadata m WHERE m.name = ? GROUP BY m.name";
        PreparedStatement stmt = conn.prepareStatement(sql);
        stmt.setString(1, type);
        return stmt;
    }

    /*
     * Exception decompiling
     */
    @Override
    public MetadataTypeInfoDTO getMetadataTypeInfo(String type) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void removeMetadata(Metadata metadata) throws IxException {
        try (Connection conn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(conn);){
            this.removeMetadata(conn, metadata);
            tm.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot remove meta indicators", e);
        }
    }

    public void removeMetadata(Connection cn, Metadata metadata) throws IxException, SQLException {
        for (Metadata.MetadataEntry<? extends Serializable> entry : metadata.getEntries()) {
            this.removeMetadataEntryWithRefs(cn, entry);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<ScenarioDTO> getScenarioList() throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<ModelDTO> getModelList() throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setNullable(PreparedStatement stmt, int index, Long parameter) throws SQLException {
        if (parameter != null) {
            stmt.setLong(index, parameter);
        } else {
            stmt.setNull(index, -5);
        }
    }

    private Workspace resultToWorkspace(ResultSet rs) throws SQLException {
        Gson gson = new Gson();
        Type listType = new TypeToken<ArrayList<WorkspacePanel>>(){}.getType();
        return new Workspace(rs.getLong("id"), rs.getString("name"), rs.getString("description"), (List)gson.fromJson(rs.getString("panels"), listType), rs.getTimestamp("updated_at").getTime(), rs.getString("updated_by"), WorkspacePublishType.valueOf(rs.getString("publish_type").toUpperCase()), rs.getString("access_token"), rs.getBoolean("has_preview"));
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Workspace> getUserWorkspaces(String user, WorkspacePublishType publishType, String textFilter) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Workspace getWorkspace(Long id) throws IxException {
        Workspace workspace;
        block8: {
            Connection conn = this.getPooledConn();
            try {
                workspace = this.getWorkspace(conn, id);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException ex) {
                    throw this.loggedIxException("Cannot retrieve workspace", ex);
                }
            }
            conn.close();
        }
        return workspace;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Workspace getWorkspace(Connection conn, Long id) throws IxException {
        String sql = "SELECT id, name, description, panels, publish_type, access_token, updated_at, updated_by,       CASE WHEN preview IS NOT NULL THEN 1 ELSE 0 END has_preview FROM workspaces WHERE id = ? ";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            Workspace workspace;
            block15: {
                stmt.setLong(1, id);
                ResultSet rs = stmt.executeQuery();
                try {
                    if (!rs.next()) {
                        throw new IxNotFoundException("Workspace not found");
                    }
                    workspace = this.resultToWorkspace(rs);
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return workspace;
        }
        catch (SQLException ex) {
            throw this.loggedIxException("Cannot retrieve workspace", ex);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Workspace createWorkspace(Workspace workspace, String user) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public Workspace saveWorkspace(Workspace workspace, String user, boolean hasAccess) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void deleteWorkspace(Long id, String user, boolean hasAccess) throws IxException {
        String sql = "DELETE FROM workspaces WHERE id = ? ";
        if (!hasAccess) {
            sql = sql + "AND updated_by = ? ";
        }
        try (Connection conn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(conn);
             PreparedStatement stmt = conn.prepareStatement(sql);){
            stmt.setLong(1, id);
            if (!hasAccess) {
                stmt.setString(2, user);
            }
            if (stmt.executeUpdate() != 1) {
                throw new IxException("Workspace to delete not found");
            }
            tm.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error deleting workspace", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Workspace getWorkspaceByAccessToken(String accessToken) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void saveWorkspacePreview(Long workspaceId, byte[] preview) throws IxException {
        String sql = "UPDATE workspaces SET preview = ? WHERE id = ? ";
        try (Connection conn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(conn);
             PreparedStatement stmt = conn.prepareStatement(sql);){
            String dataURL = "data:image/png;base64," + Base64.encodeBase64String((byte[])preview);
            stmt.setString(1, dataURL);
            stmt.setLong(2, workspaceId);
            if (stmt.executeUpdate() != 1) {
                throw new IxException("Workspace to update not found or no access to target workspace");
            }
            tm.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error updating workspace preview", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] getWorkspacePreview(Long workspaceId) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<DocsItemDTO> getDocumentation(List<String> keys) throws IxException {
        List<DocsItemDTO> list;
        block8: {
            Connection cn = this.getPooledConn();
            try {
                list = this.getDocumentation(cn, keys);
                if (cn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null) {
                        try {
                            cn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw this.loggedIxException("Cannot retrieve documentation", e);
                }
            }
            cn.close();
        }
        return list;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<DocsItemDTO> getDocumentation(Connection cn, List<String> keys) throws IxException {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        if (keys.size() > 1000) {
            throw new IxException("Too many documentation items requested at once (max 1000)");
        }
        String sql = "SELECT key, description FROM documentation WHERE key IN (" + this.getPlaceholders(keys) + ")";
        try (PreparedStatement stmt = cn.prepareStatement(sql);){
            ArrayList<DocsItemDTO> arrayList;
            block18: {
                int index = 0;
                for (String key : keys) {
                    stmt.setString(++index, key);
                }
                ResultSet rs = stmt.executeQuery();
                try {
                    ArrayList<DocsItemDTO> result = new ArrayList<DocsItemDTO>(keys.size());
                    while (rs.next()) {
                        result.add(new DocsItemDTO(rs.getString("key"), rs.getString("description")));
                    }
                    arrayList = result;
                    if (rs == null) break block18;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot retrieve documentation", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<Long, Model> getModels(Connection cn, List<String> names) throws IxException {
        String sql = "SELECT id, name FROM model ";
        if (names != null && !names.isEmpty()) {
            sql = sql + "WHERE name IN (" + this.getPlaceholders(names) + ")";
        }
        try (PreparedStatement stmt = cn.prepareStatement(sql);){
            HashMap<Long, Model> hashMap;
            block18: {
                int index = 0;
                if (names != null) {
                    for (String name : names) {
                        stmt.setString(++index, name);
                    }
                }
                ResultSet rs = stmt.executeQuery();
                try {
                    HashMap<Long, Model> result = new HashMap<Long, Model>(names != null ? names.size() : 0);
                    while (rs.next()) {
                        long id = rs.getLong("id");
                        String name = rs.getString("name");
                        result.put(id, new Model(id, name));
                    }
                    hashMap = result;
                    if (rs == null) break block18;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot get list of model identifiers", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<Long, Scenario> getScenarios(Connection cn, List<String> names) throws IxException {
        String sql = "SELECT id, name FROM scenario ";
        if (names != null && !names.isEmpty()) {
            sql = sql + "WHERE name IN (" + this.getPlaceholders(names) + ")";
        }
        try (PreparedStatement stmt = cn.prepareStatement(sql);){
            HashMap<Long, Scenario> hashMap;
            block18: {
                int index = 0;
                if (names != null) {
                    for (String name : names) {
                        stmt.setString(++index, name);
                    }
                }
                ResultSet rs = stmt.executeQuery();
                try {
                    HashMap<Long, Scenario> result = new HashMap<Long, Scenario>(names != null ? names.size() : 0);
                    while (rs.next()) {
                        long id = rs.getLong("id");
                        String name = rs.getString("name");
                        result.put(id, new Scenario(id, name));
                    }
                    hashMap = result;
                    if (rs == null) break block18;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot get list of scenario identifiers", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<Long, TimeseriesVariable> getAllTimeseriesVariables(Connection cn) throws IxException {
        String sql = "SELECT keyid, keystring, u.name AS unit FROM iamc_key k INNER JOIN ix_unit u ON u.id = k.unitid ";
        try (PreparedStatement stmt = cn.prepareStatement(sql);){
            HashMap<Long, TimeseriesVariable> hashMap;
            block15: {
                ResultSet rs = stmt.executeQuery();
                try {
                    HashMap<Long, TimeseriesVariable> result = new HashMap<Long, TimeseriesVariable>();
                    while (rs.next()) {
                        long id = rs.getLong("keyid");
                        String keystring = rs.getString("keystring");
                        String unit = rs.getString("unit");
                        TimeseriesVariable variable = new TimeseriesVariable(id, keystring, unit);
                        result.put(variable.getId(), variable);
                    }
                    hashMap = result;
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot get list of timeseries variables identifiers", e);
        }
    }

    private Map<Long, TimeseriesVariable> getTimeseriesVariables(Connection cn, List<String> names) throws IxException {
        if (names == null || names.isEmpty()) {
            return this.getAllTimeseriesVariables(cn);
        }
        Partition<String> varsParts = Partition.ofSize(names, 1000);
        HashMap<Long, TimeseriesVariable> result = new HashMap<Long, TimeseriesVariable>();
        for (List list : varsParts) {
            String sql = "SELECT keyid, keystring, u.name AS unit FROM iamc_key k INNER JOIN ix_unit u ON u.id = k.unitid WHERE keystring IN (" + this.getPlaceholders(list) + ")";
            try {
                PreparedStatement stmt = cn.prepareStatement(sql);
                try {
                    int index = 0;
                    for (String name : list) {
                        stmt.setString(++index, name);
                    }
                    ResultSet rs = stmt.executeQuery();
                    try {
                        while (rs.next()) {
                            long id = rs.getLong("keyid");
                            String keystring = rs.getString("keystring");
                            String unit = rs.getString("unit");
                            TimeseriesVariable variable = new TimeseriesVariable(id, keystring, unit);
                            result.put(variable.getId(), variable);
                        }
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                }
            }
            catch (SQLException e) {
                throw this.loggedIxException("Cannot get list of timeseries variables identifiers", e);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<Long, Region> getRegions(Connection cn, List<String> names) throws IxException {
        String sql = "SELECT id, name, hierarchy FROM iamc_nodes WHERE ";
        try (PreparedStatement stmt = this.buildStringInStatement(cn, sql, "name", names, false);){
            HashMap<Long, Region> hashMap;
            block15: {
                ResultSet rs = stmt.executeQuery();
                try {
                    HashMap<Long, Region> result = new HashMap<Long, Region>(names != null ? names.size() : 0);
                    while (rs.next()) {
                        long id = rs.getLong("id");
                        String name = rs.getString("name");
                        String hierarchy = rs.getString("hierarchy");
                        result.put(id, new Region(id, name, hierarchy));
                    }
                    hashMap = result;
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot get list of region identifiers", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<Long, Unit> getUnits(Connection cn, List<String> names) throws IxException {
        String sql = "SELECT id, name FROM ix_unit WHERE ";
        try (PreparedStatement stmt = this.buildStringInStatement(cn, sql, "name", names, false);){
            HashMap<Long, Unit> hashMap;
            block15: {
                ResultSet rs = stmt.executeQuery();
                try {
                    HashMap<Long, Unit> result = new HashMap<Long, Unit>(names != null ? names.size() : 0);
                    while (rs.next()) {
                        long id = rs.getLong("id");
                        String name = rs.getString("name");
                        result.put(id, new Unit(id, name));
                    }
                    hashMap = result;
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot get list of units identifiers", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<DocumentationKey.DocumentationDomain, Map<String, String>> getDocumentation(Map<DocumentationKey.DocumentationDomain, List<String>> filters) throws IxException {
        try (Connection cn = this.getPooledConn();){
            Object requestedMetadata;
            ArrayList<String> keys = new ArrayList<String>();
            Map<Long, Model> modelIdMap = null;
            if (filters.containsKey((Object)DocumentationKey.DocumentationDomain.MODEL)) {
                modelIdMap = this.getModels(cn, filters.get((Object)DocumentationKey.DocumentationDomain.MODEL));
                keys.addAll(modelIdMap.keySet().stream().map(DocumentationKey.DocumentationDomain.MODEL::getKey).collect(Collectors.toList()));
            }
            Map<Long, Scenario> scenarioIdMap = null;
            if (filters.containsKey((Object)DocumentationKey.DocumentationDomain.SCENARIO)) {
                scenarioIdMap = this.getScenarios(cn, filters.get((Object)DocumentationKey.DocumentationDomain.SCENARIO));
                keys.addAll(scenarioIdMap.keySet().stream().map(DocumentationKey.DocumentationDomain.SCENARIO::getKey).collect(Collectors.toList()));
            }
            Map<Long, TimeseriesVariable> timeseriesIdMap = null;
            if (filters.containsKey((Object)DocumentationKey.DocumentationDomain.TIMESERIES)) {
                timeseriesIdMap = this.getTimeseriesVariables(cn, filters.get((Object)DocumentationKey.DocumentationDomain.TIMESERIES));
                keys.addAll(timeseriesIdMap.keySet().stream().map(DocumentationKey.DocumentationDomain.TIMESERIES::getKey).collect(Collectors.toList()));
            }
            Map<Long, Region> regionIdMap = null;
            if (filters.containsKey((Object)DocumentationKey.DocumentationDomain.REGION)) {
                regionIdMap = this.getRegions(cn, filters.get((Object)DocumentationKey.DocumentationDomain.REGION));
                keys.addAll(regionIdMap.keySet().stream().map(DocumentationKey.DocumentationDomain.REGION::getKey).collect(Collectors.toList()));
            }
            if (filters.containsKey((Object)DocumentationKey.DocumentationDomain.METADATA)) {
                requestedMetadata = new HashSet(filters.getOrDefault((Object)DocumentationKey.DocumentationDomain.METADATA, Collections.emptyList()));
                List metadataTypes = this.getMetadataTypes().stream().filter(arg_0 -> DbDAO.lambda$getDocumentation$13((Set)requestedMetadata, arg_0)).collect(Collectors.toList());
                keys.addAll(metadataTypes.stream().map(type -> DocumentationKey.DocumentationDomain.METADATA.getKey(type.getName())).collect(Collectors.toList()));
            }
            if (keys.isEmpty()) {
                requestedMetadata = Collections.emptyMap();
                return requestedMetadata;
            }
            List<DocsItemDTO> docs = this.getDocumentation(cn, keys);
            HashMap<DocumentationKey.DocumentationDomain, Map> result = new HashMap<DocumentationKey.DocumentationDomain, Map>();
            for (DocsItemDTO entry : docs) {
                DocumentationKey key = DocumentationKey.parse(entry.getKey());
                String value = entry.getDescription();
                DocumentationKey.DocumentationDomain domain = key.getDomain();
                Map typeMap = result.computeIfAbsent(domain, ignored -> new HashMap());
                switch (domain) {
                    case MODEL: {
                        typeMap.put(modelIdMap.get(Long.parseLong(key.getId())).getName(), value);
                        break;
                    }
                    case SCENARIO: {
                        typeMap.put(scenarioIdMap.get(Long.parseLong(key.getId())).getName(), value);
                        break;
                    }
                    case TIMESERIES: {
                        typeMap.put(timeseriesIdMap.get(Long.parseLong(key.getId())).getKeystring(), value);
                        break;
                    }
                    case REGION: {
                        typeMap.put(regionIdMap.get(Long.parseLong(key.getId())).getName(), value);
                        break;
                    }
                    case METADATA: {
                        typeMap.put(key.getId(), value);
                        break;
                    }
                }
            }
            HashMap<DocumentationKey.DocumentationDomain, Map> hashMap = result;
            return hashMap;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot get documentation", e);
        }
    }

    private PreparedStatement prepareDeleteDocumentation(Connection conn, List<DocsItemDTO> items) throws SQLException {
        String sql = "DELETE FROM documentation WHERE key = ?";
        PreparedStatement stmt = conn.prepareStatement(sql);
        for (DocsItemDTO item : items) {
            stmt.setString(1, item.getKey());
            stmt.addBatch();
        }
        return stmt;
    }

    private PreparedStatement prepareInsertDocumentation(Connection conn, List<DocsItemDTO> items) throws SQLException {
        String sql = "INSERT INTO documentation(key, description) VALUES(?, ?)";
        PreparedStatement stmt = conn.prepareStatement(sql);
        for (DocsItemDTO item : items) {
            if (item.getDescription() == null) continue;
            stmt.setString(1, item.getKey());
            stmt.setString(2, item.getDescription());
            stmt.addBatch();
        }
        return stmt;
    }

    @Override
    public void setDocumentation(List<DocsItemDTO> items) throws IxException {
        if (items == null || items.isEmpty()) {
            return;
        }
        try (Connection conn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(conn);){
            this.setDocumentation(conn, items);
            tm.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error updating documentation", e);
        }
    }

    private void setDocumentation(Connection cn, List<DocsItemDTO> items) throws IxException {
        if (items == null || items.isEmpty()) {
            return;
        }
        try (PreparedStatement delete = this.prepareDeleteDocumentation(cn, items);
             PreparedStatement insert = this.prepareInsertDocumentation(cn, items);){
            delete.executeBatch();
            if (items.stream().anyMatch(item -> item.getDescription() != null)) {
                insert.executeBatch();
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error updating documentation", e);
        }
    }

    @Override
    public void setDocumentation(Map<DocumentationKey.DocumentationDomain, Map<String, String>> docs) throws IxException {
        try (Connection cn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(cn);){
            ArrayList<DocsItemDTO> items = new ArrayList<DocsItemDTO>();
            if (docs.containsKey((Object)DocumentationKey.DocumentationDomain.MODEL)) {
                Map<String, String> modelDocs = docs.get((Object)DocumentationKey.DocumentationDomain.MODEL);
                Map<Long, Model> modelIdMap = this.getModels(cn, new ArrayList<String>(modelDocs.keySet()));
                if (modelIdMap.size() != modelDocs.size()) {
                    Set foundModelNames = modelIdMap.values().stream().map(Model::getName).collect(Collectors.toSet());
                    String unknownModelNames = modelDocs.keySet().stream().filter(model -> !foundModelNames.contains(model)).collect(Collectors.joining(", "));
                    throw new IxException(String.format("Missing models to update documentation: %s", unknownModelNames));
                }
                items.addAll(modelIdMap.entrySet().stream().map(entry -> new DocsItemDTO(DocumentationKey.DocumentationDomain.MODEL.getKey((Long)entry.getKey()), (String)modelDocs.get(((Model)entry.getValue()).getName()))).collect(Collectors.toList()));
            }
            if (docs.containsKey((Object)DocumentationKey.DocumentationDomain.SCENARIO)) {
                Map<String, String> scenarioDocs = docs.get((Object)DocumentationKey.DocumentationDomain.SCENARIO);
                Map<Long, Scenario> scenarioIdMap = this.getScenarios(cn, new ArrayList<String>(scenarioDocs.keySet()));
                if (scenarioIdMap.size() != scenarioDocs.size()) {
                    throw new IxException("Scenario name is not found to update documentation");
                }
                items.addAll(scenarioIdMap.entrySet().stream().map(entry -> new DocsItemDTO(DocumentationKey.DocumentationDomain.SCENARIO.getKey((Long)entry.getKey()), (String)scenarioDocs.get(((Scenario)entry.getValue()).getName()))).collect(Collectors.toList()));
            }
            if (docs.containsKey((Object)DocumentationKey.DocumentationDomain.TIMESERIES)) {
                Map<String, String> timeseriesDocs = docs.get((Object)DocumentationKey.DocumentationDomain.TIMESERIES);
                Map<Long, TimeseriesVariable> timeseriesIdMap = this.getTimeseriesVariables(cn, new ArrayList<String>(timeseriesDocs.keySet()));
                if (timeseriesIdMap.size() != timeseriesDocs.size()) {
                    throw new IxException("Timeseries variable is not found to update documentation");
                }
                items.addAll(timeseriesIdMap.entrySet().stream().map(entry -> new DocsItemDTO(DocumentationKey.DocumentationDomain.TIMESERIES.getKey((Long)entry.getKey()), (String)timeseriesDocs.get(((TimeseriesVariable)entry.getValue()).getKeystring()))).collect(Collectors.toList()));
            }
            if (docs.containsKey((Object)DocumentationKey.DocumentationDomain.REGION)) {
                Map<String, String> regionDocs = docs.get((Object)DocumentationKey.DocumentationDomain.REGION);
                Map<Long, Region> regionIdMap = this.getRegions(cn, new ArrayList<String>(regionDocs.keySet()));
                if (regionIdMap.size() != regionDocs.size()) {
                    throw new IxException("Region is not found to update documentation");
                }
                items.addAll(regionIdMap.entrySet().stream().map(entry -> new DocsItemDTO(DocumentationKey.DocumentationDomain.REGION.getKey((Long)entry.getKey()), (String)regionDocs.get(((Region)entry.getValue()).getName()))).collect(Collectors.toList()));
            }
            if (docs.containsKey((Object)DocumentationKey.DocumentationDomain.METADATA)) {
                Map metadataDocs = docs.getOrDefault((Object)DocumentationKey.DocumentationDomain.METADATA, Collections.emptyMap());
                List metadataTypes = this.getMetadataTypes().stream().filter(type -> metadataDocs.containsKey(type.getName())).collect(Collectors.toList());
                if (metadataTypes.size() != metadataDocs.size()) {
                    throw new IxException("Meta indicator category is not found to update documentation");
                }
                items.addAll(metadataTypes.stream().map(entry -> new DocsItemDTO(DocumentationKey.DocumentationDomain.METADATA.getKey(entry.getName()), (String)metadataDocs.get(entry.getName()))).collect(Collectors.toList()));
            }
            this.setDocumentation(cn, items);
            tm.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot save documentation", e);
        }
    }

    private PreparedStatement prepareGetRunsTimeseries(Connection conn, List<Long> runIds) throws SQLException {
        String sql = "SELECT DISTINCT        ts.runid,        k.keyid AS id,        k.keystring AS variable,        k.unitid AS unitid,        u.name AS unit FROM iamc_tsinfo ts INNER JOIN iamc_key k ON k.keyid = ts.key INNER JOIN ix_unit u on u.id = k.unitid WHERE ts.runid IN (" + this.getPlaceholders(runIds) + ") ORDER BY ts.runid ASC, k.keystring ASC";
        PreparedStatement stmt = conn.prepareStatement(sql);
        int index = 0;
        for (Long runId : runIds) {
            stmt.setLong(++index, runId);
        }
        log.debug("SQL: " + sql);
        return stmt;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<Long, List<TimeseriesDTO>> getRunsTimeseries(Connection conn, List<Long> runIds) throws IxException {
        try (PreparedStatement stmt = this.prepareGetRunsTimeseries(conn, runIds);){
            HashMap<Long, List<TimeseriesDTO>> hashMap;
            block16: {
                ResultSet rs = stmt.executeQuery();
                try {
                    HashMap<Long, List<TimeseriesDTO>> result = new HashMap<Long, List<TimeseriesDTO>>(runIds.size());
                    Long previousRunId = null;
                    ArrayList<TimeseriesDTO> runTimeseries = null;
                    Map<Long, List<Long>> timeseriesRuns = this.getTimeseriesRuns(conn);
                    Map<Long, List<Long>> timeseriesRegions = this.getTimeseriesRegions(conn);
                    while (rs.next()) {
                        Long runId = rs.getLong("runid");
                        if (previousRunId == null || !Objects.equals(previousRunId, runId)) {
                            previousRunId = runId;
                            runTimeseries = new ArrayList<TimeseriesDTO>();
                            result.put(runId, runTimeseries);
                        }
                        long id = rs.getLong("id");
                        String variable = rs.getString("variable");
                        long unitId = rs.getLong("unitid");
                        String unitName = rs.getString("unit");
                        runTimeseries.add(new TimeseriesDTO(id, variable, unitId, unitName, timeseriesRuns.get(id), timeseriesRegions.get(id)));
                    }
                    hashMap = result;
                    if (rs == null) break block16;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot retrieve run timeseries", e);
        }
    }

    private PreparedStatement prepareGetRunsParameters(Connection conn, List<Long> runIds) throws SQLException {
        String sql = "SELECT p.runid, p.name, p.dim, p.itemid,        pd.idx, pd.idx_set, pd.idx_name FROM ix_par p INNER JOIN ix_par_dim pd ON p.runid = pd.runid AND p.name = pd.name WHERE p.runid IN (" + this.getPlaceholders(runIds) + ") ORDER BY runid ASC, name ASC, idx ASC";
        PreparedStatement stmt = conn.prepareStatement(sql);
        int index = 0;
        for (Long runId : runIds) {
            stmt.setLong(++index, runId);
        }
        log.debug("SQL: " + sql);
        return stmt;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<Long, List<RunParameterDTO>> getRunsParameters(Connection conn, List<Long> runIds) throws IxException {
        try (PreparedStatement stmt = this.prepareGetRunsParameters(conn, runIds);){
            HashMap<Long, List<RunParameterDTO>> hashMap;
            block18: {
                ResultSet rs = stmt.executeQuery();
                try {
                    HashMap<Long, List<RunParameterDTO>> result = new HashMap<Long, List<RunParameterDTO>>(runIds.size());
                    Long previousRunId = null;
                    ArrayList<RunParameterDTO> runParameters = null;
                    RunParameterDTO currentParameter = null;
                    int parameterId = 0;
                    while (rs.next()) {
                        Long runId = rs.getLong("runid");
                        if (previousRunId == null || !Objects.equals(previousRunId, runId)) {
                            previousRunId = runId;
                            runParameters = new ArrayList<RunParameterDTO>();
                            result.put(runId, runParameters);
                        }
                        String name = rs.getString("name");
                        if (currentParameter != null && Objects.equals(currentParameter.getName(), name)) {
                            runParameters.add(currentParameter);
                            currentParameter = null;
                        }
                        if (currentParameter == null) {
                            currentParameter = new RunParameterDTO();
                            currentParameter.setId(++parameterId);
                            currentParameter.setName(name);
                            currentParameter.setSets(new ArrayList<RunparamsSets>());
                        }
                        currentParameter.getSets().add(new RunparamsSets());
                    }
                    hashMap = result;
                    if (rs == null) break block18;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot retrieve run parameters", e);
        }
    }

    @Override
    public List<RunDetailsDTO> getRunsDetails(List<Long> runIds) throws IxException {
        ArrayList<RunDetailsDTO> arrayList;
        block10: {
            if (runIds.isEmpty() || runIds.size() > 1000) {
                log.warn(String.format("Requested details for %d runs", runIds.size()));
                return Collections.emptyList();
            }
            Connection conn = this.getPooledConn();
            try {
                ArrayList<RunDetailsDTO> result = new ArrayList<RunDetailsDTO>();
                Map<Long, List<TimeseriesDTO>> timeseries = this.getRunsTimeseries(conn, runIds);
                Map<Long, List<RunParameterDTO>> parameters = this.getRunsParameters(conn, runIds);
                for (Long id : runIds) {
                    RunDetailsDTO dto = new RunDetailsDTO();
                    dto.setRunId(id);
                    dto.setTimeseries(timeseries.get(id));
                    dto.setParameters(parameters.get(id));
                    result.add(dto);
                }
                arrayList = result;
                if (conn == null) break block10;
            }
            catch (Throwable result) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            result.addSuppressed(throwable);
                        }
                    }
                    throw result;
                }
                catch (SQLException e) {
                    String message = "Cannot retrieve run details";
                    log.error(message, (Throwable)e);
                    throw new IxException(message);
                }
            }
            conn.close();
        }
        return arrayList;
    }

    private Map<Long, List<Long>> getTimeseriesRuns(Connection conn) throws SQLException {
        String sql = "SELECT t.key, t.runid FROM (SELECT DISTINCT t.key, t.runid FROM iamc_tsinfo t) t ORDER BY t.key ASC, t.runid ASC";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            HashMap<Long, List<Long>> hashMap;
            block16: {
                ResultSet rs = stmt.executeQuery();
                try {
                    rs.setFetchSize(1000);
                    HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>();
                    Long prevKey = null;
                    ArrayList<Long> runs = null;
                    while (rs.next()) {
                        Long key = rs.getLong("key");
                        Long runId = rs.getLong("runid");
                        if (!key.equals(prevKey)) {
                            if (prevKey != null) {
                                result.put(prevKey, (List<Long>)runs);
                            }
                            prevKey = key;
                            runs = new ArrayList<Long>();
                        }
                        runs.add(runId);
                    }
                    if (prevKey != null) {
                        result.put(prevKey, runs);
                    }
                    hashMap = result;
                    if (rs == null) break block16;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashMap;
        }
    }

    private Map<Long, List<Long>> getTimeseriesRegions(Connection conn) throws SQLException {
        String sql = "SELECT t.key, t.node FROM (SELECT DISTINCT t.key, t.node FROM iamc_tsinfo t) t ORDER BY t.key ASC, t.node ASC";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            HashMap<Long, List<Long>> hashMap;
            block16: {
                ResultSet rs = stmt.executeQuery();
                try {
                    rs.setFetchSize(1000);
                    HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>();
                    Long prevKey = null;
                    ArrayList<Long> runs = null;
                    while (rs.next()) {
                        Long key = rs.getLong("key");
                        Long node = rs.getLong("node");
                        if (!key.equals(prevKey)) {
                            if (prevKey != null) {
                                result.put(prevKey, (List<Long>)runs);
                            }
                            prevKey = key;
                            runs = new ArrayList<Long>();
                        }
                        runs.add(node);
                    }
                    if (prevKey != null) {
                        result.put(prevKey, runs);
                    }
                    hashMap = result;
                    if (rs == null) break block16;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashMap;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<TimeseriesDTO> getTimeseries() throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<String, List<Long>> getParametersRuns(Connection conn, List<Long> runIds) throws IxException {
        String sql = "SELECT name, runid FROM ix_par_dim pd " + (runIds.isEmpty() ? "" : "WHERE runid IN (" + this.getPlaceholders(runIds) + ") ") + "GROUP by name, runid ORDER BY name ASC";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            HashMap<String, List<Long>> hashMap;
            block19: {
                int i = 0;
                for (Long id : runIds) {
                    stmt.setLong(++i, id);
                }
                ResultSet rs = stmt.executeQuery();
                try {
                    HashMap<String, List<Long>> result = new HashMap<String, List<Long>>();
                    String prevName = null;
                    HashSet<Long> paramRunIds = null;
                    while (rs.next()) {
                        String name = rs.getString("name");
                        Long runId = rs.getLong("runid");
                        if (name == null || !name.equals(prevName)) {
                            if (prevName != null) {
                                result.put(prevName, new ArrayList(paramRunIds));
                            }
                            paramRunIds = new HashSet<Long>();
                            prevName = name;
                        }
                        paramRunIds.add(runId);
                    }
                    if (prevName != null) {
                        result.put(prevName, new ArrayList(paramRunIds));
                    }
                    hashMap = result;
                    if (rs == null) break block19;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot retrieve runs parameters (runs)", e);
        }
    }

    private <T> String getPlaceholders(Collection<T> list) {
        return list.stream().map(id -> "?").collect(Collectors.joining(","));
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<ParameterDTO> getParameters(List<Long> runIds) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public String createFile(InputStream stream, String filename, String description, String user, String contentType) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public FileDTO updateFileDetails(String filename, String description, String author) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void deleteFile(String user, String filename) throws IxException {
        String sql = "DELETE FROM files WHERE author = ? AND filename = ? ";
        try (Connection cn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(cn);
             PreparedStatement stmt = cn.prepareStatement(sql);){
            stmt.setString(1, user);
            stmt.setString(2, filename);
            if (stmt.executeUpdate() != 1) {
                throw new IxException("Cannot delete file");
            }
            tm.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot delete file", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<FileDTO> getFilesList(boolean includePublic, boolean includePrivate) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public FileDTO getFile(String filename) throws IxException {
        FileDTO fileDTO;
        block8: {
            Connection cn = this.getPooledConn();
            try {
                fileDTO = this.getFile(cn, filename);
                if (cn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null) {
                        try {
                            cn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw this.loggedIxException("Cannot get file", e);
                }
            }
            cn.close();
        }
        return fileDTO;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private FileDTO getFile(Connection cn, String filename) throws IxException {
        String sql = "SELECT description, filesize, sort_order, content_type, author, created_at FROM files d WHERE d.filename = ?";
        try (PreparedStatement stmt = cn.prepareStatement(sql);){
            FileDTO fileDTO;
            block15: {
                stmt.setString(1, filename);
                ResultSet rs = stmt.executeQuery();
                try {
                    ArrayList result = new ArrayList();
                    if (!rs.next()) {
                        throw new IxNotFoundException("File not found");
                    }
                    String description = rs.getString("description");
                    long filesize = rs.getLong("filesize");
                    long sortOrder = rs.getLong("sort_order");
                    String contentType = rs.getString("content_type");
                    String author = rs.getString("author");
                    Date createdAt = rs.getDate("created_at");
                    fileDTO = new FileDTO(filename, description, sortOrder, filesize, contentType, author, createdAt.getTime());
                    if (rs == null) break block15;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return fileDTO;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot get file", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public FileContent getFileContent(String filename) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void makeFilePublic(String filename) throws IxException {
        String sql = "UPDATE files SET author = NULL WHERE filename = ? ";
        try (Connection cn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(cn);
             PreparedStatement stmt = cn.prepareStatement("UPDATE files SET author = NULL WHERE filename = ? ");){
            stmt.setString(1, filename);
            if (stmt.executeUpdate() != 1) {
                throw new IxException("Cannot make file public");
            }
            FileDTO updated = this.getFile(cn, filename);
            tm.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot make file public", e);
        }
    }

    private String getStringWithDefault(ResultSet rs, String columnLabel, String defaultValue) throws SQLException {
        String value = rs.getString(columnLabel);
        return rs.wasNull() ? defaultValue : value;
    }

    @Override
    public void audit(String action, String username, String text) throws IxException {
        String sql = "INSERT INTO downloads_audit (action, username, text) VALUES (?, ?, ?)";
        try (Connection cn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(cn);
             PreparedStatement stmt = cn.prepareStatement(sql);){
            stmt.setString(1, action);
            stmt.setString(2, username);
            stmt.setString(3, text);
            if (stmt.executeUpdate() != 1) {
                throw new IxException("Cannot put audit entry");
            }
            tm.commit();
        }
        catch (SQLException e) {
            throw new IxException("Cannot get download");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, Long> getAppDownloadsStats(Long from, Long to) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<DatasetDTO> getDatasets(DatasetsFilterDTO filter) throws IxException {
        if (filter.getRuns() == null || filter.getRuns().length == 0) {
            throw new IxException("Missing list of runs");
        }
        if (filter.getSources() == null || filter.getSources().size() == 0) {
            return Collections.emptyList();
        }
        List<Long> runIds = Arrays.asList(filter.getRuns());
        HashMap filtersByType = new HashMap();
        filter.getSources().forEach((key, value) -> {
            DatasetType type = value.getType();
            filtersByType.computeIfAbsent(type, ignore -> new HashMap()).put(key, value);
        });
        ArrayList<DatasetDTO> result = new ArrayList<DatasetDTO>();
        for (DatasetType type : filtersByType.keySet()) {
            result.addAll(this.getDatasetsData(type, runIds, (Map)filtersByType.get((Object)type)));
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private List<DatasetDTO> getGeoData(List<Long> runIds, Map<String, SourceFilter> filters) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<DatasetDTO> getDatasetsData(DatasetType type, List<Long> runIds, Map<String, SourceFilter> filters) throws IxException {
        switch (type) {
            case SET: 
            case PARAMETER: 
            case VARIABLE: 
            case EQUATION: {
                return this.getSymbolData(type, runIds, filters);
            }
            case TIMESERIES: {
                return this.getTimeseriesData(runIds, filters);
            }
            case LAYER: {
                return this.getGeoData(runIds, filters);
            }
            case METADATA: {
                return this.convertMetadataToDatasets(this.getMetadata(runIds));
            }
        }
        throw new IxException(String.format("Dataset type is not supported: %s", new Object[]{type}));
    }

    private List<DatasetDTO> convertMetadataToDatasets(List<Metadata> metadata) throws IxException {
        return metadata.stream().map(m -> {
            DatasetDTO dto = new DatasetDTO();
            dto.setRunId(m.getRunId());
            dto.setType(DatasetType.METADATA);
            dto.setSource(DatasetType.METADATA.name());
            HashMap keys = new HashMap();
            List<Object[]> entries = m.getEntries().stream().map(entry -> {
                String name = entry.getName();
                Object value = entry.getValue();
                keys.putIfAbsent(name, keys.size());
                return new Object[]{keys.get(name), value};
            }).collect(Collectors.toList());
            dto.setDims(new String[]{"name"});
            dto.setEntries(entries);
            dto.setKeys(keys.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)));
            return dto;
        }).collect(Collectors.toList());
    }

    /*
     * Exception decompiling
     */
    private List<DatasetDTO> getSymbolData(DatasetType type, List<Long> runIds, Map<String, SourceFilter> filters) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private List<DatasetDTO> getTimeseriesData(List<Long> runIds, Map<String, SourceFilter> filters) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<DatasetDefinitionDTO> getDatasetsDefinitions(DatasetsFilterDTO filter) throws IxException {
        ArrayList<DatasetDefinitionDTO> arrayList;
        block11: {
            List<Long> runIds = filter.getRuns() == null ? Collections.emptyList() : Arrays.asList(filter.getRuns());
            HashMap filtersByType = new HashMap();
            if (filter.getSources() != null && !filter.getSources().isEmpty()) {
                filter.getSources().forEach((key, value) -> {
                    DatasetType type = value.getType();
                    filtersByType.computeIfAbsent(type, ignore -> new HashMap()).put(key, value);
                });
            } else {
                Arrays.asList(DatasetType.values()).forEach(type -> filtersByType.put(type, Collections.emptyMap()));
            }
            Connection conn = this.getPooledConn();
            try {
                ArrayList<DatasetDefinitionDTO> result = new ArrayList<DatasetDefinitionDTO>();
                for (DatasetType type2 : filtersByType.keySet()) {
                    Map typeFilter = (Map)filtersByType.get((Object)type2);
                    log.debug(String.format("Getting %s symbols using filters: %s", new Object[]{type2, typeFilter}));
                    long start = System.currentTimeMillis();
                    result.addAll(this.getSymbols(conn, type2, runIds, typeFilter));
                    log.debug(String.format("Took %d ms", System.currentTimeMillis() - start));
                }
                arrayList = result;
                if (conn == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw this.loggedIxException("Cannot get datasets definitions", e);
                }
            }
            conn.close();
        }
        return arrayList;
    }

    @Override
    public void removeScenarioFromDB(long runId) throws IxException {
        String sql = "DELETE FROM run WHERE id = ?";
        try (Connection cn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(cn);
             PreparedStatement stmt = cn.prepareStatement(sql);){
            stmt.setLong(1, runId);
            int cnt = stmt.executeUpdate();
            if (cnt != 1) {
                throw new IxException(String.format("Unexpected number of runs to remove from database: %d", cnt));
            }
            tm.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot remove Scenario from database", e);
        }
    }

    @Override
    public void addLayersToDB(Connection cn, int runId, String keyString, String unitName, String nodeName, String time, int meta, Map<Integer, String> yearlyData) throws IxException {
        if (yearlyData.isEmpty()) {
            return;
        }
        String sql = "INSERT INTO iamc_tsgeodata(tsid, year, layerinfo) VALUES (?, ?, ?)";
        try (PreparedStatement stmt = cn.prepareStatement(sql);){
            int[] batch;
            Long tsId = this.getOrCreateTsId(cn, runId, keyString, unitName, nodeName, time, meta);
            for (Map.Entry<Integer, String> entry : yearlyData.entrySet()) {
                Integer year = entry.getKey();
                String layerInfo = entry.getValue();
                stmt.setLong(1, tsId);
                stmt.setInt(2, year);
                stmt.setString(3, layerInfo);
                stmt.addBatch();
            }
            for (int i : batch = stmt.executeBatch()) {
                if (i == 1) continue;
                throw new IxException("Not all geo data added to " + keyString);
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot add geo data", e);
        }
    }

    private Long getOrCreateTsId(Connection cn, int runId, String keyString, String unitName, String nodeName, String time, int meta) throws SQLException, IxException {
        Long tsId = this.getTsId(cn, runId, keyString, unitName, nodeName, time, meta);
        if (tsId != null) {
            return tsId;
        }
        return this.createTsInfo(cn, runId, keyString, unitName, nodeName, time, meta);
    }

    /*
     * Exception decompiling
     */
    private Long createTsInfo(Connection cn, int runId, String keyString, String unitName, String nodeName, String time, int meta) throws SQLException, IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PreparedStatement prepareGetTsId(Connection cn, int runId, String keyString, String unitName, String nodeName, String time, int meta) throws SQLException {
        String sql = "SELECT tsid FROM iamc_tsinfo ti INNER JOIN iamc_key k ON k.keyid = ti.key INNER JOIN iamc_nodes n ON n.id = ti.node INNER JOIN iamc_timeslices ts ON ts.id = ti.time WHERE ti.runid = ? AND k.keystring = ? AND n.name = ? AND ts.name = ?AND ti.meta = ? ";
        PreparedStatement stmt = cn.prepareStatement(sql);
        stmt.setInt(1, runId);
        stmt.setString(2, keyString);
        stmt.setString(3, nodeName);
        stmt.setString(4, time);
        stmt.setInt(5, meta);
        return stmt;
    }

    private Long getTsId(Connection cn, int runId, String keyString, String unitName, String nodeName, String time, int meta) throws SQLException {
        try (PreparedStatement stmt = this.prepareGetTsId(cn, runId, keyString, unitName, nodeName, time, meta);){
            Long l;
            block12: {
                ResultSet rs = stmt.executeQuery();
                try {
                    Long l2 = l = rs.next() ? Long.valueOf(rs.getLong("tsid")) : null;
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return l;
        }
    }

    @Override
    public void updateLayersInDB(Connection cn, int runId, String keyString, String unitName, String nodeName, String time, int meta, Map<Integer, String> yearlyData) throws IxException {
        if (yearlyData.isEmpty()) {
            return;
        }
        String sql = "UPDATE iamc_tsgeodata SET layerinfo = ? WHERE tsid = ? AND year = ?";
        try (PreparedStatement stmt = cn.prepareStatement(sql);){
            Long tsId = this.getOrCreateTsId(cn, runId, keyString, unitName, nodeName, time, meta);
            for (Map.Entry<Integer, String> entry : yearlyData.entrySet()) {
                Integer year = entry.getKey();
                String layerInfo = entry.getValue();
                stmt.setString(1, layerInfo);
                stmt.setLong(2, tsId);
                stmt.setInt(3, year);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot update geo data", e);
        }
    }

    @Override
    public void removeLayersFromDB(Connection cn, int runId, String keyString, String unitName, String nodeName, String time, int meta, Set<Integer> years) throws IxException {
        if (years.isEmpty()) {
            return;
        }
        String sql = "DELETE FROM iamc_tsgeodata WHERE tsid = ? AND year = ?";
        try (PreparedStatement stmt = cn.prepareStatement(sql);){
            Long tsId = this.getOrCreateTsId(cn, runId, keyString, unitName, nodeName, time, meta);
            for (Integer year : years) {
                stmt.setLong(1, tsId);
                stmt.setInt(2, year);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot remove geo data", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<DatasetDefinitionDTO> getSymbols(Connection conn, DatasetType type, List<Long> runIds, Map<String, SourceFilter> typeFilter) throws IxException {
        String subquery;
        switch (type) {
            case TIMESERIES: {
                subquery = "SELECT keystring AS name, runid FROM iamc_key k INNER JOIN iamc_tsinfo ti ON ti.key = k.keyid WHERE EXISTS (SELECT tsid FROM iamc_tsdata d WHERE d.tsid = ti.tsid) ";
                break;
            }
            case LAYER: {
                subquery = "SELECT k.keystring AS name, ti.runid FROM iamc_key k INNER JOIN iamc_tsinfo ti ON ti.key = k.keyid WHERE EXISTS (SELECT tsid FROM iamc_tsgeodata g WHERE g.tsid = ti.tsid) ";
                break;
            }
            case METADATA: {
                subquery = "SELECT DISTINCT 'metadata' AS name, r.id AS runid FROM run_meta m INNER JOIN run r   ON (r.scen_id = m.scen_id OR m.scen_id IS NULL)   AND (r.model_id = m.model_id OR m.model_id IS NULL)   AND (r.version = m.version OR m.version IS NULL) ";
                break;
            }
            default: {
                subquery = "SELECT name, runid FROM ix_" + type.getDbTablePrefix() + " pd ";
            }
        }
        String sql = "SELECT * FROM (" + subquery + ") t WHERE 1=1 ";
        if (!runIds.isEmpty()) {
            sql = sql + "AND runid IN (" + this.getPlaceholders(runIds) + ") ";
        }
        if (!(typeFilter.isEmpty() || typeFilter.size() <= 1 && typeFilter.containsKey(ALL_SYMBOLS))) {
            sql = sql + "AND name IN (" + this.getPlaceholders(typeFilter.keySet()) + ") ";
        }
        sql = sql + "GROUP BY name, runid ORDER BY name ASC, runid ASC";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            ArrayList<DatasetDefinitionDTO> arrayList;
            block28: {
                int idx = 0;
                for (Long id : runIds) {
                    stmt.setLong(++idx, id);
                }
                if (typeFilter.size() > 1 || !typeFilter.containsKey(ALL_SYMBOLS)) {
                    for (String paramName : typeFilter.keySet()) {
                        stmt.setString(++idx, paramName);
                    }
                }
                ResultSet rs = stmt.executeQuery();
                try {
                    ArrayList<DatasetDefinitionDTO> result = new ArrayList<DatasetDefinitionDTO>();
                    String prevName = null;
                    ArrayList<Long> runList = null;
                    while (rs.next()) {
                        String name = rs.getString("name");
                        Long runId = rs.getLong("runid");
                        if (name == null || !name.equals(prevName)) {
                            if (prevName != null) {
                                result.add(new DatasetDefinitionDTO(prevName, type, runList.toArray(new Long[0])));
                            }
                            prevName = name;
                            runList = new ArrayList<Long>();
                        }
                        runList.add(runId);
                    }
                    if (prevName != null) {
                        result.add(new DatasetDefinitionDTO(prevName, type, runList.toArray(new Long[0])));
                    }
                    arrayList = result;
                    if (rs == null) break block28;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot retrieve runs parameters", e);
        }
    }

    private static Element objectToElement(Object obj) {
        if (obj instanceof IXelement) {
            return new Element((IXelement)obj);
        }
        return (Element)obj;
    }

    private static List<Element> objectToElements(Object obj) throws IxException {
        if (obj instanceof List) {
            return ((List)obj).stream().map(DbDAO::objectToElement).collect(Collectors.toList());
        }
        throw new IxException("Cannot read element from DB");
    }

    Object readObject(InputStream input, String message) throws IxException {
        Object object;
        ObjectInputStream stream = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(input), 0x100000));
        try {
            object = stream.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw this.loggedIxException(message, e);
            }
        }
        stream.close();
        return object;
    }

    List<Element> readElementFromBlob(InputStream stream) throws IxException {
        return DbDAO.objectToElements(this.readObject(stream, "Cannot read element from DB"));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<Long, Map<Integer, String>> getRunsKeys(Connection conn, List<Long> runIds) throws IxException {
        String sql = "SELECT runid, keyid, key FROM ix_key WHERE runid IN (" + this.getPlaceholders(runIds) + ") ORDER BY runid ASC";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            HashMap<Long, Map<Integer, String>> hashMap;
            block19: {
                int i = 0;
                for (Long runId : runIds) {
                    stmt.setLong(++i, runId);
                }
                ResultSet rs = stmt.executeQuery();
                try {
                    HashMap<Long, Map<Integer, String>> result = new HashMap<Long, Map<Integer, String>>();
                    Long prevRunId = null;
                    HashMap<Integer, String> keyMap = null;
                    while (rs.next()) {
                        Long runId = rs.getLong("runid");
                        Integer keyId = rs.getInt("keyid");
                        String keyString = rs.getString("key");
                        if (!runId.equals(prevRunId)) {
                            if (prevRunId != null) {
                                result.put(prevRunId, (Map<Integer, String>)keyMap);
                            }
                            keyMap = new HashMap<Integer, String>();
                            prevRunId = runId;
                        }
                        keyMap.put(keyId, keyString);
                    }
                    if (prevRunId != null) {
                        result.put(prevRunId, keyMap);
                    }
                    hashMap = result;
                    if (rs == null) break block19;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot get key id list", e);
        }
    }

    private Map<Long, Map<String, String[]>> getRunsSymbolsDims(Connection conn, DatasetType type, Map<Long, String[]> filter) throws SQLException {
        String sql = "SELECT runid, name, idx, idx_set, idx_name FROM ix_" + type.getDbTablePrefix() + "_dim WHERE runid IN (" + this.getPlaceholders(filter.keySet()) + ") ORDER BY runid ASC, name ASC, idx ASC";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            HashMap<Long, Map<String, String[]>> hashMap;
            block20: {
                int index = 0;
                for (Long id : filter.keySet()) {
                    stmt.setLong(++index, id);
                }
                ResultSet rs = stmt.executeQuery();
                try {
                    HashMap<Long, Map<String, String[]>> result = new HashMap<Long, Map<String, String[]>>();
                    Long prevRunId = null;
                    String prevName = null;
                    HashMap<String, String[]> paramDims = null;
                    ArrayList<String> dims = null;
                    HashSet<String> runSymbols = null;
                    while (rs.next()) {
                        Long runId = rs.getLong("runid");
                        String name = rs.getString("name");
                        if (!runId.equals(prevRunId) || !name.equals(prevName)) {
                            if (prevName != null && runSymbols.contains(prevName)) {
                                paramDims.put(prevName, dims.toArray(new String[0]));
                            }
                            dims = new ArrayList<String>();
                            prevName = name;
                        }
                        if (!runId.equals(prevRunId)) {
                            if (prevRunId != null) {
                                result.put(prevRunId, (Map<String, String[]>)paramDims);
                            }
                            paramDims = new HashMap<String, String[]>();
                            runSymbols = new HashSet<String>(Arrays.asList(filter.get(runId)));
                            prevRunId = runId;
                        }
                        String dim = rs.getString("idx_name");
                        dims.add(dim);
                    }
                    if (prevName != null && runSymbols.contains(prevName)) {
                        paramDims.put(prevName, dims.toArray(new String[0]));
                    }
                    if (prevRunId != null) {
                        result.put(prevRunId, paramDims);
                    }
                    hashMap = result;
                    if (rs == null) break block20;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return hashMap;
        }
    }

    void setBinaryDoubleValue(PreparedStatement stmt, int index, Double value) throws SQLException {
        if (value != null) {
            stmt.setDouble(index, value);
        } else {
            stmt.setNull(index, 8);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<List<Integer>, Integer> saveTimeseriesToDB(Connection conn, Map<List<Integer>, Map<Integer, Double>> tsMap, int runId) throws IxException {
        String insertInfo = "INSERT INTO iamc_tsinfo (tsid, runid, node, key, meta, time) VALUES (?, ?, ?, ?, ?, ?)";
        String insertData = "INSERT INTO iamc_tsdata (tsid, year, value) VALUES (?, ?, ?)";
        try (PreparedStatement infoStmt = conn.prepareStatement(insertInfo);){
            Map<List<Integer>, Integer> map;
            block23: {
                PreparedStatement dataStmt = conn.prepareStatement(insertData);
                try {
                    Map<List<Integer>, Integer> tsInfo = this.getTsInfoFromDB(conn, runId);
                    int batchInfo = 0;
                    int batchData = 0;
                    for (Map.Entry<List<Integer>, Map<Integer, Double>> aTs : tsMap.entrySet()) {
                        int tsId;
                        try {
                            tsId = tsInfo.get(aTs.getKey());
                        }
                        catch (NullPointerException e) {
                            tsId = this.getNextId(conn, "IAMC_TS").intValue();
                            infoStmt.setInt(1, tsId);
                            infoStmt.setInt(2, runId);
                            infoStmt.setInt(3, aTs.getKey().get(0));
                            infoStmt.setInt(4, aTs.getKey().get(1));
                            infoStmt.setInt(5, aTs.getKey().get(2));
                            if (aTs.getKey().size() > 3) {
                                infoStmt.setInt(6, aTs.getKey().get(3));
                            } else {
                                infoStmt.setInt(6, -1);
                            }
                            infoStmt.addBatch();
                            ++batchInfo;
                            tsInfo.put(aTs.getKey(), tsId);
                        }
                        for (Map.Entry<Integer, Double> data : aTs.getValue().entrySet()) {
                            dataStmt.setInt(1, tsId);
                            dataStmt.setInt(2, data.getKey());
                            this.setBinaryDoubleValue(dataStmt, 3, data.getValue());
                            dataStmt.addBatch();
                            ++batchData;
                        }
                        if (batchInfo < 1000 && batchData < 1000) continue;
                        if (batchInfo > 0) {
                            infoStmt.executeBatch();
                            batchInfo = 0;
                        }
                        if (batchData <= 0) continue;
                        dataStmt.executeBatch();
                        batchData = 0;
                    }
                    if (batchInfo > 0) {
                        infoStmt.executeBatch();
                    }
                    if (batchData > 0) {
                        dataStmt.executeBatch();
                    }
                    map = tsInfo;
                    if (dataStmt == null) break block23;
                }
                catch (Throwable throwable) {
                    if (dataStmt != null) {
                        try {
                            dataStmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                dataStmt.close();
            }
            return map;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Error writing the timeseries data to the IXMP database!", e);
        }
    }

    @Override
    public void writeChangeLog(Connection conn, int annotationId, List<ChangelogEntry> changeLogList, int runId) throws IxException {
        String sql = "INSERT INTO change_log (annotationid, runid, operation, item, key, val_prev, val_new) VALUES (?, ?, ?, ?, ?, ?, ?)";
        try (PreparedStatement stmt = conn.prepareStatement(sql);){
            int batches = 0;
            for (ChangelogEntry entry : changeLogList) {
                stmt.setInt(1, annotationId);
                stmt.setInt(2, runId);
                stmt.setString(3, entry.getOperation());
                stmt.setString(4, entry.getItem());
                if (entry.getKey() != null) {
                    stmt.setString(5, entry.getKey());
                } else {
                    stmt.setNull(5, 12);
                }
                this.setBinaryDoubleValue(stmt, 6, entry.getValPrev());
                this.setBinaryDoubleValue(stmt, 7, entry.getValNew());
                stmt.addBatch();
                if (++batches < 1000) continue;
                stmt.executeBatch();
                batches = 0;
            }
            if (batches > 0) {
                stmt.executeBatch();
            }
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot write change log!", e);
        }
    }

    @Override
    public List<RunInfoDTO> getRunsInfo(List<Long> runIds) throws IxException {
        List<RunInfoDTO> list;
        block8: {
            Connection cn = this.getPooledConn();
            try {
                list = this.getRunsInfo(cn, runIds, false);
                if (cn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cn != null) {
                        try {
                            cn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw this.loggedIxException("Cannot get runs info", e);
                }
            }
            cn.close();
        }
        return list;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<RunInfoDTO> getRunsInfo(Connection cn, List<Long> runIds, boolean getAllIfRunsEmpty) throws IxException {
        if (!getAllIfRunsEmpty && (runIds == null || runIds.isEmpty())) {
            return Collections.emptyList();
        }
        String sql = "SELECT r.id,        m.id AS model_id,        m.name AS model_name,        s.id AS scenario_id,        s.name AS scenario_name,        CASE WHEN rd.id IS NULL THEN 0 ELSE 1 END AS is_default,       r.version  FROM run r INNER JOIN model m ON m.id = r.model_id INNER JOIN scenario s ON s.id  = r.scen_id LEFT OUTER JOIN run_default rd ON rd.id = r.id WHERE " + this.buildInClause("r.id", runIds, getAllIfRunsEmpty) + " ";
        try (PreparedStatement stmt = cn.prepareStatement(sql);){
            ArrayList<RunInfoDTO> arrayList;
            block16: {
                ResultSet rs = stmt.executeQuery();
                try {
                    ArrayList<RunInfoDTO> result = new ArrayList<RunInfoDTO>();
                    while (rs.next()) {
                        result.add(new RunInfoDTO(rs.getLong("id"), new ModelDTO(rs.getInt("model_id"), rs.getString("model_name")), new ScenarioDTO(rs.getInt("scenario_id"), rs.getString("scenario_name")), rs.getInt("version"), rs.getBoolean("is_default")));
                    }
                    arrayList = result;
                    if (rs == null) break block16;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return arrayList;
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot get runs info", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<JobDTO> listJobs(JobDTO.JobStatus jobStatus, Long since, Long till) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public JobDTO createJob(JobDTO job) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void startJob(Long jobId) throws IxException {
        String sql = "UPDATE job_queue SET status = ?, started_at = ? WHERE id = ? AND status = ? ";
        try (Connection cn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(cn);
             PreparedStatement stmt = cn.prepareStatement(sql);){
            stmt.setString(1, JobDTO.JobStatus.STARTED.name());
            stmt.setDate(2, new Date(System.currentTimeMillis()));
            stmt.setLong(3, jobId);
            stmt.setString(4, JobDTO.JobStatus.CREATED.name());
            if (stmt.executeUpdate() != 1) {
                throw new IxException("Cannot update job status");
            }
            tm.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot update job status", e);
        }
    }

    @Override
    public void finishJob(Long jobId, Map<String, Object> result) throws IxException {
        String sql = "UPDATE job_queue SET status = ?, finished_at = ?, result = ? WHERE id = ? AND status = ? ";
        try (Connection cn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(cn);
             PreparedStatement stmt = cn.prepareStatement(sql);){
            stmt.setString(1, JobDTO.JobStatus.FINISHED.name());
            stmt.setDate(2, new Date(System.currentTimeMillis()));
            stmt.setString(3, JobDTO.getResultAsJson(result));
            stmt.setLong(4, jobId);
            stmt.setString(5, JobDTO.JobStatus.STARTED.name());
            if (stmt.executeUpdate() != 1) {
                throw new IxException("Cannot update job status");
            }
            tm.commit();
        }
        catch (JsonProcessingException | SQLException e) {
            throw this.loggedIxException("Cannot update job status", e);
        }
    }

    @Override
    public void deleteJob(Long jobId) throws IxException {
        String sql = "UPDATE job_queue SET status = ? WHERE id = ?";
        try (Connection cn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(cn);
             PreparedStatement stmt = cn.prepareStatement(sql);){
            stmt.setString(1, JobDTO.JobStatus.DELETED.name());
            stmt.setLong(2, jobId);
            if (stmt.executeUpdate() != 1) {
                throw new IxException("Cannot update job status");
            }
            tm.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot update job status", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public JobDTO getJob(Long jobId) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void updateJobLog(Long jobId, String log) throws IxException {
        String deleteSQL = "DELETE FROM job_logs WHERE job_id = ?";
        String insertSQL = "INSERT INTO job_logs(job_id, log) VALUES(?, ?)";
        try (Connection cn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(cn);
             PreparedStatement delete = cn.prepareStatement(deleteSQL);
             PreparedStatement insert = cn.prepareStatement(insertSQL);){
            delete.setLong(1, jobId);
            delete.executeUpdate();
            insert.setLong(1, jobId);
            insert.setString(2, log);
            if (insert.executeUpdate() != 1) {
                throw new IxException("Cannot update job log");
            }
            tm.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot update job log", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getJobLog(Long jobId) throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void exportTimeseriesData(List<Long> runIds, List<String> variables, List<String> units, List<String> regions, String filename) throws IxException {
        this.exportTimeseriesData(runIds, variables, units, regions, filename, false);
    }

    @Override
    public void exportTimeseriesData(List<Long> runIds, List<String> variables, List<String> units, List<String> regions, String filename, boolean exportAllIfRunsEmpty) throws IxException {
        try (Connection cn = this.getPooledConn();
             BufferedWriter out = Files.newBufferedWriter(Paths.get(filename, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
             CSVPrinter printer = new CSVPrinter((Appendable)out, CSVFormat.DEFAULT.withHeader(TS_CSV_COLS));){
            Set<Long> variableIds = this.getTimeseriesVariables(cn, variables).keySet();
            Set<Long> regionIds = this.getRegions(cn, regions).keySet();
            Set<Long> unitIds = this.getUnits(cn, units).keySet();
            List<RunInfoDTO> runsInfo = this.getRunsInfo(cn, runIds, exportAllIfRunsEmpty);
            Map<String, List<RunInfoDTO>> byModel = runsInfo.stream().collect(Collectors.groupingBy(p -> p.getModel().getName()));
            int i = 0;
            int modelsCount = byModel.size();
            for (Map.Entry<String, List<RunInfoDTO>> entry : byModel.entrySet()) {
                List modelRunIds = entry.getValue().stream().map(RunInfoDTO::getRunId).collect(Collectors.toList());
                log.debug(String.format("Processing %s model (%d of %d, %d scenario versions)...", entry.getKey(), ++i, modelsCount, modelRunIds.size()));
                String sql = "SELECT m.name AS model,        s.name AS scenario,        r.version,        k.keystring AS variable,        u.name AS unit,        n.name AS region,        i.meta, \t\tt.name AS subannual, \t\td.year, \t\td.value FROM iamc_tsinfo i INNER JOIN iamc_tsdata d ON (i.tsid = d.tsid) INNER JOIN iamc_key k ON k.keyid = i.key INNER JOIN ix_unit u ON u.id = k.unitid INNER JOIN iamc_nodes n ON n.id = i.node INNER JOIN iamc_timeslices t ON t.id = i.time INNER JOIN run r ON r.id = i.runid INNER JOIN model m ON m.id = r.model_id INNER JOIN scenario s ON s.id = r.scen_id WHERE " + this.buildInClause("r.id", modelRunIds, false) + " AND " + this.buildInClause("k.keyid", variableIds, variables == null || variables.isEmpty()) + " AND " + this.buildInClause("u.id", unitIds, units == null || units.isEmpty()) + " AND " + this.buildInClause("n.id", regionIds, regions == null || regions.isEmpty()) + " ORDER BY m.name, s.name, r.version, k.keystring, u.name, n.name, d.year ";
                PreparedStatement stmt = cn.prepareStatement(sql);
                try {
                    ResultSet rs = stmt.executeQuery();
                    try {
                        rs.setFetchSize(1000);
                        while (rs.next()) {
                            printer.printRecord(new Object[]{rs.getString("model"), rs.getString("scenario"), rs.getString("version"), rs.getString("variable"), rs.getString("unit"), rs.getString("region"), rs.getInt("meta"), rs.getString("subannual"), rs.getInt("year"), rs.getDouble("value")});
                        }
                        printer.flush();
                    }
                    finally {
                        if (rs == null) continue;
                        rs.close();
                    }
                }
                finally {
                    if (stmt == null) continue;
                    stmt.close();
                }
            }
        }
        catch (IOException | SQLException e) {
            log.error("Cannot export timeseries data", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<TimesliceDTO> getTimeslices() throws IxException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void addTimeslice(String name, String category, Double duration) throws IxException {
        String sql = "INSERT INTO iamc_timeslices(id, name, category, duration) VALUES (?, ?, ?, ?)";
        try (Connection cn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(cn);
             PreparedStatement stmt = cn.prepareStatement(sql);){
            Long nextId = this.getNextId(cn, "iamc_timeslices");
            stmt.setInt(1, nextId.intValue());
            stmt.setString(2, name);
            stmt.setString(3, category);
            if (duration == null) {
                stmt.setNull(4, 8);
            } else {
                stmt.setDouble(4, duration);
            }
            stmt.executeUpdate();
            tm.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException("Cannot add new time slice", e);
        }
    }

    @Override
    public void removeTimeslice(String name) throws IxException {
        String sql = "DELETE FROM iamc_timeslices WHERE name = ?";
        try (Connection cn = this.getPooledConn();
             AutoRollback tm = new AutoRollback(cn);
             PreparedStatement stmt = cn.prepareStatement(sql);){
            stmt.setString(1, name);
            if (stmt.executeUpdate() != 1) {
                throw new IxException(String.format("Timeslice %s not found", name), null);
            }
            tm.commit();
        }
        catch (SQLException e) {
            throw this.loggedIxException(String.format("Cannot remove timeslice %s", name), e);
        }
    }

    public String getDbInterface() {
        return this.dbInterface;
    }

    public DataSource getDs() {
        return this.ds;
    }

    private static /* synthetic */ Object lambda$getSymbolData$31(Map keys, Map runKeys, Integer i) {
        keys.put(i, (String)runKeys.get(i));
        return i;
    }

    private static /* synthetic */ String[] lambda$getSymbolData$30(Map filters, Long id) {
        return filters.keySet().toArray(new String[0]);
    }

    private static /* synthetic */ Long lambda$getSymbolData$29(Long id) {
        return id;
    }

    private static /* synthetic */ boolean lambda$getDocumentation$13(Set requestedMetadata, MetadataTypeDTO type) {
        return requestedMetadata.isEmpty() || requestedMetadata.contains(type.getName());
    }

    private static /* synthetic */ void lambda$getNodeFromDB$4(Map nodeMap, Long synonymNodeId, List synonyms) {
        nodeMap.compute(synonymNodeId, (nodeId, value) -> {
            if (value != null && value.getSynonyms() == null) {
                value.setSynonyms(synonyms);
            }
            return value;
        });
    }

    private static /* synthetic */ List lambda$getIamVariableIdsOfRunIds$2(Long varsOfRun) {
        return new ArrayList();
    }

    static interface Converter<S, T> {
        public T convert(S var1) throws IxException;
    }
}

