/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.dto;

import org.apache.commons.lang.StringUtils;

public class DocumentationKey {
    private final DocumentationDomain domain;
    private final String id;

    private DocumentationKey(DocumentationDomain domain, String id) {
        this.domain = domain;
        this.id = id;
    }

    public static DocumentationKey parse(String key) {
        DocumentationDomain type = DocumentationDomain.detect(key);
        if (type != null) {
            return new DocumentationKey(type, DocumentationDomain.extractId(key));
        }
        return null;
    }

    public String toString() {
        return this.domain.getKey(this.id);
    }

    public DocumentationDomain getDomain() {
        return this.domain;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentationKey)) {
            return false;
        }
        DocumentationKey other = (DocumentationKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DocumentationDomain this$domain = this.getDomain();
        DocumentationDomain other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !((Object)((Object)this$domain)).equals((Object)other$domain)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DocumentationKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DocumentationDomain $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : ((Object)((Object)$domain)).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public static enum DocumentationDomain {
        SCENARIO("scenarios"),
        MODEL("models"),
        REGION("regions"),
        METADATA("metadata"),
        TIMESERIES("timeseries");

        private static final String SEPARATOR = "/";
        private final String prefix;

        private DocumentationDomain(String prefix) {
            this.prefix = prefix;
        }

        public String getKey(Long id) {
            return String.format("%s%s%s%d", SEPARATOR, this.prefix, SEPARATOR, id);
        }

        public String getKey(String name) {
            return String.format("%s%s%s%s", SEPARATOR, this.prefix, SEPARATOR, name);
        }

        public static DocumentationDomain detect(String key) {
            for (DocumentationDomain type : DocumentationDomain.values()) {
                if (!key.startsWith(String.format("%s%s%s", SEPARATOR, type.prefix, SEPARATOR))) continue;
                return type;
            }
            return null;
        }

        public static String extractId(String key) {
            DocumentationDomain type = DocumentationDomain.detect(key);
            if (type != null) {
                return StringUtils.removeStart((String)key, (String)String.format("%s%s%s", SEPARATOR, type.prefix, SEPARATOR));
            }
            return key;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

