/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.ixobjects.IXelement;
import at.ac.iiasa.ixmp.objects.Equation;
import at.ac.iiasa.ixmp.objects.Item;
import at.ac.iiasa.ixmp.objects.Parameter;
import at.ac.iiasa.ixmp.objects.Variable;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class Element
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Item ixItem = null;
    private Integer id = null;
    private Vector<Integer> keyVector = null;
    private Double value = null;
    private Integer unitid = null;
    private Double level = null;
    private Double marginal = null;

    Element(Item item, Vector<Integer> keyVector) {
        this.ixItem = item;
        this.setId();
        this.keyVector = keyVector;
    }

    Element(Item item, Vector<Integer> keyVector, Double value, Integer unitId) {
        this.ixItem = item;
        this.setId();
        this.keyVector = keyVector;
        this.value = value;
        this.unitid = unitId;
    }

    Element(Item pItem, Double value, Integer unitId) {
        this.ixItem = pItem;
        this.setId();
        this.setScalar();
        this.value = value;
        this.unitid = unitId;
    }

    Element(Item item, Vector<Integer> keyVector, Double level, Double marginal) {
        this.ixItem = item;
        this.setId();
        this.keyVector = keyVector;
        this.level = level;
        this.marginal = marginal;
    }

    Element(Item item, Double level, Double marginal) {
        this.ixItem = item;
        this.setId();
        this.setScalar();
        this.level = level;
        this.marginal = marginal;
    }

    public Element(IXelement ixElement) {
        this.id = ixElement.id;
        this.keyVector = ixElement.keyVector;
        this.value = ixElement.value;
        this.unitid = ixElement.unitid;
        this.level = ixElement.level;
        this.marginal = ixElement.marginal;
    }

    void setIXitem(Item item) {
        this.ixItem = item;
    }

    private void setScalar() {
        this.keyVector = new Vector();
        this.keyVector.add(0);
    }

    private void setId() {
        this.id = this.ixItem.scenario.getNextItemId();
    }

    public Vector<Integer> getVector() {
        return this.keyVector;
    }

    public Vector<Integer> getClonedVector() {
        Vector<Integer> aVector = this.ixItem.getNewVector();
        aVector.addAll(this.keyVector);
        return aVector;
    }

    Integer getKeyId(String idxName) throws IxException {
        return this.keyVector.get(this.ixItem.getIdx(idxName));
    }

    Integer getKeyId(int idx) {
        return this.keyVector.get(idx);
    }

    public String getConcatKey() {
        return this.ixItem.getConcatKey(this.keyVector);
    }

    public String[] getKey() {
        Vector<String> ret = new Vector<String>(this.ixItem.dim);
        for (int i = 0; i < this.ixItem.dim; ++i) {
            ret.add(this.ixItem.scenario.getKeyIdString(this.keyVector.get(i)));
        }
        return ret.toArray(new String[0]);
    }

    public String getKey(String idxName) throws IxException {
        return this.getKey(this.ixItem.getIdx(idxName));
    }

    public String getKey(int idx) {
        return this.ixItem.scenario.getKeyIdString(this.keyVector.get(idx));
    }

    public boolean checkKeyAtIndex(String idxName, String key) throws IxException {
        return this.checkKeyAtIndex(idxName, (Integer)this.ixItem.scenario.getKeyId(key));
    }

    boolean checkKeyAtIndex(String idxName, Integer keyId) throws IxException {
        return this.getKeyId(idxName).equals(keyId);
    }

    boolean checkKeyAtIndex(int idx, Integer keyId) {
        return this.getKeyId(idx).equals(keyId);
    }

    public List<String> getEleComments() {
        return this.ixItem.getCommentsById(this.id);
    }

    public void setValue(Double value) throws IxException {
        this.checkType("This element does not have a value!", Parameter.class);
        this.value = value;
    }

    public Double getValue() throws IxException {
        this.checkType("This element does not have a value!", Parameter.class);
        return this.value;
    }

    @SafeVarargs
    private final void checkType(String message, Class<? extends Item> ... classes) throws IxException {
        if (this.ixItem != null && Arrays.stream(classes).noneMatch(cls -> cls.isInstance(this.ixItem))) {
            throw new IxException(message);
        }
    }

    void setUnitId(Integer unitId) throws IxException {
        this.checkType("This element does not have a unit!", Parameter.class);
        this.unitid = unitId;
    }

    Integer getUnitId() throws IxException {
        this.checkType("This element does not have a unit!", Parameter.class);
        return this.unitid;
    }

    public String getUnit() throws IxException {
        this.checkType("This element does not have a unit!", Parameter.class);
        return this.ixItem.scenario.getUnitName(this.unitid);
    }

    public Double getLevel() throws IxException {
        this.checkType("This element does not have a level!", Variable.class, Equation.class);
        return this.level;
    }

    public Double getMarginal() throws IxException {
        this.checkType("This element does not have a marginal!", Variable.class, Equation.class);
        return this.marginal;
    }

    Element copyTo(Item target) throws IxException {
        Element clone = new Element(target, new Vector<Integer>(this.keyVector));
        clone.value = this.value;
        if (this.ixItem instanceof Parameter) {
            try {
                clone.unitid = clone.ixItem.scenario.getUnitId(this.getUnit());
            }
            catch (IxException e) {
                clone.unitid = clone.ixItem.scenario.getMp().addUnitToDB(this.getUnit(), null);
            }
        }
        clone.level = this.level;
        clone.marginal = this.marginal;
        return clone;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Element)) {
            return false;
        }
        Element other = (Element)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$id = this.id;
        Integer other$id = other.id;
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Vector<Integer> this$keyVector = this.keyVector;
        Vector<Integer> other$keyVector = other.keyVector;
        if (this$keyVector == null ? other$keyVector != null : !((Object)this$keyVector).equals(other$keyVector)) {
            return false;
        }
        Double this$value = this.value;
        Double other$value = other.value;
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Integer this$unitid = this.unitid;
        Integer other$unitid = other.unitid;
        if (this$unitid == null ? other$unitid != null : !((Object)this$unitid).equals(other$unitid)) {
            return false;
        }
        Double this$level = this.level;
        Double other$level = other.level;
        if (this$level == null ? other$level != null : !((Object)this$level).equals(other$level)) {
            return false;
        }
        Double this$marginal = this.marginal;
        Double other$marginal = other.marginal;
        return !(this$marginal == null ? other$marginal != null : !((Object)this$marginal).equals(other$marginal));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Element;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $id = this.id;
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Vector<Integer> $keyVector = this.keyVector;
        result = result * 59 + ($keyVector == null ? 43 : ((Object)$keyVector).hashCode());
        Double $value = this.value;
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Integer $unitid = this.unitid;
        result = result * 59 + ($unitid == null ? 43 : ((Object)$unitid).hashCode());
        Double $level = this.level;
        result = result * 59 + ($level == null ? 43 : ((Object)$level).hashCode());
        Double $marginal = this.marginal;
        result = result * 59 + ($marginal == null ? 43 : ((Object)$marginal).hashCode());
        return result;
    }

    public Integer getId() {
        return this.id;
    }
}

