/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.Platform;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.Item;
import at.ac.iiasa.ixmp.objects.Scenario;
import at.ac.iiasa.ixmp.objects.Set;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSet
extends Set {
    private static final Logger log = LoggerFactory.getLogger(IndexSet.class);
    private final java.util.Set<Integer> indexSetKeys = new LinkedHashSet<Integer>();

    public IndexSet(Platform mp) {
        super(mp);
    }

    IndexSet(Platform mp, Scenario scenario, String name) {
        super(mp);
        this.initializeIXItem(scenario, name, "index set");
        scenario.addToItemList(this);
        log.debug(" initialize " + this.getTypeName());
    }

    public IndexSet(Platform mp, Scenario scenario, String name, int itemId, List<Element> blob) {
        super(mp);
        this.initializeIXItem(scenario, name, "index set");
        scenario.addToItemList(this);
        this.itemId = itemId;
        if (blob != null) {
            this.setElementListFromDB(blob);
            for (Element ele : this.eleList) {
                this.indexSetKeys.add(ele.getKeyId(0));
            }
        }
    }

    @Override
    public void addElement(String key) throws IxException {
        this.addElement(key, null);
    }

    @Override
    public void addElement(String key, String comment) throws IxException {
        if (key.contains(".")) {
            throw new IxException("An element with '.' cannot be added to an index set!");
        }
        this.addElement(this.getKeyIdVector(key), comment);
    }

    void addElement(Integer keyId) throws IxException {
        Vector<Integer> eleVector = new Vector<Integer>(1);
        eleVector.add(keyId);
        this.addElement(eleVector, (String)null);
    }

    @Override
    public void addElement(Vector<Integer> keyVector, String comment) throws IxException {
        this.scenario.assertTimeSeriesIsEditable(false);
        if (keyVector.size() != 1) {
            throw new IxException("only single keys can be added to an index set!");
        }
        Element ele = (Element)this.eleMap.get(keyVector);
        if (ele == null) {
            ele = new Element(this, keyVector);
            this.addItemElement(ele, comment);
            this.indexSetKeys.add(keyVector.get(0));
            this.scenario.addToChangelog("add index set element", this.name, this.getConcatKey(keyVector));
        }
        if (comment != null) {
            this.addItemComment(ele, comment);
        }
    }

    @Override
    public void removeElement(Element pEle) throws IxException {
        this.scenario.assertTimeSeriesIsEditable(false);
        Vector<Integer> eleVector = pEle.getVector();
        if (this.hasElement(eleVector)) {
            this.hasUpdatedElement = true;
            int keyId = eleVector.get(0);
            this.indexSetKeys.remove(keyId);
            this.scenario.removeAllEleByIndex(this.name, keyId);
            if (this.scenario.isChangeLogged().booleanValue()) {
                this.scenario.addToChangelog("delete set element", this.name, this.scenario.getKeyIdString(keyId));
            }
            super.removeItemElement(pEle);
        }
    }

    public String[] getIndexSetKeys() {
        Vector<String> ret = new Vector<String>(this.indexSetKeys.size());
        for (int id : this.indexSetKeys) {
            ret.add(this.scenario.getKeyIdString(id));
        }
        return ret.toArray(new String[0]);
    }

    List<Integer> getIndexSetKeyIds() {
        return new ArrayList<Integer>(this.indexSetKeys);
    }

    boolean hasIndexSetKey(int pKeyId) {
        return this.indexSetKeys.contains(pKeyId);
    }

    void checkIndexSetKey(int pKeyId) throws IxException {
        if (!this.hasIndexSetKey(pKeyId)) {
            throw new IxException(String.format("The index set '%s' does not have an element '%s'!", this.name, this.scenario.getKeyIdString(pKeyId)));
        }
    }

    @Override
    List<Map<Object, Object>> toJsonList(Map<String, List<String>> eleListFilter) {
        LinkedList<Map<Object, Object>> jsonList = new LinkedList<Map<Object, Object>>();
        for (Integer key : this.indexSetKeys) {
            LinkedHashMap<String, String> jsonMap = new LinkedHashMap<String, String>();
            jsonMap.put("model", this.scenario.getModel());
            jsonMap.put("scenario", this.scenario.getScenario());
            jsonMap.put("type", "index set");
            jsonMap.put("name", this.name);
            jsonMap.put("key", this.scenario.getKeyIdString(key));
            jsonList.add(jsonMap);
        }
        return jsonList;
    }

    @Override
    protected Item createInstance(Platform platform) {
        return new IndexSet(platform);
    }

    @Override
    public Item copyTo(Scenario target, boolean keepElements) throws IxException {
        IndexSet clone = (IndexSet)super.copyTo(target, keepElements);
        for (Element ele : clone.eleList) {
            clone.indexSetKeys.add(ele.getKeyId(0));
        }
        return clone;
    }
}

