/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.Platform;
import at.ac.iiasa.ixmp.database.DbDAO;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.Equation;
import at.ac.iiasa.ixmp.objects.IndexSet;
import at.ac.iiasa.ixmp.objects.Parameter;
import at.ac.iiasa.ixmp.objects.PlatformBound;
import at.ac.iiasa.ixmp.objects.Scenario;
import at.ac.iiasa.ixmp.objects.Set;
import at.ac.iiasa.ixmp.objects.Variable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Item
extends PlatformBound {
    private static final Logger log = LoggerFactory.getLogger(Item.class);
    protected Scenario scenario = null;
    protected String name = null;
    protected String type = "item";
    protected int itemId = -1;
    protected Integer dim = 0;
    protected List<String> idxSets = new ArrayList<String>();
    protected List<String> idxNames = new ArrayList<String>();
    protected Map<String, Integer> nameIdxMap = new HashMap<String, Integer>();
    protected boolean eleLoadedFromDB = false;
    public boolean hasUpdatedElement = false;
    protected List<Element> eleList = new ArrayList<Element>();
    protected Map<Vector<Integer>, Element> eleMap = new HashMap<Vector<Integer>, Element>();
    protected boolean commentsLoadedFromDB = true;
    public boolean hasUpdatedComment = false;
    private Map<Integer, List<Integer>> itemCommentMap = new HashMap<Integer, List<Integer>>();

    Item(Platform mp) {
        super(mp);
    }

    protected void initializeIXItem(Scenario scenario, String name, String type) {
        this.initializeIXItem(scenario, name, type, true);
    }

    protected void initializeIXItem(Scenario scenario, String name, String type, boolean fromDB) {
        this.scenario = scenario;
        this.name = name;
        this.type = type;
        this.eleLoadedFromDB = fromDB;
        this.itemId = this.scenario.getNextItemId();
    }

    protected void setIXitemIdDims(List<String> indexSets, List<String> indexNames) {
        this.setIXitemIdDims(indexSets, indexNames, null);
    }

    protected void setIXitemIdDims(List<String> indexSets, List<String> indexNames, String scheme) {
        if (indexSets != null && !indexSets.isEmpty()) {
            this.idxSets = indexSets;
            this.idxNames = indexNames;
            if (scheme != null) {
                log.debug(" initialize " + this.getTypeName() + " with index dimensions defined by '" + scheme + "' scheme");
            } else {
                log.debug(" initialize " + this.getTypeName() + " with explicitly stated index dimensions");
            }
        } else {
            log.debug(" initialize " + this.getTypeName() + " as scalar");
        }
        int i = 0;
        for (String name : this.idxNames) {
            this.nameIdxMap.put(name, i++);
        }
        this.dim = this.idxSets.size();
    }

    public void setIXitemDimsFromDB(int idx, String indexSet, String indexName) {
        this.idxSets.add(indexSet);
        this.idxNames.add(indexName);
        this.nameIdxMap.put(indexName, idx);
    }

    boolean isLoadedFromDB() {
        return this.eleLoadedFromDB;
    }

    protected boolean isScalar() {
        return this.dim == 0;
    }

    public boolean hasElements() throws IxException {
        boolean retval = false;
        if (this.isLoadedFromDB()) {
            if (!this.eleList.isEmpty()) {
                retval = true;
            }
        } else {
            retval = this.getMp().getDb().hasItemElementsInBlob(this.scenario.getRunId(), this);
        }
        return retval;
    }

    boolean loadItemElementsFromDB() throws IxException {
        if (!this.isLoadedFromDB()) {
            DbDAO ixDB = this.getMp().getDb();
            ixDB.getItemElementsFromDB(this.scenario.getRunId(), this);
            this.eleLoadedFromDB = true;
            return true;
        }
        return false;
    }

    public void setElementListFromDB(List<Element> blob) {
        for (Element ele : blob) {
            ele.setIXitem(this);
            this.eleList.add(ele);
            this.eleMap.put(ele.getVector(), ele);
        }
    }

    void loadItemCommentsFromDB() throws IxException {
        if (!this.commentsLoadedFromDB) {
            DbDAO ixDB = this.getMp().getDb();
            ixDB.getItemCommentsFromDB(this.scenario.getRunId(), this);
            this.commentsLoadedFromDB = true;
        }
    }

    Scenario getParentScenario() {
        return this.scenario;
    }

    public String getName() {
        return this.name;
    }

    public String getTypeName() {
        return this.type + " '" + this.name + "'";
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getDim() {
        return this.dim;
    }

    public List<String> getIdxSets() {
        return this.idxSets;
    }

    public String getIdxSet(int idx) {
        return this.idxSets.get(idx);
    }

    public List<String> getIdxNames() {
        return this.idxNames;
    }

    public String getIdxName(int idx) {
        return this.idxNames.get(idx);
    }

    protected Integer getIdx(String pIdxName) throws IxException {
        Integer idx = this.nameIdxMap.get(pIdxName);
        if (idx == null) {
            throw new IxException("The " + this.getTypeName() + " does not have an index '" + pIdxName + "'!");
        }
        return idx;
    }

    public boolean hasElement(String pKey) throws IxException {
        return this.hasElement(this.getKeyIdVector(pKey));
    }

    public boolean hasElement(List<String> pKeyList) throws IxException {
        return this.hasElement(this.getKeyIdVector(pKeyList));
    }

    public boolean hasElement(Vector<Integer> pEleVector) throws IxException {
        this.loadItemElementsFromDB();
        return this.eleMap.containsKey(pEleVector);
    }

    public void checkElement(String pKey) throws IxException {
        this.checkElement(this.getKeyIdVector(pKey));
    }

    public void checkElement(List<String> pKeyList) throws IxException {
        this.checkElement(this.getKeyIdVector(pKeyList));
    }

    public void checkElement(Vector<Integer> pEleVector) throws IxException {
        if (!this.hasElement(pEleVector)) {
            throw new IxException("The " + this.getTypeName() + " does not have an element " + this.getConcatKey(pEleVector) + "!");
        }
    }

    public List<Element> getElements() throws IxException {
        this.loadItemElementsFromDB();
        return this.eleList;
    }

    public List<Element> getElements(Map<String, List<String>> eleListFilter) throws IxException {
        if (eleListFilter == null) {
            this.loadItemElementsFromDB();
            return this.eleList;
        }
        HashMap<Integer, List<Integer>> eleFilter = new HashMap<Integer, List<Integer>>();
        for (String idxName : eleListFilter.keySet()) {
            if (this.nameIdxMap.get(idxName) == null) {
                throw new IxException("the " + this.getTypeName() + " does not have an index '" + idxName + "'!");
            }
            int idx = this.nameIdxMap.get(idxName);
            IndexSet idxSet = null;
            if (!this.idxSets.get(idx).equals("*")) {
                idxSet = this.scenario.getIndexSet(this.idxSets.get(idx));
            }
            LinkedList<Integer> filterKeyIdList = new LinkedList<Integer>();
            for (String aKey : eleListFilter.get(idxName)) {
                int aKeyId = this.scenario.addKey(aKey);
                if (idxSet != null) {
                    idxSet.checkIndexSetKey(aKeyId);
                }
                filterKeyIdList.add(aKeyId);
            }
            eleFilter.put(idx, filterKeyIdList);
        }
        return this.filteredEleList(eleFilter);
    }

    protected List<Element> filteredEleList(Map<Integer, List<Integer>> eleFilter) throws IxException {
        this.loadItemElementsFromDB();
        Predicate<Element> elementPredicate = element -> eleFilter.entrySet().stream().allMatch(filterEntry -> ((List)filterEntry.getValue()).contains(element.getKeyId((Integer)filterEntry.getKey())));
        return this.eleList.stream().filter(elementPredicate).collect(Collectors.toCollection(LinkedList::new));
    }

    public String[] getCol(int pIdx, List<Element> pEleList) throws IxException {
        if (!this.isScalar() && pIdx >= this.dim) {
            throw new IxException(String.format("Index higher than dimension of %s!", this.getTypeName()));
        }
        Vector<String> ret = new Vector<String>(pEleList.size());
        for (Element ele : pEleList) {
            ret.add(ele.getKey(pIdx));
        }
        return ret.toArray(new String[0]);
    }

    public Element getElement(String pKey) throws IxException {
        return this.getElement(this.getKeyIdVector(pKey));
    }

    public Element getElement(List<String> pKeyList) throws IxException {
        return this.getElement(this.getKeyIdVector(pKeyList));
    }

    public Element getElement(Vector<Integer> pKeyVector) throws IxException {
        this.loadItemElementsFromDB();
        Element retEle = this.eleMap.get(pKeyVector);
        if (retEle == null) {
            throw new IxException(String.format("The %s does not contain an element '%s'!", this.getTypeName(), this.getConcatKey(pKeyVector)));
        }
        return retEle;
    }

    protected void clearCache() throws IxException {
        if (this.hasUpdatedElement || this.hasUpdatedComment) {
            throw new IxException(String.format("The %s has updated elements, the cache cannot be cleared!", this.getTypeName()));
        }
        this.eleLoadedFromDB = false;
        this.commentsLoadedFromDB = false;
        this.eleList = new ArrayList<Element>();
        this.eleMap = new HashMap<Vector<Integer>, Element>();
        this.itemCommentMap = new HashMap<Integer, List<Integer>>();
    }

    protected void addItemElement(Element ele, String comment) throws IxException {
        Vector<Integer> keyVector = ele.getVector();
        this.checkSanity(keyVector);
        this.hasUpdatedElement = true;
        this.eleList.add(ele);
        this.eleMap.put(keyVector, ele);
    }

    protected void removeItemElement(Element pEle) throws IxException {
        int eleId = pEle.getId();
        Vector<Integer> eleVector = pEle.getVector();
        this.eleList.remove(pEle);
        this.eleMap.remove(eleVector);
        this.removeItemCommentsById(eleId);
    }

    private void checkSanity(Vector<Integer> pEleVector) throws IxException {
        if (pEleVector.size() != Math.max(this.dim, 1)) {
            throw new IxException(String.format("The element %s has the wrong number of dimensions for %s (%d)!", this.getConcatKey(pEleVector), this.getTypeName(), this.dim));
        }
        for (int i = 0; i < this.dim; ++i) {
            this.scenario.checkIndexSetEle(this.getIdxSet(i), pEleVector.get(i));
        }
    }

    protected void addItemComment(Element pEle, String pComment) throws IxException {
        this.loadItemCommentsFromDB();
        int eleId = pEle.getId();
        int comId = this.scenario.addComment(pComment);
        List<Integer> itemCommentList = this.itemCommentMap.get(eleId);
        if (itemCommentList != null && !itemCommentList.contains(comId)) {
            itemCommentList.add(comId);
        } else {
            itemCommentList = new LinkedList<Integer>();
            itemCommentList.add(comId);
            this.itemCommentMap.put(eleId, itemCommentList);
        }
        this.hasUpdatedComment = true;
        if (this.scenario.isChangeLogged().booleanValue()) {
            // empty if block
        }
    }

    public List<String> getItemComments() {
        return this.getCommentsById(this.getItemId());
    }

    protected List<String> getCommentsById(int id) {
        LinkedList<String> itemCommentList = new LinkedList<String>();
        if (this.itemCommentMap.containsKey(id)) {
            List<Integer> itemCommentIdList = this.itemCommentMap.get(id);
            for (Integer aComId : itemCommentIdList) {
                itemCommentList.add(this.scenario.getCommentString(aComId));
            }
        }
        return itemCommentList;
    }

    protected void removeItemCommentsById(int id) throws IxException {
        this.loadItemCommentsFromDB();
        this.hasUpdatedComment = true;
        this.itemCommentMap.remove(id);
    }

    public String getConcatKey(Vector<Integer> pKeyVector) {
        StringBuilder keyString = new StringBuilder(this.scenario.getKeyIdString(pKeyVector.get(0)));
        for (int i = 1; i < pKeyVector.size(); ++i) {
            keyString.append(".").append(this.scenario.getKeyIdString(pKeyVector.get(i)));
        }
        return keyString.toString();
    }

    public Vector<Integer> getKeyIdVector(String pKeyString) throws IxException {
        return this.getKeyIdVector(new LinkedList<String>(Arrays.asList(pKeyString.split("[.]"))));
    }

    protected Vector<Integer> getKeyIdVector(List<String> pKeyList) throws IxException {
        if (pKeyList.size() != Math.max(this.dim, 1)) {
            throw new IxException("The element has the wrong number of index dimensions for " + this.getTypeName() + " (dim=" + this.dim + ") !");
        }
        Vector<Integer> eleVector = new Vector<Integer>(pKeyList.size());
        for (String aKey : pKeyList) {
            eleVector.add(this.scenario.addKey(aKey));
        }
        return eleVector;
    }

    protected Vector<Integer> getNewVector() {
        return new Vector<Integer>(Math.max(this.dim, 1));
    }

    public Vector<Integer> setKeyAtIndex(Vector<Integer> pEleVector, String idxName, String pKey) throws IxException {
        return this.setKeyAtIndex(pEleVector, (int)this.nameIdxMap.get(idxName), this.scenario.addKey(pKey));
    }

    public Vector<Integer> setKeyAtIndex(Vector<Integer> pEleVector, int idx, String pKey) throws IxException {
        return this.setKeyAtIndex(pEleVector, idx, this.scenario.addKey(pKey));
    }

    public Vector<Integer> setKeyAtIndex(Vector<Integer> pEleVector, int idx, Integer pKeyId) {
        pEleVector.set(idx, pKeyId);
        return pEleVector;
    }

    public String getTypeForDB() throws IxException {
        if (this instanceof IndexSet) {
            throw new IxException("The function 'getTypeForDB()' is not applicable for index sets!");
        }
        if (this instanceof Set) {
            return "SET";
        }
        if (this instanceof Parameter) {
            return "PAR";
        }
        if (this instanceof Variable) {
            return "VAR";
        }
        if (this instanceof Equation) {
            return "EQU";
        }
        throw new IxException("Unknown type of Item!");
    }

    boolean hasUpdatedElements() {
        return this.hasUpdatedElement;
    }

    boolean hasUpdatedComments() {
        return this.hasUpdatedComment;
    }

    public List<Element> getEleBlobForDB() {
        return this.eleList;
    }

    public Map<Integer, List<Integer>> getCommentMapForDB() {
        return this.itemCommentMap;
    }

    public Item copyTo(Scenario target, boolean keepElements) throws IxException {
        Item clone = this.createInstance(target.getMp());
        clone.scenario = target;
        clone.name = this.name;
        clone.type = this.type;
        clone.itemId = this.itemId;
        clone.dim = this.dim;
        clone.idxSets = new LinkedList<String>(this.idxSets);
        clone.idxNames = new LinkedList<String>(this.idxNames);
        clone.nameIdxMap = new HashMap<String, Integer>(this.nameIdxMap);
        clone.eleLoadedFromDB = this.eleLoadedFromDB;
        clone.hasUpdatedElement = this.hasUpdatedElement;
        clone.eleMap = new HashMap<Vector<Integer>, Element>();
        clone.eleList = new ArrayList<Element>();
        if (keepElements) {
            this.loadItemElementsFromDB();
            Map<Element, Vector> mapping = this.eleMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            for (Element ele : this.eleList) {
                Element elementCopy = ele.copyTo(clone);
                clone.eleMap.put(new Vector(mapping.get(ele)), elementCopy);
                clone.eleList.add(elementCopy);
            }
        }
        clone.eleLoadedFromDB = true;
        clone.commentsLoadedFromDB = this.commentsLoadedFromDB;
        clone.hasUpdatedComment = this.hasUpdatedComment;
        clone.itemCommentMap = this.itemCommentMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList((Collection)e.getValue())));
        return clone;
    }

    public final Item copyTo(Scenario target) throws IxException {
        return this.copyTo(target, true);
    }

    protected Item createInstance(Platform platform) {
        return new Item(platform);
    }

    protected Map<Object, Object> toMap(Element ele, String type) {
        LinkedHashMap<Object, Object> jsonMap = new LinkedHashMap<Object, Object>();
        jsonMap.put("model", this.scenario.getModel());
        jsonMap.put("scenario", this.scenario.getScenario());
        jsonMap.put("type", type);
        jsonMap.put("name", this.name);
        if (this.dim >= 1) {
            for (int i = 0; i < this.dim; ++i) {
                jsonMap.put(this.idxNames.get(i), ele.getKey(i));
            }
        }
        return jsonMap;
    }
}

