/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.Platform;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.Element;
import at.ac.iiasa.ixmp.objects.Item;
import at.ac.iiasa.ixmp.objects.Scenario;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parameter
extends Item {
    private static final Logger log = LoggerFactory.getLogger(Parameter.class);
    private Element scalarEle = null;

    protected Parameter(Platform mp) {
        super(mp);
    }

    Parameter(Platform mp, Scenario scenario, String name, List<String> indexSets, List<String> indexNames) {
        super(mp);
        this.initializeIXItem(scenario, name, "parameter");
        this.setIXitemIdDims(indexSets, indexNames);
        scenario.addToItemList(this);
    }

    Parameter(Platform mp, Scenario scenario, String name, List<String> indexSets, List<String> indexNames, String scheme) {
        super(mp);
        this.initializeIXItem(scenario, name, "parameter");
        this.setIXitemIdDims(indexSets, indexNames, scheme);
        scenario.addToItemList(this);
    }

    public Parameter(Platform mp, Scenario scenario, String name, int itemId, int dim) {
        super(mp);
        this.initializeIXItem(scenario, name, "parameter", false);
        scenario.addToItemList(this);
        this.itemId = itemId;
        this.dim = dim;
    }

    @Override
    public void setElementListFromDB(List<Element> pBlob) {
        super.setElementListFromDB(pBlob);
        if (this.isScalar()) {
            this.scalarEle = (Element)this.eleList.get(this.eleList.size() - 1);
        }
    }

    public void addElement(String key, Double pValue, String pUnit) throws IxException {
        this.addElement(this.getKeyIdVector(key), pValue, pUnit, (String)null);
    }

    public void addElement(String pKey, Double pValue, String pUnit, String pComment) throws IxException {
        this.addElement(this.getKeyIdVector(pKey), pValue, pUnit, pComment);
    }

    public void addElement(List<String> pKeyList, Double pValue, String pUnit) throws IxException {
        this.addElement(this.getKeyIdVector(pKeyList), pValue, pUnit, (String)null);
    }

    public void addElement(List<String> pKeyList, Double pValue, String pUnit, String pComment) throws IxException {
        this.addElement(this.getKeyIdVector(pKeyList), pValue, pUnit, pComment);
    }

    public void addElement(Vector<Integer> pKeyVector, Double pValue, String pUnit, String pComment) throws IxException {
        this.scenario.assertTimeSeriesIsEditable(false);
        if (pValue == null) {
            throw new IxException(String.format("A value of NULL cannot be assigned to parameter '%s'!", this.name));
        }
        if (pValue.isNaN()) {
            throw new IxException(String.format("A value of NaN cannot be assigned to parameter '%s'!", this.name));
        }
        if (this.isScalar()) {
            throw new IxException(String.format("You cannot assign an element with a key to scalar '%s'!", this.name));
        }
        int unitId = this.scenario.getUnitId(pUnit);
        Element ele = (Element)this.eleMap.get(pKeyVector);
        if (ele == null) {
            ele = new Element((Item)this, pKeyVector, pValue, unitId);
            this.addItemElement(ele, pComment);
            if (this.scenario.isChangeLogged().booleanValue()) {
                this.scenario.addToChangelog("add parameter element", this.name, ele.getConcatKey(), pValue, null);
            }
        } else {
            Double prevVal = ele.getValue();
            Integer prevUnitId = ele.getUnitId();
            if (!Objects.equals(prevVal, pValue)) {
                this.changeValue(ele, pValue, prevVal);
            }
            if (unitId != prevUnitId) {
                this.changeUnit(ele, unitId, prevUnitId);
            }
        }
        if (pComment != null) {
            this.addItemComment(ele, pComment);
        }
    }

    public void addElement(Double pValue, String pUnit) throws IxException {
        this.addElement(pValue, pUnit, null);
    }

    public void addElement(Double pValue, String pUnit, String pComment) throws IxException {
        this.scenario.assertTimeSeriesIsEditable(false);
        if (pValue == null) {
            throw new IxException(String.format("A value of NULL cannot be assigned to parameter '%s'!", this.name));
        }
        if (pValue.isNaN()) {
            throw new IxException(String.format("A value of NaN cannot be assigned to parameter '%s'!", this.name));
        }
        if (!this.isScalar()) {
            throw new IxException("This parameter is not a scalar!");
        }
        int unitId = this.scenario.getUnitId(pUnit);
        Vector<Integer> eleVector = new Vector<Integer>();
        eleVector.add(0);
        if (!this.hasElement(eleVector)) {
            this.scalarEle = new Element((Item)this, pValue, unitId);
            this.addItemElement(this.scalarEle, pComment);
            this.hasUpdatedElement = true;
            if (this.scenario.isChangeLogged().booleanValue()) {
                this.scenario.addToChangelog("add scalar value", this.name, null, pValue, null);
            }
        } else {
            Element ele = (Element)this.eleMap.get(eleVector);
            Double prevVal = ele.getValue();
            Integer prevUnitId = ele.getUnitId();
            if (!Objects.equals(prevVal, pValue)) {
                this.changeValue(ele, pValue, prevVal);
            }
            if (unitId != prevUnitId) {
                this.changeUnit(ele, unitId, prevUnitId);
            }
        }
    }

    public void removeElement(String pEleKey) throws IxException {
        Vector<Integer> pEleVector = this.getKeyIdVector(pEleKey);
        if (!this.hasElement(pEleVector)) {
            throw new IxException(String.format("parameter %s does not have an element '%s', cannot be removed!", this.name, pEleKey));
        }
        this.removeElement((Element)this.eleMap.get(pEleVector));
    }

    public void removeElement(List<String> pKeyList) throws IxException {
        this.removeElement(this.getKeyIdVector(pKeyList));
    }

    public void removeElement(Vector<Integer> pEleVector) throws IxException {
        if (!this.hasElement(pEleVector)) {
            throw new IxException(String.format("Parameter %s does not have an element '%s', cannot be removed!", this.name, this.getConcatKey(pEleVector)));
        }
        this.removeElement((Element)this.eleMap.get(pEleVector));
    }

    public void removeElement(Element pEle) throws IxException {
        if (this.isScalar()) {
            throw new IxException("You cannot delete a scalar while specifying an element - use 'removePar()'!");
        }
        this.scenario.assertTimeSeriesIsEditable(false);
        this.hasUpdatedElement = true;
        if (this.scenario.isChangeLogged().booleanValue()) {
            this.scenario.addToChangelog("delete parameter element", this.name, pEle.getConcatKey(), null, pEle.getValue());
        }
        super.removeItemElement(pEle);
    }

    private void changeValue(Element pEle, Double pValue, Double prevValue) throws IxException {
        pEle.setValue(pValue);
        this.hasUpdatedElement = true;
        if (this.scenario.isChangeLogged().booleanValue()) {
            this.scenario.addToChangelog("change parameter element value", this.name, pEle.getConcatKey(), pValue, prevValue);
        }
    }

    private void changeUnit(Element pEle, int pUnitID, int prevUnitId) throws IxException {
        pEle.setUnitId(pUnitID);
        this.hasUpdatedElement = true;
        if (this.scenario.isChangeLogged().booleanValue()) {
            this.scenario.addToChangelog("change parameter element unit", this.name, pEle.getConcatKey(), pUnitID, prevUnitId);
        }
    }

    public Double getEleValue(List<String> pKeyList) throws IxException {
        if (this.isScalar()) {
            throw new IxException(String.format("The %s is initialized as a scalar, use function 'getEleValue()'!", this.getTypeName()));
        }
        return this.getElement(pKeyList).getValue();
    }

    public Double getEleValue(Vector<Integer> pKeyVector) throws IxException {
        if (this.isScalar()) {
            throw new IxException(String.format("The %s is initialized as a scalar, use function 'getEleValue()'!", this.getTypeName()));
        }
        return this.getElement(pKeyVector).getValue();
    }

    public double[] getValues(List<Element> pEleList) throws IxException {
        double[] ret = new double[pEleList.size()];
        int i = 0;
        for (Element ele : pEleList) {
            ret[i] = ele.getValue();
            ++i;
        }
        return ret;
    }

    public String getEleUnit(List<String> pKeyList) throws IxException {
        if (this.isScalar()) {
            throw new IxException(String.format("The %s is initialized as a scalar, use function 'getScalarUnit()'!", this.getTypeName()));
        }
        return this.getElement(pKeyList).getUnit();
    }

    public String getEleUnit(Vector<Integer> pKeyVector) throws IxException {
        if (this.isScalar()) {
            throw new IxException(String.format("The %s is initialized as a scalar, use function 'getScalarValue()'!", this.getTypeName()));
        }
        return this.getElement(pKeyVector).getUnit();
    }

    public String[] getUnits(List<Element> pEleList) throws IxException {
        Vector<String> ret = new Vector<String>(pEleList.size());
        for (Element ele : pEleList) {
            ret.add(this.scenario.getUnitName(ele.getUnitId()));
        }
        return ret.toArray(new String[0]);
    }

    public Double getScalarValue() throws IxException {
        if (!this.isScalar()) {
            throw new IxException("This parameter is not a scalar!");
        }
        this.loadItemElementsFromDB();
        if (this.scalarEle == null) {
            return Double.NaN;
        }
        return this.scalarEle.getValue();
    }

    public String getScalarUnit() throws IxException {
        if (!this.isScalar()) {
            throw new IxException("This parameter is not a scalar!");
        }
        this.loadItemElementsFromDB();
        return this.scalarEle == null ? "NaN" : this.scalarEle.getUnit();
    }

    public List<Map<Object, Object>> toJsonList(Map<String, List<String>> eleListFilter) throws IxException {
        LinkedList<Map<Object, Object>> jsonList = new LinkedList<Map<Object, Object>>();
        for (Element ele : this.getElements(eleListFilter)) {
            Map<Object, Object> jsonMap = this.toMap(ele, "parameter");
            jsonMap.put("unit", ele.getUnit());
            Double val = ele.getValue();
            if (!val.isInfinite()) {
                jsonMap.put("value", val);
            } else if (val < 0.0) {
                jsonMap.put("value", "-Infinity");
            } else {
                jsonMap.put("value", "Infinity");
            }
            jsonList.add(jsonMap);
        }
        return jsonList;
    }

    @Override
    public Item copyTo(Scenario target, boolean keepElements) throws IxException {
        Parameter clone = (Parameter)super.copyTo(target, keepElements);
        if (keepElements && clone.isScalar() && !clone.eleList.isEmpty()) {
            clone.scalarEle = (Element)clone.eleList.get(clone.eleList.size() - 1);
        }
        return clone;
    }

    @Override
    protected Item createInstance(Platform platform) {
        return new Parameter(platform);
    }
}

