/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.objects;

import at.ac.iiasa.ixmp.Platform;
import at.ac.iiasa.ixmp.database.AutoRollback;
import at.ac.iiasa.ixmp.database.DBUtils;
import at.ac.iiasa.ixmp.database.DbDAO;
import at.ac.iiasa.ixmp.dto.TimeseriesEntryDTO;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.ChangelogEntry;
import at.ac.iiasa.ixmp.objects.IamVariable;
import at.ac.iiasa.ixmp.objects.PlatformBound;
import at.ac.iiasa.ixmp.objects.ScenarioDbStatus;
import at.ac.iiasa.ixmp.objects.ScenarioState;
import at.ac.iiasa.ixmp.rest.v2_1.dto.DatasetDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.DatasetDefinitionDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.DatasetType;
import at.ac.iiasa.ixmp.rest.v2_1.dto.DatasetsFilterDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.NodeDTO;
import at.ac.iiasa.ixmp.rest.v2_1.dto.SourceFilter;
import at.ac.iiasa.ixmp.utils.CSVUtils;
import at.ac.iiasa.ixmp.utils.ExcelUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSeries
extends PlatformBound {
    private static final Logger log = LoggerFactory.getLogger(TimeSeries.class);
    public static final String YEAR = "Year";
    protected String type = "TimeSeries";
    protected String annotation = null;
    static final int NOT_SAVED_RUN_ID = -1;
    public static final int UNSET_META = 0;
    String model;
    String scenario;
    int version;
    int runId = -1;
    protected List<ChangelogEntry> changeLogList = new LinkedList<ChangelogEntry>();
    private final TsCache<Double, Integer, String, String, String, String> timeseriesCache = new TsCache<Double, Integer, String, String, String, String>(){

        @Override
        TsCache.CacheKey<String, String, String, String> getKey(String node, String unit, String key, Integer meta, String timesliceName) throws IxException {
            String nodeName = TimeSeries.this.getMp().getNodeName(TimeSeries.this.getMp().getNodeId(node));
            if (timesliceName == null) {
                timesliceName = TimeSeries.this.getMp().getTimesliceName(-1);
            }
            return super.getKey(nodeName, unit, key, meta, timesliceName);
        }

        @Override
        void preload(List<String> keys) throws IxException {
            Map<String, SourceFilter> keysFilters = keys.stream().collect(Collectors.toMap(key -> key, key -> new SourceFilter(DatasetType.TIMESERIES)));
            Long[] runs = new Long[]{TimeSeries.this.runId};
            DbDAO db = TimeSeries.this.getMp().getDb();
            List<DatasetDTO> datasets = db.getDatasets(new DatasetsFilterDTO(runs, keysFilters));
            this.internalPreload(datasets);
            super.preload(keys);
        }

        @Override
        void preload(String key) throws IxException {
            List datasets = TimeSeries.this.getSingleDataset(DatasetType.TIMESERIES, key);
            this.internalPreload(datasets);
            super.preload(key);
        }

        private void internalPreload(List<DatasetDTO> datasets) throws IxException {
            log.debug(String.format("loading timeseries data for %s variables...", datasets.size()));
            for (DatasetDTO ds : datasets) {
                String keyStr = ds.getSource();
                Map<Integer, String> keys = ds.getKeys();
                List<Object[]> entries = ds.getEntries();
                for (Object[] e : entries) {
                    String unitName = TimeSeries.getMappedDatasetValue(e, keys, 0);
                    String nodeName = TimeSeries.getMappedDatasetValue(e, keys, 1);
                    String timesliceName = TimeSeries.getMappedDatasetValue(e, keys, 2);
                    Integer meta = Integer.parseInt(TimeSeries.getMappedDatasetValue(e, keys, 3));
                    Integer year = Integer.parseInt(TimeSeries.getMappedDatasetValue(e, keys, 4));
                    Double value = (Double)e[5];
                    TsCache.CacheKey<String, String, String, String> cacheKey = TimeSeries.this.timeseriesCache.getKey(nodeName, unitName, keyStr, meta, timesliceName);
                    this.getCache().computeIfAbsent(cacheKey, k -> new HashMap()).put(year, value);
                    log.debug(String.format("Added cache entry for key %s: year %d, value %s", cacheKey, year, value));
                }
                log.debug(String.format("loaded timeseries data for '%s': %d entries", keyStr, entries.size()));
            }
        }

        List<Integer> getVecId(TsCache.CacheKey<String, String, String, String> key) {
            try {
                Platform mp = TimeSeries.this.getMp();
                int nodeId = mp.getNodeId((String)((TsCache.CacheKey)key).node);
                int keyId = mp.assignIamVariableId((String)((TsCache.CacheKey)key).key, (String)((TsCache.CacheKey)key).unit, TimeSeries.this.model).getId();
                int timesliceId = mp.getTimesliceId((String)((TsCache.CacheKey)key).subannual);
                return TimeSeries.getVecNdId(nodeId, keyId, ((TsCache.CacheKey)key).meta, timesliceId);
            }
            catch (IxException e) {
                log.error("Cannot get timeseries ID", (Throwable)e);
                return null;
            }
        }

        void assertUnitsAndRegionsInDB(Connection cn) throws IxException {
            DbDAO db = TimeSeries.this.getMp().getDb();
            Set units = this.getCache().keySet().stream().map(key -> (String)((TsCache.CacheKey)key).unit).collect(Collectors.toSet());
            for (String unit : units) {
                TimeSeries.this.getMp().getUnitId(unit);
            }
            Set regions = this.getCache().keySet().stream().map(key -> (String)((TsCache.CacheKey)key).node).collect(Collectors.toSet());
            for (String region : regions) {
                TimeSeries.this.getMp().getNodeId(region);
            }
        }

        @Override
        void persist(Connection cn) throws IxException {
            DbDAO db = TimeSeries.this.getMp().getDb();
            this.assertUnitsAndRegionsInDB(cn);
            Map<List<Integer>, Map<Integer, Double>> added = this.getAdded().entrySet().stream().filter(e -> !((Map)e.getValue()).isEmpty()).collect(Collectors.toMap(e -> this.getVecId((TsCache.CacheKey)e.getKey()), Map.Entry::getValue));
            Map<List<Integer>, Map<Integer, Double>> updated = this.getUpdated().entrySet().stream().filter(e -> !((Map)e.getValue()).isEmpty()).collect(Collectors.toMap(e -> this.getVecId((TsCache.CacheKey)e.getKey()), e -> ((Map)e.getValue()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, yvs -> (Double)((TsCache.ValuePair)yvs.getValue()).current))));
            Map<List<Integer>, List<Integer>> removed = this.getRemoved().entrySet().stream().filter(e -> !((Map)e.getValue()).isEmpty()).collect(Collectors.toMap(e -> this.getVecId((TsCache.CacheKey)e.getKey()), e -> new ArrayList(((Map)e.getValue()).keySet())));
            log.debug(String.format("Saving timeseries: added %d, removed: %d, updated %d", added.size(), removed.size(), updated.size()));
            Map<List<Integer>, Integer> tsInfo = db.saveTimeseriesToDB(cn, added, TimeSeries.this.runId);
            db.removeTimeseriesInDB(cn, tsInfo, removed, TimeSeries.this.runId);
            db.updateTimeseriesInDB(cn, tsInfo, updated, TimeSeries.this.runId);
            this.updateChangelog();
        }

        private void updateChangelog() {
            this.getAdded().forEach((key, yearlyValues) -> yearlyValues.forEach((year, value) -> TimeSeries.this.addToChangelog("add timeseries entry", (String)key.getKey(), (String)key.getNode() + "|" + year, (Double)value, null)));
            this.getUpdated().forEach((key, yearlyValues) -> yearlyValues.forEach((year, value) -> TimeSeries.this.addToChangelog("update timeseries entry", (String)key.getKey(), (String)key.getNode() + "|" + year, (Double)value.current, (Double)value.previous)));
            this.getRemoved().forEach((key, yearlyValues) -> yearlyValues.forEach((year, value) -> TimeSeries.this.addToChangelog("remove timeseries entry", (String)key.getKey(), (String)key.getNode() + "|" + year, (Double)null, (Double)value)));
        }
    };
    private final TsCache<String, Integer, String, String, String, String> layersCache = new TsCache<String, Integer, String, String, String, String>(){

        @Override
        void preload(String key) throws IxException {
            List datasets = TimeSeries.this.getSingleDataset(DatasetType.LAYER, key);
            for (DatasetDTO ds : datasets) {
                String keyStr = ds.getSource();
                Map<Integer, String> keys = ds.getKeys();
                List<Object[]> entries = ds.getEntries();
                for (Object[] e : entries) {
                    String unitName = TimeSeries.getMappedDatasetValue(e, keys, 0);
                    String nodeName = TimeSeries.getMappedDatasetValue(e, keys, 1);
                    String timesliceName = TimeSeries.getMappedDatasetValue(e, keys, 2);
                    Integer meta = Integer.parseInt(TimeSeries.getMappedDatasetValue(e, keys, 3));
                    Integer year = Integer.parseInt(TimeSeries.getMappedDatasetValue(e, keys, 4));
                    String value = (String)e[5];
                    TsCache.CacheKey<String, String, String, String> cacheKey = TimeSeries.this.timeseriesCache.getKey(nodeName, unitName, keyStr, meta, timesliceName);
                    this.getCache().computeIfAbsent(cacheKey, k -> new HashMap()).put(year, value);
                }
            }
            log.debug(String.format("loaded geo data for '%s'...", key));
            super.preload(key);
        }

        void createUnitsAndRegions() throws IxException {
            Platform mp = TimeSeries.this.getMp();
            for (TsCache.CacheKey key : this.getCache().keySet()) {
                mp.getUnitId((String)key.unit, true, TimeSeries.this.model);
                mp.assignIamVariableId((String)key.key, (String)key.unit, TimeSeries.this.model);
            }
        }

        @Override
        void persist(Connection cn) throws IxException {
            Object value;
            TsCache.CacheKey key;
            DbDAO db = TimeSeries.this.getMp().getDb();
            this.createUnitsAndRegions();
            for (Map.Entry entry : this.getAdded().entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                if (value.isEmpty()) continue;
                log.debug("Adding geo data " + key + ": " + value);
                db.addLayersToDB(cn, TimeSeries.this.runId, (String)key.key, (String)key.unit, (String)key.node, (String)key.subannual, key.meta, (Map<Integer, String>)value);
            }
            for (Map.Entry entry : this.getUpdated().entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                if (value.isEmpty()) continue;
                log.debug("Updating geo data " + key + ": " + value);
                Map<Integer, String> yearlyData = value.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)((TsCache.ValuePair)e.getValue()).current));
                db.updateLayersInDB(cn, TimeSeries.this.runId, (String)key.key, (String)key.unit, (String)key.node, (String)key.subannual, key.meta, yearlyData);
            }
            for (Map.Entry entry : this.getRemoved().entrySet()) {
                key = entry.getKey();
                value = entry.getValue().keySet();
                if (value.isEmpty()) continue;
                log.debug("Removing geo data " + key + ": " + value);
                db.removeLayersFromDB(cn, TimeSeries.this.runId, (String)key.key, (String)key.unit, (String)key.node, (String)key.subannual, key.meta, (Set<Integer>)value);
            }
        }

        @Override
        TsCache.CacheKey<String, String, String, String> getKey(String node, String unit, String key, Integer meta, String timesliceName) throws IxException {
            if (timesliceName == null) {
                timesliceName = TimeSeries.this.getMp().getTimesliceName(-1);
            }
            return super.getKey(node, unit, key, meta, timesliceName);
        }
    };
    protected ScenarioState state = ScenarioState.DEFAULT;

    private static String getMappedDatasetValue(Object[] row, Map<Integer, String> keys, int index) {
        Integer key = (Integer)row[index];
        return keys.get(key);
    }

    private List<DatasetDTO> getSingleDataset(DatasetType datasetType, String key) throws IxException {
        return this.getMp().getDb().getDatasets(new DatasetsFilterDTO(new Long[]{this.runId}, Collections.singletonMap(key, new SourceFilter(datasetType))));
    }

    public TimeSeries(Platform mp, String model, String scenario, Boolean isNew, String annotation) throws IxException {
        super(mp);
        if (isNew.booleanValue()) {
            this.model = model;
            this.scenario = scenario;
            this.version = 0;
            this.annotation = annotation;
            this.state = ScenarioState.NEW;
        } else {
            DbDAO db = mp.getDb();
            this.model = model;
            this.scenario = scenario;
            this.runId = db.getRunId(model, scenario);
            if (this.runId == -1) {
                throw new IxException(String.format("There exists no default TimeSeries '%s|%s' in the database!", model, scenario));
            }
            Map<String, Object> names = db.getModelScenarioName(this.runId);
            this.version = (Integer)names.get("version");
            this.annotation = (String)names.get("annotation");
        }
    }

    public TimeSeries(Platform mp, int runId) throws IxException {
        super(mp);
        this.runId = runId;
        Map<String, Object> names = mp.getDb().getModelScenarioName(runId);
        this.model = (String)names.get("model");
        this.scenario = (String)names.get("scenario");
        this.version = (Integer)names.get("version");
        this.annotation = (String)names.get("annotation");
    }

    public TimeSeries(Platform mp, String model, String scenario) throws IxException {
        this(mp, model, scenario, false, null);
    }

    public TimeSeries(Platform mp, String model, String scenario, int version) throws IxException {
        super(mp);
        this.model = model;
        this.scenario = scenario;
        this.version = version;
        this.runId = mp.getDb().getRunId(model, scenario, version);
    }

    public int getRunId() {
        return this.runId;
    }

    public String getModel() {
        return this.model;
    }

    public String getScenario() {
        return this.scenario;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isDefault() throws IxException {
        this.assertTimeseriesIsLockedInDB();
        return this.getMp().getDb().isDefaultVersion(this.runId);
    }

    public Timestamp getLastUpdateTimestamp() throws IxException {
        return this.getMp().getDb().getLastUpdTimestamp(this.runId);
    }

    public void addGeoData(String nodeName, String keyString, String timesliceName, int year, String layerInfo, String unitName, int meta) throws IxException {
        this.layersCache.add(this.layersCache.getKey(nodeName, unitName, keyString, meta, timesliceName), new HashMap<Integer, String>(Collections.singletonMap(year, layerInfo)));
    }

    public void removeGeoData(String nodeName, String keyString, String timesliceName, List<Integer> years, String unitName) throws IxException {
        this.layersCache.remove(this.layersCache.getKey(nodeName, unitName, keyString, 0, timesliceName), new HashSet<Integer>(years));
    }

    public List<Map<String, Object>> getGeoData() throws IxException {
        List<DatasetDefinitionDTO> layers = this.getDatasets(DatasetType.LAYER);
        for (DatasetDefinitionDTO layer : layers) {
            this.layersCache.preload(layer.getSource());
        }
        return ((TsCache)this.layersCache).cache.entrySet().stream().map(e -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            TsCache.CacheKey key = (TsCache.CacheKey)e.getKey();
            map.put("keyString", key.key);
            map.put("unitName", key.unit);
            map.put("nodeName", key.node);
            map.put("subannual", key.subannual);
            map.put("meta", key.meta);
            map.put("yearlyData", e.getValue());
            return map;
        }).collect(Collectors.toList());
    }

    public void addTimeseries(String nodeName, String keyString, String timesliceName, Integer year, Double value, String unitName, int meta) throws IxException {
        if (TimeSeries.isYearAndValueInvalid(year, value)) {
            throw new IxException(String.format("Variable %s year-value combination contains incorrect values", keyString));
        }
        this.addTimeseries(nodeName, keyString, timesliceName, new LinkedHashMap<Integer, Double>(Collections.singletonMap(year, value)), unitName, meta);
    }

    public void addTimeseries(String nodeName, String keyString, String timesliceName, Map<Integer, Double> yearlyData, String unitName, int meta) throws IxException {
        this.assertTimeSeriesIsEditable(true);
        if (timesliceName == null) {
            timesliceName = YEAR;
        }
        if (yearlyData.entrySet().stream().anyMatch(e -> TimeSeries.isYearAndValueInvalid((Integer)e.getKey(), (Double)e.getValue()))) {
            throw new IxException(String.format("Variable %s year-value map contains incorrect values", keyString));
        }
        this.timeseriesCache.add(this.timeseriesCache.getKey(nodeName, unitName, keyString, meta, timesliceName), yearlyData);
    }

    private static boolean isYearAndValueInvalid(Integer year, Double value) {
        return year == null || value == null;
    }

    public void removeTimeseries(String nodeName, String keyString, String timesliceName, List<Integer> years, String unitName) throws IxException {
        this.assertTimeSeriesIsEditable(true);
        this.timeseriesCache.remove(this.timeseriesCache.getKey(nodeName, unitName, keyString, 0, timesliceName), new HashSet<Integer>(years));
    }

    public void preloadAllTimeseries() throws IxException {
        long start = System.currentTimeMillis();
        List<DatasetDefinitionDTO> defs = this.getDatasets(DatasetType.TIMESERIES);
        int maxAtOnce = 500;
        log.debug(String.format("Preloading all timeseries data (variables: %d)...", defs.size()));
        AtomicInteger counter = new AtomicInteger();
        Collection<List<DatasetDefinitionDTO>> groups = defs.stream().collect(Collectors.groupingBy(it -> counter.getAndIncrement() / 500)).values();
        for (List<DatasetDefinitionDTO> group : groups) {
            List keys = group.stream().map(DatasetDefinitionDTO::getSource).collect(Collectors.toList());
            this.timeseriesCache.preload(keys);
        }
        log.debug(String.format("Preloaded all timeseries data (variables: %d, time: %d)", defs.size(), System.currentTimeMillis() - start));
    }

    protected List<DatasetDefinitionDTO> getDatasets(DatasetType timeseries) throws IxException {
        return this.getMp().getDb().getDatasetsDefinitions(new DatasetsFilterDTO(new Long[]{this.runId}, Collections.emptyMap())).stream().filter(e -> e.getType().equals((Object)timeseries)).collect(Collectors.toList());
    }

    public void loadTimeseriesFromXLS(String filename) throws IxException {
        ExcelUtils.loadTimeseriesFromXLS(this, filename);
    }

    public static List<Integer> getVecNdId(int nodeId, int keyId, int meta, int timesliceId) {
        Vector<Integer> vecNdId = new Vector<Integer>(Arrays.asList(nodeId, keyId, meta));
        if (timesliceId != -1) {
            vecNdId.add(timesliceId);
        }
        return vecNdId;
    }

    public void loadTimeseriesFromCSV(String filename) throws IxException {
        CSVUtils.loadTimeseriesFromCSV(this, filename);
    }

    public List<TimeseriesEntryDTO> getTimeseries() throws IxException {
        return this.getTimeseries(null, null, null, null, null);
    }

    public List<TimeseriesEntryDTO> getTimeseries(List<String> regions, List<String> variables, List<String> units, List<Integer> timeslices, List<Integer> years) throws IxException {
        if (this.state == ScenarioState.NEW) {
            throw new IxException(String.format("This %s was not yet committed to the database!", this.type));
        }
        this.assertTimeseriesIsLockedInDB();
        List<Integer> variableUnitKeyIds = null;
        List<Integer> nodeIds = null;
        Platform mp = this.getMp();
        if (!DBUtils.isEmpty(regions)) {
            nodeIds = mp.getNodeIdList(regions);
        }
        if (!(DBUtils.isEmpty(variables) && DBUtils.isEmpty(units) || (variableUnitKeyIds = mp.getIamVariableIds(variables, units)).size() != 0)) {
            return new LinkedList<TimeseriesEntryDTO>();
        }
        return mp.getDb().getTimeseriesFromDB(Collections.singletonList(this.runId), nodeIds, variableUnitKeyIds, timeslices, years, rs -> TimeseriesEntryDTO.fromRs(rs, true));
    }

    public List<IamVariable> getIamVariables() throws IxException {
        LinkedList<Long> runIds = new LinkedList<Long>();
        runIds.add(Long.valueOf(this.runId));
        Platform mp = this.getMp();
        Map<Long, List<IamVariable>> variables = mp.getIamVariablesOfRuns(runIds);
        return variables.get(this.runId);
    }

    public void addToChangelog(String pOperation, String pItem, String pKey) {
        if (this.isChangeLogged().booleanValue()) {
            this.changeLogList.add(new ChangelogEntry(pOperation, pItem, pKey));
        }
    }

    public void addToChangelog(String pOperation, String pItem, String pKey, Double pNewValue, Double pPrevValue) {
        if (this.isChangeLogged().booleanValue()) {
            this.changeLogList.add(new ChangelogEntry(pOperation, pItem, pKey, pNewValue, pPrevValue));
        }
    }

    public void addToChangelog(String pOperation, String pItem, String pKey, Integer pNewValue, Integer pPrevValue) {
        if (this.isChangeLogged().booleanValue()) {
            this.changeLogList.add(new ChangelogEntry(pOperation, pItem, pKey, (double)pNewValue, (double)pPrevValue));
        }
    }

    public boolean isCheckedOut() {
        return this.state.getStateInDB() == ScenarioDbStatus.LOCKED_IN_DB;
    }

    public void assertTimeSeriesIsEditable(boolean timeseriesOnly) throws IxException {
        if (this.state == ScenarioState.DEFAULT) {
            throw new IxException(String.format("This %s cannot be edited, do a checkout first!", this.type));
        }
        if (!timeseriesOnly && this.state == ScenarioState.CHECKED_OUT_FOR_TIMESERIES_UPDATE) {
            throw new IxException(String.format("Only timeseries data be edited for this %s!", this.type));
        }
    }

    protected void assertTimeseriesIsLockedInDB() throws IxException {
        this.assertTimeSeriesIsLockedInDB(false);
    }

    protected void assertTimeSeriesIsLockedInDB(boolean allowClone) throws IxException {
        if (this.state != ScenarioState.DEFAULT) {
            throw new IxException(String.format("This %s must be checked in before performing this operation!", this.type));
        }
        Platform mp = this.getMp();
        ScenarioDbStatus dbStatus = mp.getDb().getStatus(this.runId);
        if (dbStatus == ScenarioDbStatus.LOCKED_IN_DB) {
            throw new IxException(String.format("This %s is currently locked by another user!", this.type));
        }
        if (dbStatus == ScenarioDbStatus.FROZEN_IN_DB && !allowClone) {
            throw new IxException(String.format("This %s is locked and frozen in the database!", this.type));
        }
    }

    protected Boolean isChangeLogged() {
        return this.state.isChangeLogged();
    }

    public void checkOut(boolean timeseriesOnly) throws IxException {
        String osUser = System.getProperty("user.name", "(unknown)");
        this.checkOut(osUser, timeseriesOnly);
    }

    public void checkOut(String user, boolean timeseriesOnly) throws IxException {
        if (this.state == ScenarioState.NEW) {
            throw new IxException(String.format("This %s was not yet saved to the database - do a commit first!", this.type));
        }
        DbDAO db = this.getMp().getDb();
        ScenarioDbStatus dbStatus = db.getStatus(this.runId);
        if (dbStatus == ScenarioDbStatus.LOCKED_IN_DB) {
            String lockUser = db.getLockInfo(this.runId).getLockUser();
            throw new IxException(String.format("This %s is currently locked by user %s", this.type, lockUser));
        }
        if (dbStatus == ScenarioDbStatus.FROZEN_IN_DB) {
            throw new IxException(String.format("This %s is locked and frozen in the database!", this.type));
        }
        db.setStatus(user, this.runId, ScenarioDbStatus.LOCKED_IN_DB);
        this.state = timeseriesOnly ? ScenarioState.CHECKED_OUT_FOR_TIMESERIES_UPDATE : ScenarioState.CHECKED_OUT_FOR_ALL_UPDATES;
    }

    public void commit(String commitComment) throws IxException {
        String osUser = System.getProperty("user.name", "(unknown)");
        this.commit(osUser, commitComment);
    }

    public void commit(String user, String commitComment) throws IxException {
        if (this.state == ScenarioState.DEFAULT) {
            throw new IxException("This 'TimeSeries' is not checked out, no changes to be committed!");
        }
        Platform mp = this.getMp();
        DbDAO db = mp.getDb();
        this.preCommit();
        try (Connection dbConn = db.getPooledConn();
             AutoRollback tm = new AutoRollback(dbConn);){
            String script = null;
            if (this.runId == -1) {
                this.runId = db.assignRunId(dbConn, this.model, this.scenario, null, this.annotation, user);
                this.version = db.getVersion(dbConn, this.runId);
            }
            if (this.state.isChangeLogged()) {
                script = "commit changes to TimeSeries";
                log.info(String.format("committing changes of TimeSeries '%s|%s' to the database (runid: %d)...", this.model, this.scenario, this.runId));
            } else if (this.state == ScenarioState.NEW) {
                script = "save new TimeSeries";
                log.info(String.format("saving TimeSeries '%s|%s' to the database (runid: %d)...", this.model, this.scenario, this.runId));
            }
            this.persistTimeseriesCaches(dbConn);
            this.finalizeCommit(dbConn, script, commitComment, user);
            tm.commit();
        }
        catch (IxException | SQLException e) {
            throw new IxException("There was a problem writing to the database - no changes were saved!", e);
        }
        this.checkIn(user);
    }

    protected void persistTimeseriesCaches(Connection dbConn) throws IxException {
        this.timeseriesCache.persist(dbConn);
        this.layersCache.persist(dbConn);
    }

    protected void preCommit() throws IxException {
        Set units = this.getTimeseriesCache().getCache().keySet().stream().map(key -> (String)((TsCache.CacheKey)key).unit).collect(Collectors.toSet());
        for (String unit : units) {
            this.getMp().getUnitId(unit, true, this.model);
        }
    }

    protected void finalizeCommit(Connection dbConn, String script, String commitComment, String user) throws IxException {
        DbDAO db = this.getMp().getDb();
        int annotationId = db.assignAnnotationId(dbConn);
        db.writeAnnotation(dbConn, this.runId, "ok", annotationId, script, commitComment);
        db.writeChangeLog(dbConn, annotationId, this.changeLogList, this.runId);
        if (this.state.isChangeLogged()) {
            log.info(String.format("done updating %s '%s|%s' to the database (runid: %d, version: %d)!", this.type, this.model, this.scenario, this.runId, this.version));
        } else if (this.state == ScenarioState.NEW) {
            log.info(String.format("done saving %s '%s|%s' to the database (runid: %d, version: %d)!", this.type, this.model, this.scenario, this.runId, this.version));
        }
    }

    public void setAsDefaultVersion() throws IxException {
        if (this.runId == -1) {
            throw new IxException(String.format("this %s was not yet saved to the database - no run id assigned yet!", this.type));
        }
        if (this.state != ScenarioState.DEFAULT) {
            throw new IxException(String.format("this %s must be checked in before setting it as default version!", this.type));
        }
        DbDAO db = this.getMp().getDb();
        int prevDefaultId = db.getRunId(this.model, this.scenario, false);
        if (prevDefaultId != this.runId) {
            try (Connection conn = db.getPooledConn();
                 AutoRollback tm = new AutoRollback(conn);){
                int annotationId = db.assignAnnotationId(conn);
                db.writeAnnotation(conn, this.runId, "ok", annotationId, "set as default", "previous default: " + prevDefaultId);
                db.setDefaultVersion(conn, this.model, this.scenario, this.runId);
                tm.commit();
                log.info(String.format("assigned this %s as default version for '%s|%s'", this.type, this.model, this.scenario));
            }
            catch (SQLException e) {
                log.error("Setting as default version failed", (Throwable)e);
            }
        } else {
            log.info(String.format("this %s is already assigned as default version for '%s|%s'", this.type, this.model, this.scenario));
        }
    }

    public void discardChanges() throws IxException {
        String osUser = System.getProperty("user.name", "(unknown)");
        this.discardChanges(osUser);
    }

    public void discardChanges(String user) throws IxException {
        if (this.state == ScenarioState.NEW) {
            throw new IxException("This TimeSeries was not yet saved to the database - no changes to discard!");
        }
        if (this.state == ScenarioState.DEFAULT) {
            throw new IxException("This TimeSeries is not checked out - no changes to discard!");
        }
        this.checkIn(user);
    }

    protected void checkIn() throws IxException {
        this.checkIn(null);
    }

    protected void checkIn(String user) throws IxException {
        Platform mp = this.getMp();
        mp.getDb().setStatus(user, this.runId, ScenarioDbStatus.AVAILABLE_IN_DB);
        this.state = ScenarioState.DEFAULT;
        this.changeLogList.clear();
        this.timeseriesCache.clear();
        this.layersCache.clear();
    }

    protected void copyFrom(TimeSeries source) throws IxException {
        this.type = source.type;
        this.annotation = source.annotation;
        if (this.model == null) {
            this.model = source.model;
        }
        if (this.scenario == null) {
            this.scenario = source.scenario;
        }
        this.version = 0;
        this.changeLogList = new LinkedList<ChangelogEntry>(source.changeLogList);
        this.addMissingRegionsFrom(source);
        this.addMissingUnitsFrom(source);
        source.preloadAllTimeseries();
        for (Map.Entry<TsCache.CacheKey<String, String, String, String>, Map<Integer, Double>> entry : source.getTimeseriesCache().getCache().entrySet()) {
            this.timeseriesCache.add(entry.getKey(), entry.getValue());
        }
        log.debug(String.format("Added %d timeseries points from source scenario", source.getTimeseriesCache().getCache().size()));
        this.state = ScenarioState.NEW;
    }

    public void remove() throws IxException {
        if (this.runId == -1) {
            throw new IxException("Scenario is not yet saved. Nothing to delete");
        }
        log.info(String.format("Removing %s from database...", this.type));
        this.getMp().getDb().removeScenarioFromDB(this.runId);
        this.runId = -1;
        this.state = ScenarioState.UNAVAILABLE;
        log.info(String.format("Done removing %s from database!", this.type));
    }

    private void addMissingUnitsFrom(TimeSeries source) throws IxException {
        Set units = source.getTimeseries().stream().map(TimeseriesEntryDTO::getUnit).collect(Collectors.toSet());
        for (String unit : units) {
            this.getMp().getUnitId(unit, true, "clone");
        }
    }

    private void addMissingRegionsFrom(TimeSeries source) throws IxException {
        Set regions = source.getTimeseries().stream().map(TimeseriesEntryDTO::getRegion).collect(Collectors.toSet());
        for (String region : regions) {
            this.createNodeIfMissing(source.getMp().getDb(), region);
        }
    }

    private void createNodeIfMissing(DbDAO sourceDb, String region) throws IxException {
        if (this.getMp().getNodeId(region, false) == null) {
            List<NodeDTO> nodes = sourceDb.getNodeFromDB(region, -1, null, false);
            for (NodeDTO node : nodes) {
                this.getMp().addNode(node.getName(), node.getParent(), node.getHierarchy());
            }
        }
    }

    public String toString() {
        return "TimeSeries(type=" + this.type + ", annotation=" + this.annotation + ", model=" + this.getModel() + ", scenario=" + this.getScenario() + ", version=" + this.getVersion() + ", runId=" + this.getRunId() + ", changeLogList=" + this.changeLogList + ", timeseriesCache=" + this.getTimeseriesCache() + ", layersCache=" + this.getLayersCache() + ", state=" + (Object)((Object)this.state) + ")";
    }

    protected TsCache<Double, Integer, String, String, String, String> getTimeseriesCache() {
        return this.timeseriesCache;
    }

    protected TsCache<String, Integer, String, String, String, String> getLayersCache() {
        return this.layersCache;
    }

    static abstract class TsCache<VALUE, YEAR, KEY, NODE, SUBANNUAL, UNIT> {
        private Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>> cache = new HashMap<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>>();
        private Set<KEY> keysInCache = new HashSet<KEY>();
        private Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>> added = new HashMap<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>>();
        private Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, ValuePair>> updated = new HashMap<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, ValuePair>>();
        private Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>> removed = new HashMap<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>>();

        void preload(KEY keyString) throws IxException {
            this.getKeysInCache().add(keyString);
        }

        void preload(List<KEY> keys) throws IxException {
            this.getKeysInCache().addAll(keys);
        }

        void clear() {
            log.debug("Cleaning cache...");
            this.cache.clear();
            this.added.clear();
            this.updated.clear();
            this.removed.clear();
            this.keysInCache.clear();
        }

        abstract void persist(Connection var1) throws IxException;

        CacheKey<KEY, NODE, SUBANNUAL, UNIT> getKey(NODE node, UNIT unit, KEY key, Integer meta, SUBANNUAL SUBANNUAL) throws IxException {
            return new CacheKey<KEY, NODE, SUBANNUAL, UNIT>(key, unit, node, SUBANNUAL, meta);
        }

        protected KeyValues getCacheOrInit(CacheKey<KEY, NODE, SUBANNUAL, UNIT> key) throws IxException {
            if (!this.keysInCache.contains(((CacheKey)key).key)) {
                this.preload(((CacheKey)key).key);
            }
            Map yearlyValues = this.cache.computeIfAbsent(key, k -> new HashMap());
            Map addedYears = this.added.computeIfAbsent(key, k -> new HashMap());
            Map updatedYears = this.updated.computeIfAbsent(key, k -> new HashMap());
            Map removedYears = this.removed.computeIfAbsent(key, k -> new HashMap());
            return new KeyValues(yearlyValues, addedYears, updatedYears, removedYears);
        }

        void add(CacheKey<KEY, NODE, SUBANNUAL, UNIT> key, Map<YEAR, VALUE> values) throws IxException {
            KeyValues kv = this.getCacheOrInit(key);
            log.debug(String.format("Looking for cache by key %s: %d entries found", key, kv.yearlyValues.size()));
            values.forEach((year, value) -> {
                if (year == null) {
                    return;
                }
                if (kv.yearlyValues.containsKey(year)) {
                    if (kv.addedYears.containsKey(year)) {
                        kv.addedYears.put(year, value);
                    } else {
                        kv.updatedYears.put(year, new ValuePair(value, kv.yearlyValues.get(year)));
                    }
                } else if (kv.removedYears.containsKey(year)) {
                    kv.updatedYears.put(year, new ValuePair(value, kv.removedYears.get(year)));
                    kv.removedYears.remove(year);
                } else {
                    kv.addedYears.put(year, value);
                }
                kv.yearlyValues.put(year, value);
            });
        }

        void remove(CacheKey<KEY, NODE, SUBANNUAL, UNIT> key, Set<YEAR> years) throws IxException {
            KeyValues kv = this.getCacheOrInit(key);
            years.forEach(year -> {
                if (year == null) {
                    return;
                }
                if (kv.yearlyValues.containsKey(year)) {
                    if (kv.addedYears.containsKey(year)) {
                        kv.addedYears.remove(year);
                    } else if (kv.updatedYears.containsKey(year)) {
                        kv.removedYears.put(year, kv.updatedYears.get((Object)year).previous);
                        kv.updatedYears.remove(year);
                    } else {
                        kv.removedYears.put(year, kv.yearlyValues.get(year));
                    }
                    kv.yearlyValues.remove(year);
                } else {
                    log.debug(String.format("Cannot remove already removed or non-existing value for key %s: year %s", key, year));
                }
            });
        }

        public Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>> getCache() {
            return this.cache;
        }

        public Set<KEY> getKeysInCache() {
            return this.keysInCache;
        }

        public Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>> getAdded() {
            return this.added;
        }

        public Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, ValuePair>> getUpdated() {
            return this.updated;
        }

        public Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>> getRemoved() {
            return this.removed;
        }

        public void setCache(Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>> cache) {
            this.cache = cache;
        }

        public void setKeysInCache(Set<KEY> keysInCache) {
            this.keysInCache = keysInCache;
        }

        public void setAdded(Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>> added) {
            this.added = added;
        }

        public void setUpdated(Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, ValuePair>> updated) {
            this.updated = updated;
        }

        public void setRemoved(Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>> removed) {
            this.removed = removed;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TsCache)) {
                return false;
            }
            TsCache other = (TsCache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>> this$cache = this.getCache();
            Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>> other$cache = other.getCache();
            if (this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache)) {
                return false;
            }
            Set<KEY> this$keysInCache = this.getKeysInCache();
            Set<KEY> other$keysInCache = other.getKeysInCache();
            if (this$keysInCache == null ? other$keysInCache != null : !((Object)this$keysInCache).equals(other$keysInCache)) {
                return false;
            }
            Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>> this$added = this.getAdded();
            Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>> other$added = other.getAdded();
            if (this$added == null ? other$added != null : !((Object)this$added).equals(other$added)) {
                return false;
            }
            Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, ValuePair>> this$updated = this.getUpdated();
            Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, ValuePair>> other$updated = other.getUpdated();
            if (this$updated == null ? other$updated != null : !((Object)this$updated).equals(other$updated)) {
                return false;
            }
            Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>> this$removed = this.getRemoved();
            Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>> other$removed = other.getRemoved();
            return !(this$removed == null ? other$removed != null : !((Object)this$removed).equals(other$removed));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TsCache;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>> $cache = this.getCache();
            result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
            Set<KEY> $keysInCache = this.getKeysInCache();
            result = result * 59 + ($keysInCache == null ? 43 : ((Object)$keysInCache).hashCode());
            Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>> $added = this.getAdded();
            result = result * 59 + ($added == null ? 43 : ((Object)$added).hashCode());
            Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, ValuePair>> $updated = this.getUpdated();
            result = result * 59 + ($updated == null ? 43 : ((Object)$updated).hashCode());
            Map<CacheKey<KEY, NODE, SUBANNUAL, UNIT>, Map<YEAR, VALUE>> $removed = this.getRemoved();
            result = result * 59 + ($removed == null ? 43 : ((Object)$removed).hashCode());
            return result;
        }

        public String toString() {
            return "TimeSeries.TsCache(cache=" + this.getCache() + ", keysInCache=" + this.getKeysInCache() + ", added=" + this.getAdded() + ", updated=" + this.getUpdated() + ", removed=" + this.getRemoved() + ")";
        }

        private class KeyValues {
            final Map<YEAR, VALUE> yearlyValues;
            final Map<YEAR, VALUE> addedYears;
            final Map<YEAR, ValuePair> updatedYears;
            final Map<YEAR, VALUE> removedYears;

            public KeyValues(Map<YEAR, VALUE> yearlyValues, Map<YEAR, VALUE> addedYears, Map<YEAR, ValuePair> updatedYears, Map<YEAR, VALUE> removedYears) {
                this.yearlyValues = yearlyValues;
                this.addedYears = addedYears;
                this.updatedYears = updatedYears;
                this.removedYears = removedYears;
            }
        }

        class ValuePair {
            VALUE current;
            VALUE previous;

            public ValuePair(VALUE current, VALUE previous) {
                this.current = current;
                this.previous = previous;
            }
        }

        static class CacheKey<KEY, NODE, SUBANNUAL, UNIT> {
            private KEY key;
            private UNIT unit;
            private NODE node;
            private SUBANNUAL subannual;
            private int meta;

            public KEY getKey() {
                return this.key;
            }

            public UNIT getUnit() {
                return this.unit;
            }

            public NODE getNode() {
                return this.node;
            }

            public SUBANNUAL getSubannual() {
                return this.subannual;
            }

            public int getMeta() {
                return this.meta;
            }

            public void setKey(KEY key) {
                this.key = key;
            }

            public void setUnit(UNIT unit) {
                this.unit = unit;
            }

            public void setNode(NODE node) {
                this.node = node;
            }

            public void setSubannual(SUBANNUAL subannual) {
                this.subannual = subannual;
            }

            public void setMeta(int meta) {
                this.meta = meta;
            }

            public CacheKey(KEY key, UNIT unit, NODE node, SUBANNUAL subannual, int meta) {
                this.key = key;
                this.unit = unit;
                this.node = node;
                this.subannual = subannual;
                this.meta = meta;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CacheKey)) {
                    return false;
                }
                CacheKey other = (CacheKey)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                KEY this$key = this.getKey();
                KEY other$key = other.getKey();
                if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                    return false;
                }
                UNIT this$unit = this.getUnit();
                UNIT other$unit = other.getUnit();
                if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
                    return false;
                }
                NODE this$node = this.getNode();
                NODE other$node = other.getNode();
                if (this$node == null ? other$node != null : !this$node.equals(other$node)) {
                    return false;
                }
                SUBANNUAL this$subannual = this.getSubannual();
                SUBANNUAL other$subannual = other.getSubannual();
                if (this$subannual == null ? other$subannual != null : !this$subannual.equals(other$subannual)) {
                    return false;
                }
                return this.getMeta() == other.getMeta();
            }

            protected boolean canEqual(Object other) {
                return other instanceof CacheKey;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                KEY $key = this.getKey();
                result = result * 59 + ($key == null ? 43 : $key.hashCode());
                UNIT $unit = this.getUnit();
                result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
                NODE $node = this.getNode();
                result = result * 59 + ($node == null ? 43 : $node.hashCode());
                SUBANNUAL $subannual = this.getSubannual();
                result = result * 59 + ($subannual == null ? 43 : $subannual.hashCode());
                result = result * 59 + this.getMeta();
                return result;
            }

            public String toString() {
                return "TimeSeries.TsCache.CacheKey(key=" + this.getKey() + ", unit=" + this.getUnit() + ", node=" + this.getNode() + ", subannual=" + this.getSubannual() + ", meta=" + this.getMeta() + ")";
            }
        }
    }
}

