/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.security;

import at.ac.iiasa.ixmp.database.ConfigProvider;
import at.ac.iiasa.ixmp.dto.AccessRequestDTO;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.security.AccessType;
import at.ac.iiasa.ixmp.security.EntityType;
import at.ac.iiasa.ixmp.utils.ApplicationConfig;
import at.ac.iiasa.ixmp.utils.AuthServerConfig;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SecurityService {
    private static final Logger log = LoggerFactory.getLogger(SecurityService.class);
    private final AuthServerConfig config;
    private final ApplicationConfig application;
    private final WebTarget target;
    private String authToken;
    public static final String ALL = "*";
    public static final String ADMIN_GROUP = "Admin";
    public static final String GUEST_GROUP = "Guest";

    public SecurityService() throws IxException {
        this("ixmp.properties");
    }

    public SecurityService(ApplicationConfig applicationConfig, AuthServerConfig serverConfig) {
        this.application = applicationConfig;
        this.config = serverConfig;
        Client client = ClientBuilder.newClient();
        this.target = client.target(this.config.url());
    }

    public SecurityService(String props) throws IxException {
        this(ConfigProvider.getConfig("application", props, ApplicationConfig.class), ConfigProvider.getConfig("config.server", props, AuthServerConfig.class));
    }

    public SecurityService(AuthServerConfig config, ApplicationConfig application, Client client) {
        this.config = config;
        this.application = application;
        this.target = client.target(config.url());
    }

    public String getApplicationTag() {
        return this.application.tag();
    }

    public void grantDirectUserAccess(String user, EntityType entityType, String entityId, AccessType accessType) throws IxException {
        AccessRequestDTO accessRequest = new AccessRequestDTO(user, this.getApplicationTag(), entityType.name(), accessType.name(), entityId);
        WebTarget accessGrantTarget = this.target.path("access/grant");
        Response accessResponse = accessGrantTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)String.format("Bearer %s", this.getToken(false))).post(Entity.json((Object)accessRequest));
        if (accessResponse.getStatusInfo().equals(Response.Status.UNAUTHORIZED)) {
            accessResponse = accessGrantTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)String.format("Bearer %s", this.getToken(true))).post(Entity.json((Object)accessRequest));
        }
        if (!accessResponse.getStatusInfo().equals(Response.Status.OK)) {
            log.error(String.format("Cannot grant access (status: %s): %s", accessResponse.getStatusInfo().getReasonPhrase(), accessRequest));
        }
    }

    public void revokeDirectUserAccess(String user, EntityType entityType, String entityId, AccessType accessType) throws IxException {
        AccessRequestDTO accessRequest = new AccessRequestDTO(user, this.getApplicationTag(), entityType.name(), accessType.name(), entityId);
        WebTarget accessRevokeTarget = this.target.path("access/revoke");
        Response accessResponse = accessRevokeTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)String.format("Bearer %s", this.getToken(false))).post(Entity.json((Object)accessRequest));
        if (accessResponse.getStatusInfo().equals(Response.Status.UNAUTHORIZED)) {
            accessResponse = accessRevokeTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)String.format("Bearer %s", this.getToken(true))).post(Entity.json((Object)accessRequest));
        }
        if (!accessResponse.getStatusInfo().equals(Response.Status.OK)) {
            log.error(String.format("Cannot revoke access (status: %s): %s", accessResponse.getStatusInfo().getReasonPhrase(), accessRequest));
        }
    }

    private synchronized String getToken(boolean forceRenew) throws IxException {
        if (this.authToken == null || forceRenew) {
            try {
                HashMap<String, String> loginPayload = new HashMap<String, String>();
                loginPayload.put("username", this.config.username());
                loginPayload.put("password", this.config.password());
                Response loginResponse = this.target.path("login").request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.json(loginPayload));
                Response.StatusType loginStatus = loginResponse.getStatusInfo();
                if (!loginStatus.equals(Response.Status.OK)) {
                    throw this.loggedIxException(String.format("Cannot authenticate on %s (status: %d, reason: %s)", this.config.url(), loginStatus.getStatusCode(), loginStatus.getReasonPhrase()), null);
                }
                this.authToken = ((String)loginResponse.readEntity(String.class)).replaceAll("\"", "");
                log.debug(String.format("Authenticated successfully on %s", this.config.url()));
            }
            catch (IllegalStateException | ResponseProcessingException e) {
                throw this.loggedIxException("Cannot process auth server login response", e);
            }
            catch (ProcessingException e) {
                throw this.loggedIxException("Cannot send login request to auth server", e);
            }
        }
        return this.authToken;
    }

    public boolean checkUserAccess(String username, EntityType entityType, String entityId, AccessType accessType) throws IxException {
        AccessRequestDTO accessRequest = new AccessRequestDTO(username, this.getApplicationTag(), entityType.name(), accessType.name(), entityId);
        return this.checkSingleAccess(accessRequest);
    }

    public List<Boolean> checkUserAccess(String username, EntityType entityType, List<String> entityIds, AccessType accessType) throws IxException {
        List<AccessRequestDTO> accessRequests = entityIds.stream().map(entityId -> new AccessRequestDTO(username, this.getApplicationTag(), entityType.name(), (String)entityId, accessType.name())).collect(Collectors.toList());
        return this.checkMultiAccess(accessRequests);
    }

    public List<Boolean> checkMultiAccess(List<AccessRequestDTO> accessRequest) throws IxException {
        try {
            WebTarget accessListTarget = this.target.path("access/list");
            Response accessResponse = accessListTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)String.format("Bearer %s", this.getToken(false))).post(Entity.json(accessRequest));
            if (accessResponse.getStatusInfo().equals(Response.Status.UNAUTHORIZED)) {
                accessResponse = accessListTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)String.format("Bearer %s", this.getToken(true))).post(Entity.json(accessRequest));
            }
            if (accessResponse.getStatusInfo().equals(Response.Status.OK)) {
                List list = (List)accessResponse.readEntity(List.class);
                return list.stream().map(b -> (Boolean)b).collect(Collectors.toList());
            }
            log.error(String.format("Cannot check access (status: %s):\n%s\n%s", accessResponse.getStatusInfo().getReasonPhrase(), accessRequest, accessResponse.readEntity(String.class)));
            return accessRequest.stream().map(r -> false).collect(Collectors.toList());
        }
        catch (ProcessingException e) {
            throw this.loggedIxException("Cannot check multi access", e);
        }
    }

    public boolean checkSingleAccess(AccessRequestDTO accessRequest) throws IxException {
        try {
            WebTarget accessTarget = this.target.path("access");
            Response accessResponse = accessTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)String.format("Bearer %s", this.getToken(false))).post(Entity.json((Object)accessRequest));
            if (accessResponse.getStatusInfo().equals(Response.Status.UNAUTHORIZED)) {
                accessResponse = accessTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)String.format("Bearer %s", this.getToken(true))).post(Entity.json((Object)accessRequest));
            }
            if (accessResponse.getStatusInfo().equals(Response.Status.OK)) {
                return (Boolean)accessResponse.readEntity(Boolean.class);
            }
            log.error(String.format("Cannot check access (status: %s): %s", accessResponse.getStatusInfo().getReasonPhrase(), accessRequest));
            return false;
        }
        catch (ProcessingException e) {
            throw this.loggedIxException("Cannot check single access", e);
        }
    }

    public boolean checkUserGroup(String username, String application, String group) throws IxException {
        try {
            WebTarget accessTarget = this.target.path("membership").queryParam("users", new Object[]{username}).queryParam("groups", new Object[]{group}).queryParam("apps", new Object[]{application});
            Response accessResponse = accessTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)String.format("Bearer %s", this.getToken(false))).get();
            if (accessResponse.getStatusInfo().equals(Response.Status.UNAUTHORIZED)) {
                accessResponse = accessTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)String.format("Bearer %s", this.getToken(true))).get();
            }
            if (accessResponse.getStatusInfo().equals(Response.Status.OK)) {
                if (((List)accessResponse.readEntity(List.class)).isEmpty()) {
                    return this.checkGlobalUserGroup(username, group);
                }
                return true;
            }
            log.error(String.format("Cannot check user group (status: %s)", accessResponse.getStatusInfo().getReasonPhrase()));
            return false;
        }
        catch (ProcessingException e) {
            throw this.loggedIxException("Cannot check user group", e);
        }
    }

    public boolean isAdmin(String user) throws IxException {
        return this.checkUserGroup(user, this.getApplicationTag(), ADMIN_GROUP);
    }

    public boolean checkGlobalUserGroup(String username, String group) throws IxException {
        try {
            WebTarget accessTarget = this.target.path("membership").queryParam("users", new Object[]{username}).queryParam("groups", new Object[]{group});
            Response accessResponse = accessTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)String.format("Bearer %s", this.getToken(false))).get();
            if (accessResponse.getStatusInfo().equals(Response.Status.UNAUTHORIZED)) {
                accessResponse = accessTarget.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)String.format("Bearer %s", this.getToken(true))).get();
            }
            if (accessResponse.getStatusInfo().equals(Response.Status.OK)) {
                return !((List)accessResponse.readEntity(List.class)).isEmpty();
            }
            log.error(String.format("Cannot check user group (status: %s)", accessResponse.getStatusInfo().getReasonPhrase()));
            return false;
        }
        catch (ProcessingException e) {
            throw this.loggedIxException("Cannot check global user group", e);
        }
    }

    private IxException loggedIxException(String message, Throwable e) {
        log.error(message, e);
        return new IxException(message);
    }
}

