/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.utils;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.ooxml.util.SAXHelper;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.Styles;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class ExcelReader {
    private final OPCPackage xlsxPackage;
    private final int minColumns;
    private final CellHandler output;

    public ExcelReader(OPCPackage pkg, CellHandler output, int minColumns) {
        this.xlsxPackage = pkg;
        this.output = output;
        this.minColumns = minColumns;
    }

    private void processSheet(StylesTable styles, ReadOnlySharedStringsTable strings, XSSFSheetXMLHandler.SheetContentsHandler sheetHandler, InputStream sheetInputStream) throws IOException, SAXException {
        DataFormatter formatter = new DataFormatter();
        InputSource sheetSource = new InputSource(sheetInputStream);
        try {
            XMLReader sheetParser = SAXHelper.newXMLReader();
            XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler((Styles)styles, null, (SharedStrings)strings, sheetHandler, formatter, false);
            sheetParser.setContentHandler((ContentHandler)handler);
            sheetParser.parse(sheetSource);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("SAX parser appears to be broken - " + e.getMessage());
        }
    }

    public void process() throws IOException, OpenXML4JException, SAXException {
        ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(this.xlsxPackage);
        XSSFReader xssfReader = new XSSFReader(this.xlsxPackage);
        StylesTable styles = xssfReader.getStylesTable();
        XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
        int index = 0;
        while (iter.hasNext()) {
            InputStream stream = iter.next();
            String sheetName = iter.getSheetName();
            this.output.newSheet(sheetName, index);
            this.processSheet(styles, strings, new SheetToCSV(), stream);
            stream.close();
            ++index;
        }
    }

    private class SheetToCSV
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        private int currentRow = -1;
        private int currentCol = -1;

        private SheetToCSV() {
        }

        private void outputMissingRows(int number) {
            for (int i = 0; i < number; ++i) {
                for (int j = 0; j < ExcelReader.this.minColumns; ++j) {
                    ExcelReader.this.output.newCell(null);
                }
                ExcelReader.this.output.newRow();
            }
        }

        public void startRow(int rowNum) {
            this.outputMissingRows(rowNum - this.currentRow - 1);
            this.currentRow = rowNum;
            this.currentCol = -1;
        }

        public void endRow(int rowNum) {
            for (int i = this.currentCol; i < ExcelReader.this.minColumns; ++i) {
                ExcelReader.this.output.newCell(null);
            }
            ExcelReader.this.output.newRow();
        }

        public void cell(String cellReference, String formattedValue, XSSFComment comment) {
            if (cellReference == null) {
                cellReference = new CellAddress(this.currentRow, this.currentCol).formatAsString();
            }
            short thisCol = new CellReference(cellReference).getCol();
            int missedCols = thisCol - this.currentCol - 1;
            for (int i = 0; i < missedCols; ++i) {
                ExcelReader.this.output.newCell(null);
            }
            this.currentCol = thisCol;
            ExcelReader.this.output.newCell(formattedValue);
        }

        public void headerFooter(String text, boolean isHeader, String tagName) {
        }
    }

    public static interface CellHandler {
        public void newRow();

        public void newCell(String var1);

        public void newSheet(String var1, int var2);
    }
}

