/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.utils;

import at.ac.iiasa.ixmp.Platform;
import at.ac.iiasa.ixmp.exceptions.IxException;
import at.ac.iiasa.ixmp.objects.TimeSeries;
import at.ac.iiasa.ixmp.utils.ExcelReader;
import at.ac.iiasa.ixmp.utils.RegionUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);

    public static Map<String, Set<String>> getAvailableScenarios(String filename) throws IxException {
        final HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        try (OPCPackage p = OPCPackage.open((String)filename, (PackageAccess)PackageAccess.READ);){
            new ExcelReader(p, new ExcelReader.CellHandler(){
                private int row = -1;
                private int col = -1;
                private Map<Integer, String> colToName = new HashMap<Integer, String>();
                private String currentModel;
                private String currentScenario;

                @Override
                public void newRow() {
                    if (this.row > 0) {
                        result.computeIfAbsent(this.currentModel, key -> new HashSet()).add(this.currentScenario);
                    }
                    ++this.row;
                    this.col = 0;
                }

                @Override
                public void newCell(String value) {
                    if (value != null) {
                        if (this.row == 0) {
                            try {
                                Integer.parseInt(value);
                            }
                            catch (NumberFormatException e) {
                                this.colToName.put(this.col, value);
                            }
                        } else if (this.colToName.keySet().contains(this.col)) {
                            try {
                                switch (KnownIAMCColumns.valueOf(this.colToName.get(this.col))) {
                                    case Model: {
                                        this.currentModel = value;
                                        break;
                                    }
                                    case Scenario: {
                                        this.currentScenario = value;
                                        break;
                                    }
                                }
                            }
                            catch (IllegalArgumentException e) {
                                log.debug(String.format("Unexpected value in column %d and row %d", this.col, this.row));
                            }
                        }
                    }
                    ++this.col;
                }

                @Override
                public void newSheet(String sheetName, int index) {
                    this.row = 0;
                    this.col = 0;
                    this.colToName.clear();
                    log.debug(String.format("Reading data from %s (index: %d)", sheetName, index));
                }
            }, 30).process();
        }
        catch (IOException | OpenXML4JException | SAXException e) {
            throw new IxException("Error adding timeseries from file " + filename, e);
        }
        return result;
    }

    public static void loadTimeseriesFromExcelAsStream(final TimeSeries scenario, String filename) throws IxException {
        scenario.assertTimeSeriesIsEditable(true);
        final Platform mp = scenario.getMp();
        try (OPCPackage p = OPCPackage.open((String)filename, (PackageAccess)PackageAccess.READ);){
            new ExcelReader(p, new ExcelReader.CellHandler(){
                private int row = -1;
                private int col = -1;
                private Map<Integer, Integer> colToYear = new HashMap<Integer, Integer>();
                private Map<Integer, String> colToName = new HashMap<Integer, String>();
                private Map<Integer, Double> yearlyValues = new HashMap<Integer, Double>();
                private String currentModel;
                private String currentScenario;
                private String currentRegion;
                private String currentVariable;
                private String currentUnit;

                @Override
                public void newRow() {
                    if (this.row > 0 && Objects.equals(this.currentModel, scenario.getModel()) && Objects.equals(this.currentScenario, scenario.getScenario())) {
                        try {
                            RegionUtils.addRegionIfNotExists(mp, this.currentRegion);
                        }
                        catch (IxException ex) {
                            log.debug("Cannot add a region " + this.currentRegion, (Throwable)ex);
                        }
                        try {
                            scenario.addTimeseries(this.currentRegion, this.currentVariable, null, this.yearlyValues, this.currentUnit, 0);
                        }
                        catch (IxException e) {
                            log.error("Cannot import from row " + this.row, (Throwable)e);
                        }
                    }
                    ++this.row;
                    this.col = 0;
                    this.yearlyValues.clear();
                }

                @Override
                public void newCell(String value) {
                    if (value != null) {
                        if (this.row == 0) {
                            try {
                                Integer year = Integer.parseInt(value);
                                this.colToYear.put(this.col, year);
                            }
                            catch (NumberFormatException e) {
                                this.colToName.put(this.col, value);
                            }
                        } else if (this.colToYear.keySet().contains(this.col)) {
                            try {
                                Double yearValue = Double.parseDouble(value.replace(',', '.'));
                                this.yearlyValues.put(this.colToYear.get(this.col), yearValue);
                            }
                            catch (NumberFormatException e) {
                                log.debug(String.format("Cannot parse year value for %d: %s", this.colToYear.get(this.col), value));
                            }
                        } else if (this.colToName.keySet().contains(this.col)) {
                            try {
                                switch (KnownIAMCColumns.valueOf(this.colToName.get(this.col))) {
                                    case Model: {
                                        this.currentModel = value;
                                        break;
                                    }
                                    case Scenario: {
                                        this.currentScenario = value;
                                        break;
                                    }
                                    case Region: {
                                        this.currentRegion = value;
                                        break;
                                    }
                                    case Variable: {
                                        this.currentVariable = value;
                                        break;
                                    }
                                    case Unit: {
                                        this.currentUnit = value;
                                    }
                                }
                            }
                            catch (IllegalArgumentException e) {
                                log.debug(String.format("Unexpected value in column %d and row %d", this.col, this.row));
                            }
                        }
                    }
                    ++this.col;
                }

                @Override
                public void newSheet(String sheetName, int index) {
                    this.row = 0;
                    this.col = 0;
                    this.colToYear.clear();
                    this.colToName.clear();
                    this.yearlyValues.clear();
                    log.debug(String.format("Reading data from %s (index: %d)", sheetName, index));
                }
            }, 30).process();
        }
        catch (IOException | OpenXML4JException | SAXException e) {
            throw new IxException("Error adding timeseries from file " + filename, e);
        }
    }

    public static void loadTimeseriesFromXLS(TimeSeries scenario, String filename) throws IxException {
        try {
            Platform mp = scenario.getMp();
            try (Workbook workbook = WorkbookFactory.create((File)new File(filename));){
                for (int index = 0; index < workbook.getNumberOfSheets(); ++index) {
                    Sheet sheet = workbook.getSheetAt(index);
                    Row headers = sheet.getRow(sheet.getFirstRowNum());
                    if (headers == null) continue;
                    HashMap<String, Integer> headersMap = new HashMap<String, Integer>();
                    HashMap<Integer, Integer> yearsMap = new HashMap<Integer, Integer>();
                    for (int headerIndex = headers.getFirstCellNum(); headerIndex <= headers.getLastCellNum(); ++headerIndex) {
                        Cell headerCell = headers.getCell(headerIndex);
                        if (headerCell == null) continue;
                        if (headerCell.getCellTypeEnum().equals((Object)CellType.STRING)) {
                            String cellValue = headerCell.getStringCellValue().toLowerCase();
                            try {
                                int year = Integer.parseInt(cellValue);
                                yearsMap.put(year, headerIndex);
                            }
                            catch (NumberFormatException e) {
                                headersMap.put(cellValue, headerIndex);
                            }
                            continue;
                        }
                        if (!headerCell.getCellTypeEnum().equals((Object)CellType.NUMERIC)) continue;
                        double cellValue = headerCell.getNumericCellValue();
                        yearsMap.put((int)cellValue, headerIndex);
                    }
                    for (int rowIndex = sheet.getFirstRowNum() + 1; rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
                        try {
                            Row row = sheet.getRow(rowIndex);
                            if (row == null) continue;
                            String model = row.getCell(((Integer)headersMap.get("model")).intValue()).getStringCellValue();
                            String scenarioName = row.getCell(((Integer)headersMap.get("scenario")).intValue()).getStringCellValue();
                            if (!Objects.equals(scenario.getModel(), model) || !Objects.equals(scenario.getScenario(), scenarioName)) continue;
                            String region = row.getCell(((Integer)headersMap.get("region")).intValue()).getStringCellValue();
                            String variable = row.getCell(((Integer)headersMap.get("variable")).intValue()).getStringCellValue();
                            String unit = row.getCell(((Integer)headersMap.get("unit")).intValue()).getStringCellValue();
                            RegionUtils.addRegionIfNotExists(mp, region);
                            HashMap<Integer, Double> data = new HashMap<Integer, Double>();
                            for (Map.Entry entry : yearsMap.entrySet()) {
                                Integer year = (Integer)entry.getKey();
                                Integer yearIndex = (Integer)entry.getValue();
                                Cell yearCell = row.getCell(yearIndex.intValue());
                                if (yearCell == null) continue;
                                if (yearCell.getCellTypeEnum().equals((Object)CellType.NUMERIC)) {
                                    double yearValue = yearCell.getNumericCellValue();
                                    data.put(year, yearValue);
                                    continue;
                                }
                                if (!yearCell.getCellTypeEnum().equals((Object)CellType.STRING)) continue;
                                try {
                                    double yearValue = Double.parseDouble(yearCell.getStringCellValue());
                                    data.put(year, yearValue);
                                }
                                catch (NumberFormatException e) {
                                    e.printStackTrace();
                                }
                            }
                            scenario.addTimeseries(region, variable, null, data, unit, 0);
                            continue;
                        }
                        catch (IxException e) {
                            log.error(String.format("Error adding timeseries from %d row", rowIndex), (Throwable)e);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IxException("Error adding timeseries from file " + filename, e);
        }
    }

    public static enum KnownIAMCColumns {
        Model,
        Scenario,
        Region,
        Variable,
        Unit;

    }
}

