/*
 * Decompiled with CFR 0.152.
 */
package at.ac.iiasa.ixmp.utils;

import javax.servlet.http.HttpServletRequest;

public class Pagination {
    private final long offset;
    private final long limit;

    public Pagination(long offset, long limit) {
        this.offset = offset;
        this.limit = limit;
    }

    public static Pagination fromRequest(HttpServletRequest request) {
        String offsetParam = request.getParameter("offset");
        String limitParam = request.getParameter("limit");
        long offset = offsetParam != null ? Long.parseLong(offsetParam) : 0L;
        long limit = limitParam != null ? Long.parseLong(limitParam) : -1L;
        return new Pagination(offset, limit);
    }

    public long getOffset() {
        return this.offset;
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pagination)) {
            return false;
        }
        Pagination other = (Pagination)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        return this.getLimit() == other.getLimit();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pagination;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        long $limit = this.getLimit();
        result = result * 59 + (int)($limit >>> 32 ^ $limit);
        return result;
    }

    public String toString() {
        return "Pagination(offset=" + this.getOffset() + ", limit=" + this.getLimit() + ")";
    }
}

