/*
 * Decompiled with CFR 0.152.
 */
package com.github.drapostolos.typeparser;

import com.github.drapostolos.typeparser.Helper;
import com.github.drapostolos.typeparser.NullStringStrategy;
import com.github.drapostolos.typeparser.NullStringStrategyHelper;
import com.github.drapostolos.typeparser.SplitStrategy;
import com.github.drapostolos.typeparser.SplitStrategyHelper;
import com.github.drapostolos.typeparser.TargetType;
import com.github.drapostolos.typeparser.TypeParser;
import com.github.drapostolos.typeparser.Util;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;

public final class ParserHelper
extends Helper {
    private final TargetType targetType;
    private final TypeParser typeParser;
    private final SplitStrategy splitStrategy;
    private final SplitStrategy keyValueSplitStrategy;
    private final NullStringStrategy nullStringStrategy;

    ParserHelper(TargetType targetType, TypeParser typeParser) {
        super(targetType);
        this.targetType = targetType;
        this.typeParser = typeParser;
        this.splitStrategy = typeParser.splitStrategy;
        this.nullStringStrategy = typeParser.nullStringStrategy;
        this.keyValueSplitStrategy = typeParser.keyValueSplitStrategy;
    }

    public <T> T parse(String input, Class<T> targetType) {
        return this.typeParser.parse(input, targetType);
    }

    public Object parseType(String input, Type targetType) {
        return this.typeParser.parseType(input, targetType);
    }

    public List<String> split(String input) {
        if (input == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("input"));
        }
        if (this.nullStringStrategy.isNullString(input, new NullStringStrategyHelper(this.targetType))) {
            return Collections.emptyList();
        }
        return this.splitStrategy.split(input, new SplitStrategyHelper(this.targetType));
    }

    public List<String> splitKeyValue(String keyValue) {
        if (keyValue == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("keyValue"));
        }
        return this.keyValueSplitStrategy.split(keyValue, new SplitStrategyHelper(this.targetType));
    }

    public boolean isNullString(String input) {
        if (input == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("input"));
        }
        return this.nullStringStrategy.isNullString(input, new NullStringStrategyHelper(this.targetType));
    }
}

