/*
 * Decompiled with CFR 0.152.
 */
package com.github.drapostolos.typeparser;

import com.github.drapostolos.typeparser.Util;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

final class TargetType {
    private final Type targetType;
    private Class<?> rawTargetType;
    private List<Class<?>> parameterizedClassArguments;

    TargetType(Type targetType) {
        this.targetType = targetType;
    }

    boolean isTargetTypeParameterized() {
        return this.targetType instanceof ParameterizedType;
    }

    Type targetType() {
        return this.targetType;
    }

    Class<?> rawTargetType() {
        if (this.rawTargetType == null) {
            this.rawTargetType = this.extractRawTargetType();
        }
        return this.rawTargetType;
    }

    private Class<?> extractRawTargetType() {
        if (this.targetType instanceof Class) {
            return (Class)this.targetType;
        }
        if (this.isTargetTypeParameterized()) {
            ParameterizedType type = (ParameterizedType)this.targetType;
            return (Class)type.getRawType();
        }
        if (this.targetType instanceof GenericArrayType) {
            GenericArrayType array = (GenericArrayType)this.targetType;
            Type componentType = array.getGenericComponentType();
            if (componentType instanceof Class) {
                return Array.newInstance((Class)componentType, 0).getClass();
            }
            if (componentType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)componentType;
                Class rawType = (Class)parameterizedType.getRawType();
                return Array.newInstance(rawType, 0).getClass();
            }
        }
        return this.targetType.getClass();
    }

    public final List<Class<?>> getParameterizedClassArguments() {
        if (this.parameterizedClassArguments == null) {
            this.parameterizedClassArguments = this.extractParameterizedClassArguments();
        }
        return this.parameterizedClassArguments;
    }

    List<Class<?>> extractParameterizedClassArguments() {
        if (!this.isTargetTypeParameterized()) {
            String message = String.format("type must be parameterized: %s", Util.objectToString(this.targetType));
            throw new UnsupportedOperationException(message);
        }
        ParameterizedType pt = (ParameterizedType)this.targetType;
        ArrayList result = new ArrayList();
        for (Type typeArgument : pt.getActualTypeArguments()) {
            Type rawType;
            if (typeArgument instanceof Class) {
                result.add((Class)typeArgument);
                continue;
            }
            if (typeArgument instanceof ParameterizedType && (rawType = ((ParameterizedType)typeArgument).getRawType()) instanceof Class) {
                result.add((Class)rawType);
                continue;
            }
            String message = "That type contains illegal type argument: '%s' [%s]";
            message = String.format(message, typeArgument, typeArgument.getClass());
            throw new UnsupportedOperationException(message);
        }
        return result;
    }

    public String toString() {
        return this.targetType.toString();
    }
}

