/*
 * Decompiled with CFR 0.152.
 */
package com.github.drapostolos.typeparser;

import com.github.drapostolos.typeparser.GenericType;
import com.github.drapostolos.typeparser.InputPreprocessor;
import com.github.drapostolos.typeparser.InputPreprocessorHelper;
import com.github.drapostolos.typeparser.NoSuchRegisteredParserException;
import com.github.drapostolos.typeparser.NullStringStrategy;
import com.github.drapostolos.typeparser.ParserInvoker;
import com.github.drapostolos.typeparser.Parsers;
import com.github.drapostolos.typeparser.SplitStrategy;
import com.github.drapostolos.typeparser.TargetType;
import com.github.drapostolos.typeparser.TypeParserBuilder;
import com.github.drapostolos.typeparser.TypeParserException;
import com.github.drapostolos.typeparser.Util;
import java.lang.reflect.Type;

public final class TypeParser {
    final Parsers parsers;
    final SplitStrategy splitStrategy;
    final SplitStrategy keyValueSplitStrategy;
    final InputPreprocessor inputPreprocessor;
    final NullStringStrategy nullStringStrategy;

    public static TypeParserBuilder newBuilder() {
        return new TypeParserBuilder();
    }

    TypeParser(TypeParserBuilder builder) {
        this.parsers = Parsers.unmodifiableCopy(builder.parsers);
        this.splitStrategy = builder.splitStrategy;
        this.keyValueSplitStrategy = builder.keyValueSplitStrategy;
        this.inputPreprocessor = builder.inputPreprocessor;
        this.nullStringStrategy = builder.nullStringStrategy;
    }

    public <T> T parse(String input, Class<T> targetType) {
        if (input == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("input"));
        }
        if (targetType == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("targetType"));
        }
        Object temp = this.parseType2(input, new TargetType(targetType));
        return (T)temp;
    }

    public <T> T parse(String input, GenericType<T> genericType) {
        if (input == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("input"));
        }
        if (genericType == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("genericType"));
        }
        Object temp = this.parseType2(input, new TargetType(genericType.getType()));
        return (T)temp;
    }

    public Object parseType(String input, Type targetType) {
        if (input == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("input"));
        }
        if (targetType == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("targetType"));
        }
        return this.parseType2(input, new TargetType(targetType));
    }

    private Object parseType2(String input, TargetType targetType) {
        String preprocessedInput = null;
        try {
            preprocessedInput = this.preProcessInputString(input, targetType);
            ParserInvoker invoker = new ParserInvoker(this, targetType, preprocessedInput);
            return invoker.invoke();
        }
        catch (TypeParserException e) {
            throw e;
        }
        catch (NoSuchRegisteredParserException e) {
            String message = Util.formatErrorMessage(input, preprocessedInput, targetType, e.getMessage());
            throw new NoSuchRegisteredParserException(message);
        }
        catch (NumberFormatException e) {
            String message = "NumberFormatException " + e.getMessage();
            message = Util.formatErrorMessage(input, preprocessedInput, targetType, message);
            throw new TypeParserException(message, e);
        }
        catch (Throwable t) {
            String message = Util.formatErrorMessage(input, preprocessedInput, targetType, t.getMessage());
            throw new TypeParserException(message, t);
        }
    }

    private String preProcessInputString(String input, TargetType targetType) {
        String result = this.inputPreprocessor.prepare(input, new InputPreprocessorHelper(targetType, this));
        if (result == null) {
            String message = "InputPreprocessor.prepare(...) method returned a null object when its contract states an actual String must be returned.";
            throw new UnsupportedOperationException(message);
        }
        return result;
    }
}

