/*
 * Decompiled with CFR 0.152.
 */
package com.github.drapostolos.typeparser;

import com.github.drapostolos.typeparser.DynamicParser;
import com.github.drapostolos.typeparser.GenericType;
import com.github.drapostolos.typeparser.InputPreprocessor;
import com.github.drapostolos.typeparser.NullStringStrategy;
import com.github.drapostolos.typeparser.Parser;
import com.github.drapostolos.typeparser.Parsers;
import com.github.drapostolos.typeparser.SplitStrategy;
import com.github.drapostolos.typeparser.TypeParser;
import com.github.drapostolos.typeparser.Util;

public final class TypeParserBuilder {
    Parsers parsers;
    SplitStrategy splitStrategy = Util.defaultSplitStrategy();
    SplitStrategy keyValueSplitStrategy = Util.defaultKeyValueSplitStrategy();
    InputPreprocessor inputPreprocessor = Util.defaultInputPreprocessor();
    NullStringStrategy nullStringStrategy = Util.defaultNullStringStrategy();

    TypeParserBuilder() {
        this.parsers = Parsers.copyDefault();
    }

    public TypeParserBuilder unregisterParser(Class<?> targetType) {
        if (targetType == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("targetType"));
        }
        this.parsers.removeStaticParser(targetType);
        return this;
    }

    public <T> TypeParserBuilder registerParser(Class<T> targetType, Parser<T> parser) {
        if (parser == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("parser"));
        }
        if (targetType == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("targetType"));
        }
        if (targetType.isArray()) {
            String message = "Cannot register Parser for array class. Register a Parser for the component type '%s' instead, as arrays are handled automatically internally in type-parser.";
            Class<?> componentType = targetType.getComponentType();
            throw new IllegalArgumentException(String.format(message, componentType.getName()));
        }
        this.parsers.addStaticParser(targetType, parser);
        return this;
    }

    public <T> TypeParserBuilder registerParser(GenericType<T> targetType, Parser<T> parser) {
        if (parser == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("parser"));
        }
        if (targetType == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("targetType"));
        }
        this.parsers.addStaticParser(targetType.getType(), parser);
        return this;
    }

    public TypeParserBuilder registerDynamicParser(DynamicParser parser) {
        if (parser == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("parser"));
        }
        this.parsers.addDynamicParser(parser);
        return this;
    }

    public TypeParserBuilder setSplitStrategy(SplitStrategy splitStrategy) {
        if (splitStrategy == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("splitStrategy"));
        }
        this.splitStrategy = splitStrategy;
        return this;
    }

    public TypeParserBuilder setKeyValueSplitStrategy(SplitStrategy splitStrategy) {
        if (splitStrategy == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("splitStrategy"));
        }
        this.keyValueSplitStrategy = splitStrategy;
        return this;
    }

    public TypeParserBuilder setInputPreprocessor(InputPreprocessor inputPreprocessor) {
        if (inputPreprocessor == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("inputPreprocessor"));
        }
        this.inputPreprocessor = inputPreprocessor;
        return this;
    }

    public TypeParserBuilder setNullStringStrategy(NullStringStrategy nullStringStrategy) {
        if (nullStringStrategy == null) {
            throw new NullPointerException(Util.makeNullArgumentErrorMsg("nullStringStrategy"));
        }
        this.nullStringStrategy = nullStringStrategy;
        return this;
    }

    public TypeParser build() {
        return new TypeParser(this);
    }
}

