/*
 * Decompiled with CFR 0.152.
 */
package org.cfg4j.provider;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Objects;
import org.cfg4j.provider.ConfigurationProvider;
import org.cfg4j.provider.GenericTypeInterface;

class BindInvocationHandler
implements InvocationHandler {
    private final ConfigurationProvider simpleConfigurationProvider;
    private final String prefix;

    BindInvocationHandler(ConfigurationProvider configurationProvider, String prefix) {
        this.simpleConfigurationProvider = Objects.requireNonNull(configurationProvider);
        this.prefix = Objects.requireNonNull(prefix);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException {
        if (this.isObjectMethod(method)) {
            return method.invoke((Object)this, args);
        }
        final Type returnType = method.getGenericReturnType();
        return this.simpleConfigurationProvider.getProperty(this.prefix + (this.prefix.isEmpty() ? "" : ".") + method.getName(), new GenericTypeInterface(){

            @Override
            public Type getType() {
                return returnType;
            }
        });
    }

    private boolean isObjectMethod(Method method) {
        for (Method objectMethod : Object.class.getMethods()) {
            if (!method.getName().equals(objectMethod.getName()) || !this.equalParamTypes(objectMethod.getParameterTypes(), method.getParameterTypes())) continue;
            return true;
        }
        return false;
    }

    private boolean equalParamTypes(Class<?>[] params1, Class<?>[] params2) {
        if (params1.length == params2.length) {
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

