/*
 * Decompiled with CFR 0.152.
 */
package org.cfg4j.provider;

import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import org.cfg4j.provider.ConfigurationProvider;
import org.cfg4j.provider.MeteredConfigurationProvider;
import org.cfg4j.provider.SimpleConfigurationProvider;
import org.cfg4j.source.ConfigurationSource;
import org.cfg4j.source.context.environment.DefaultEnvironment;
import org.cfg4j.source.context.environment.Environment;
import org.cfg4j.source.empty.EmptyConfigurationSource;
import org.cfg4j.source.metered.MeteredConfigurationSource;
import org.cfg4j.source.reload.ReloadStrategy;
import org.cfg4j.source.reload.strategy.ImmediateReloadStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationProviderBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationProviderBuilder.class);
    private ConfigurationSource configurationSource = new EmptyConfigurationSource();
    private ReloadStrategy reloadStrategy = new ImmediateReloadStrategy();
    private Environment environment = new DefaultEnvironment();
    private MetricRegistry metricRegistry;
    private String prefix = "";

    public ConfigurationProviderBuilder withConfigurationSource(ConfigurationSource configurationSource) {
        this.configurationSource = configurationSource;
        return this;
    }

    public ConfigurationProviderBuilder withReloadStrategy(ReloadStrategy reloadStrategy) {
        this.reloadStrategy = reloadStrategy;
        return this;
    }

    public ConfigurationProviderBuilder withEnvironment(Environment environment) {
        this.environment = environment;
        return this;
    }

    public ConfigurationProviderBuilder withMetrics(MetricRegistry metricRegistry, String prefix) {
        this.prefix = Objects.requireNonNull(prefix);
        this.metricRegistry = metricRegistry;
        return this;
    }

    public ConfigurationProvider build() {
        LOG.info("Initializing ConfigurationProvider with " + this.configurationSource.getClass().getCanonicalName() + " source, " + this.reloadStrategy.getClass().getCanonicalName() + " reload strategy and " + this.environment.getClass().getCanonicalName() + " environment");
        ConfigurationSource configurationSource = this.configurationSource;
        if (this.metricRegistry != null) {
            configurationSource = new MeteredConfigurationSource(this.metricRegistry, this.prefix, configurationSource);
        }
        configurationSource.init();
        this.reloadStrategy.register(configurationSource);
        SimpleConfigurationProvider configurationProvider = new SimpleConfigurationProvider(configurationSource, this.environment);
        if (this.metricRegistry != null) {
            return new MeteredConfigurationProvider(this.metricRegistry, this.prefix, configurationProvider);
        }
        return configurationProvider;
    }

    public String toString() {
        return "ConfigurationProviderBuilder{configurationSource=" + this.configurationSource + ", reloadStrategy=" + this.reloadStrategy + ", environment=" + this.environment + '}';
    }
}

