/*
 * Decompiled with CFR 0.152.
 */
package org.cfg4j.provider;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.cfg4j.provider.GenericTypeInterface;

public abstract class GenericType<T>
implements GenericTypeInterface {
    private final Type type;

    public GenericType() {
        if (GenericType.class != this.getClass().getSuperclass()) {
            throw new IllegalArgumentException("You must extend GenericType class directly");
        }
        Type t = this.getClass().getGenericSuperclass();
        if (!(t instanceof ParameterizedType)) {
            throw new IllegalArgumentException("You must use parametrized type");
        }
        ParameterizedType superClass = (ParameterizedType)t;
        this.type = superClass.getActualTypeArguments()[0];
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public String toString() {
        return "GenericType{type=" + this.type + '}';
    }
}

