/*
 * Decompiled with CFR 0.152.
 */
package org.cfg4j.provider;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Objects;
import java.util.Properties;
import org.cfg4j.provider.ConfigurationProvider;
import org.cfg4j.provider.GenericTypeInterface;
import org.cfg4j.provider.SimpleConfigurationProvider;

class MeteredConfigurationProvider
implements ConfigurationProvider {
    private final SimpleConfigurationProvider delegate;
    private final Timer allConfigurationAsPropertiesTimer;
    private final Timer getPropertyTimer;
    private final Timer getPropertyGenericTimer;
    private final Timer bindTimer;

    MeteredConfigurationProvider(MetricRegistry metricRegistry, String metricPrefix, SimpleConfigurationProvider delegate) {
        Objects.requireNonNull(metricRegistry);
        Objects.requireNonNull(metricPrefix);
        this.delegate = Objects.requireNonNull(delegate);
        this.allConfigurationAsPropertiesTimer = metricRegistry.timer(metricPrefix + "allConfigurationAsProperties");
        this.getPropertyTimer = metricRegistry.timer(metricPrefix + "getProperty");
        this.getPropertyGenericTimer = metricRegistry.timer(metricPrefix + "getPropertyGeneric");
        this.bindTimer = metricRegistry.timer(metricPrefix + "bind");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties allConfigurationAsProperties() {
        Timer.Context context = this.allConfigurationAsPropertiesTimer.time();
        try {
            Properties properties = this.delegate.allConfigurationAsProperties();
            return properties;
        }
        finally {
            context.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getProperty(String key, Class<T> type) {
        Timer.Context context = this.getPropertyTimer.time();
        try {
            T t = this.delegate.getProperty(key, type);
            return t;
        }
        finally {
            context.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getProperty(String key, GenericTypeInterface genericType) {
        Timer.Context context = this.getPropertyGenericTimer.time();
        try {
            Object t = this.delegate.getProperty(key, genericType);
            return t;
        }
        finally {
            context.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T bind(String prefix, Class<T> type) {
        Timer.Context context = this.bindTimer.time();
        try {
            T t = this.delegate.bind(this, prefix, type);
            return t;
        }
        finally {
            context.stop();
        }
    }
}

