/*
 * Decompiled with CFR 0.152.
 */
package org.cfg4j.source.files;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.cfg4j.source.ConfigurationSource;
import org.cfg4j.source.context.environment.Environment;
import org.cfg4j.source.context.environment.MissingEnvironmentException;
import org.cfg4j.source.context.filesprovider.ConfigFilesProvider;
import org.cfg4j.source.context.propertiesprovider.JsonBasedPropertiesProvider;
import org.cfg4j.source.context.propertiesprovider.PropertiesProvider;
import org.cfg4j.source.context.propertiesprovider.PropertiesProviderSelector;
import org.cfg4j.source.context.propertiesprovider.PropertyBasedPropertiesProvider;
import org.cfg4j.source.context.propertiesprovider.YamlBasedPropertiesProvider;

public class FilesConfigurationSource
implements ConfigurationSource {
    private final ConfigFilesProvider configFilesProvider;
    private final PropertiesProviderSelector propertiesProviderSelector;

    public FilesConfigurationSource() {
        this(new ConfigFilesProvider(){

            @Override
            public Iterable<Path> getConfigFiles() {
                return Collections.singletonList(Paths.get("application.properties", new String[0]));
            }
        });
    }

    public FilesConfigurationSource(ConfigFilesProvider configFilesProvider) {
        this(configFilesProvider, new PropertiesProviderSelector(new PropertyBasedPropertiesProvider(), new YamlBasedPropertiesProvider(), new JsonBasedPropertiesProvider()));
    }

    public FilesConfigurationSource(ConfigFilesProvider configFilesProvider, PropertiesProviderSelector propertiesProviderSelector) {
        this.configFilesProvider = Objects.requireNonNull(configFilesProvider);
        this.propertiesProviderSelector = Objects.requireNonNull(propertiesProviderSelector);
    }

    @Override
    public Properties getConfiguration(Environment environment) {
        Properties properties = new Properties();
        Path rootPath = environment.getName().trim().isEmpty() ? Paths.get(System.getProperty("user.home"), new String[0]) : Paths.get(environment.getName(), new String[0]);
        if (!rootPath.toFile().exists()) {
            throw new MissingEnvironmentException("Directory doesn't exist: " + rootPath);
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        for (Path path : this.configFilesProvider.getConfigFiles()) {
            paths.add(rootPath.resolve(path));
        }
        for (Path path : paths) {
            try {
                FileInputStream input = new FileInputStream(path.toFile());
                Throwable throwable = null;
                try {
                    PropertiesProvider provider = this.propertiesProviderSelector.getProvider(path.getFileName().toString());
                    properties.putAll((Map<?, ?>)provider.getProperties(input));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)input).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ((InputStream)input).close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to load properties from file: " + path, e);
            }
        }
        return properties;
    }

    @Override
    public void init() {
    }

    @Override
    public void reload() {
    }

    public String toString() {
        return "FilesConfigurationSource{configFilesProvider=" + this.configFilesProvider + '}';
    }
}

