/*
 * Decompiled with CFR 0.152.
 */
package org.cfg4j.source.metered;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Objects;
import java.util.Properties;
import org.cfg4j.source.ConfigurationSource;
import org.cfg4j.source.context.environment.Environment;

public class MeteredConfigurationSource
implements ConfigurationSource {
    private final ConfigurationSource delegate;
    private final Timer getConfigurationTimer;
    private final Timer initTimer;
    private final Timer reloadTimer;

    public MeteredConfigurationSource(MetricRegistry metricRegistry, String metricPrefix, ConfigurationSource delegate) {
        Objects.requireNonNull(metricRegistry);
        Objects.requireNonNull(metricPrefix);
        this.delegate = Objects.requireNonNull(delegate);
        this.getConfigurationTimer = metricRegistry.timer(metricPrefix + "source.getConfiguration");
        this.initTimer = metricRegistry.timer(metricPrefix + "source.init");
        this.reloadTimer = metricRegistry.timer(metricPrefix + "source.reload");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getConfiguration(Environment environment) {
        Timer.Context context = this.getConfigurationTimer.time();
        try {
            Properties properties = this.delegate.getConfiguration(environment);
            return properties;
        }
        finally {
            context.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        Timer.Context context = this.initTimer.time();
        try {
            this.delegate.init();
        }
        finally {
            context.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        Timer.Context context = this.reloadTimer.time();
        try {
            this.delegate.reload();
        }
        finally {
            context.stop();
        }
    }
}

