/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.command;

import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.callback.Event;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.database.Connection;
import org.flywaydb.core.internal.database.Database;
import org.flywaydb.core.internal.database.Schema;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.util.StopWatch;
import org.flywaydb.core.internal.util.TimeFormat;
import org.flywaydb.core.internal.util.jdbc.TransactionTemplate;

public class DbClean {
    private static final Log LOG = LogFactory.getLog(DbClean.class);
    private final Connection connection;
    private final SchemaHistory schemaHistory;
    private final Schema[] schemas;
    private final CallbackExecutor callbackExecutor;
    private boolean cleanDisabled;

    public DbClean(Database database, SchemaHistory schemaHistory, Schema[] schemas, CallbackExecutor callbackExecutor, boolean cleanDisabled) {
        this.connection = database.getMainConnection();
        this.schemaHistory = schemaHistory;
        this.schemas = schemas;
        this.callbackExecutor = callbackExecutor;
        this.cleanDisabled = cleanDisabled;
    }

    public void clean() throws FlywayException {
        if (this.cleanDisabled) {
            throw new FlywayException("Unable to execute clean as it has been disabled with the \"flyway.cleanDisabled\" property.");
        }
        this.callbackExecutor.executeOnMainConnection(Event.BEFORE_CLEAN);
        try {
            this.connection.changeCurrentSchemaTo(this.schemas[0]);
            boolean dropSchemas = false;
            try {
                dropSchemas = this.schemaHistory.hasSchemasMarker();
            }
            catch (Exception e) {
                LOG.error("Error while checking whether the schemas should be dropped", e);
            }
            for (Schema schema : this.schemas) {
                if (!schema.exists()) {
                    LOG.warn("Unable to clean unknown schema: " + schema);
                    continue;
                }
                if (dropSchemas) {
                    this.dropSchema(schema);
                    continue;
                }
                this.cleanSchema(schema);
            }
        }
        catch (FlywayException e) {
            this.callbackExecutor.executeOnMainConnection(Event.AFTER_CLEAN_ERROR);
            throw e;
        }
        this.callbackExecutor.executeOnMainConnection(Event.AFTER_CLEAN);
        this.schemaHistory.clearCache();
    }

    private void dropSchema(final Schema schema) {
        LOG.debug("Dropping schema " + schema + " ...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            new TransactionTemplate(this.connection.getJdbcConnection()).execute(new Callable<Object>(){

                @Override
                public Void call() {
                    schema.drop();
                    return null;
                }
            });
        }
        catch (FlywaySqlException e) {
            LOG.debug(e.getMessage());
            LOG.warn("Unable to drop schema " + schema + ". Attempting clean instead...");
            new TransactionTemplate(this.connection.getJdbcConnection()).execute(new Callable<Object>(){

                @Override
                public Void call() {
                    schema.clean();
                    return null;
                }
            });
        }
        stopWatch.stop();
        LOG.info(String.format("Successfully dropped schema %s (execution time %s)", schema, TimeFormat.format(stopWatch.getTotalTimeMillis())));
    }

    private void cleanSchema(final Schema schema) {
        LOG.debug("Cleaning schema " + schema + " ...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        new TransactionTemplate(this.connection.getJdbcConnection()).execute(new Callable<Object>(){

            @Override
            public Void call() {
                schema.clean();
                return null;
            }
        });
        stopWatch.stop();
        LOG.info(String.format("Successfully cleaned schema %s (execution time %s)", schema, TimeFormat.format(stopWatch.getTotalTimeMillis())));
    }
}

