/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.redshift;

import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.Connection;
import org.flywaydb.core.internal.database.Schema;
import org.flywaydb.core.internal.database.redshift.RedshiftDatabase;
import org.flywaydb.core.internal.database.redshift.RedshiftSchema;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.util.StringUtils;

public class RedshiftConnection
extends Connection<RedshiftDatabase> {
    RedshiftConnection(Configuration configuration, RedshiftDatabase database, java.sql.Connection connection, boolean originalAutoCommit) {
        super(configuration, database, connection, originalAutoCommit, 12);
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("SHOW search_path", new String[0]);
    }

    @Override
    public void changeCurrentSchemaTo(Schema schema) {
        try {
            if (schema.getName().equals(this.originalSchemaNameOrSearchPath) || this.originalSchemaNameOrSearchPath.startsWith(schema.getName() + ",") || !schema.exists()) {
                return;
            }
            if (StringUtils.hasText(this.originalSchemaNameOrSearchPath) && !"unset".equals(this.originalSchemaNameOrSearchPath)) {
                this.doChangeCurrentSchemaOrSearchPathTo(schema.toString() + "," + this.originalSchemaNameOrSearchPath);
            } else {
                this.doChangeCurrentSchemaOrSearchPathTo(schema.toString());
            }
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Error setting current schema to " + schema, e);
        }
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        if ("unset".equals(schema)) {
            schema = "";
        }
        this.jdbcTemplate.execute("SELECT set_config('search_path', ?, false)", schema);
    }

    @Override
    public Schema doGetCurrentSchema() throws SQLException {
        return this.getSchema(this.jdbcTemplate.queryForString("SELECT current_schema()", new String[0]));
    }

    @Override
    public Schema getSchema(String name) {
        return new RedshiftSchema(this.jdbcTemplate, (RedshiftDatabase)this.database, name);
    }
}

